import numpy as np

# 创建棋盘
board_size = 15
board = np.zeros((board_size, board_size))

# 定义棋子的标记
EMPTY = 0
BLACK = 1
WHITE = 2

# 定义游戏状态
GAME_CONTINUE = 0
GAME_OVER = 1

# 当前玩家，默认黑棋先下
current_player = BLACK

# 检查是否五子连珠
def check_win(row, col):
    # 水平方向
    count = 1
    for c in range(col - 1, -1, -1):
        if board[row, c] == board[row, col]:
            count += 1
        else:
            break
    for c in range(col + 1, board_size):
        if board[row, c] == board[row, col]:
            count += 1
        else:
            break
    if count >= 5:
        return True

    # 垂直方向
    count = 1
    for r in range(row - 1, -1, -1):
        if board[r, col] == board[row, col]:
            count += 1
        else:
            break
    for r in range(row + 1, board_size):
        if board[r, col] == board[row, col]:
            count += 1
        else:
            break
    if count >= 5:
        return True

    # 左斜方向
    count = 1
    r, c = row - 1, col - 1
    while r >= 0 and c >= 0:
        if board[r, c] == board[row, col]:
            count += 1
        else:
            break
        r -= 1
        c -= 1
    r, c = row + 1, col + 1
    while r < board_size and c < board_size:
        if board[r, c] == board[row, col]:
            count += 1
        else:
            break
        r += 1
        c += 1
    if count >= 5:
        return True

    # 右斜方向
    count = 1
    r, c = row - 1, col + 1
    while r >= 0 and c < board_size:
        if board[r, c] == board[row, col]:
            count += 1
        else:
            break
        r -= 1
        c += 1
    r, c = row + 1, col - 1
    while r < board_size and c >= 0:
        if board[r, c] == board[row, col]:
            count += 1
        else:
            break
        r += 1
        c -= 1
    if count >= 5:
        return True

    return False

# 打印棋盘
def print_board():
    # 打印列号
    print('  ', end='')
    for col in range(board_size):
        print(col, end=' ')
    print()

    for row in range(board_size):
        # 打印行号
        print(row, end=' ')
        for col in range(board_size):
            if board[row, col] == EMPTY:
                print('. ', end='')
            elif board[row, col] == BLACK:
                print('X ', end='')
            elif board[row, col] == WHITE:
                print('O ', end='')
        print()

# 游戏循环
while True:
    print_board()

    # 输入下棋位置
    row_input = input("请输入下棋行号：")
    while not row_input.isdigit():
        row_input = input("行号不能为空或者非数字，请重新输入下棋行号：")
    col_input = input("请输入下棋列号：")
    while not col_input.isdigit():
        col_input = input("行号不能为空或者非数字，请重新输入下棋行号：")
    row = int(row_input)
    col = int(col_input)

    # 检查是否合法位置
    if row < 0 or row >= board_size or col < 0 or col >= board_size or board[row, col] != EMPTY:
        print("非法位置，请重新输入！")
        continue

    # 下棋
    board[row, col] = current_player

    # 检查游戏状态
    if check_win(row, col):
        print_board()
        print("玩家", current_player, "获胜！")
        break

    # 切换玩家
    current_player = WHITE if current_player == BLACK else BLACK
