/* Copyright (c) 2016 PaddlePaddle Authors. All Rights Reserve.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. */

#include "paddle/framework/scope.h"
#include "gtest/gtest.h"

using paddle::framework::Scope;
using paddle::framework::Variable;

TEST(Scope, VarsShadowing) {
  Scope s;
  Scope& ss1 = s.NewScope();
  Scope& ss2 = s.NewScope();

  Variable* v0 = s.NewVar("a");
  Variable* v1 = ss1.NewVar("a");

  EXPECT_NE(v0, v1);

  EXPECT_EQ(v0, s.FindVar("a"));
  EXPECT_EQ(v1, ss1.FindVar("a"));
  EXPECT_EQ(v0, ss2.FindVar("a"));
}

TEST(Scope, FindVar) {
  Scope s;
  Scope& ss = s.NewScope();

  EXPECT_EQ(nullptr, s.FindVar("a"));
  EXPECT_EQ(nullptr, ss.FindVar("a"));

  ss.NewVar("a");

  EXPECT_EQ(nullptr, s.FindVar("a"));
  EXPECT_NE(nullptr, ss.FindVar("a"));
}

TEST(Scope, FindScope) {
  Scope s;
  Scope& ss = s.NewScope();
  Variable* v = s.NewVar("a");

  EXPECT_EQ(&s, s.FindScope(v));
  EXPECT_EQ(&s, ss.FindScope(v));
}
