// Copyright (c) 2018 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#pragma once
#include "paddle/fluid/memory/allocation/allocator.h"

namespace paddle {
namespace memory {
namespace allocation {

// Allocator uses `cudaHostAlloc`
class CPUPinnedAllocation : public Allocation {
 public:
  CPUPinnedAllocation(void *ptr, size_t size)
      : Allocation(ptr, size, platform::CUDAPinnedPlace()) {}
};

class CPUPinnedAllocator : public Allocator {
 public:
  bool IsAllocThreadSafe() const override;

 protected:
  void Free(Allocation *allocation) override;
  Allocation *AllocateImpl(size_t size, Allocator::Attr attr) override;
};

}  // namespace allocation
}  // namespace memory
}  // namespace paddle
