#   Copyright (c) 2018 PaddlePaddle Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from paddle.trainer_config_helpers import *

settings(learning_rate=1e-4, batch_size=1000)

din = data_layer(name='dat_in', size=100)

POOL_TYPE = [MaxPooling, AvgPooling, SumPooling]

AGG_LEVEL = [AggregateLevel.TO_SEQUENCE, AggregateLevel.TO_NO_SEQUENCE]

opts = []

for pt in POOL_TYPE:
    for al in AGG_LEVEL:
        opts.append(pooling_layer(input=din, agg_level=al, pooling_type=pt()))

for pt in POOL_TYPE:
    opts.append(
        pooling_layer(
            input=din,
            agg_level=AggregateLevel.TO_NO_SEQUENCE,
            pooling_type=pt(),
            stride=5))

opts.append(
    pooling_layer(
        input=din, pooling_type=MaxPooling(output_max_index=True)))

outputs(opts)
