## 附录4 开放科学和开放标准
### 开放科学

开放科学的发展历程开放科学的思想最早萌芽于中世纪的欧洲宫廷资助系统，资助者采用同行评议、开放交流的方式鉴别受资助成果的质量。开放科学的发展大致经历了三个阶段。欧洲一直走在开放科学的前沿，2009年欧盟第七框架计划（FP7）资助了欧洲开放获取基础设施项目（OpenAIRE），致力于建设开放和可持续的学术交流基础设施。2014年，在欧洲“地平线2020计划”下提出了欧洲开放科学培训项目（FOSTER）。2018年，欧盟支持发起开放获取S计划，旨在使得受公共和私人支持的，经过同行评议的出版物能够完全和立即开放获取。美国开放科学中心（COS）于2013年发布了开放科学框架（OSF），旨在协助科研团队管理项目和公开成果。《中华人民共和国科学技术进步法》（2021年修订）第九十五条规定“推动开放科学的发展，促进科学技术交流和传播”。

根据联合国教科文组织（UNESCO）在2021年11月发布的《开放科学建议书》，开放科学被定义为一种包容性的结构。开放科学包括所有科学学科和学术实践的各个方面，包括基础科学和应用科学、自然科学和社会科学以及人文科学，它建立在开放科学知识、开放科学基础设施、科学传播、社会行为者的开放参与并与其他知识系统进行公开对话的框架之上。 
开放科学的核心价值观、指导原则和行动领域，《开放科学建议书》概述了开放科学的四大核心价值观、六项指导原则、七个行动领域。

**开放科学的四大核心价值**

（1）质量和完整性：开放科学应该尊重学术自由和人权，支持高质量的研究，方法是汇集多种知识来源，广泛提供研究方法和成果，供严格审查和透明的评估过程使用。

（2）集体利益：科学知识应该是公开且普遍共享的。科学实践应该是包容的、可持续的和公平的，也应该是科学教育和能力发展的机会。

（3）公平公正：开放科学应发挥重要作用，确保发达国家和发展中国家科学家之间的公平，实现科学投入和产出的公平互惠共享，使知识的生产者和消费者都能平等获得科学知识。

（4）多样化与包容性：开放科学应该包含知识、实践、工作流程、语言、研究成果和研究主题的多样性，以支持科学界作为一个整体的需求和知识多元化，支持多样化的研究团体和学者，支持传统科学界之外的更广泛的公众和知识持有者，包括土著人民和当地社区，以及不同国家和地区的社会行动者。

**开放科学的六项指导原则**

（1）透明度、审查、批评和可重复性；

（2）机会均等；

（3）责任、尊重和问责；

（4）合作、参与和包容；

（5）灵活性；

（6）持续性。

 
**开放科学的七个行动领域**

为实现开放科学建议书的目标，建议成员国根据国际法并考虑到各自的政治、行政和法律框架，在以下七个领域同时采取行动。

（1）促进对开放科学、相关利益和挑战以及开放科学的多种途径的共同理解；

（2）为开放科学营造有利的政策环境；

（3）投资开放科学基础设施和服务；

（4）投资于开放科学的人力资源、培训、教育、数字素养和能力建设；

（5）培育开放科学文化，调整开放科学激励机制；

（6）在科学进程的不同阶段促进开放科学的创新方法；

（7）在开放科学的背景下促进国际和多方利益攸关方合作，以减少数字、技术和知识差距。

 
### 开放获取

2002年，《布达佩斯开放获取倡议》（BOAI）正式提出开放获取概念。2003年，德国马普学会等机构发起开放获取柏林会议，并发表《柏林宣言》，呼吁免费公开更多的科学资源，鼓励科学家以OA方式出版论文。2004年，Springer出版集团开始在其1000多种订阅期刊上向作者提供开放获取选项，带动期刊向符合开放获取期刊转换。2006年，高能物理开放获取联盟SCOAP 3建立，推动学科内大多数期刊向开放获取出版转换。2007年，南非开普敦开放教育会议发布了《开普敦开放教育宣言》。2009年，开放获取知识库联盟COAR成立，旨在联合遍布五大洲的机构知识库并建立一个全球协作网络，提高存储成果的可见度和利用度。2013年，全球研究理事会发布《出版物开放获取行动计划》。2016年3月 德国马普学会联合多家机构发起“OA 2020计划”。2018年9月4日，在欧盟委员会和欧洲研究理事会（ERC）支持下成立S联盟（Coalition S），发布《加速向全面且立即的科研出版物开放获取转变倡议》。

**开放获取的主要方式**

《布达佩斯开放获取倡议》提出了实现开放获取的两条路径，即开放获取期刊（Open-access Journals）和开放存储（Self-archiving），这两种方式分别被称为金色OA和绿色OA。除这两种主要方式外，在实际出版过程中还有其他的开放获取模式。

* 金色OA（GoldOA）：指论文的最终版本在网络上立即开放获取，读者不需要付费。金色OA的论文一般发表在完全开放获取或向开放获取转换的期刊上，遵循CCBY或CCBY-NC-ND的版权许可协议，由作者、研究机构或基金资助机构缴纳论文处理费（Article Processing Charge，简称APC）。
* 绿色OA（GreenOA）：指作者在订购期刊上发表论文后,将论文一定版本存到开放获取知识库中并在一定时间后（Embargo Period,开放时滞期）开放获取。
* 青铜OA（BronzeOA）：指科研论文的许可并不明确，出版商可能限时授予文献免费访问权限的获取方式。
* 钻石OA（DiamondOA）：指在不收取作者费用的情况下，发布开放获取的期刊，即作者和读者双向免费。2022年3月2日，Science Europe、S联盟（cOAlition S）、人文学科开放学术交流研究基础设施服务联盟项目（OPERAS）和法国国家研究机构（ANR）共同提出了“钻石OA行动计划”。
* 黑色OA（BlackOA）：是较新的说法，指的是从学术社交网（如Mendeley、ResearchGate、Academia.edu等）或非法提供学术论文全文的网站（如Sci-Hub）上可以免费下载大量本应交费浏览的学术文章。


**开放获取的载体**

CORE（https://core.ac.uk/）是全球最大的开放获取研究论文库，其使命是索引全球所有开放获取研究，并为所有人提供不受限制的访问。 

Dimensions是最全面的研究资助数据库，它将资助与数百万种由此产生的出版物、临床试验和专利联系起来。

WebofScience（https://www.webofscience.com/）是全球最受信赖且独立于出版方的全球引文数据库。
 
开放获取期刊指用户可以在法律允许的范围内最大限度地接近学术资源，打破传统学术期刊的限制和门槛，排除经济、地域等因素，按照个体需求进行阅读和分享学术期刊。美国科研出版社（Scientific Research Publishing，简称SCIRP）是全球最大的开放获取期刊出版商之一。目前已出版超过200多种开放获取、在线、同行评审的期刊，涵盖了广泛的学术学科。此外，国际上开放出版期刊平台还有PLOS、Cogent OA、Dove Medical Press、Copernicus Publications、ELCVIA、Frontiers等。DOAJ是全球开放获取期刊索引，只接受开放获取期刊，期刊应遵守学术出版的透明度和最佳实践原则，期刊必须有自己的专用URL和主页，必须至少有一个ISSN，期刊必须有编辑和编委会，所有文章在发表前必须通过同行评审。 

机构知识库（Institutional Repository，简称IR）又称机构典藏库、机构仓储、机构库等，通常情况下指的是，某个机构实体为保存和管理本机构智力成果资源（包括本机构成员创作的学术成果、科研数据、课件教程、软件工具等），自主或借助第三方机构建立的集提交、组织、检索、分析、利用等为一体的学术存储与服务系统。OpenDOAR是开放获取存储库全球目录，截至2024年5月，OpenDOAR平台注册的机构知识库总数达5,907个，其中美国（818个）、日本（655个）、德国（305个）排名前三位，中国大陆66个，占比1.11%。国际上机构知识库联盟主要包括：开放获取知识库联盟（COAR）、法国FAL、荷兰DAREnet、澳大利亚ARROW、日本JAIRO、德国OA-Network、英国JISC RepositoryNet、欧盟DRIVER。我国的机构知识库联盟主要有中国科学院机构知识库网络（CASIRGRID）、中国高校机构知识库联盟（Confederation of China Academic Institutional Repository，简称CHAIR）和农业机构知识库联盟。 

预印本（Preprint）是作者在提交期刊出版前未经严格同行评议的手稿（投稿版、录用稿），经过初步的评议审核后，即借助于预印本平台在最短的时间内以开放获取的形式发布，为作者获得最新研究成果的网络首发权，为学术交流系统提供最新、最快速的研究成果传播与利用渠道。学术论文出版的预印本平台有：arXiv、BioRxiv、medRxiv、ChemRxiv、F1000、figshare、PeerageofScience、engrXiv、PeerJPreprints等。其中，arXiv于1991年发起，涉及物理学、数学、计算机科学、定量生物学、定量金融学、统计学、电气工程和系统科学以及经济学领域的超过200万篇学术论文。BioXiv、MedXiv和ChemXiv分别是生命科学、医学和化学领域的预印本平台。ChinaXiv是中国科学院文献情报中心于2016年开始运营的预印本交流平台，支持中英文科技论文预印本的发布、传播、下载和评论， 

### 开放标准

标准记录了产品或相关工艺和生产方法的规则、条件、准则或特性的使用。标准可以来自一家公司，其成功的产品成为“事实上的”标准。标准也可以由两个或两个以上的软件生产商之间的协议制定，或者通过政府法令或政府运行的流程，或者由多个政府的代表制定。在政府流程中制定的标准，例如国际标准化组织 （ISO） 的标准，称为“法律”标准。或者，可以通过成员的包容性共识过程来制定标准，并按照明确定义的政策和程序进行排序。这些标准由协商一致进程中的公共和私营部门参与者商定，他们通常同意以非歧视性的方式免费提供其标准。这些标准被称为“开放”标准。

开源促进会（OSI）是负责审查和批准符合开源定义（OSD）许可证的组织，该组织表示：“开放标准”不得禁止在开源软件中实现符合要求。OSI 列出了开放标准必须满足的五个基本要求（https://opensource.org/osr）：

（1）没有故意的秘密。标准不得隐瞒可互操作实现所需的任何细节。由于缺陷是不可避免的，因此该标准必须定义一个过程，用于修复在实施和互操作性测试中发现的缺陷，并将上述更改纳入该标准的修订版本或替代版本，以在不违反OSR的条款下发布。
（2）可用性。该标准必须以合理和非歧视性的成本在免版税条款下免费和公开提供（例如，从稳定的网站）。
（3）专利。所有对实施标准至关重要的专利必须：根据免版税条款获得许可，不受限制地使用；或在开源软件开发时予以清晰明确的使用声明。
（4）无协议。不得要求执行许可协议、NDA、授权、通过点击或任何其他形式的文书工作来部署符合标准的实施。
（5）没有与开放标准要求不兼容的依赖关系。标准的实施不得要求任何其他不符合此要求标准的技术。

**开放标准的原则** 

“开放标准”原则构成了全球市场经济的现代化模式，以技术创新为动力源泉并推动了标准的全球化部署，而无论这些标准在传统的国内体系中处于何种地位。该声明的5个核心原则要求如下：

（1）标准机构间相互协作；

（2）在标准制定中，坚持遵守流程、达成广泛一致、公开透明和利益平衡；

（3）致力于推动技术先进性、互操作性、相互竞争、创新性和为人类谋福利；

（4）标准规范的可得可用；

（5）自主决定是否采用。

在政府治理方面，英国政府针对对软件、数据和文档格式互操作的要求，提出了开放标准的7条原则：

（1）开放标准必须满足用户需求；

（2）开放标准必须使供应商能够平等地获得政府合同；

（3）开放标准必须支持灵活性和变化；

（4）开放标准必须支持可持续成本；

（5）使用明智的决策选择开放标准；

（6）使用公平透明的流程选择开放标准；

（7）使用公平透明的流程指定和实施开放标准。

**常见的开放标准组织**

* 标准机构：DMTF（分布式管理任务组公司）、IETF（互联网工程任务组）、NIST（美国国家标准与技术研究院）、OASIS（结构化信息标准促进组织）和The Open Group（开放组小组）
* 软件标准：C++ 标准委员会、DWARF 调试标准、Java 社区进程、OSGi联盟、UEFI（统一可扩展固件接口论坛）、OpenMP、PatternFly
* 安全标准：CSA（云安全联盟）、Trusted Computing Group （可信计算组）
* 基准标准：SPEC（标准绩效评估公司）、STAC（安全技术分析中心）、TPC（事务处理绩效委员会）

**开放科学数据**

开放科学数据包括具有以下特点的原始的和经过处理的数字数据与模拟数据及附属的元数据，以及数字分数、文字记录、图像和声音、协议、分析代码和工作流程等：任何人都可以公开使用、重用、保留和重新发行，但须注明出处；依照良好数据治理和管理原则，特别是FAIR（可查询、可获取、可互操作和可重复使用）原则，及时以方便用户、人机可读和可操作的格式提供，并辅以定期管理和维护。 

FAIR原则：2014年1月，一些代表学术界、工业界、资助机构和学术出版商的多元化利益相关者共同研讨起草了一份指导科学数据管理的倡议性文件，倡导科研活动产出的数据在开放共享过程中应该努力实现可发现（Findable）、可访问（Accessible）、可互操作（Interoperable）和可重用（Reusable），4个目标层层递进，简称为“FAIR原则”。2016年，FORCE11（一个由学者、图书馆员、档案管理员、出版商和研究资助者组成的社区，将4个抽象目标细化为15条具体原则正式发布。

CARE原则：土著数据治理原则（The CARE Principles for Indigenous Data Governance，简称CARE）四个字母分别对应“关注集体利益（Collective Benefit）”、“控制权（Authority to Control）”、“责任（Responsibility）”和“伦理（Ethics）”，由全球土著数据联盟（GIDA）于 2019年制定，其目标是土著数据的管理人和其他用户要“公平且关怀”。相比起2016年首次发表在《科学数据 》上提出的“科学数据管理和管理的FAIR原则”，CARE原则是作为对于FAIR原则、以及其他开放数据运动的伦理补充。

**全球开放科学数据状况**

Dimensions的数据集专题库收录汇总了多个知名的科学数据平台的资源，对于跟踪了解当前全球的科学数据状况有一定的参考价值。截止2024年5月，该库共收录数据集31,507,869个。按机构所在国家来统计，TOP 5国家分别是美国（816,919条，占比2.6%）、中国（680,120条，占比2.2%）、德国（403,725条，占比1.3%）、英国（366,737条，占比1.2%）和法国（233,973条，占比0.7%）。

《开放数据现状报告》是Springer Nature每年联合多方机构发布的调研报告。2023年度报告显示，全球有超过6000名研究人员做出了回应，其中印度（12%）、中国（11%）和美国（9%）的回答比例最高。近四分之三的受访研究人员表示，他们仍然没有得到公开分享数据所需的支持。这些数据凸显了对加强社区合作和工具的需求增加，以支持研究人员转向可持续的开放科学实践。其余23%的受访者曾寻求并获得数据共享支持，支持主要来自内部来源（同事/主管 - 61%），其次是机构图书馆（31%）、研究办公室/内部机构专业知识（26%）、出版商（21%）和资助者（17%）。

**全球开放科学数据的编目平台**

科学数据仓储注册系统（re3data）：2015年5月，德国研究基金会（DFG）资助构建了re3data，是专门汇集全球不同学科科学数据仓储的注册平台，由德国洪堡大学柏林图书情报学院、德国波茨坦地学研究中心和德国卡尔斯鲁厄理工学院联合维护，2014年开始与DataBib合并，持续提供DataCite引用服务。re3data旨在对所有领域的科学数据仓储基于注册机制进行索引化和结构化描述，采用信息图标来描述每个科学数据仓储的基本特征，这样就能方便使用者更加方便、快捷地使用该系统。截止2024年5月，该系统共收录3,216条记录，其中中国的注册记录为，仅占比2.6%。

数据、标准和政策综合注册平台（FAIRSharing）：FAIRSharing的前身是2011年推出的Biosharing，通过注册操作，将标准（术语、格式和模型以及报告指南）、数据库和数据政策进行关联集成，并结合了所有三种类型资源的集成视图。目前共有1755条标准，2122条数据库（其中中国记录有126条，占比5.9%）和265条政策数据。

**中国的国家科学数据中心**

为了落实《科学数据管理办法》和《国家科技资源共享服务平台管理办法》的要求，规范管理国家科技资源共享服务平台，完善科技资源共享服务体系，推动科技资源向社会开放共享，2019年6月5日，科技部和财政部联合发布《国家科技资源共享服务平台优化调整名单》，发布了“国家高能物理科学数据中心”等20个国家科学数据中心名单，具体如下。
20	国家海洋科学数据中心	国家海洋信息中心	自然资源部
