## 3.4 RISC-V行业研究报告 

### 3.4.1 RISC-V概述
RISC-V作为开源指令集，经过近几年的快速发展，已经成长为仅次于x86和ARM的国际第三大指令集架构。在2015年成立的RISC-V国际基金会，旨在为基于RISC-V ISA的软硬件开发者建立一个开放、协作的社区。截至2024年4月底，RISC-V国际基金会已接纳全球70多个国家的4100多个会员，会员单位相比2019年的435位，增长了超过942%，相比2022年底的数据又增长了超过125%。RISC-V国际基金会的会员可以参与RISC-V指令集规范以及相关软硬件生态的开发，并决定RISC-V未来的推广方向。

在RISC-V国际基金会理事会26名理事中，与中国相关的有8家，包括北京开源芯片研究院、阿里巴巴、RIOS实验室、希姆计算、晶心科技、飞腾、华为、成为资本；与美国相关的有11家，与欧洲相关的有6家，南美洲（巴西）1家。

在RISC-V国际基金会中包括高级会员（Premier Members）25家，其中中方成员12家，占比达到48%；战略会员（Strategic Members）174家，其中中方成员41家，占比达到24%；社区会员（Community Organization Members）177家，其中中方成员14家，占比达到8%。会员中包含科技公司、芯片设计公司、IP公司、软件开发企业、高校院所等多种开发主体。
近年来，RISC-V在国际市场上占据越来越重要的位置。据RISC-V国际基金会披露，截至2022年，市场上量产的RISC-V处理器已经达到100亿颗，其中有50%来自中国。根据市场研究公司Counterpoint Research预测，到2025年，RISC-V处理器累计出货量将超过800亿颗，年复合增长率高达114.9%，届时RISC-V将占据全球14%的CPU市场、28%的IoT市场、12%的工业市场和10%的汽车市场。

目前，全球RISC-V产业生态已经初步建立。美国、欧盟、以色列、印度等国家的众多开发者纷纷加入到RISC-V生态中，不断推动RISC-V技术与产业发展。其中，美国国防高级研究计划局连续多年专项支持RISC-V研究和实用化，而谷歌、英特尔、英伟达、高通等软硬件巨头公司也加入RISC-V的阵营中；欧盟不仅在《欧盟芯片法案》中强调要发展RISC-V，还宣布投资2.7亿欧元来开展RISC-V小芯片项目；以色列为发展本土IoT与高性能计算芯片，国家创新局投入1360万美元建设RISC-V协作平台；印度政府将 RISC-V 定为国家事实指令集，推出数字印度计划。

中国也高度重视RISC-V的发展，有数据显示，中国有超过400家企业关注、参与和使用RISC-V指令集进行开发。北京、上海、深圳、武汉、杭州等城市陆续推出一系列科研、产业化支持政策，以加强本土基于RISC-V的芯片设计研发能力。同时，中科院、阿里巴巴等科研院所与企业也在持续推出基于RISC-V的芯片产品。目前我国已经形成了较完整的RISC-V产业链，产品覆盖消费电子、通讯、汽车、通用计算等领域，具备产业化优势。


### 3.4.2 中国的技术贡献

**（1 ）MCU领域**

**国内企业积极推动RISC-V车载芯片发展**

2023年8月，我国RISC-V芯片设计企业芯来科技宣布，芯来NA系列CPU IP NA900顺利获得了ISO 26262最高汽车功能安全等级ASIL D的产品认证证书，而NA900也成为全球首个获得ISO 26262 ASIL D认证的RISC-V CPU IP产品。

2023年7月，由东风公司牵头成立的湖北省车规级芯片产业技术创新联合体完成了国内首款基于RISC-V指令集架构车规级MCU芯片的首次流片。

此外，比亚迪也在与华为合作，双方在基于RISC-V架构的芯片上联合开展研究。奇瑞也在与国内芯片厂商合作，积极推动整个RISC-V的测试架构，例如基于RISC-V的客户端和RISC-V芯片的测试标准，来确保芯片的可靠性。

**RISC-V芯片在物联网安全领域应用越发广泛**

2023年7月，由赛昉科技、微五科技与名气家三方联手研制的RISC-V物联网安全芯片“港华芯”销量正式突破一百万颗。“港华芯”采用赛昉科技与微五科技的RISC-V芯片硬件基础，以及名气家安全协议与平台规范，达到国密二级安全标准，支持SM1/2/4/9等国密和国际加密算法，主要应用落地场景是智能燃气表。

2023年3月，苏州国芯科技宣布其基于RISC-V指令集架构研发的CCM3310S-L、CCM3310S-LP安全芯片已规模化应用于eSIM智能穿戴、智能门锁安全、ETC OBE-SAM、燃气表安全SE等物联网应用领域，出货量已达数百万颗。该安全芯片系列均采用40nm EFlash工艺设计，支持DES、AES、RSA、ECC、SHA等国际算法，SM2、SM3、SM4等国密算法，安全等级达到《安全芯片密码检测准则》第二级要求。

**推出基于RISC-V架构的AI技术框架MCU**

2023年12月，华为海思推出了一款基于RISC-V内核并结合端侧嵌入式AI技术的A²MCU。A²MCU聚焦行业专用（Application Specific）和嵌入式AI技术，将AI领域超轻量级的技术框架、极致性能的推理要求、方便快速的部署能力与MCU深度融合，为MCU行业客户探索智能化应用提供新的选择。海思表示，A²是海思针对家电、能源、工业、汽车等领域推出的全新解决方案，它不仅涵盖了基于RISC-V的系列化的MCU，还包含了高性能兼容ARM指令集的MPU，以及与之紧密配合并优化的openEuler操作系统。

**（2）芯片系统领域**

**推出基于RISC-V的多芯片设计系统**

2024年1月，中国科学院计算技术研究所推出了一种名为“Zhejiang”（浙江）的“大芯片”，即是一种直接使用整个晶圆制造的多芯片设计系统。该芯片采用Chiplet设计，共包括16个芯粒，而每个芯粒内有16个RISC-V核心，总计256核心，且均支持可编程、可重新配置。这颗“大芯片”基于22nm工艺制造，由超过1万亿个晶体管组成，总面积数千平方毫米，采用小芯片封装或计算和存储块的晶圆级集成。不同核心之间通过网络芯片（Network-on-Chip）、同步多处理器（SMP）实现互连，不同芯粒之间再通过D2D（Die-to-Die）接口、芯粒间网络接口（Inter-chiplet Network）实现互连，并使用了2.5D中介层行封装，以实现小芯片之间的内存共享。

**发布利用AI全自动生成的CPU芯片**

2023年6月底，中科院计算所等机构用AI技术设计出了世界上首个无人工干预、全自动生成的CPU芯片——启蒙1号。这颗完全由AI设计的32位RISC-V CPU，相比GPT-4目前所能设计的电路规模大4000倍，并可运行Linux操作系统，且性能堪比Intel 486。为了减少人力和资源投入，研究人员采用AI技术直接从测试用例的输入/输出（IO）自动生成CPU设计，无需工程师提供任何代码或自然语言描述。该方法在5小时内生成了超过4,000,000个逻辑门的32位RISC-V CPU，甚至自主地发现了包含控制器和运算器等在内的冯诺依曼架构，为后续发现新的体系结构优化知识提供了参考。

**推出面向多领域应用的RISC-V处理器芯片**

2023年11月，阿里平头哥发布三款基于RISC-V内核的玄铁系列处理器：玄铁C920、玄铁C907、玄铁R910。其中，玄铁C920升级支持最新的Vector1.0标准，可实现更精准、稳定地分配任务，较上代提升了高至3.8倍的AI性能，可用于Transformer模型，适合机器学习、自动驾驶等领域。玄铁C907首次实现了独立矩阵运算（Matrix）扩展，提高了计算密度和计算并行能力，充分挖掘出RISC-V架构的AI原生优势。玄铁R910同时支持Cache以及TCM存储架构，可以在保持高可靠的基础上提升系统实时性，可应用于存储控制、网络通信、自动驾驶等领域。基于软硬协同研发的这三款玄铁处理器，提升了加速计算能力、安全性及实时性，将加速推动RISC-V在自动驾驶、人工智能、企业级SSD、网络通信等场景和领域的商用落地。

2023年8月，智芯科正式发布基于精度无损SRAM存内计算（CIM)的超低功耗神经网路处理器芯片——AT700，可用于安防监控、智能家居、机器人、智能驾驶，智能后视镜CMS等领域。

**推出首个适配RISC-V的云操作系统及虚拟机**

2023年5月，中国电信研究院牵头，联合天翼云公司、中科院软件所PLCT实验室，完成CTyunOS在RISC-V指令集芯片的适配测试，共完成4100+基础软件包和1100+拓展包编译适配，并在国内合作伙伴首台RISC-V服务器板卡成功运行，推动CTyunOS成为目前业界首个适配RISC-V云服务器操作系统。同时，中国电信研究院基于CTyunOS及欧拉开源生态，还成功研发出业界首个支持RISC-V的云原生轻量级虚拟机TeleVM，并在RISC-V CPU上完成软硬件协同测试验证。据官方介绍，TeleVM基于Rust安全语言重写了虚拟机并进行RISC-V架构适配优化，结合RISC-V精简指令集特性，裁剪冗余功能，实现了应用安全隔离，同时降低资源消耗并提升响应速度，适用于可信云原生、Serverless、函数计算等新型弹性云计算业务场景。

**发布首款RISC-V开发笔记本电脑**

2023年8月，深度数智发布了全球首款RISC-V开发笔记本电脑ROMA，并默认搭载openKylin（开放麒麟）国产操作系统，可体验原生RISC-V开发及RISC-V软件生态系统。据悉，该电脑采用4核RISC-V12/22nm处理器，配有4/8/16GB内存，未来还将支持ChromeOS等。

**（3）人工智能领域**

**推动RISC-V在AI部署方面加速落地**

2023年世界互联网大会乌镇峰会上，希姆计算联合国鑫发布了基于RISC-V架构的大模型系列一体机，包括2U4卡、4U8卡机，支持部署6B、7B、13B参数规模的大模型，这也是专门针对私有化部署提供的系统级解决方案。希姆STCP920系列采用12nm工艺，是基于RISC-V的人工智能计算加速卡，具备较高的云端AI计算能效比和可编程性，混合支持FP16/INT8数据类型。

**推出面向AI的RISC-V全栈软硬件平台**

2023年RISC-V中国峰会上，阿里平头哥更新自研一站式AI部署套件HHB，实现典型网络性能比第三方工具平均提升88%，并增加支持运行Transformer、TensorFlow、PyTorch等170余个主流框架AI模型，让RISC-V真正成为AI算力的新选择。基于此，平头哥发布了首个面向多媒体AI增强场景的RISC-V全栈软硬件平台。该平台将RISC-V扩展性的新型Vector、Matrix及第三方硬件进行算力抽象，创新接入OpenCV与CSI-NN等弹性计算库，深度融合多媒体处理流程，形成面向业务的流水线设计，方便用户在流水线的不同步骤上进行AI增强优化，为检测、分类、跟踪和超分等各类应用提速。
 
### 3.4.3中国RISC-V的发展实践

**（1）举办全球性会议赛事推动RISC-V发展**

**成功举办RISC-V中国峰会**

2023年8月23日至25日，2023 RISC-V中国峰会（RISC-V Summit China 2023）成功在北京举办。RISC-V峰会由RISC-V国际基金会组织，每年在北美、欧洲、中国分别举行，是全球RISC-V领域规格最高、影响力最广的年度峰会。本届峰会为第三届中国峰会，以“RISC-V生态共建”为主题，采用“主论坛+主题报告+展览展示+同期活动+Poster”的方式，涵盖了100余个主题报告、16场同期活动、18个企业展位、16个社区展位、67个Poster及31个Poster预约交流。来自RISC-V国际基金会、业界专家、企业嘉宾及社区代表等专家学者，结合当下全球新形势，对RISC-V产业发展进行了深入探讨。

**举办RISC-V应用创新大赛**

2023年7月到11月，第三届玄铁杯全球RISC-V应用创新大赛成功举行。本次大赛采用内置玄铁RISC-V处理器的3款量产高性能开发板，基于平头哥全新开源的安卓13系统SDK等软件栈，开发者可首次在RISC-V高性能硬件上体验安卓、openKylin等操作系统并直接开发相关应用。经过四个月的报名及开发阶段，本次大赛共计2012位开发者参赛，收到511份创意方案，参赛作品覆盖Vector加速、YOLO、机器人、车载设备、可穿戴设备、工业设备等领域。

**（2）积极构建良好的国内RISC-V创新环境**

**积极推动RISC-V标准化发展**

2023年8月，中国电子工业标准化技术协会RISC-V工作委员会成立大会在京召开。RISC-V工委会由中国电子工业标准化技术协会牵头，联合国内38家重点企业共同组建，是全国性、行业性、非盈利性的社会组织。工委会围绕RISC-V产业发展开展标准研制、符合性评估、知识产权保护、人才培养、产业研究等方面工作，并与RISC-V国际基金会协同合作，引导产业实现优势互补、资源共享、协同推进，营造产业良好生态环境，带动产业链高质量发展。

**国内企业成立RISC-V专利联盟**

2023年8月28日，由中国RISC-V产业联盟、芯原微电子（上海）股份有限公司共同主办的第三届滴水湖中国RISC-V产业论坛在上海召开，论坛上9家RISC-V领域企业宣布成立RISC-V专利联盟。该专利联盟旨在构建RISC-V专利互不诉讼的生态系统，推动RISC-V技术创新和快速发展。首批联盟成员包括芯原股份、芯来融智、平头哥、赛昉科技、时擎智能、思尔芯、钜泉光电、芯思原以及上海恒锐知识产权共计9家单位。

**（3）开源软件助力RISC-V生态发展**

**开放麒麟openKylin加入RISC-V国际基金会**

2023年7月，开放麒麟宣布openKylin社区正式加入RISC-V国际基金会，成为其产业联盟成员，以构筑操作系统与RISC-V架构软硬件生态协同发展，助力RISC-V生态建设。openKylin是一个桌面操作系统根社区，从源码级别自主构建了RISC-V开源桌面操作系统版本，目前能够支持HiFive Unmatched、VisionFive2、LicheePi和SG2042 EVB等多个硬件平台，支持80%以上市场主流RISC-V芯片，并与深度数智联合发布了全球首款搭载RISC-V笔记本电脑ROMA。同时，openKylin社区还基于RISC-V指令集和GPU优化了UKUI桌面环境，并适配了openKylin自研软件、Libreoffice、浏览器、影音播放和编程开发等常用软件。

**开源欧拉openEuler加入RISC-V Landscape**

2023年3月，开源欧拉openEuler宣布已加入RISC-V Landscape。openEuler以Community Organization Member的身份加入了RISC-V International，同时RISC-V正式成为openEuler的官方支持架构。RISC-V SIG领头完成了openEuler RISC-V 23.09的主线集成工作，该项目涵盖了主线代码回合、官方工程整合及正式的镜像的发布。自openEuler RISC-V 23.09版本起，RISC-V进入openEuler T1架构级别，这一进展标志着openEuler RISC-V发展的一个重要里程碑。目前开源欧拉已经推出多个基于openEuler开发的RISC-V架构的发行版。openEuler是由开放原子开源基金会孵化及运营的，面向数字基础设施的开源操作系统项目，支持服务器、云计算、边缘计算、嵌入式等应用场景。

### 3.4.4中国与国际的RISC-V合作

**（1）合作推出RISC-V配套开源工具项目**

2023年12月，中国芯原股份宣布与谷歌合作支持新推出的开源项目Open Se Cura。Open Se Cura项目是一个由设计工具和IP库组成的开源框架，配备了一个基于RISC-V ISA的开源、安全、低功耗的环境感知和传感系统，包括系统管理、机器学习和硬件信任根 (RoT) 功能。该项目旨在加速安全、可扩展、透明和高效的人工智能 (AI) 系统的发展。

**（2）合作推动RISC-V微控制器开发环境更加完善**

2023年12月，中国兆易创新与德国SEGGER Microcontroller GmbH（以下简称“SEGGER”）联合宣布，向所有使用GD32V系列RISC-V微控制器的用户提供免费商用的SEGGER Embedded Studio多平台集成开发环境（IDE）。SEGGER Embedded Studio配备了强大的项目构建和管理系统、灵活的源代码编辑器，以及用于下载和安装的软件支持包，还集成了高度优化的运行时库emRun、浮点库emFloat以及智能编译链接器。目前SEGGER所有工具现已完全支持GD32V RISC-V MCU，包括Embedded Studio集成开发环境(IDE)、市场领先的J-Link仿真器、Ozone debugger、实时操作系统embOS和通信、数据存储、压缩感知、物联网领域的软件库，以及Flasher编程器。

**（3）合作构建RISC-V车规级芯片的应用生态**

2023年7月，瑞典嵌入式开发软件和服务公司IAR与中国RISC-V处理器IP及解决方案公司芯来科技共同宣布达成战略合作：IAR的Embedded Workbench for RISC-V车规级工具链将全面支持芯来NA系列车规级处理器内核，包括代码编辑、编译、调试等功能，以支持在芯来车规级内核中实现汽车功能安全(FuSa)。IAR Embedded Workbench for RISC-V是一个经过认证的集成开发环境，内含强大的IAR C/C++编译程序和调试器。

**（4）合作打造更丰富的RISC-V硬件开发环境**

2023年7月，中国RISC-V设计企业平头哥与开源硬件开发社区BeagleBoard合作，推出首个兼容安卓的RISC-V单板计算机（SBC，Single Board Computer）BeagleV-Ahead。该单板机基于平头哥RISC-V内核芯片，开发者可以在机上运行安卓、Yocto、Ubuntu等多操作系统，能完成计算、存储及输入/输出等基础功能，并可直接嵌入智能产品中使用，可以协助开发者探索RISC-V在AI、物联网、机器人等领域的应用创新，降低了RISC-V开发门槛。