## 3.6开源供应链研究报告
### 3.6.1开源供应链整体态势

开源供应链主要关注开源产业生态中不同角色间的依赖关系，以及根据上下游关系梳理出的核心节点。这些节点既包括供应链的主体如开发者、开源社区、开源基金会，开源企业，也包括开源代码、开源项目、开源产品，以及广泛存在的链接不同主体和客体的中间载体，如编译器、开发和测试工具、开发语言、包管理器、代码托管平台、软件仓库、测试用例等。当前全球开源供应链的发展已日趋成熟，形成了项目数量庞大、精细化、专业化运作的社区，各国也在不断完善开源供应链的治理体系。美欧等国家和地区将开源提升至战略层面，产业界成立基金会协调相关企业共同维护开源供应链安全，一系列新的开源供应链相关标准也在逐步探索实践，关于开源供应链的研究正在逐步推进。供应链安全风险日益严峻，风险类型可以划分为技术、法律和其他三大类。

### 3.6.2开源供应链面临技术风险
开源供应链技术风险主要表现在大量开源项目、开源组件存在安全漏洞。在开源软件供应链中，供应链上游的漏洞会随着组件依赖和代码复用被引入到下游的应用软件中，因此漏洞数量近年来逐年递增，开发流程和最终使用者代码审计技能的不完善也会增大安全风险。直接和间接使用该开源代码或组件的用户基数越大，开源项目对攻击者的吸引力就越大，一旦出现问题影响也越大。

**（1）安全漏洞数量持续增长**

在过去几年中，包含漏洞的开源软件数量持续高速增长。安全企业Sonatype《Annual State of the Software Supply Chain 2023》调查统计了390多万个开源库，其中有245032个存在漏洞，较前五年相比急剧增长。

![](https://i-blog.csdnimg.cn/direct/1b59d6b543ca46bca4f8c36a41e82ea3.png#pic_center)
含有漏洞的开源库数量持续增长

已发布的开源软件漏洞数量也在不断增加，根据网安企业Mend最新一期的《Mend Open Source Risk Report》统计，近年来全球开源软件漏洞数量持续增加，在2022年，平均每个月新增开源漏洞数量已超1000，如下图所示。

![](https://i-blog.csdnimg.cn/direct/ae5cf7d5f3104370a18ca9bc4637ff35.png#pic_center)
近年来全球开源软件漏洞数量持续增加

漏洞增加的原因有很多，一部分原因是现在有更多的自动扫描和检测工具可以在开源软件中发现和修复这些安全漏洞，更重要的原因是全球利用上游开源生态系统（如JavaScript、Java、.NET和Python）的弱点而攻击的行为在持续增长。根据安全企业Sonatype的《Annual State of the Software Supply Chain 2023》调查统计，在2022年开源软件供应链攻击同比增长742% ，较前一年的650%再次大幅增长。

![](https://i-blog.csdnimg.cn/direct/0a092600c36e415ba1068ce0ac49db2b.png#pic_center)
2020年至2022年全球开源软件供应链攻击同比增加

开源软件供应链易的风险点在于攻击者发布恶意开源项目、植入恶意代码、使用易于合法包混淆的包名等。和其他软件安全风险相似的是，开源软件攻击者的主要手段是数据窃取、勒索病毒、获取主机权限、拒绝服务攻击以及其他获取经济利益的手段。根据新思（Synopsys）公司《2024年开源安全和风险分析报告》，Black Duck漏洞审计团队在2023年审计的1067个流行代码库中，96%的代码库包含开源代码，84%的包含至少一个漏洞，74%的包含高风险漏洞。分布数量前十的漏洞如下表所示。

 	
![](https://i-blog.csdnimg.cn/direct/e1c83a263c3d4e99ab59bd7ff2539f1f.png#pic_center)
分布数量前十的漏洞


**（2）安全漏洞层级传播**

在开源组件复杂的依赖关系中，一旦上游项目发现有严重漏洞，就会直接或间接地影响到依赖它的下游开源软件，在错综复杂的层级依赖关系传播后，该漏洞隐匿在深层依赖的应用中不易被发现，为全球软件供应链带来无法估量且不可控的影响。

根据安全企业Veracode发布的《State of Software Security: Open Source Edition》，统计了8.5k个应用和35.1k个开源软件库的数据显示，软件应用中平均每个软件应用依赖283个开源库，有90%的应用依赖34个以上的开源库，有10%的应用依赖1400个以上的开源库。其中依赖情况最复杂的是JavaScript，JavaScript应用中平均每个应用依赖377个开源库，有90%的应用依赖66个以上的开源库。按编程语言统计，大部分开源库平均漏洞数量介于2-3个之间，包含缺陷库的百分比最低的是.NET，最高的是PHP语言。

![](https://i-blog.csdnimg.cn/direct/ac8cf34f7a31486fb672586b17ca8686.png#pic_center)
开源软件库中漏洞存在情况

统计这些库中所有已发现漏洞类型，比例最高的是跨站脚本漏洞，之后分别是反序列化漏洞、越权漏洞。前三种类型在所有已发现的漏洞中占比超过四分之三。

![](https://i-blog.csdnimg.cn/direct/58a857a13ee1493e82410e97e4be24f8.png#pic_center)
开源软件库中主要漏洞类型

**（3）安全漏洞修复滞后**

开源软件开发过程中使用过时的、存在漏洞的开源组件仍然是常态。据Linux基金会统计，超过80%的代码库包含四年未更新的组件。根据Sonatype的《Annual State of the Software Supply Chain 2023》调查统计，只有28%的组织机构可在1天之内追踪到最新发布的漏洞。39%的组织机构在1到7天内追踪到并着手修复漏洞，29%的组织机构需要1周以上的时间才能追踪到。这意味着将有很长一段时间，软件应用暴露潜在的恶意攻击下。
 
![](https://i-blog.csdnimg.cn/direct/26154970483a48b3a1cfaf5a7fe5d7f4.png#pic_center)
漏洞修复时间分布

以2021年影响最大的Apache Log4j 2漏洞事件为例。据不完全统计，GitHub超过8600多个开源软件直接依赖Log4j 2组件，但通过这些开源软件继续追溯，最终超过20万个开源软件受到了影响。同时，在官方第一次发布修复版本的一周时间后，仍然有超过80%的间接关联开源软件没有被修复。

**（4）基础平台以及重要项目面临巨大的安全压力**

2024年3月全球最大的开源软件平台GitHub遭受了大规模攻击，涉及克隆安全且干净的存储库，添加恶意的、模糊的代码后重新上传。据报道，此类攻击于2023年5月开始，呈指数级增长。随着这些攻击的继续，越来越多的用户可能被感染。

历史上，Github多次面临恶意攻击和信息泄露风险。例如，2023年GitHub平台上发生了大规模的敏感信息泄露事件，超过300万个公开代码库累计泄漏超过1280万个身份验证和敏感密钥。2018年，Github遭受峰值高达1.3Tbs/秒的严重的DDoS攻击，其他年份也多次遭受严重攻击。Github作为开源领域的重要基础平台，长期面临巨大压力。

在重要项目方面，2024年爆出的开源软件xz后门事件引起业界震惊。一款在Red Hat和Debian等多个广泛使用的Linux版本中的压缩工具被发现植入了恶意代码，发现时该代码已存在三年，若xz被广泛引入各Linux发行版，Linux系统也将会轻易被入侵。目前，GitHub已经禁用XZ Utils代码库。

### 3.6.3开源供应链面临法律风险

开源软件并不等于无限制的自由使用，必须在遵循相关开源许可证的基础上注重知识产权保护。常见的许可证有GPL、LGPL、AGPL、MPL、MIT、BSD和Apache等，各个许可证还包含不同版本。总体上可分为宽松式（Permissive）和责任传播式（Copyleft）两种。若不认真分析和甄别，很容易陷入许可证冲突，违反协议条款等法律风险。

**（1）开源许可证冲突**

信息系统中不同部分会存在多个开源软件许可证，但不同软件提供者对于软件发行的目的不同，因此开源软件许可证对企业或个人所给予的自由程度有所差别。而多个开源软件的条款之间可能会存在法律冲突，例如因署名义务引发的冲突，因发布义务引发的冲突，因许可证（GPL类）的传染性引发的冲突等，需要对具体代码库进行风险分析。根据新思（Synopsys）公司《2024年开源安全和风险分析报告》，Black Duck漏洞审计团队在2023年审计的1067个流行代码库中发现，53%包含存在许可证冲突的开源软件，有36%包含没有许可证或定制许可证的开源代码。

![](https://i-blog.csdnimg.cn/direct/845f64572b9a4631bf083a79752642e7.png#pic_center)
开源代码库的许可问题

其中，Creative Commons是引发许可证冲突的最主要的原因。仅Creative Commons ShareAlike 3.0(CC-SA 3.0)就引发了17%的许可证冲突。这可能是因为开发人员手动将代码片段或部分组件“复制粘贴”到代码库中，它们通常来自颇受欢迎的博客网站Stack Overflow，该网站根据Creative Commons ShareAlike许可证自动授权所有可公开访问的用户贡献。但这些许可证根本不是针对软件设计的，可能会引起法律方面的风险。

![](https://i-blog.csdnimg.cn/direct/06615799011545808c4f81659a0bda8c.png#pic_center)
最常见10种许可证冲突代码库占比

**（2）特殊附加条款存在隐藏红线**

即使有些企业在专利运营方面成果显著，被称作为“巨无霸”，但是在使用开源软件时也要注意一些“隐藏”红线。安卓系统是谷歌开发的智能手机和平板电脑操作系统，全球份额超过82%，虽然安卓系统被称为开源系统，但是开源系统也存在着“垄断”行为，最简单的例子是手机制造商必须接受预装的谷歌软件，否则将无法使用安卓系统。作为免费安装安卓系统的“对价”，如果一个设备制造商意图安装谷歌的任何服务，主要是安卓系统，谷歌都会在协议中要求他们安装其他的谷歌服务，在形式上非常类似于捆绑销售。这份“移动应用分发协议”（Mobile Application Distribution Agreement）（以下简称MADA协议）被其竞争对手在欧洲、韩国等地投诉滥用市场地位。分析MADA协议中的预装服务条款，一旦制造商决定安装一个类似于YouTube的谷歌服务，那么谷歌的搜索引擎就会被认为是搜索的默认引擎，谷歌地址服务也会默认安装并应用。由于“集群效应”的存在，制造商将有可能主动排除选择竞争对手的软件。

另外，有些软件被称为“开放源代码”软件但实质上同真正的开源软件有着本质不同，例如微软提出的“共享源代码计划”（Shared Source Initiative），该计划所提供的绝大部分源代码都允许合资格者下载，并通过各种许可证进行规范和限制，而用户并不能直接对源代码有任何修改，只允许阅读源代码或提出修改意见。

**（3）开源知识产权问题悬而未决**

开源供应链还涉及到著作权，软件专利，商标和商业秘密等法律风险。首先，由于开源软件都有免担保条款，强调“在任何情况下，软件的原始开发者和版权所有者都不对任何损失负责，即使他们已经被告知这种损失的可能性”，但如果软件作者明知某代码存在危害性，同时未署名并标明修改内容，软件作者的这种行为并不会收到免担保条款的保护，依旧会被认定为侵犯了他人的知识产权。其次，开源软件的著作权仍未明确，世界各地的开发者都会参与进开源软件的改进，这就不会出现对开源软件进行修改且具有独创性，修改的结果使得开源软件能单独成为一个新的作品，该作品也受到著作权法独立的保护。再次，后续开发者将基于源代码产生的作品进行专利申请，导致使用该软件的用户可能会侵权专利权。最后，开源软件的开发人员之间并非以真实姓名联系，沟通的方式一般通过网络进行，因此开源项目组很难判断个人提交的代码是否侵犯他人的知识产权。

另外，随着近年来大模型持续火热，人工智能工具也使得开源代码知识产权变得日益复杂。随着AI驱动的编码推荐工具的使用，围绕生成代码的所有权、版权和许可问题也随之产生。例如，一项针对GitHub、Microsoft和OpenAI的集体诉讼声称，GitHub Copilot违反了版权法和软件许可要求。具体包括Copilot推荐的代码使用了未经许可的内容，没有归属、版权声明，或者不遵守原始许可条款。该案例凸显出使用AI生成代码的法律复杂性。


**3.6.4开源供应链面临其他风险**

阻碍开源供应链上下游高效整合的一大因素是信息不透明，展开来讲是开源组件的成分、依赖信息的缺失或紊乱。而全球范围内供应链安全标准体系仍未统一，专业性的供应链安全组织尚未建设成熟。维护开源供应链本身逐渐成为一项成本高昂的工作，这导致小团队的项目因能力有限而逐步停止维护，而大公司凭借资源优势易在细分领域形成生态垄断，这将对开源供应链的健康发展带来巨大风险。

**（1）小项目停止维护**

当一个开源代码库变得越来越受欢迎时，其代价就是其维护人员承受的压力就会越来越大，随之产生一系列运维相关问题。大量的项目处于失去维护的风险中，据奇安信代码安全实验室《2023中国软件供应链安全分析报告》数据显示，2022年全年，主流开源软件包管理工具生态系统中不活跃的开源软件项目数量为3967204个，占比高达72.1%。统计的八个典型的开源软件包管理工具生态系统Maven、NPM、Packagist、Pypi、Godoc、Nuget、Rubygems、Swift中NPM的不活跃项目数量最多，达1693287个，Rubygems的不活跃项目比例最高，占比达到90.5%。具体见下表。

![](https://i-blog.csdnimg.cn/direct/11f4d85f1e3f49d294062176f9f39df3.png#pic_center)
开源软件包管理工具生态不活跃项目数量


开源项目是由不确定数量的贡献者和维护者共同努力的结果。这种结构使开源成为一种协作项目，但由于开展维护活动的贡献者缺乏激励，小型团队常常难以支持开源代码的持续维护。新思《开源安全和风险分析报告2023》统计的1,481个代码库中，91%都包含过去两年内未进行任何更新的开源代码。这可能意味着相关方不再对该项目进行维护，尤其是在小型项目。

![](https://i-blog.csdnimg.cn/direct/ebc8d32ad06b4ed785f04941638951f6.png#pic_center)
近年来开源代码库可维护性

2020年初，JavaScript的模块化标准库core-js的作者Denis Pushkarev因交通肇事被判处18个月监禁。Denis Pushkarev是core-js项目唯一的维护人员，该项目周下载量达2600万次，在npmjs.com上被19279个包依赖，重要程度可以认为是前端的基础设施。后续，GitHub社区通过将账户所有权转移暂时缓解这一问题。

2022年1月10日，个人软件开发者Marak Squires将其个人创建的位于项目仓库GitHub和开源组件包NPM上的开源库faker.js、colors.js的代码清空。由于成千上万的用户依赖这些库，本次恶意更新导致所有相关项目受到影响。使用遭到破坏的版本，会导致应用程序无限输出乱码。据报道，其清空仓库的代码是因为缺乏资金和被别人滥用开源项目，并声称不希望自己的努力成果为国际巨头企业免费使用。由于faker.js、colors.js代码库的历史版本仍存在于相关平台上，用户可及时降级为旧版本解决。后续，项目仓库GitHub还暂停了该作者对自己所有公共和私有项目的访问。

2022年1月11日，另一个开源项目Apache PLC4X的创建者Christofer Dutz也在开源托管平台GitHub中发文，称由于得不到任何形式的回报，他将停止对PLC4X的企业用户提供免费的社区咨询，若后续仍无企业资助项目则将停止项目维护和任何形式的支持。

**（2）大企业生态垄断**

随着开源势不可挡地发展，全球科技巨头持续加码开源领域，通过收购开源平台逐渐强化其市场主导地位，并使得社区从早期的高度分散的技术架构转变为由几个强大的网络巨头所控制的架构。这种“大公司拥抱开源”的现象，一方面因大公司拥有在更高级别上开发和维护开源项目所需的资金，推动产生了更多的开源重点项目，并有助于提高质量和安全性；另一方面，受商业利益等因素驱使，通过对开源社区项目的开发和商业化推广，对开发人员施加种种限制，易造成技术垄断，并最终阻碍技术创新。

例如一些国际巨头通过通用性和适用性的开源产品，在产业链中具有掌握极大话语权。这些开源产品自身具有一定通用性和适用性，便于后续开发者“不重复制造轮子”而在其产品的基础上进行进一步开发，但又通过人为制造诸如广告服务、有意破坏其他竞品的用户体验等方式排除竞争者获得垄断地位，最后获得高额利润。尽管这些产品本身都是开源的，但是中小企业和个体开发者在面对限定的服务接口、苛刻的商业条款等问题时，很少有能力再进行创新并反馈开源社区。

**（3）云服务等新模式的影响**

开源在云服务兴起和大规模应用过程中发挥了至关重要的作用，在云原生等新兴领域也将持续产生深刻影响。但另一方面，云服务也给开源产业带来了新的挑战和冲击。云提供商可以通过采用开源软件搭建相关服务，并使其商业化，但云提供商并不必须为这些开源技术买单或者支持未来开发。相关的争议引出了在开源社区已存在一段时间的问题。开源使用效果最好的地方是软件基础设施，而不是应用软件项目。如果云计算公司成为软件的基础设施提供商，它们的市场控制力可能让它们得以接管开源项目，并以低于销售开源服务的公司的价格销售这些软件服务。云服务商可以此获得大量利润，但对回馈社区基本没有贡献。

部分开源研发的企业对云服务商因开源获利却不回馈社区的行为难以忍受。例如数据库系统Redis就因此更改了协议。Redis不再使用BSD 3-Clause开源协议进行分发。从Redis 7.4版本开始，Redis将采用SSPLv1和 RSALv2双重许可证。Redis的源代码将通过Redis社区版免费提供给开发者、客户和合作伙伴。但托管Redis产品的云服务提供商将不再允许免费使用Redis的源代码。

**（4）国际形势以及政治因素影响**

近年来，美国不断修改《出口管制条例》（EAR）来试图限制和阻挠一些包括开源技术在内的先进技术出口到特定国家、特定实体和雇员，并先后采取了如账号禁止访问、代码删除等行为来实现“断供”。另外，开源软件供应链近年来也越来越多地面临意识形态、地缘政治、战争冲突等因素导致的影响。多个开源平台、开源项目要求开发者和用户在参与开源的时候进行表态，并根据政治立场划分阵营分裂对抗，社区中开源协作的基础被人为割裂了。虽然开源社区一向推崇“自由、平等、相互尊重”的原则，开源精神被无数开发者奉为圭臬，然而“断供”“封锁”之类事件的不断上演，令全球开源开发者们开始担心，政治因素未来是否将逐步影响开源，“开源无国界”是否可能成为伪命题。

然而，从积极的一面看，并不是所有的开发者和开源社区都会轻易被政治倾向和意识形态所左右。在2022年3月，Eclipse社区中引发了一起线上争端，并引发大讨论，24小时内就被社区管理者和资深开发者平息。事情起因是由于一位来自欧洲的代码维护者，拒绝接纳来自中国开发者的一个补丁，补丁内容针对的是龙芯架构指令集。公开拒绝的原因既有技术原因，也有政治因素。不过，社区中绝大多数开发者选择保持中立，或要求不要在Eclipse社区中讨论政治话题，而一些中国开发者听闻之后，涌入该社区进行针对性抨击，争端有愈演愈烈的迹象。该社区主要负责人第一时间站出来平息事件，主要观点两个，这是一个开放的技术社区，任何人都可以有自己的政治主张，社区对此不予评价，但社区是一个进行技术交流合作创新的地方，社区不欢迎一切有关政治立场和倾向的话题在此讨论。同时，根据OSI对于开源定义的十个特征，Eclipse社区严格执行其中有关对任何人和群体，任何技术路线的非歧视原则，因此，社区不赞成拒收来自中国的补丁。通过这个案例，可以得出结论，开源本身是具有非政治倾向的一个群体，但其中不乏一些个体会有各种观点和主张，也会有偏见和过激的行为。作为中国开发者和开源爱好者，应该尊重开源“开放共享、平等协作”的创新精神，并坚定的支持开源社区远离政治因素的干扰，保护和建设这方净土。
