#第二章 开源开发者及项目发展现状

随着开源文化的普及和技术飞速发展，越来越多的开发者投身开源项目，共同促进开源生态的繁荣。作为项目核心动力，开发者从编写、测试到优化代码，持续推动项目进展。同时，他们的多元背景和专长，丰富了开源项目的技术内涵和功能应用。在生成式人工智能大趋势下，开发者积极吸纳新技术，显著提升了项目的智能化、性能、安全性和易用性，共同构建一个开放、协作、创新的生态体系。

近年来，中国开源生态发展迅速，呈现出以下主要特点：

**开源人才大量供给：**大量外企和国企的开源岗位，培养了一批开源人才，开源开发者增速很快。中国年轻一代的开发者具备全球化的视野和交际能力，开始主动融入全球协作，参与到开源项目。

**开源社区发展迅速：**涌现出一批具有影响力的开源社区，如开源中国、CSDN、掘金等，这些社区为开发者提供了丰富的技术资源、交流平台和互助环境，有力地推动了中国开源生态的发展。

**开源项目数量逐年攀升：**涉及云计算、大数据、人工智能、物联网等多个领域，部分项目已在国际开源社区中取得一定影响力。

##2.1 开源开发者发展现状

###2.1.1 开源开发者发展概述

**（一）开发者画像及规模、发展趋势**

在2023年中国软件创新发展大会上，工信部发布了ICT产业的最新数据：中国的源代码贡献量已经达到世界第二，国内开源软件开发者数量突破800万，同样居全球第二。面对日益繁荣的开源市场，工信部已制定实施《“十四五”软件和信息技术服务业发展规划》，为加速开源发展和繁荣开源生态提出了明确战略部署和要求。此外，开源产业相关的中央及地方政策也日趋完善。

![](https://i-blog.csdnimg.cn/direct/e2492f15340d4a21a8dc5641141f3757.jpeg#pic_center)

过去一年各地方政府的开源政策（图源：整理自网络）

中国的开源开发者数量呈现稳步上升状态。据GitHub 2023年数据显示，平台上已有1亿名开发者。根据GitHub Octoverse 2021报告显示，有755万名用户来自于中国；在2022年新增的2050万用户中，近320万（约15.6%）来自中国。目前GitHub的1亿用户中，超过一千万名开发者来自中国。

![](https://i-blog.csdnimg.cn/direct/e4b699b484434ae0953ff07010b02344.png#pic_center)
GitHub平台开发者增长趋势 （图源：GitHub Octoverse）

从国家和地区分布来看，中国和印度的GitHub开发者用户数量和增长速度仅次于美国。印度、中国和巴西以其庞大的人口基数，开发者数量分别位居二三四位，但从活跃率（年度活跃数/总人数）可以看到，中国是前四名中最高的。

![](https://i-blog.csdnimg.cn/direct/c2724d62d60144c78e8b3d24e41b358a.png#pic_center)
全球开发者国家/地区人数分布（Top15） （图源： 开源社）

基于国内主流的技术社区及论坛的注册用户数，观察中国开发者的整体增长趋势时发现，中国开发者社区CSDN，注册用户超过5000万，覆盖全球95%的中文开发者，超过750万日均独立用户，超过1亿月独立访问用户。与此同时，CSDN于2022年推出面向新一代云原生开发者的开发云服务，为开发者提供更加稳定、便捷、高效的开源工具和开源服务。此外，CSDN携手华为云CodeArts推出新一代AI驱动的开源开发者平台，依托CodeArts一站式、全流程、安全可信的软件开发生产线，与CSDN数以千万的开发者，将成为人工智能驱动的新一代开发资源库和赋能平台，服务智能时代新开发者生态。目前用户数达到245万，项目超33万，入驻组织达到4.9万。

根据开源社区Gitee统计，2023年Gitee总用户数达到1200万，新增用户200万，总仓库数量达到3000万，新仓库数量500万。

 
**（二）开发者行业、地域、技术特点等**

根据CSDN发布的《2024中国开发者调查报告》显示，我们将开发者根据年龄范围划分成三类，对不同年龄段开发者群体进行特征分析后发现，30岁以下的开发者人数占72%， 本科及以上学历占78%，84%的开发者都是男性。软件行业涵盖了国内四成开发者，40岁以下的开发者从事后端开发的比例最高。40岁以上开发者在一线城市占比最高，达到36%，所属行业重点分布在软件、教育和其他制造业领域。

![](https://i-blog.csdnimg.cn/direct/6b6b9ebe71cf443bb7f22d91de9bd8f4.png#pic_center)
开发者基本特征 （图源： CSDN）

全国超过40%的开发者工作在一线城市（其中以北京、上海、广州、深圳为主）。北京、广东是开发者聚集较多的地域，占全国总数的27%。江苏、上海地区的开发者占比数量处于第二梯队，占全国总数的14%。

![](https://i-blog.csdnimg.cn/direct/e5696c172a64448885a1c718c9675548.png#pic_center)
开发者地域分布（省、自治区、直辖市、特别行政区）Top15（图源：CSDN）

在参与开源项目的群体中，35%的人是兼职或在业余时间参与，34%是自由开发者，而全职开源开发者的比例为14%。这些数据反映了开源生态的多样性和广泛的参与基础，显示出即使在非全职的情况下，开源项目仍然吸引了大量贡献者，推动了技术的创新和社区的发展。

![](https://i-blog.csdnimg.cn/direct/ecb7d756a45d4eeda698d0f4d48354c0.png#pic_center)
参与开源的人群比例（图源：CSDN）

越来越多的开发者通过参与开源项目提升技能、获取资源，并在全球开源社区中协作与分享。数据显示，近三成开发者接触开源已有3-5年的时间。

![](https://i-blog.csdnimg.cn/direct/50a6c60b0f574db59004dc0ba4e69d6e.png#pic_center)
开发者参与开源的时间（图源：CSDN）

在开源项目的贡献上，主要还是通过代码和文档的贡献，在参与开源的开发者中，有35%的开发者有代码贡献，31%开发者有文档贡献。

![](https://i-blog.csdnimg.cn/direct/0557cc9cdc3f4bdf91d04b4cfbb648e0.png#pic_center)
开发者参与开源的方式（图源：CSDN）

中国开源开发者在多个技术领域都有显著贡献。数据显示，开发者对开源技术领域的关注点主要集中在开源AI、开源大数据和开源云原生技术上，分别占比47%、28%和24%。这表明人工智能、数据处理和云计算是当前最受开发者重视的技术方向。总体来看，开发者对于新兴技术和基础架构的兴趣广泛，尤其是能够推动技术前沿发展的领域，如人工智能和大数据分析，显示了其在行业中的重要性和发展潜力。

![](https://i-blog.csdnimg.cn/direct/e757e010b30c456e97f1503af4889f80.png#pic_center)
开发者关注的开源技术领域（图源： CSDN）

全民AI时代，已有69%的开发者在日常工作、生活中用上了AI智能化工具。还有25%的人正处于计划使用中。

![](https://i-blog.csdnimg.cn/direct/abc6a5ca1e9e4810aa76fbfeb8e6f2b7.png#pic_center)
AI工具使用情况（图源： CSDN）

在全球开源背景下，超过75%的开发者支持AI大模型的开源，并认为这种开源模式可以促进全球开发者社区的参与和贡献，从而防止技术垄断。通过开源大模型，开发者能够共享资源和技术，实现创新的快速迭代。此外，开源大模型能够降低进入门槛，让更多中小企业和研究机构利用先进的AI技术，从而推动整个行业的进步和多样化发展。

开源不仅有助于技术的普及，还能加强跨国界的合作，促进技术交流与共享。这种协作方式在提升项目的质量和影响力的同时，还为开发者提供了学习和成长的机会。

![](https://i-blog.csdnimg.cn/direct/bb220db2860c438ea61cef69ecf86198.png#pic_center)
开源与闭源对AI大模型的影响（图源： CSDN）

###2.1.2 开发者在全球开源的投入与贡献分析
选择开源的原因多种多样，其中48%的开发者认为开源协作方式能够显著降低开发成本，34%的人认为可以基于开源软件进行二次开发和定制自己的服务。这样的选择不仅节省资源，还能加速创新，促进技术交流和共享。在这种背景下，开源模式被越来越多的开发者和企业所接受和推广。
除此之外，开放透明的代码和知识共享、众多的社区开发人员支持也是吸引开发者使用开源软件的重要原因。如果没有开源社区、开源活动、开源项目的支持，也不会有今天繁荣的开源生态。

![](https://i-blog.csdnimg.cn/direct/e0d9b5d566014a55afe9b0b18ec95760.png#pic_center)
吸引开发者使用开源软件的因素（图源： CSDN）

 
**（一）开源组织和开源活动**

我国开发者发起和主导的开源社区不断发展， 开源项目逐步实现国际化。数据显示，截至2022年，国内已经成立超过500个开源社区，涵盖了数据库、中间件、物联网、微服务、大数据、人工智能、移动互联网、云计算等技术领域。中国开发者主导的开源项目占全球12.5%，中国发起的开源项目海外贡献者占比33.7%。

就地域而言，多数社区集聚在北京地区，共有74个，相较去年新增了5个，代表社区有Apache IoTDB、Kube OVN、开源GitOps产业联盟、Casbin开源社区等。上海的开源社区数量排名第二，有27家，覆盖Kratos开源社区、Neo4j开发者社区、Graviti AI Community、OpenDataLab社区等。杭州地区有25家，包含Curve开源社区、Apache RocketMQ、Datawhale社区等。

![](https://i-blog.csdnimg.cn/direct/852e35c97add4d638f3d6d487c79bb11.png#pic_center)
开源社区城市分布（图源： 开源社）

今年云原生和大数据在开源社区领域的类别中数量最高，均为47个。这两种技术在当今数字化转型和企业运营中扮演着越来越重要的角色。云原生技术支持应用程序的可移植性和可扩展性，使企业能够更灵活地管理和部署应用。而大数据技术则是处理和分析海量数据的关键，帮助企业在数据驱动的决策中获得竞争优势。这些技术领域的项目数量之多反映了开源社区的高度活跃。开发者们在云原生和大数据方面的贡献显著增加，推动了技术的快速迭代和创新。开源社区的合作使得这些技术更加成熟和完善。


![](https://i-blog.csdnimg.cn/direct/11ec4ffd67654aaa934659ec05eeb6c1.png#pic_center)
开源社区领域排行（图源： 开源社）


在开源组织活跃度方面，据 OSCHINA《2023中国开源开发者报告》显示，OpenHarmony凭借其日益强大的生态规模保持着极高的活跃度。其次分别为openEuler、anolis、MindSpore。
 
![](https://i-blog.csdnimg.cn/direct/273e5769eeb34b4e8b3639fde5df7f90.png#pic_center)
2023年最活跃的开源组织（图源：OSCHINA）

从2023年最受开发者关注的和喜爱的开源组织中，可以看出技术大厂凭借其技术底蕴和知名度仍然收获了大部分开发者的关注，但同时由开发者自发形成的开源组织受到了更多开发者的喜爱，如开源组织Dromara经过多年发展，已经逐渐有了自己的组织架构、项目捐赠机制和毕业机制，在用心的经营下，Dromara也在2023年共获得了超过57000个Star。


![](https://i-blog.csdnimg.cn/direct/1d93ce2e08fd4ceea5440e9d10f487bd.png#pic_center)
2023年最活跃的开源组织词云（图源：OSCHINA）
 
 
在过去一年，国内举办了多场开源社区活动和会议，为开发者提供了学习和交流的机会。例如：

全球开源技术峰会（Global Open-source Technology Conference），简称GOTC，是由上海浦东软件园、开放原子开源基金会、Linux基金会亚太区和开源中国联合发起的，面向全球开发者的一场盛大开源技术盛宴。GOTC 2023于上海举办为期2天的开源行业盛会，以行业展览、主题发言、特别论坛、分论坛的形式展现，与会者将一起探讨元宇宙、3D与游戏、eBPF、Web3.0、区块链等热门技术主题，以及开源社区、开源商业化、开源教育培训、云原生等热门话题，探讨开源未来，助力开源发展。

在2023年6月15～16日由COPU召开的《第18届开源中国开源世界高峰论坛》和《园桌会议》上，中外专家对GPT的发展前景进行了热烈讨论。在会上谈到OpenAI、谷歌、微软等科技大公司在数据和模型权重方面拥有优势，结合他们的商业战略，选择了闭源大模型：OpenAI的ChatGPT，谷歌Bard、微软的AzureChatGPT，垄断了大型语言模型市场。座谈会结论性意见是：大模型走向开源的趋势几乎成为定局。

2023年6月11日-13日，2023开放原子全球开源峰会在北京圆满举办。本届峰会以“开源赋能，普惠未来”为主题，邀前沿科学家、技术领袖揭秘顶尖的开源趋势，与国际嘉宾、行业专家探讨开源领域最前沿的思想与理论，与开发者大咖、技术创作者学习交流，聚集政、产、学、研、用、创、投、金等各领域的优势资源，共商开源发展大计，共筑开源发展未来，凝聚共建、共治、共享的发展共识。

2023年9月26日，由GOSIM开源创新汇主办，CSDN协办的GOSIM Conference在上海跨国采购会展中心隆重召开。来自英特尔、Arm、华为、微软、字节跳动、中兴、Futurewei、国汽智控、长安汽车、新加坡南洋理工、波特兰州立大学、清华大学、Rust 社区等全球60+产学研专家助阵，进行技术解读和产业论证，旨在汇聚全球开源力量，提升开源价值，共铸开源新生态。

由开源社主办的第八届中国开源年会（COSCon'23）于2023年10月29日在成都圆满收官。这次大会众多开源大神云集，以“Mind Hackathon”为主题的创新主论坛形式让人耳目一新，同时分论坛延续往年传统将时下热点技术领域一网打尽，覆盖人工智能、开源商业、云计算、大数据、区块链、开源教育、开源文化、开源治理、开源硬件、开源操作系统、编程语言、女性论坛、Web应用开发、开源百宝箱以及闪电演讲等等。

2023 CCF中国开源大会于2023年10月21日至22日在湖南省长沙市北辰国际会议中心召开。本届大会的主题为“开源联合、聚力共赢”，邀请开源及相关领域中国科学院院士、中国工程院院士与知名专家，为大会带来特邀报告并参加开源高峰论坛等活动。本届大会作为中国开源领域的年度盛会，诚挚地邀请开源领域学术界、企业界、教育界的学者、从业者、师生等前来参会，共见中国开源新征程！

CSDN主办的第四届“长沙·中国1024程序员节”于2023年10月23 - 24日在长沙盛大举行，本届程序员节以“研发新高地，数智创未来”为主题，设置了岳麓对话、技术英雄会、十多场技术论坛以及编程大赛、创新展览、开发者嘉年华等精彩环节。议题涵盖人工智能、开源、AI模型、数据技术、AI编程与研发效能、自动驾驶与智能制造、信创等热点方向。
 

**（二）开源项目开发者贡献发展现状**

中国在开源项目上的发展近年来取得了显著成就。据X-Lab数据显示，全球开源仓库OpenRank排名如下：

注：OpenRank指标是由X-Lab开放实验室所研发，基于开源开发者—项目协作关系网络构建的协作网络指标，不仅能够很好地表征项目的整体发展状态、社区参与度，同时也引入了开源生态的要素，能够很好地将开源生态中位于关键协作位置的项目、人、组织等实体识别并展示出来。
 
![](https://i-blog.csdnimg.cn/direct/f8cac6c2e4544a6492bbb21c0a866c06.png#pic_center)
全球开源项目OpenRank排名（Top 20）（图源： X-Lab）
 

聚焦中国开源项目，OpenRank排名如下图所示。榜单上，位列前五的分别为openHarmony、openEuler、PaddlePaddle、MindSpore、Ant Design。这样的排名反映中国开源事业的蓬勃发展，企业与个人对于开源技术的贡献与参与度不断提升，同时也意味着开源项目在中国正受到越来越多的关注和实质性支持，无论是从政府、企业还是开发者层面。与此同时，在Top20榜单中，我们发现中国顶尖开源项目在操作系统、大数据、数据库、前端、人工智能等领域表现尤为突出。


![](https://i-blog.csdnimg.cn/direct/e1a9abacefa14c298c962c36bbd511db.png#pic_center)
中国开源项目OpenRank排名（Top20）（图源：X-Lab）


中国开源项目是以OpenDigger项目标签数据为准，单项目可能包含多个 GitHub或Gitee平台上的组织或仓库。


放眼全球重点参与开源的企业，排名前五的分别是微软、华为、谷歌、亚马逊和Meta公司。其中，微软自十多年前（2008年）开始布局开源，时任公司平台技术战略和开源软件实验室总监山姆·拉姆齐（Sam Ramji）在微软内部大力呼吁增强开源软件和闭源软件的互操作性。2014年，Satya Nadella担任微软首席执行官后，高调宣称：“微软爱Linux”，彻底改变了微软对开源的态度。在随后的两年多时间里，微软通过积极参与和贡献开源项目，于2016年达到了全球开源影响力的巅峰，并且这种影响力一直持续到今天，至今无人撼动。

![](https://i-blog.csdnimg.cn/direct/33815d103522490180465b1e22afd753.png#pic_center)
全球企业OpenRank排名（Top20）（图源：开源社）

聚焦国内，华为于2019年将开源作为重要战略方向开始发力，仅用2年的时间就做到了国内第一，全球第二的位置；阿里巴巴在2021年前，一直是国内开源的领先者，并至今稳居世界第六的排名；蚂蚁集团在近三年的表现也是非常抢眼，并于2023年正式进入世界前十；国内开源的第四大巨头百度，由于国内快速的开源态势变化，目前排名全球12。

根据OpenLeaderboard榜单显示，进入全球前30的中国企业还有字节跳动（18）、PingCAP（19）、飞致云（24）、Deepin（25）、腾讯（26）、以及乐鑫科技（27）。

![](https://i-blog.csdnimg.cn/direct/6c78d6e966f849eca80dcb7f322f3e00.png#pic_center)
中国企业OpenRank排名变化（图源：开源社）

##2.2开源项目发展现状
###2.2.1 中国开源项目概况

**（一）总体概况 **

首先，统计分析全域 GitHub 的事件⽇志总体数量，如下图所示。


![](https://i-blog.csdnimg.cn/direct/1609d09b7e2c42f5a632e7a657153068.png#pic_center)
全球项目GitHub年度事件数趋势

可以看到近⼏年全球开源的总体活跃情况和活跃仓库数量都在明显上升，显⽰了全球开源在快速发展。经过2018-2020年的高增长后，GitHub平台的年度事件增长数量逐渐下降。2023年GitHub⽇志数据为14亿，相⽐2022年增⻓了约10.32%。但由于整体体量的关系，10.23%的增长率还是一个非常大的数字，继续凸显出开源科技的发展在全球数字化转型中的活跃与关键地位。

![](https://i-blog.csdnimg.cn/direct/f04f3e3e54d649dcbeb94abf3ec41279.png#pic_center)
中国项目GitHub年度事件数趋势

在经历了疫情前后的快速增长后，GitHub平台上中国项目活跃度开始处于一个稳定的增长期。中国在2023年的日志事件和活跃仓库数均有明显的增长，相信在国家各项政策性意见的出台下，中国开源的发展会越来越好。

同时，在全球的开源舞台上，越来越多的中国代码托管平台涌现出来：

* GitHub：拥有强大的协同功能，能够让全球的开发者在同一项目中共同作业，支持PR（Pull Request）以及Issue等功能。同时，GitHub还提供了代码审查、项目管理、版本控制等一系列工具，对于开源项目非常友好。其社区非常活跃，有着丰富的第三方集成服务。然而，对于私有项目，GitHub的价格相对较高。

* GitLab：除了具有版本控制功能，还具备项目管理、CI/CD等功能。GitLab有着完善的权限管理系统，支持多人协同开发，也可自建服务器，适用于企业内部使用。其持续集成工具GitLab CI/CD功能十分强大，可进行自动测试、部署等。不过，GitLab的界面相对于GitHub更复杂一些，需要一些时间来适应。

* GitCode：是CSDN携手华为云CodeArts 推出新一代AI驱动的开源开发者平台，依托CodeArts一站式、全流程，安全可信的软件开发生产线与 CSDN 数以千万的开发者，将成为人工智能驱动的新一代开发资源库和赋能平台，服务智能时代新开发者生态。

* Gitee：是开源中国社区2013年推出的基于Git的代码托管服务，目前已经成为国内知名的代码托管平台，致力于为国内开发者提供优质稳定的托管服务。除了提供最基础的Git代码托管之外，还提供代码在线查看、历史版本查看、Fork、Pull Request、打包下载任意版本、Issue、Wiki 、保护分支、代码质量检测、PaaS项目演示等方便管理、开发、协作、共享的功能。

* GitLink：是CCF官方指定的开源创新服务平台，旨在以“为开源创新服务”为使命，以“成为开源创新的汇聚地”为愿景，秉承“创新、开放、协作、共享”的价值观，致力于为大规模开源开放协同创新助力赋能，打造创新成果孵化和新工科人才培养的开源创新生态！拥有分布式协作开发、一站式过程管理、高效流水线运维、多层次代码分析、多维度用户画像等多种功能。

* Bitbucket：是Atlassian公司开发的一款Git版本控制系统，与Jira、Confluence等工具有很好的集成，方便团队协同开发。Bitbucket支持私有仓库，针对小团队有免费方案，比较适合初创公司使用。然而，相较于GitHub和GitLab，Bitbucket的社区活跃度较低。

* SourceForge：这是一个开源软件开发和下载平台，允许用户利用Git 进行版本控制，并提供项目管理、错误跟踪、功能请求等工具。其界面设计较为陈旧，开源项目的数量和活跃度相较于GitHub要低一些。

* Beanstalk：一款为企业设计的Git项目管理工具，拥有代码审查、发布工具、时间线、通知和报告等功能，还提供了强大的权限管理功能和集成其他服务的能力，但价格较高，不太适合小团队或者个人开发者。

* Gitea：一个开源的自托管Git服务，界面简洁，部署简单，支持多人协同开发，拥有issue跟踪和管理系统，更适用于小型团队或者个人开发者。

* Coding：是一个面向开发者的云端开发平台，致力于做项目众包平台。支持多种账号登陆，实行用户等级制。

* 阿里云效Codeup：阿里云的代码管理平台，致力于保障企业代码资产安全，支持自动化代码扫描、合并评审管控等高级功能。

* 腾讯Coding：腾讯旗下的开发平台，提供一站式开发管理协作工具，帮助研发团队快速落地敏捷开发与DevOps开发方式，实现研发效能升级，适用于多种研发工作场景。

* SVNChina：国内成立较早的支持私有项目的SVN源代码托管平台。

* Google Code：拥有良好的issue tracker、wiki系统以及Google group/gmail的集成，同时支持svn/mercurial/git三种版本管理，但在中国大陆无法访问。


（二）GitHub和Gitee的总事件数趋势比较

由于GitHub平台活跃事件的庞大，接下来的分析工作，建立在每个平台的前3万个活跃仓库的基准之上。为了方便比较，选取了GitHub与Gitee中与开源参与相关性较大的8类事件进行统计分析，包括CommitCommentEvent、ForkEvent、IssueCommentEvent、IssuesEvent、PullRequestEvent、PullRequestReviewCommentEvent、PushEvent 和 WatchEvent。

![](https://i-blog.csdnimg.cn/direct/1cc988e317f14d26b11c7209690ff307.png#pic_center)
GitHub与Gitee活跃仓库事件数（图源：开源社）

分析发现Gitee平台呈现更为显著的增长趋势。甚至从2021年起，前3万个活跃仓库的事件数量超越了GitHub，凸显了国内活跃开源项目的爆发态势。反映了国内开发者积极参与和贡献到开源社区的热情，为技术创新和知识共享注入了新的活力。

然而，需要强调的是，单纯依靠前3万个活跃项目的数据无法完全揭示全球GitHub平台的真实情况，因为长尾效应在全球范围内仍然非常明显。特别是GitHub平台作为全球领先的开源社区的广泛和多样性。在未来，随着技术的不断演进和开源文化的推动，可以期待中国开源社区在全球范围内继续蓬勃发展。

再进一步，分析基础事件的细分领域数据，结果如下图所示。


![](https://i-blog.csdnimg.cn/direct/b46e93d45b5d4cb589dfd366dd584225.png#pic_center)
GitHub与Gitee活跃仓库事件类型对比（图源：开源社）

从分析结果可以看到：

在GitHub平台上，最多的事件类型是Push事件，Pull Request事件和 Issue Comment事件分别居二三席。其中各个事件的发生次数占比基本上没有太大的变化，这体现出GitHub的开源生态模式在走向一个稳定的趋势。

在Gitee平台上，事件数据在2018年有极大的增长，最初以Watch事件为主。但在2020年后，Pull Request、 Review Comment事件开始快速增长，在2022年成为最多的事件类型，并且在2023年也有持续的增长。Gitee事件数据的结构性变化，体现出国内开发者从关注者到贡献者角色的巨大转变，这和全球范围内的观察都是一致的。

（三）GitLink事件数分析

对于GitLink平台，同样选择了前3万个活跃仓库作为基准。鉴于数据的局限性，仅选取了包括 CommitCommentEvent、ForkEvent、IssueCommentEvent、IssuesEvent、PullRequestEvent 和 WatchEvent 六种事件类型的数据进行分析。

![](https://i-blog.csdnimg.cn/direct/23172c9e6ed04f129e52281c3e40aa06.png#pic_center)
GitLink平台事件数据分析（图源：开源社）

观察到，尽管Gitlink的活跃仓库事件数相较 GitHub、Gitee等平台仍存在一定差距，但同样呈现明显的增长趋势。在Gitlink平台上，Issue事件和CommitComment事件占活跃仓库事件的绝大多数。

###2.2.2 中国项目活跃度与影响力趋势分析

![](https://i-blog.csdnimg.cn/direct/61a64949ae2d4e088ef2d2585458a4af.png#pic_center)
中国项目活跃度Top10 2019-2023

可以看出，从2021年开始MindSpore项目上升至第1。MindSpore是一种适用于端边云场景的新型开源深度学习训练/推理框架。

OpenHarmony活跃度上升至第2，StarRocks 得益于其良好的开源生态以及全球的推广，在 021年上榜，并 在2023年直接上升至第 6 位。


![](https://i-blog.csdnimg.cn/direct/a9ca0d297af14d89aad3f565a38e133a.png#pic_center)
中国项目影响力Top10 2019-2023

MindSpore稳居中国开源项目影响力第一，Paddle长期居于第二，OpenHarmony影响力上涨较快，Doris项目近3年排名上涨较快，反映出中国开源项目积极的发展。

###2.2.3 中国项目活跃度与影响力榜单

在开源项目洞察这部分，同样根据活跃度和影响力，分别比较了全球和中国排名前20的开源项目，可以看到：

在单个项目上，中国主导的开源项目的活跃度和影响力距离全球顶级开源项目的活跃度与影响力还有一定的差距，特别是在影响力方面，需要长期建设，需要最大限度融入全球开源生态里。

中国主导的开源项目中，华为旗下的相关项目排名相对靠前，mindspore/mindspore活跃度与影响力均位列第一。百度旗下PaddlePaddle相关项目也表现不俗，pingCAP旗下的TiDB与StarRocks旗下的StarRocks数据库排名相对靠前。

![](https://i-blog.csdnimg.cn/direct/6d93db68bbee470f90ebd20064fb1016.png#pic_center)
表1 全球项目活跃度Top20

![](https://i-blog.csdnimg.cn/direct/4f350c9f5b80450fb1120c2d8a01e9a8.png#pic_center)
表2 中国项目活跃度Top20

![](https://i-blog.csdnimg.cn/direct/9848675916864062a802b3eec2a27097.png#pic_center)
表3 全球项目影响力Top20

![](https://i-blog.csdnimg.cn/direct/26677e81e7b94692b7a8faf7416cb5e2.png#pic_center)
表4 中国项目影响力Top20

 
###2.2.4 基金会旗下中国项目影响力趋势分析

![](https://i-blog.csdnimg.cn/direct/fc063aa7d0bb40959852d78b41283c3d.png#pic_center)
中国基金会项目OpenRank变化趋势

各基金会旗下的中国项目单独分析来看：

* Doris和OpenHarmony发展速度最为抢眼；
* Milvus向量数据库由于AIGC领域的需求，发展迅速；
* Flink、ShardingSphere等项目稳中有降。

开放原子基金会旗下项目OpenRank趋势分析：

![](https://i-blog.csdnimg.cn/direct/ab2298511cdc4f5288d70f421d5ced07.png#pic_center)
开放原子基金会项目OpenRank变化趋势

今年能够第一次看到开放原子旗下各项目的发展情况：

* 排名前三的分别是OpenHarmony、openEuler和Anolis，代表了操作系统绝对的地位，特别是OpenHarmony，发展最为迅速；
* 其他上榜项目发展非常平稳，期待后续能够在新的一年中发力。

##2.3 开发者面临的挑战、建议与未来展望
 
###2.3.1 面临的挑战
随着开源软件的蓬勃发展，以及人工智能技术的逐渐成熟，也为中国开源领域带来了巨大的挑战。

其一，大模型技术、开源、生成式AI、算力这些热词都是开发者最关注的技术突破方向。而更深远的问题，比如与隐私保护、日常生活息息相关的价值对齐、安全合规等问题，受关注度弱于其他技术突破方向。这可能是因为很多人还未对「人工智能的潜在伦理风险」产生实感，这些情节暂时还存在于电影之中。

![](https://i-blog.csdnimg.cn/direct/b247cbe9f84f464c8d827d9b9fecd448.png#pic_center)
开源开发者关注的人工智能突破方向 （图源：CSDN）

隐私保护也逐渐成为一个不可忽视的挑战。目前，以大模型产品为例，国内外诸多公司也遇到过因“用公开数据训练大模型”导致官司缠身，这也引发了巨大的争议。开源AI领域需要处理大量的数据，但同时也需要保护数据的隐私和安全性。随着对个人数据使用的监管加强，保护用户隐私成为一个重要挑战。

根据CSDN发布的《AI 开发者生态报告》显示，在大数据时代，尽管数据量呈指数级增长，但获取高质量的数据、处理数据偏见、保障数据安全与隐私，以及有效利用数据进行创新研究等方面依然面临巨大挑战。

![](https://i-blog.csdnimg.cn/direct/8d846c0cf381439fa6db15d2a96b4017.png#pic_center)
开发者眼中的发展挑战（图源：CSDN）
 
 
其二，知识产权和许可管理的挑战，导致代码滥用或滥用风险。开源软件项目需要清晰的许可协议，但有时会存在许可混乱或侵权问题，这引发法律纠纷和不确定性。
 
在过去一年里，也迎来了一则好消息。2024年2月，最高人民法院发布了一则《这份判决给软件开发者吃了定心丸》文章，最高法知产法庭平衡保护软件开源社区建设和软件开发者权益受好评。“最高人民法院对案件的妥善处理，合理地界定了GPLv2（开源协议）此类开源许可证软件二次开发者的权利边界，为我国正在建设有中国特色的开源社区树立了标杆，是我国软件开发行业的重要里程碑，意义非凡。”这是良好的开端。
 
其三，维护和支持的可持续性，一些项目缺乏长期支持和资金，让很多开源开发者面临生存问题，最终导致一些项目难以长期维护，会停滞或废弃，影响用户和企业的可靠性。在这一窘境下，52%的开发者称自己没有在开源上获得任何收入。

![](https://i-blog.csdnimg.cn/direct/4cab45a8a2b44ac7a8eaba7c7ae43c20.png#pic_center)
开发者在开源上获得的收入（图源：CSDN）

其四，安全性和漏洞管理。开源软件虽然公开代码，但并不保证免受漏洞和安全威胁的影响。不及时发现和修复漏洞会给用户和组织带来风险，特别是在广泛使用的开源项目中。调查数据显示，46%的开发者遇到过开源软件相关的安全漏洞。

![](https://i-blog.csdnimg.cn/direct/97f3206255e94a42abff975079297ef1.png#pic_center)
开源软件的安全漏洞（图源：CSDN）
 
###2.3.2 建议
基于以上挑战，开源开发需要包括政府、企业、社会组织以及个人开发者的积极参与和支持，以下是一些建议和措施：

（一）加强数据隐私与安全性：

* 数据最小化原则: 在项目中最小化收集和使用个人数据。只收集和使用必要的数据，避免收集不必要的个人信息。
* 用户明示同意: 在收集个人数据之前，确保获得用户的明示同意。用户应该清楚地知道他们的数据将被用于何种目的，并且有权选择是否同意。
* 匿名化和脱敏: 在可能的情况下，对收集的个人数据进行匿名化或脱敏处理，以降低数据关联性和识别性。
* 数据访问权限控制: 限制对用户数据的访问权限，仅允许有必要权限的人员或系统进行访问，并建立审计机制以监控数据访问情况。
* 社区教育和意识提升: 加强社区成员对隐私保护的意识，教育他们如何保护个人隐私，并提供相应的培训和资源。

（二）采用有效的方式更好地管理知识产权和许可证，降低法律风险：


* 开源项目应该制定明确的知识产权政策，包括许可证选择、版权声明、贡献者权利和责任等方面的规定。这有助于消除不确定性，增加项目的透明度和可预测性。
* 选择合适的许可证: 选择一个适合项目需求和目标的开源许可证是至关重要的。开源社区提供了多种选择，如MIT、GPL、Apache License等，每种许可证都有其特定的特点和限制。项目组织者应该认真评估每种许可证的优缺点，选择最适合项目的许可证。
* 明确贡献者的权利和责任: 确保贡献者清楚地了解他们的贡献如何受到保护，并明确他们对项目的贡献的版权归属。这可以通过贡献者协议或贡献者许可协议来实现。
* 建立贡献者指南和流程: 提供清晰的贡献者指南和流程，包括如何提交贡献、如何报告问题、如何进行代码审查等。这有助于规范贡献的方式，减少知识产权纠纷的可能性。
* 定期审查和更新许可证: 定期审查项目使用的开源许可证，并根据项目的发展和需求进行更新。随着时间的推移，项目的需求和环境可能会发生变化，因此需要不断地审查和更新许可证选择。
* 采用自动化工具: 使用自动化工具来管理知识产权和许可证信息，如软件扫描工具、许可证管理工具等。这些工具可以帮助识别项目中使用的开源组件和其相关的许可证信息，从而更好地管理知识产权和遵守许可证要求。

（三）维护和支持的可持续性：

* 多样化的资金来源: 探索多样化的资金来源，包括个人捐赠、企业赞助、基金会资助等。建立稳定的资金来源有助于项目的长期发展和运营。
* 建立商业模式: 考虑建立基于项目的商业模式，例如提供付费支持和咨询服务、开展培训和认证等。通过商业模式来获得收入，可以支持项目的持续发展和维护。
* 定期更新和维护: 定期更新和维护项目，修复漏洞、改进功能、更新文档等。这有助于保持项目的活跃度和吸引力，增加用户和贡献者的参与度。
* 建立社区参与机制: 建立开放、包容的社区参与机制，鼓励更多的人参与项目的开发和维护。这不仅能够分担项目维护的压力，还能够增加项目的可持续性。
 

（四）使用内存安全编程语言。

随着技术的进步和需求的变化，开发人员逐渐意识到选择适合的编程语言来减少内存管理的风险是明智之举。使用那些在设计时就注重内存安全的语言，可以通过自动内存管理、严格的类型检查和内置的安全特性，显著降低了开发人员引入内存错误的风险。

例如，Rust通过借用检查器和所有权系统，确保在编译时捕获几乎所有的内存错误；Go语言通过垃圾回收机制有效地管理内存；Java同样利用垃圾回收，确保对象的生命周期管理更加安全；Python和Ruby则通过高层次的抽象和动态类型系统，减少了内存管理的复杂度。Swift不仅为iOS和macOS开发提供了强大的功能，同时也通过自动引用计数（ARC）来实现内存安全。
 
###2.3.3 未来展望
随着数字化转型的不断推进，越来越多的企业和组织意识到开源软件的价值，其在削减成本、提高安全性、推动创新和实现可持续性方面的优势日益显著。开源开发者将继续在推动开源和开源人工智能领域发展中发挥重要作用。他们将继续引领创新，推动技术进步，并积极参与社区建设，促进合作和知识共享。
 
![](https://i-blog.csdnimg.cn/direct/bbd477dcd32649fa8d419c174f9b6fd1.png#pic_center)
开发者眼中的发展机遇（图源：CSDN）
 
 
在AI维度，开发者眼中的发展机遇同样丰富多彩，拥抱开源、出海与国际化、深耕模型技术、发力国产替代、挖掘商业场景、加强数字化建设……这些都是亟待积极把握的多元化发展机遇。

 


