# 第六章 开源国际化发展现状
## 6.1 国际开源基金会和企业对中国的贡献
### 6.1.1 Linux基金会
Linux基金会（The Linux Foundation，简称LF）搭建了一个中立且值得信赖的平台，供全球开发者和企业共同开发、管理和扩展开源项目。目前，中国在开源代码和项目的贡献上正以迅猛的速度增长，已经成为一个极为重要的参与者。以云原生计算基金会（CNCF）为例，根据CNCF云原生计算基金会CTO Chris Aniszczyk介绍，中国已经成为第二大开源项目贡献国。截至目前，中国贡献了Harbor、Volcano、Dragonfly等32个项目，大约占CNCF所有项目的四分之一。

在过去20年里，Linux基金会已经从单一支持Linux内核项目扩展到支持众多不同的项目社区。目前，有超过2300名成员和数十万名开发者参与到一些最为关键和活跃的开源项目中，这些项目在云计算、安全、区块链和Web等跨行业的技术领域展开合作。

到了2021年，Linux基金会在它所支持的数百个开放技术社区中的贡献和参与度持续上升。特别是中国区域的成员增长极为显著，仅CNCF中国区成员的增长就达到了80%。

随着对专业人才需求的不断增长，供应商中立的培训和认证变得日益重要。在中国，已有超过5500人获得了Kubernetes认证管理员的资格。2021年，Linux基金会向全球，包括中国的个人，提供了免费的培训和认证奖学金，数百人通过与非营利组织的合作获得了这一荣誉。

除了上述贡献外，Linux基金会还通过举办各类活动和建立合作，为中国的开源发展注入了强劲动力。

* 2007年，Linux基金会组织欧美资深开源开发者来北京支持COPU召开的“Linux开发者国际会议”，与国内开发者展开深入交流。
* 2008年，作为主要助力之一，Linux基金会助力COPU无偿聘任数十名国际开源领袖、开源大师为智囊团高级顾问，从而建立了中国的开源高地，也是创新高地、科技高地和人才高地。
* 2017年，Linux基金会成立一批旗下跨界的基金会（如云原生、区块链、人工智能等）并建立孵化器，为中国和全球培养人才与发展技术作出贡献。

Linux基金会每年都会参加由COPU举办的"开源中国开源世界高峰论坛"，在这个年度盛会上，它作为圆桌会议的核心团队之一，深入探讨国际开源技术的最前沿发展、国内外开源生态发展中遇到的挑战及其解决方案。通过这些深入的交流和讨论，Linux基金会致力于推动开源社区的全球合作与发展。

此外，Linux基金会针对不同生态领域成立了众多新基金会，并见证了越来越多的中国企业加入其合作行列。例如，2021年上半年，RISC-V基金会的成员数量翻了一番，其中许多新成员来自中国。同时，LF AI & DATA、LF Networking、O3DF、OpenSSF、CNCF等基金会的董事会中，中国企业的代表也在显著增加。由中国企业发起的开源基金会，如NextArch，正在全球范围内迅速崛起并蓬勃发展。

在2023年里，Linux基金会积极在中国举办各类开源活动，为中国开源生态系统的成长注入了强劲动力。

* 3月，Linux基金会在香港举办了亚太领导力峰会；
* 5月27日，在2023全球开源技术峰会（Global Open-source Technology Conference，GOTC ）上，与上海浦东软件园签约，成立Linux 基金会亚太区开源社区服务中心；
* 6月，LFOSSA成功举办了RISC-V国际人才认证中国区发布会，并发布首个RISC-V认证RVFA的中文版；
* 8月，LFOSSA与RISC-V International联合举办了RISC-V中国峰会之国际人才暨开源技术与生态论坛；
* 9月，LFOSSA与CNCF在上海联合发布云原生人才培养计划；
* 10月，LFOSSA与中国20多所大学、开源社区及机构加入天工开物基金成立的开源创新教育联盟，一起推动开源教育的创新与发展。

未来，Linux基金会和其亚太团队将继续推动中国企业和社区参与全球开源合作，培养更多开源人才。

### 6.1.2 Apache软件基金会

2012年之前，国内与ASF（Apache Software Foundation，简称“ASF”）接触的公司主要集中在外企，例如Intel中国研发中心、IBM中国研究院、eBay中国等。但在2012年之后，华为、阿里巴巴、百度、京东、腾讯、蚂蚁等公司开始陆续将项目捐赠给ASF，在ASF的孵化下，多个项目成为顶级项目。

伴随着越来越多来自于中国的项目进入到ASF，中国的Committer数量也在不断增加。如下图所示，在2010之前，中国开发者参与度并不高。自2014年开始，中国Committer数量逐年递增，直至今日，中国Committer数量占到新增Committer一半左右的比例。

![](https://i-blog.csdnimg.cn/direct/1d174ff9fc3d471aa4d382f117c35262.png#pic_center)
Apache Committer总人数和中国人数 

后图展示了2014年之后源自中国Apache孵化项目与所有进入到ASF的孵化项目对比，可以看到2021年之后来自于中国的孵化项目占比越来越大。

![](https://i-blog.csdnimg.cn/direct/a95c2020043844b6b0b51e82964ca560.png#pic_center)
进入ASF孵化器项目数和源自中国项目数

**2023-2024年，Apache在中国举办的ASF相关会务活动**

* 2023年7月，ALC-Xi’an在六朝古都西安正式成立。
* 2023年7月26日-28日，CommunityOverCode Asia在美丽的西子湖畔杭州召开线下大会。
* 2023年8月18日-20日，由Apache软件基金会举办的官方全球系列大会CommunityOverCode Asia首次中国线下峰会于北京顺利举行。
* 2024年5月，ALC-HangZhou正式成立，进一步链接杭州的阿里，蚂蚁，字节等大厂的开发者资源，共谋开源发展大事。
* 2024年7月，ALC-Shanghai正式成立，为华东地区的开源开发者提供了一个连接，交流，成长的好环境。

### 6.1.3 开放基础设施基金会

OpenInfra基金会专注于打造一个多元化的开源社区，并推动开源基础设施软件在实际生产中的广泛应用。在全球187个国家/地区的110,000多名社区成员的共同支持下，该基金会不仅托管了一系列开源项目，还积极开展社区实践活动，覆盖了人工智能、容器云原生应用、边缘计算和数据中心云等多个领域。在中国，OpenInfra基金会旗下的OpenStack、Kata Containers项目以及算力网络工作组尤其受到社区成员的广泛欢迎，并呈现出活跃的增长态势。

**（1）OpenStack社区**

2022年，中国的OpenInfra社区发展迅速。凭借众多的志愿者和庞大的开源基础设施组织基础，中国仍然是世界第二大OpenStack社区。在过去的一年了，OpenStack技术架构委员会提交、接受并发布了两个来自中国贡献的新项目：Venus project提供日志管理服务的一站式解决方案；Skyline项目由UI和UE优化的现代OpenStack仪表板。

Venus项目由浪潮数据发起，回馈社区。这有助于发布全文/多维检索、典型错误分析、调用链分析等功能。

Skyline项目最初由九州云发起并贡献，现在有超过四个组织参与上游开发。近期，OpenStack韩国用户小组也开始了参与Skyline项目的预研和评估工作。

除了新近发布的项目，在过去的一年里，已经与OpenStack社区中开发成长了许多年的Cyborg继续展示其发展以及更多元化的上游社区。在上一版中，全球有超过25个组织参与了Cyborg上游开发，其中包括一众来自中国的企业与组织，如浪潮集团、麒麟软件。

**（2）Kata Containers社区**

Kata Containers在2022年取得了重要进展，尤其是在中国社区。社区已完成Kata Containers 3.2.0版本的发布，增加了机密容器对GPU设备的支持，以及对设备管理的抽象。

中国联通和浪潮数据发布了两个新的用户案例研究，针对Kata容器的大规模部署；蚂蚁集团的Kata Container使用白皮书也在2022年发布，在全球获得了很高的知名度，甚至获得了超级用户奖；300多位开发者在微信群里积极交流，讨论技术问题，分享部署。

2023年3月份，Kata Containers中国社区也在成都举办了疫情恢复后的第一次线下技术聚会，来自社区的30多位开发人员参加了聚会并分享各自的实践案例以及技术研发。据统计，Kata Containers上游社区去年共有来自18个组织的140多位开发者提交了1363项修改，其中将近50多位开发者来自中国，包括一些企业、科研学术机构和大学同学。

**（3）算力网络（CFN）工作组**

2022年，新的算力网络（CFN）工作组成立，最初由中国移动发起。该小组旨在利用相关技术制定应对共同挑战的解决方案，推动技术落地，逐步构建下一代开源基础设施技术。工作组得到了广泛认可，2022年共有16个组织加入工作组。

此外，2023年12月1日，OpenInfra Days China 2023在北京海航万豪酒店盛大启幕。时隔两年，OpenInfra Days China重返线下，聚集了全球社区的技术专家、行业领袖以及国内开源基础设施技术企业的代表，围绕开源基础设施项目的最新进展、生产实践以及所面临的挑战进行面对面分享与交流。

### 6.1.4 云原生计算基金会

云原生计算基金会全称Cloud Native Computing Foundation，简称CNCF。CNCF中国区蓬勃发展。企业会员超过90家，Kubernetes官方认可服务供应商 （KCSP）44家，Kubernetes官方培训伙伴 （KTP）14家。截至2023年，CNCF（云原生计算基金会）在全球已经吸纳了超过173个项目，中国已成为第二大开源项目贡献国，来自中国的代码占比从2016年的3.8%增长到2022年的13.2%。目前有超过60个中国企业、团队成为了CNCF会员。

2023年，CNCF依旧注重云原生人才培养成功设计并最终确定了36门崭新课程。在此基础上，推出了20门全新课程，包括6门edX、MOOC和14门线上课程。中国区合作伙伴共进行超过300场CKA、CKAD、CKS等Kubernetes线上线下面授培训，培训人数已超过万人。

CNCF推出4个新的Linux基金会官方认证：

* ICA （Istio Certified Associate）
* HFCP （Hyperledger Fabric Certified Practitioner）
* FCFP （FINOS Certified FDC3 Practitioner）
* Skillcred -SC106 （Pipelines with Tekton）

另外，以下认证已在Beta测试阶段，预计在2024年登场。

* KCSA （Kubernetes and Cloud Native Seurity Associate）
* CCA （Certified Cilium Associate） 
* CAPA （Certified Argo Project Associate）
* CGOA （Certified GitOps Associate） 
* FSOSD （FINOS Financial Services Open Source Developer）

### 6.1.5 RISC-V国际基金会

2011年5月，加州大学伯克利分校研究团队发布了一套全新的开放指令集RISC-V。2015年，汇聚全球100多家单位的非营利组织RISC-V基金会正式成立。

为降低潜在的技术出口法律限制风险，减轻来自地缘政治的潜在破坏，同时为确保基金会更加中立、开放和包容，2020年，RISC-V国际基金会将注册地迁移至瑞士，此举受到全球RISC-V爱好者的广泛好评。在过去一年，RISC-V国际基金会在中国有如下贡献：

* 2023年5月26日，RISC-V国际基金会首席执行官Calista Redmond女士、首席技术官Mark Himelstein先生等来华参与"RISC-V开源处理器芯片生态发展论坛"与在场嘉宾分享了其推动开源处理器芯片生态发展的努力与贡献。
* 2023年8月23日，2023 RISC-V中国峰会在北京盛大开幕。本届峰会由北京开源芯片研究院主办，中关村创业大街科技服务有限公司、广州市智能软件产业研究院承办。会议吸引了来自北京大学、清华大学、中国科学院、科技企业、投资机构等2000人参会。
* 2023年8月31日,RISC-V国际基金会CEO Calista Redmond女士担任特聘顾问应邀出席“RISC-V工作委员会成立大会”，RISC-V工委会由中国电子工业标准化技术协会牵头，联合国内38家重点企业共同组建。
* 2023在Linux基金会的协助下推出了RVFA （RISC-V Foundational Associate） 的中文版。
 
### 6.1.6 IBM

近年来IBM在AI，云原生，可持续计算，边缘计算，量子计算等前沿技术领域采用开源、开放的模式面向全球进行探索与创新。

在IBM 2024 Think大会在开源创新，AI和自动化，生态合作三条主线上均有重磅发布和创新进展。IBM同时将最新的人工智能平台watsonx及其背后的开源技术和其他AI相关开源技术一并介绍给中国。

今年，中国开源软件推进联盟与IBM联合发布《可信赖的企业级生成式AI白皮书》，旨在为中国企业提供借鉴，助力企业基于自身的业务需求与数据来构建开放、可信、具有业务针对性的企业级AI应用与模型。

IBM在Hugging Face平台上开源了Granite和Merlinite两个大模型的同时携手Red Hat开源了instruct lab项目，这个项目实现了Large-Scale Alignment for ChatBots技术，使得模型训练所使用数据的公开透明。我们通过IBM watsonx和该技术显著改进了Granite模型。在有效提高了模型可解释性的同时缓解了GPT-4等专有LLM生成合成数据的合法性风险。

数据是AI生态的重要组成部分，2023年4月，IBM收购了Ahana，成为湖仓查询引擎Presto Foundation的成员，并在整个社区中成为仅次于Meta的最大贡献者。IBM在Presto的多个领域均有显著贡献，尤其是在最新发布的Presto C++中，IBM是主要贡献者。Presto C++的性能比Presto Java提升了2-3倍。

随着AI和大模型应用上云，云计算领域开始出现一些新的热点领域，如可持续计算，机密计算，云原生可观测性等，IBM也和国内外CNCF社区的伙伴们有着广泛的合作。

GPU能耗在数据中心不断增加，为了更好应对的为数据中心进行能耗规划在内的诸多挑战，CNCF sustainable TAG（云原生可持续技术指导工作组）正式成立。IBM同Intel，Red Hat合作，承办了CNCF sustainable TAG 2023年在国内的CNCF sustainable week（云原生可持续计算周）活动。上千人在线观看了技术分享，也收到了来自国际社区对于活动结果的认可和祝贺。在2024年推进CNCF sustainable TAG，决定将在亚洲时区召开月度工作会议，开始筹备2024年的云原生可持续计算周活动。

在机密容器（Confidential Containers）开源社区，IBM与社区的伙伴密切合作，进一步将零信任安全原则纳入机密容器框架，增强了安全性和易用性。IBM还公开了机密容器在不同行业中的各种用例。例如，在医疗保健领域保护患者数据。在金融行业，确保敏感的金融信息在机密容器内处理，帮助实现合规并防止欺诈。

聚焦云原生可观测性，IBM也在不遗余力的将可观测性领域的最佳实践经验通过各种形式回馈分享给开源社区，尤其是Instana团队在公开博客中介绍了通过将可观测性技术和生成式人工智能相结合以实现将治理融入AI生命周期中监控管理的相关实践。

IBM在系统软件特别是编译器领域与业内建立了紧密的联系，与国内领头企业华为，阿里平头哥，字节，RISCV社区等都有各种形式的交流与探讨。IBM中国编译器团队自2010年成立以来，深耕编译器后端优化技术，取得了多项成果，在业内两大开源编译器领域GCC和LLVM，林科文和陈正先后被社区任命为maintainer。从2022年开始，积极投入Rust语言开源社区，为IBM硬件平台带来Rust开发语言支持的同时，也为社区贡献了非常多的质量和生态提升的代码。与此同时，以传统编译器为基础，在其他系统软件的开源领域诸如高性能科学计算库OpenBLAS，调试器LLDB，JIT Linker以及仿真器QEMU都有涉足及贡献。

IBM在2021年成立了RISC-V的兴趣小组，来促进围绕着RISC-V开源处理器的创新，协作和生态的建设。IBM参与Open Horizon开源边缘计算和Kepler可持续开源社区的研发人员，开发了Open Horizon和Kepler对RISC-V的支持，从而把RISC-V的使用生态扩展到云和边，以及可持续的应用场景。

在量子计算领域，经过六年开源努力，汇集成千上万用户的持续热情和数百名贡献者的持续支持才得以实现的，Qiskit 1.0版本发布是一个重要的里程碑。这个版本的发布标志着Qiskit开发进入了一个新阶段，该阶段以性能、稳定性和可用性为中心。

IBM非常重视开源协作，从量子和区块链到容器、人工智能和操作系统，积极领导当今最具影响力的项目，并创建新项目以推动明天的技术发展。

## 6.2 中国企业对国际开源基金会的贡献

时至今日，尽管全球开源界普遍认可中国企业和开发者对全球开源产业的巨大贡献，但仍有人持中国仅是全球开源资源的索取者和使用者的成见，这是一种误解，更是偏见。

事实上，在20世纪90年代中期，中国开源还处于启蒙阶段，国内最早接触这一领域的技术先驱者尝试积极参与国际开源社区的代码共享活动，虽然是凤毛麟角，但星星之火终成燎原之势。

21世纪初，随着国内Linux系统和LAMP技术栈的兴起，中国开源进入萌芽阶段，一些全球知名企业在华研究机构成建制地组织中国开发者，系统地参与到国际知名开源社区中。国内开源社区如雨后春笋般层出不穷，开源文化在当时那一批20岁出头的中国开发者心中埋下了种子。

2008年，作为中国开源发展史上的一座重要里程碑，见证了Linux基金会、GNOME基金会、Apache软件基金会以及OpenOffice基金会在北京首次举办技术峰会，标志着它们在亚洲的首次亮相。这一年，中国开源贡献者的地位获得了全球开源界的广泛认可，标志着中国开源进入了新的发展阶段。

在过去13年中，中国开源开发者开始习惯于用流利的英语和全球开源人士分享他们的技术经验。根据COPU统计，在2016年至2017年在华召开的开源国际会议上发表的论文中，来自国内和国外的的论文比例为4:6，即有40%的开源论文来自中国开发者。

中国的开源力量正在以惊人的速度迎头赶上，在开源开发者贡献度、开源社区活跃度、开源基金会参与度等方面，我们均已取得不俗的成绩。这些来自中国的开发者和科技企业正在向全世界呈现全新的中国印象，中国逐步实现了开源世界的大国担当。

### 6.2.1 对Linux基金会的贡献


Linux基金会董事会成员共23人，其中中国成员2人，占比为8.6%。分别为华为的侯培新与腾讯的单志豪。

Linux基金会目前共有中国会员139家，相较于2020年的70家增涨了98.6%。其中白金会员2家（约占17%）；黄金会员2家（约占18%）；白银会员78家（约占7%）；Associate（准会员）23家（约占6%）。
同时，中国开发者已经成为Kernel.org社区最大贡献群体。

在Linux基金会，甚至全球开源生态中，Kernel.org社区的象征意义无可替代，开源界的创世一代至今依然活跃在这个社区，因而Kernel.org至今仍常被作为一个开源指数来度量一个企业或一个区域的开源繁荣和发展程度。为更加全面地展示中国在开源领域的成长过程，我们分别通过中国开发者和中国科技企业对Kernel. org社区的补丁贡献数据来呈现。

![](https://i-blog.csdnimg.cn/direct/d9b79baf20b744269aab3396daeddd00.png#pic_center)
中国开发者对Kernel.org社区的贡献数据和贡献度排名（数据采集截至2024年4月）

为了更直观地呈现内核社区中中国开发者的参与度和贡献度的变化，我们节选了部分版本的贡献度进行对比，从下表可看出，在过去的19年间，参与Kernel.org社区的中国开发者的规模提升了40倍， 对社区的贡献绝对数量提升了50倍，对Kernel.org的贡献排名近五年来保持世界第一。

![](https://i-blog.csdnimg.cn/direct/479f288089dd405da0be2cdebb0f3536.png#pic_center)
部分版本贡献度对比（数据采集截至2024年4月10日）

在统计过程中，我们还有一些发现。通过对比19年来中国开发者数量的变化，可以推算出中国开发者对Kernel.org社区的人均贡献度，其整体变化如下图所示。

![](https://i-blog.csdnimg.cn/direct/944b9c9b5d4c4d72806afda908e0779e.png#pic_center)
中国开发者对Kernel.org社区的人均贡献度（数据采集截至2024年4月）

通过对比最近三个内核版本排名前三国家的开发者人数和人均贡献值，可以发现现今中国开发者的人均贡献度远小于德国和美国，进而我们可以推断出未来中国开发者的人均贡献度和绝对贡献数量还有很大提升空间。

![](https://i-blog.csdnimg.cn/direct/3f3eaf341d874a96acd37cea89a51e9c.png#pic_center)
Kernel.org社区三个内核版本排名前三国家的开发者人数和人均贡献值

纵观Kernel.org社区总体的开发者贡献，我们会发现中国、美国、德国、英国、法国、印度是该社区的主要贡献群体，其中中国的发展速度远远超过上述其他国家。

![](https://i-blog.csdnimg.cn/direct/41282fb731f74977be1dd8f07fa31bbf.png#pic_center)
主要国家开发者在Kernel.org社区的贡献排名（数据采集截至2024年4月）

从另一个角度，我们同样可以发现中国企业在Kernel.org社区中的贡献度越来越大，相关排名持续上升，下图是2005年6月至2024年4月的内核社区贡献排名中国前十企业的动态变化，包括华为、联发科、阿里、瑞芯微、龙芯、中兴、vivo、腾讯、字节跳动、成都菁蓉。

![](https://i-blog.csdnimg.cn/direct/0dbf22a620174035882a8cb4e1ba97a3.png#pic_center)
十大中国企业在Kernel.org社区中的贡献排名（数据截止至2024年4月）

 
### 6.2.2 对Apache软件基金会的贡献

截至2023年6月，Apache软件基金会源自中国的活跃开源项目共34个，其中有17个项目成为了顶级项目。分别是：
![](https://i-blog.csdnimg.cn/direct/df2b620231da47e5ba4e86c61c6190bf.png#pic_center)

ASF全球有800余位成员，目前已知并互动较为频繁的中国及华人成员有29位。其中，姜宁在2022年3月ASF举行的成员会议上被选举成为新任董事。Apache软件基金会现有中国企业赞助商6家，分别是白金赞助商：华为、腾讯云；黄金赞助商：百度；白银赞助商：阿里云、滴滴出行；银牌赞助商：小米。
 
### 6.2.3 对开放基础设施基金会的贡献

OIF基金会董事会15人，其中中国成员5人（占33.3%）。分别为浪潮张炳玲；九州云黄淑泉；中国移动李翔宇；蚂蚁集团王旭；华为周君毅。OIF现有中国成员中包括白金会员1家（占20%）；黄金会员6家（占46%）；白银会员3家（5%）；支持机构13家（占4%）。

![](https://i-blog.csdnimg.cn/direct/912f16abcf2b44478dd7e758a30730ca.png#pic_center)
开放基础设施基金会会员

### 6.2.4 对云原生基金会的贡献
据CNCF的统计，超过20%的开源项目来自中国，贡献度排名上升至世界第二。在云原生应用上，68%的机构在生产过程中使用容器，31%的开发者称所在单位的容器使用量已经超过5000个。CNCF理事会共29名成员，其中中国成员2人，分别是阿里云的易立、华为的任旭东以及火山引擎（字节跳动）的张鑫。CNCF现有TOC成员11人，其中中国成员1人是来自华为的王泽锋。

CNCF基金会目前共有中国会员84家（见下表），其中包括3个白金会员（占15.8%）、10个黄金会员（占37%）、35个白银会员（占5.9%）、1个研究院所（占25%），以及3个最终用户会员（占3.3%）。

![](https://i-blog.csdnimg.cn/direct/44e45a8c80044639b5f0d7908571dd14.png#pic_center)

### 6.2.5 对RISC-V国际基金会的贡献

RISC-V基金会的日常运营由董事会负责，由4名常委和21名委员构成，其中的中方委员有五名，RISC-V基金会设立了技术委员会，成员共32人，其中包含11名中国成员：晶心科技的苏泓萌；阿里云的陈炜；希姆计算的范福杰;成为资本的沈海滨；腾讯蓬莱实验室的高剑林；中科院计算所的石侃；华为的Peter Chun；中兴通讯的石义军；天津飞腾的赵Tom，PLCT实验室的吴伟；北京开源芯片研究院的包云岗；RIOS实验室的谭章熹。

在RISC-V这一轮发展浪潮中，中国企业、高校和科研机构发挥了巨大作用。有数据显示，中国有超过400家企业关注、参与和使用RISC-V指令集进行开发。据统计，在RISC-V基金会中，成员分为三个层次（见下表），在基金会核心成员（Premier Member）中，中方成员12家，占比达到48%。在战略成员（Strategic Member）中，中方成员41家，占比达到24%，在社区成员（Community Organization Member）中，中方成员14家，占比达到8%。

![](https://i-blog.csdnimg.cn/direct/5537d9f647954fc6962973b58b4994b2.png#pic_center)
RISC-V理事会中方成员

在2018年12月RISC-V基金会首次宣布要迁至瑞士后，中国企业界和学术界加速了参与和融入RISC-V基金会的进程，其中中国RISC-V产业联盟和中国开放指令生态（RISC-V）联盟发挥了巨大的促进作用。自2020年开始，中国国内的RISC-V生态快速完善，并开始涌现越来越多的RISC-V产业化案例。

众所周知，中国一直在芯片领域处于受制于人的窘境，整个产业迫切走出一条自力更生、自主创新之路。RISC-V由于开源的特性，自诞生起就在中国产业界备受瞩目，大量中国芯片公司正在成为RISC-V的拥趸，加大对RISC-V的投入。而中国具备的电子制造业生态优势，也成为RISC-V应用前景最乐观的地区，RISC-V在中国的市场容量和发展潜力巨大。这些因素成就了双方“互利互助、合作共赢”的天作之合。

另外，RISC-V生态中的相应软件、工具链还有待完善。RISC-V指令集开源并不意味着CPU核心也同时免费授权，这对芯片公司提出了很高的设计和研发要求。客观上，目前RISC-V只是帮中国芯片产业走上快车道，但前路漫漫，还需要我们持续努力。在未来的RISC-V生态建设中，中国企业需要平心静气、戒骄戒躁，避免在资本的推动下过度炒作概念，同时加强全球产业合作，避免产业生态碎片化趋势。

 
### 6.2.6 对其他国际开源基金会的贡献

目前OIN社区现有中国成员共121个。

![](https://i-blog.csdnimg.cn/direct/4a002b4c6024472d8d252030896a1aba.png#pic_center)
![](https://i-blog.csdnimg.cn/direct/cbf917e5f54246cf9365d8310d53046a.png#pic_center)
OIN社区中国成员

 
## 6.3 COPU中沙开源合作进展及成果 

COPU在促进中国沙特开源合作方面的进展和成果。从背景、COPU的合作策略、已取得的工作成果、下一步计划等方面展开，详细阐述了COPU如何通过一系列具体行动，推动中沙两国在开源领域的深入合作。

### 6.3.1 背景与战略意义

近年来，在全球科技竞争日益激烈和地缘政治格局不断变化的背景下，中国与阿拉伯国家之间的合作交流变得愈发重要。作为"一带一路"倡议的重要组成部分，中国与沙特阿拉伯的开源合作正在迎来新的发展机遇。
 
2022年12月，中沙两国元首签署了《中华人民共和国和沙特阿拉伯王国全面战略伙伴关系协议》，同时两国政府签署了《中华人民共和国政府和沙特阿拉伯王国政府关于共建"一带一路"倡议与"2030愿景"对接实施方案》。这标志着中沙合作进入了一个新的历史阶段。在这一背景下，中国方面表示愿意与沙特在包括数字经济在内的多个领域展开全面合作。与此同时，沙特也迫切需要中国的科技和数字化技术来助力其"2030愿景"的实现。 

沙特阿拉伯正在积极推进其"2030愿景"计划，其中数字化转型是核心内容之一。沙特政府高度重视信息技术的发展，特别是在人工智能、云计算、大数据等领域。在这一背景下，中国的开源技术和数字化经验对沙特具有重要的战略价值。正如沙特阿拉伯王国的通信和信息技术大臣阿卜杜拉.斯瓦哈在2023年7月接受《南华早报》记者采访时表示，“中国信息技术实现了世界级转型，沙特渴望复制成功故事。中国在过去几十年的数字化转型中积累了丰富的经验，特别是在开源软件和开放技术标准方面取得了显著成果。通过开源合作，中国可以帮助沙特加速其数字化进程，同时也为中国企业开拓新的市场机会。 

基于这一战略背景，COPU常务副秘书长谭中意联合OpenTEKr 发起人狄安自2023年初开始，积极开展了与沙特的一系列交流对话工作。他们与沙特的相关政府部门、社会组织、高校科研机构以及科技企业建立了广泛的沟通渠道和合作关系。这些机构和组织包括沙特阿拉伯通信与信息技术部（MCIT）及其下属的数字政府管理局（DGA）和数字企业家创新中心（CODE）、沙特人工智能局（SDAIA）、沙特开发者协会（Parmg）以及沙特国王大学等。

中沙开源合作不仅有助于推动两国技术创新和数字经济发展，还能促进文化交流和人才培养。通过开源项目的共同开发和维护，两国的技术专家和开发者可以建立长期的合作关系，推动知识共享和技术传播。

### 6.3.2 COPU的战略定位与实施方针

COPU在推动中沙开源合作中采取了明确的战略定位和实施方针。以“促进源于中国的开源技术在沙特以共建的方式落地”为目标；以开源先行，商业跟进的方式推进合作为战略。具体实施方针为：

* 与沙特当地的开源组织建立战略合作关系；
* 在人工智能、操作系统等开源技术领域与沙特合作，成立联合工作组和联合项目；
* 通过企业深度合作的模式，推动合作研发成果的商业化落地；
 
### 6.3.3 已取得工作成果
在COPU和OpenTEKr 的密切合作下，由谭中意和狄安组成的"开源老DJ"团队积极推动，中沙开源合作交流已经取得了显著成效：

**（1）成功组织三期中方IT企业代表团访问沙特**

第一期（2023年11月）：COPU组织了包括开源中国、浪潮数字企业、统信软件、万里数据库、飞轮科技、道客等企业的代表团访问沙特。代表团与沙特通信与信息技术部（MCIT）、数字政府管理局（DGA）、数字企业家创新中心（CODE）等机构进行了深入交流。

第二期（2024年3月）：COPU组织了包括蚂蚁集团在内的企业代表团参加沙特年度科技大会Leap 2024。Leap大会是中东地区最大的科技盛会之一，吸引了全球数千名科技专家和企业代表。蚂蚁集团在大会上展示了其在区块链、人工智能和金融科技领域的最新成果，并与沙特本地企业进行了多场合作洽谈。 

第三期（2024年5月）：COPU组织了包括华为、用友、明道云等IT企业的代表团参加沙特低代码、云和网络安全峰会并考察多个沙特机构和组织。

**（2）跟沙特开源组织Parmg签署战略合作备忘录**

2024年2月21日，COPU常务副秘书长谭中意受邀参加沙特年度开源峰会Open Source Summit Saudi 2024，并发表主题演讲。会上，COPU与会议组织方即沙特著名开源组织沙特开发者协会（Parmg）正式签署了《开源战略合作备忘录》，共同推动沙特阿拉伯和中国在开源领域的交流与合作。

这份备忘录的签署标志着中沙两国在开源领域的合作进入了一个新的阶段，为双方在开源技术、人才培养和项目合作等方面的深入交流奠定了基础。

**（3）联合发起成立AI Desktop工作组**

 2024年6月，中沙AI Desktop Working Group（工作组）正式成立。该工作组由中国开源推进联盟（COPU）和沙特开发者协会（Parmg）共同发起，旨在推动新一代AI驱动的桌面操作系统的研发和应用。
 
工作组的成立成员包括来自中国和沙特的多家知名科技企业和研究机构，如统信软件、英特尔（Intel）、联想（Lenovo）和沙特著名IT企业Slnee。工作组计划在未来一年内开发出一套适合中国和中东市场的AI桌面操作系统原型，并在沙特进行试点应用。

这一举措不仅体现了中沙两国在高科技领域的深度合作，也为两国在AI和操作系统领域的技术创新提供了重要平台。

**（4）促进企业间实质性合作**

通过COPU的牵线搭桥，多家中国IT企业已经与沙特方面开始了深入的合作洽谈。案例包括，国内某大型企业信息化软件研发企业与沙特某著名家族企业科技公司签署战略合作协议，共同拓展沙特和中东市场；另一家中国开源企业则与沙特某科技企业签署开源社区合作协议，先在开源社区项目上展开合作。

为了更好地服务国家战略，帮助中国开源企业出海，与沙特及阿拉伯世界共建基于开源生态的数字命运共同体，COPU计划从以下三个方面展开未来工作：

* 运营常态化：每周与沙特各方保持定期远程视频会议，维护合作关系；继续组织中国科技企业赴沙考察团，2024年下半年计划组织两次考察活动；开始组织沙特方代表来华考察，促进双向交流。
* 组织体系化：在COPU指导下，联合沙特相关单位探讨多种组织形式，包括共同发起成立开源创新合作中心等。
* 成果显性化：推动中国科技企业以开源生态共建的方式在沙特进行技术能力输出和落地；实现中沙之间基于开源的技术商业合作和市场共拓。 

COPU在推动中沙开源合作方面已经取得了显著的进展。通过组织IT企业沙特考察团、跟沙特开源组织签署战略合作协议、联合成立技术工作组等一系列举措，COPU为中国开源技术在沙特的落地和发展铺平了道路。未来，COPU将继续深化与沙特在开源领域的合作，推动更多实质性的技术交流和商业合作，为构建中沙数字命运共同体做出积极贡献。

在全球科技竞争日益激烈的今天，开源合作不仅是技术创新的重要途径，更是促进国际交流、增进互信的重要纽带。COPU在中沙开源合作中的积极实践，为推动"一带一路"倡议在数字领域的深入实施提供了有力支撑，也为中国开源技术"走出去"探索了新的模式。我们有理由相信，随着合作的不断深入，中沙两国在开源领域的交流将会结出更加丰硕的成果，为两国乃至全球的数字经济发展注入新的活力。
