# 第四章 开源教育现状

开源教育旨在让数字时代的公民了解开源的理念与文化，增强数字化协作能力，共享开源开放的成果。开源教育涵盖开源文化教育、开源意识教育、开源技能教育三个方面。开源文化教育内容主要包括开源社区的形成机理和运转机制，以及开源活动得以持续生存和发展的机制、机理等，同时还包括开源历史、开源共识及开源的治理规则等。开源意识教育包括创新意识和开放透明的协作共享意识，创新意识表现在以开源技术迭代为基础，敏锐感知新兴技术的需求并进行快速创造，协作共享意识表现在适应全球分布式开发的趋势。开源技能教育体现为开发者传统的编程能力，开发者对开源技术和工具的使用能力，以及分布式环境下的协调、协作能力。

开源教育在当下发展迅速。其因技术进步和教育理念转变而兴起，特点是资源开放、社区协作与创新。优势在于降低成本、促进公平和提升质量。然而也面临资源质量不一、技术支持缺乏和教师培训需求等挑战。目前已在计算机科学等领域广泛应用，未来有望与新兴技术融合，更多机构和企业也将参与。总之，开源教育虽有不足，但前景广阔，为教育创新和公平提供了有力支持。

## 4.1 开源教育加速融入并贯穿教育全阶段

### 4.1.1 高、中、小学开源教育

在人才培养的高、中、小学阶段，开源文化与技术逐渐渗入到庞大的教学体系中。在“双减”政策颁布之后，中小学生也更有时间和精力去投入一些开源的项目，加强综合素质提升。虽然中小学信息化教育目前较少开设独立的开源文化与技能教学内容模块，但是由于开源具有低成本以及便于获取、学习和应用等优势，各地高、中、小学可以尝试以开源软件、开源硬件作为素质教育、STEAM教育、 创客教育的工具，培养学生的科学精神和创造力。例如Arduino、Scratch等开源软硬件在儿童创客 教育产品被广泛使用。与此同时，众多开源组织和开源在线教育平台组织了相关师资培训及学生创 客活动，并提供相关系列课程和教具，支持学校进行开源启蒙教育。

###4.1.2 高等院校开源教育
高校是开源人才培养不可或缺的重要基地，目前，国内很多高校已经在积极探索我国开源创新人 才的培养路径，推动开源软件生态建设，提升软件人才与关键软件技术创新和供给能力。众多高等 院校加大开源基础设施投入力度，进行开源课程建设，组织开源相关讲座、竞赛以及多种线上、线下活动。例如，北京大学计算机学院周明辉开设的《OSS Development开源软件技术》课程，以学生实际参与的开源项目为线索，讲授开源软件开发涉及的理论知识、方法技术和工程实践，帮助学生了解开源软件开发、学习如何参与开源项目、训练开源思维。华东师范大学与同济大学共同创建X-lab开放实验室，开设开源软件通识基础课程，通过收集、整理、理解和拓展国际最新的前沿开源课程，讲解开源基础、开源经济学、商业开源软件、开源项目办公室治理导论的相关内容。北京信息科技大学设置开源软件开发技术课程，通过学习开源软件背景、开发方法等方面知识，使学生掌握开源软件开发要领和开源项目管理方式，了解开源软件成功的经验和失败的教训，学会利用开放源代码资源从事专业学习和科学研究，客观分析开源软件对社会、经济可持续发展的影响，鼓励学 生积极参与开源软件开发并为之贡献自身力量。

###4.1.3 职业教育与终身教育

开源职业教育与终身教育跟随行业需求飞速发展。近年来开源具有的越来越大的影响力，开源相关培训以及网络课程大量增加。越来越多的职业教育机构和培训机构开始引入开源软件和工具， 为学生提供更加实用和创新的教育体验和机会。基于网络的大规模开放在线课程MOOC学习模式出现，大量优质开源课程资源免费共享，吸引来自全球学习者注册学习，其中典型的代表是edX、 Coursera、Udacity等MOOC平台。同时，一些企业也开始注重开源软件和工具的应用和推广，为职 业教育与终身教育提供更加实用和创新的教育资源和支持。GitHub、GitLink、CSDN、开源中国、头歌（educoder.net）等开源社区上的优质项目也为学习者提供了面向全球顶级开发者学习实践的通道。在国家相关政策的指导下，随着教育信息化的发展，开源教育正在融入从中小学教育到职业化教育的各个阶段。
 
##4.2 开源教育平台和开源协作模式
###4.2.1 基于开发工具和知识社区的开源教育平台
基于开发工具的开源教育平台支持大规模开源开发者分享开源技术、传播开源理念、推广开源项目。基于开发工具的平台典型代表包括Github.com、SourceForge.net、GitLink.org.cn、Gitee.com、 GitCode.net、eudcoder.net、learnerhub.net等。

基于知识社区的开源教育平台提供了软件工程服务、讨论区、资源库等，形成了活跃的互动在线学习模式。平台典型代表包括Stackoverflow.com、CSDN.net、learnerhub.net等。其中，Stack Overflow 由Jeff Atwood和Joel Spolsky这两位非常著名的Blogger在2008年创建，旨在提供一个与程序相关的IT技术问答网站。中国专业IT社区CSDN(Chinese Software Developer Network)创立于1999年，致力于为中国软件开发者提供知识传播、在线学习、职业发展等全生命周期服务。

###4.2.2 基于开放实践和开源竞赛的开源教育平台
基于开放实践和开源竞赛的开源教育平台支持大规模开源开发者参与开源项目实训，该类平台以实践需要为导向，形成了产教一体化的在线学习模式。例如，早期国防科技大学毛新军教授团队基于社交化编程思想和群智共创理念，设计了群体化学习平台原型系统（learnerhub.net）， 其主体包括群体化学习内容共创、群体化学习主题研讨、群体化学习问题解决、群体化教学过程外包四大部分，用以支撑开源活动和进行开源教育。
头歌（educoder.net）是一个由国内知名高校、产业联盟和大型企业共同发起的新型开放在线实践教学平台。基于大规模开放在线实践（MOOP）范式，头歌将1000多种开源软件引入教研和教学活动，支持2800所高校建立的8000多门在线实践课程，涵盖计算机程序设计、软件工程、计算机系统、云计算、大数据、人工智能、电子技术、智能制造等所有专业方向的教学、实验、实训和科研活动，同 时也支持老师和开发者按需协同开发在线实践项目和课程，为各类高校和社会各界提供高可扩展和 高可定制的教学资源和实践环境。

软通教育面向信创技术等领域提供教育和资源服务，自主开发的信创智能交互实训教学平台，支撑高校在开源领域的实践类教学活动、过程管理、学生创新实践能力以及师资科研，为高校提供专业建设、实验室建设、教师发展及学生就业实训等一站式解决方案，辅助教师快速适应新型教学模式、优化配置教学资源，快速提升学生在开源技术等领域的实际操作能力及行业经验，最终实现高质量的人才输出。

CSDN在20余年的发展中，逐步建成了体系化、多视角的教育平台。由优秀博主设计的专栏和课程在IT行业各个领域都有覆盖。由CSDN和专家主导的技能树、编程比赛、专项训练为IT人士提供了循序 渐进、自我驱动的培养体系。CSDN推出的训练平台和能力认证，致力训练开发者的硬核技能，整体 设计融入“技术素养”“项目素养”“开源素养”和“职业素养”。广大在校生可以通过训练平台进行技能实训，从而提升工程化交付能力。平台设计以任务闯关为驱动，培养主动学习的习惯，现已培养了大量具备动手能力的IT研发工程师。能力鉴定方面，CSDN能力认证以真实项目为考题， 采用真实 场景（全程录屏、真人露脸）的考核方式，线上实时监考，所有代码与文档同步到GitCode。效果评估方面，有专家评判结果，有据可查。通过CSDN的训练平台和能力认证，为IT大学生毕业上岗缺乏实践经验及软件工程师技术能力客观评估提供了有效的解决路径。2023年3月，CSDN发布InsCode，它是面向开发者的集编程，创作，分享于一体的全新共创社区。可提 供基于云的IDE，支持多种环境和语言，无需下载安装，帮助在校生直接在浏览器中编码开发；完整的开发流程，也可为他们省去大量配置和概念，专注在创作本身；提供不同类型的项目内容模版，助力开发者想法到作品的快速落地；开放的作品分享社区，为编程学习提供边学习边实践的学习环境。

百度AI Studio是针对AI学习者的在线一体化学习与实训社区，集合了AI教程、深度学习样例工程、各领域的经典数据集、云端的超强运算及存储资源，以及比赛平台和社区，从而解决学习者在AI学习过程中的一系列难题，例如教程水平不一、教程和样例代码难以衔接、高质量的数据集不易获得，以及本地难以使用大体量数据集进行模型训练等。

竞赛类学习平台主要采用在线编程竞赛的形式促进学习者进行程序设计语言学习、算法设计、编程 应用等。例如，Topcoder平台（topcoder.com）每个月都有2至3次在线编程比赛，参赛者可根据自己的爱好选用Java、C++、C#、VB或Python进行编程。Kaggle平台（kaggle.com）为学习者提供了举办机器学习竞赛、托管数据库、编写和分享代码的环境，近些年吸引了大量学习者的关注。头歌将全 栈化智能在线实践技术和环境引入在线竞赛，有效支持在线实战化的全流程竞赛和活动。自2018年 以来，中国软件开源创新大赛已成功举办五届。2023年第六届“中国软件开源创新大赛”在国家自 然科学基金委信息科学部的指导下，由中国计算机学会（CCF）主办，西北工业大学、绿色计算产业 联盟、CCF开源发展委员会联合承办。大赛面向国家“十四五”开源生态发展战略布局，聚焦“卡脖 子”软件领域以及人工智能、大数据、芯片设计、物联网等前沿技术领域的开源软件，旨在为国内开 源社区提供展示、交流、合作的平台，激发开源创新活力，培养开源实践人才，助力开源生态建设的 高质量发展。

##4.3 校企结合的开源教育协同模式
###4.3.1 多源主体协同推动开源教育发展
**政府引导：** 2020年6月5日，教育部办公厅、工业和信息化部办公厅关于印发《特色化示范性软件学 院建设指南（试行）》的通知中提出，要以特色化软件人才培养为目标，以深化产教融合为途径，以改革创新为驱动，以特色发展为重点，深化软件人才培养模式改革，大力开展关键核心软件技术攻关，促进软件生态体系建设，充分发挥软件人才培养对产业发展的支撑引领作用，推动我国软件产业实现由大到强的历史跨越。同时，开源教育也在对接教育部“计算机领域本科教育教学改革试点工作计划（101计划）”，提升软件人才与关键软件技术创新和供给能力。

**高校、企业、社区、科研院所多方积极协同：**随着开源教育从以开源软件教学为主的教育模式向理论 与实践结合的综合教育模式的转变，一些企业与高校联动，形成校企联合建设实训基地。例如极狐 （GitLab）免费向X-lab成员中的华东师范大学数据科学与工程学院师生提供极狐GitLab旗舰版使用 许可。并且，X-lab实验室将极狐在开源文化、开源社区运营管理、DevOps等领域的通用知识纳入教 材编写与人才培养计划。同时，X-lab利用极狐技术平台与开源社区资源，基于极狐GitLab平台研发 “校园版”DevOps。

**平台支持：**2021年，中国计算机协会（CCF）开源发展委员会成立，作为中国计算机及相关领域具有 广泛影响的学术团体，重点聚焦共同打造开源、开放、中立的产学研协同开源创新服务平台，推动探 索学术共同体主导的开源发展新途径，助力我国开源生态建设的发展。在OSTech、华为、Linux基金 会亚太区、Linux基金会开源软件学院、南方科技大学等企业社区及高校开源俱乐部的联合支持下， 成立了高校开源社区联合体——开源高校联盟，它提供社区运营、技术、课程/认证、导师以及多方面资源和资金服务。

###4.3.2 开源教育与产教融合
高等院校开源教育从学生、教师自发开源教育行为转变为院校行为，从高校教师的独立行为转变为与开源社区合作的共建行为。北京大学软件与微电子学院的荆琦提出“产教融合下的双轨制开源教学模式”，开发《开源软件开发基础及实践》课程，与RocketMQ、openEuler、PostgreSQL、OpenCloudOS、CloudWeGo、XIAOJU-SURVEY、DoKit&Hummer、OpenAnolis等开源社区合作，开源文化通识性教育和开源实践开发指导双轨同步进行。课程通过与开源社区合作，解决了开源技术方向多样性与教师个人研究方向单一性之间的矛盾，在一定程度上弥补了企业人才需求与高校教育之间的差距，被中国开源软件推进联盟推荐为示范课程。
目前，国内很多企业及高校已经在积极探索我国开源创新人才的培养路径，推动开源软件生态建设， 提升软件人才与关键软件技术的创新和供给能力。例如,头歌（educoder.net）平台构建了开源软件实 践教学生态系统，致力于打造基于开源的覆盖通识课程、系统类课程、平台类课程的教学实验平台 及相关课程资源和开源生态建设场景。达到提升学生实践能力、推广开源思想、培养与社会和岗位需求紧密匹配的目的。
 
###4.3.3 开源创新活动丰富校企联动机制
丰富多样的开源活动为校企合作与开放创新提供了多层次的交流渠道，为产教研用搭建了高效的合 作平台。

**中日韩三国IT局长OSS会议**。中日韩三国IT局长OSS会议暨东北亚开源软件推进论坛自2004年建立 以来，在三国开源领域合作中发挥了重要作用。大会总结了近年来中日韩三国在开源技术与评估、人力资源开发、标准化与认证、开源人才共建等方面的成功经验，并联合产、学、研、用的全要素力量，共培开源沃土，助力开源产业创新发展。

**开源中国开源世界高峰论坛**。开源软件推进联盟每年举办开源中国开源世界高峰论坛，高峰论坛通 过“现场论道+云端连线”的方式，邀请国内外开源领域的专家、高校学者、企业领袖、技术大咖等齐 聚一堂，深度分享开源产业发展现状与趋势、技术与模式创新以及人才构建等方面的实践经验。

**CCF青年精英大会**。依托CCF在学术资源、产业资源和社会资源连接中的桥梁和纽带作用，中国计算 机学会开源发展委员会探索产、教、研、用联动的开源创新模式，打造开源、开放、中立的产学研协 同开源创新服务平台，举办CCF青年精英大会开源专题论坛，论坛邀请产业界、学术界以及科研领 域的开源领军人物，共同分享和讨论如何通过产学研协同加速高校开源生态建设。

**“CCF开源高校行”**。它旨在高校加强开源文化宣传和开源人才培养，是CCF开源发展委员会年度重点校园推广活动之一。活动从2021年开始，依托CCF开源发展委员会执行委员，联合企业、开源社区和高校，围绕开源文化、技术、项目、应用等设立不同专题，走进高校，面向广大师生宣讲开源。“开源高校行”活动至今共组织了19场，活动参与的高校包括北京大学、清华大学、复旦大学、中南大学、国防科技大学、南方科技大学、上海交通大学、武汉大学、武汉理工大学、华南师范大学、南京大学、东北大学等；50多位业内专家老师进行了报告分享；形成了广泛影响和成功实践。

GitLink确实开源、木兰开源社区、开放原子基金会、飞桨开源社区、红山开源平台、Alluxio开源社区、OpenCloudOS社区、OpenHarmony开源社区等众多开源社区专家、学者与高校师生分享开源经验，共话开源。

**开放原子“校源行”活动**。2023年4月，由开放原子开源基金会、央视网联合主办，北京航空航天大学承办的开放原子“校源行”活动在京举行，活动积极宣传推广开源文化，加快推进开源 “进校园”，对于厚培开源人才底座、夯实开源发展基础、提升软件源头创新和供给能力具有重要意义。
 
##4.4 开源教育问题与挑战
###4.4.1 国内开源人才短缺
开源教育需要大量的技术人才和教育专家来推动，缺少专业人才是我国开源教育发展道路上一个极大的绊脚石。虽然各大高校每年都向社会输送大量的软件人才，但是还是不能满足开源教育的需要。从芯片、操作系统、虚拟化、云计算、人工智能、代码托管等领域来看，国内仍然依赖大量海外开源项目，如何带领学生进入“卡脖子”技术开源社区，培养一批未来的核心贡献者团队；如何摆脱受制于人的困境实现科技自立自强，仍然任重道远。

###4.4.2 开源教育资源不完善
国内开源教育仍然处于少数高校、教师先行示范阶段，并未大范围展开。在教学资料方面，现阶段缺少面向开源的教育资源，包括教材、课程设计等。如何形成统一的教学案例、教学素材，使全国范围内的大部分高校达到实际推行开源教育的地步，仍是一个亟待解决的问题。

###4.4.3 高校对开源教育的接受程度有限
传统教育的观念较为保守，教师和学生都习惯于被动接受知识，而不是积极地参与到知识的创造和分享中，使得教师与学生对于开源教育的理念和模式理解不足。从学生角度来说，缺乏开放学习的方法，从教师角度来说，应用计算机的能力较低，对新技术的使用难以适应，从“不会用”、“不能用”到“不想用”，从而导致开源教育难以在教育体系中得到认可和推广，限制了其发展。

###4.4.4 缺乏可持续发展的商业模式
国内开源商业模式虽然逐渐成熟，但在开源的商业策略、长远的战略上与国外的企业还有着较大差距，国内开源教育项目大多采用捐助、志愿者、增值服务、机构合作、会员等绝大多数非盈利的运营模式，缺乏可持续发展的商业模式，难以支撑项目的长期发展。因此，寻找开源教育运营规律，实现商业模式优化和创新，是开源教育持续发展的不竭动力。

###4.4.5 法律法规的约束力度需加强
开源是一种有约束的开放共享，正是这种约束才使开放共享得以长久繁荣。从法律法规角度，对违 背开源许可证的负面行为进行合法合规约束，是推动国内开源事业的关键。国外有对FaceBook、Google、微软等企业进行反垄断罚款的先例。国内在这方面刚刚起步，如何在社会范围内建立健全 版权意识、如何合理合法的对开源负面行为进行追责，都是我们当前应该考虑的问题。

##4.5 开源教育发展建议

###4.5.1 加强培养开源创新人才培养
推动基于优秀国产开源成果的课程体系设计、师资队伍建设和培养计划制定，培养开源创新人才， 支撑国产开源软件形成可持续发展生态。建议由教育部牵头，会同工信部等国家部委，以开源实践教学、新形态开源教育资源建设、“101计划”和特色化示范性软件学院建设为基础，推动基于开源的教育落实到相应方案和规划中。

###4.5.2 加强开源文化和开源技能教育
我国高校亟需加强开源文化和开源技能教育，建立鼓励软件成果开源的评价机制和价值导向，推动高 校产出更多原创性开源成果。一是在软件工程等相关课程内容设计上，主动融入开源文化、开源规律 和开源模式的教学内容，培养学生的开源意识和开源技能。二是在高校学科建设评价机制方面，将成果开源情况纳入考核指标，鼓励高校师生积极参与开源社区贡献，加强与开源企业的合作，促进开源教育的应用和推广，鼓励高校形成原创性开源成果。

###4.5.3 打造创新性产教融合平台
开源教育应拓展到人才培养成长的各个阶段，需要相应平台和政策环境的支持，建立从高校开源学习、产业开源实践到开源创新创业的闭环，服务我国软件产业发展。一是以各类教学服务平台为基础，以开源实践创新为抓手，打造涵盖学习实践和创新创业的云原生产教融合开源实践平台和开放共享学习创业社区；二是以学生为中心，以融合平台为依托，联合高校、企业、投融资机构等建立起支持学生从开源实践到创新创业的机制和途径。建议由教育部联合工信部、发改委、中国科协等共同设计行动方案。
