# 第三章 开源重点领域发展现状
## 3.1 操作系统产业研究报告
### 3.1.1调研背景

操作系统是信息化的核心基础设施，自1991年Linux操作系统发布以来，开源一直是我国发展操作系统产业的重要路径。

经过多年的探索和尝试，第一代Linux中文发行版开始陆续推向市场，与上游社区的割裂成为这一带产品的典型特征也为后续的自主发展和演进埋下了隐患。后续中国操作系统企业的发展是相对艰难的，热情冷却后要面临的是自我的救赎，这时我们大多数人开始意识到“开源并不简单”。2008年是中国奥运之年，是中国向世界打开的一扇窗，这一年也是中国开源和中国操作系统的转折之年，在中国开源泰斗陆首群主席的努力斡旋下，Linux基金会首次在华召开了2008 Linux Symposium，同年Apache软件基金会、openOffice基金会、Gnome基金会也在华完成了它们的亚洲首秀，中国开源开发者和中国Linux企业在全球开源界的形象大幅提升，为后续进一步融入全球开源大家庭奠定了基础。

2019年3月，正当我们为中国开发者内核贡献度全球排名连续排名第一（自2017年11月Linux-4.14发布持续至今）而沾沾自喜的时候，美国对中国开始了史无前例的科技封锁和技术供应链解耦，以华为为首的中国科技企业面临有史以来最大的生存危机。如操作系统等信息产业核心技术在民间瞬间被“卡脖子技术”一词代替。所幸的是，我国几十年来在开源生态中积累了大量的人才和工程经验，同时信创市场给国产软硬件企业撑起了一个稳定的市场空间，保证部分国内企业可以不断发展，不断迭代技术产品。

今天，华为、阿里、腾讯、麒麟、统信、睿赛德、翼辉信息等企业的相关操作系统产品的用户量持续增长，品牌影响力大幅提升。2022年受COPU委托，北京初心开源技术有限公司面向整个行业开展了一次中国操作系统产品调研。2023年10月至2024年3月，在第一次调研数据的基础上，COPU联合北京开源创新委员会、北京初心开源技术有限公司、清华大学计算机系联合发起范围更广的中国操作系统调研。

本次调研希望能够完整呈现当前我国操作系统产业发展的整体情况，产品分布，技术特点和现存问题。

### 3.1.2调研方法

本次中国操作系统产品调研分为两个阶段，第一个阶段面向全社会广泛征集现已对外发行的操作系统产品（包含同一单位的多个发行版，不包含内部使用不对外发行的自用操作系统），并对其产品特性进行标注和补充。

第二个阶段是定向邀请来自30家不同企业和高校的操作系统专家在第一阶段征集的操作系统产品列表中自主选择十佳操作系统，并对其在技术栈成熟度和发展性、系统和应用生态开放性、存储性能、网络性能、硬件性能等十五个维度进行评分。

### 3.1.3调研数据

本次调研数据《中国操作系统产品名录》为公开文档（如下图）。

![](https://i-blog.csdnimg.cn/direct/f7b05b41e2e1414aba53312282192be1.png#pic_center)


截止2024年3月30日，本次操作系统调研（去重后）共收录各类中国操作系统发行版累计216个，其中桌面类24个，手机平板类39个，云和服务器类38个，物联网类71个，汽车类28个，嵌入式类46个，特种应用类15个。

![](https://i-blog.csdnimg.cn/direct/56c99eec5e2946269a477dd2bb8ac39d.png#pic_center)

相较于2022年9月第一次调研数据，中国操作系统发行版数量增长18.68%，增幅较大的集中在机器人和边缘操作系统、物联网操作系统、嵌入式操作系统和智能网联汽车操作系统等领域。

 
### 3.1.4调研总览

在桌面操作系统方向上，依然是在Linux内核基础上的系统自主构建，以麒麟软件和统信软件为代表的第一梯队，在产品成熟度上取得长足进步，同时两家企业不约而同增加了自己对上游开源社区的贡献度，截止2024年3月，两家企业Linux内核贡献均超过100个，并先后于年内宣布建立“根社区”，暨不再依赖其他发行版做分支，而是进行操作系统的自主构建，这是Linux发行商技术能力提升的一个重要里程碑。同时在信创市场的引领下，麒麟和统信已经建成了百万级的国产操作系统应用软件生态，海量的应用软件为操作系统的国产化进程提供了巨大助力。桌面操作系统未来发展是一个一直存在争议的话题，事实上尽管它是PC时代的产物，但同样面临着移动互联网时代和人工智能时代的冲击。麒麟和统信为代表的国产操作系统阵营，短期要解决替代的需求，同时与时俱进，提出下一代操作系统的新的定义和新的功能特征。据悉，两款国产桌面操作系统可以有效的与智能手机系统链接，并可以通过容器或类似ARC技术直接运行安卓APP，但我们认为下一代操作系统在工作场景、生活场景和娱乐场景都将深度的与人工智能技术集成，在人机交互、分布式计算、分布式存储、算力资源等领域均有巨大的发展潜力。微软公司作为最成功的桌面操作系统供应商，其当下的AI战略值得我们企业广泛借鉴。2023年9月统信率先发布UOS AI产品，现已覆盖90%主流开源大模型与AI框架。

在手机平板类操作系统方向上，得益于中国物联网产业的高度发展和手机平板等智能终端制造业的高度成熟，与桌面操作系统相比，这类操作系统普遍拥有更大量的实际用户、日活用户。除少量基于chromium和Linux+QT的技术架构外，基于AOSP的深度定制版依然是此类操作系统的主流架构。值得关注的一点是在过去一年中openHarmony正在成为此类操作系统的第二个选择，其在物联网类的上升势头更加明显，技术生态和影响力大幅提升。华为手机回归后，新一代的HamonyOS确实让业界眼前一亮，除了原有的软总线、混合内核等技术特征之外，其尝试在安卓生态之外，自建技术生态的战略发展路线着实让业内普遍为之振奋同时也为其担忧。一个技术生态的发展往往伴随着一个新时代的崛起，而技术生态又具有全球性和广泛性的特征，围绕单一市场是难以构建具备竞争力的新技术生态。在生态构建者具备足够开源开放的基础上，同时还要有与之配套的长期发展战略和大量的资源投入，此外有与业界共享产业发展红利的胸怀，与生态伙伴共赢的商业模式，甚至还要抓住人工智能时代技术更迭的历史机遇。国内其他手机制造商对Harmony技术生态的态度可以作为一把标尺，也是其生态发展第一个要突破的瓶颈。

云和服务器类操作系统方向则呈现出openEuler、OpenAnolis和OpenCloudOS三驾马车持续领跑。作为华为云、阿里云和腾讯云的战略型核心基础设施，三款产品不论是在开放性、先进性和可持续发展性上均领先其他同类操作系统产品，但此类操作系统产品的同质化也是最高的（目前三家企业正在CAC的直接指导下加强技术合作，逐步在核心软件包和系统升级等方面开始统筹规划）。在所有收录的此类系统中，我们可以看到越来越多操作系统发行商正在将上游社区从Debian、RHEL/CentOS开始向openEuler和OpenAnolis转移，这一现象得益于近期国内兴起的“根社区”能力建设，这个方向无疑是正确的。自主可控操作系统，必须从自主构建开始，在开源操作系统生态中，如何提升自身的技术影响力，这其实是一个长期开源战略，自主构建只是第一步。

物联网操作系统方向则呈现出多种结构并存的百花齐放局面。一部分是基于Linux内核的衍生版（如OpenHarmony），也有一部分是基于RT-Thread内核的衍生版（如XiUOS矽璓等），此外近期基于OpenHarmony的衍生版在智能机器人和智能家居领域领域日渐增多。一直秉持自主研发的翼辉信息边缘操作系统EdgerOS近两年也取得了不俗的市场成绩。此类操作系统产品中还包括了许多智能网联汽车中的智慧座舱类系统。与前述几类系统最大的差别，是此类操作系统产品的硬件平台千差万别，因此系统定制化的要求较高，这也导致了开源操作系统的碎片化生态在此显而易见。对功耗、性能、工况、计算、存储和通信能力的差别短期内依然无法形成清晰产业格局，智能家居市场也成为目前看得见但却赚不到钱的“鸡肋”操作系统市场，尽管OpenHarmony正在成为原来越多此类系统的上游社区，但其技术生态影响力和市占率还远远不够，此类操作系统“小碎散”的现状短期难以扭转。

汽车类操作系统方向在智能网联汽车时代则呈现出三个应用场景驱动下的三类汽车操作系统，分别是车辆控制操作系统、智慧座舱操作系统和自动驾驶操作系统。另外由于智能域融合的发展趋势，涌现了对于嵌入式虚拟化操作系统的需求，在智能座舱、融合网关、舱驾合一的多个场景中都需要虚拟化来实现算力、外设资源的灵活调配。对于车辆控制操作系统当前依然是国外操作系统的天下，国内的东软睿驰、翼辉信息、睿赛德、中电科普华等少数企业有上车交付的案例，在智慧座舱和自动驾驶领域近年来涌现出了几十个技术产品，但同质化极其严重，可以说一车一系统，每个汽车主机厂都在努力构建自己的品牌，大体上只有三个技术架构，第一个是“Linux深度定制”对标特斯拉的汽车操作系统（值得一提的是特斯拉在超级充电、自动驾驶等诸多领域的深度开放开源已经成为业界典范）；第二个架构是Linux+AOSP主要被国内的造车新势力和一级技术供应商所采纳，这类架构的特点是更侧重于操作系统本身的出发点来定义系统；第三个架构是QNX+AOSP，这也是目前国内最常见的技术架构，主要被国内传统汽车主机厂所采用，这类架构的特点是更侧重于汽车安全体系的出发点来定义系统，因此QNX成为了不二之选。汽车从早期机械时代、电控时代到如今的智能网联时代，汽车操作系统也正在从分布式、域控制向集中控制转化，因此此类操作系统尚未形成MacOS和Windows、iOS和Android一样的确定的两级产业结构，如何利用这个窗口期把握机遇抢占一个席位，值得我们深思。目前华为、斑马智行、中汽创智、小米、翼辉信息、中瓴智行、国汽智联、中科础石等均在摩拳擦掌，快速迭代产品。但此类系统最终仍需要通过“上车”这一关键环节来验证自身系统的安全性和可靠性，相较于对云和服务器操作系统的国家级单位斡旋下的统一协作，汽车行业现阶段更需要行业主管部门和权威机构的介入，避免重复投资和产品同质化，避免“小碎散”局面在这个领域重现。其中，中瓴智行的RAITE Hypervisor嵌入式虚拟化产品精准定位于智能化域融合的基础设施，兼顾了资源隔离及高效复用、异构功能安全等级OS的生态兼容，已在多个主机厂实现了“上车”量产。

嵌入式类操作系统方向则根据其对操作系统的实时性要求不同，呈现出强实时和弱实时两个方向。强实时操作系统主要应用在国防军工、火箭卫星、大飞机、轨道交通、电力能源、工业制造、汽车电子、医疗设备、先进制造等对“实时性、稳定性、安全性”要求苛刻的领域，目前市场主要被VxWorks和其国内衍生版垄断，国内发展势头较好的有翼辉信息原创SylixOS，承担起我国关键产业的安全可控和持续发展。弱实时操作系统主要应用在智能穿戴设备、物联网设备、智能家居设备、工业互联网设备等行业，目前市场上Liunx的定制发行版为主流方案，国内睿赛德RT-Thread、中移物联OneOS以及华为OpenHarmony发展势头相对较好。国内操作系统产品呈现出行业聚集的分布特点，即某个产品在某行业具有较高市占率，且很难在其他行业保持市场优势。此外中国电子、中国电科、中国航天、中国航空、中国船舶、中国兵器等央企所属的研究院所也分别拥有自己的嵌入式操作系统品牌，相对独立的服务于自身业务体系。

特种应用类操作系统方向则呈现出快速发展迹象，特别在WRZZ、TZZZ等场景下的操作系统产品快速迭代，在武器装备领域多个平台也涌现出更具竞争力的操作系统产品。

### 3.1.5 发展趋势

根据本次面向全社会的操作系统产品征集和调研，中国操作系统行业发展呈现出以下几个特点和趋势。

操作系统定义正在外延。随着云计算、物联网、人工智能和智能网联汽车等时代的来临，操作系统定义正在不断被扩大，虚拟化、容器、多模态感知、AI算法和业务中间件正在不断被操作系统发行商集成到操作系统内部，这一现象是新时代对操作系统不断诠释的正常演进，也造成了操作系统家族的泛化和产品细分。

操作系统产品的战略地位持续提升。自操作系统产品被定义为信息化核心基础设施之后，其在产业生态和供应链系统中的地位就在不断攀升。曾经普遍被质疑的操作系统商业模式随着时间的推移已经不再是业内人士口诛笔伐的焦点。现今，我国操作系统产品正在从产业政策驱动的时代向用户市场驱动的时代迈进。操作系统产品以其特有的技术生态核心地位正在成为各行业志存高远的科技企业构筑其核心竞争力的重要途径，成为企业长期竞争战略的重要组成部分。

操作系统产品同质化严重，生态碎片化加剧。操作系统产品因其基础性、广泛性和先进性的特点成为开源生态的重要组成部分。也正因如此，我国操作系统产品普遍通过继承或引用部分开源技术构建自身产品，这是同质化的根源之一。其次目前国内操作系统研发团队规模较小、成立时间短，只能将有限的研发资源优先投入到系统的定制化上，对上游开源社区和系统核心模块的投入不够，于是选择直接“继承”，导致了对系统结构框架、核心软件包以及部分强依赖软件包无法自主维护更新，软件包自研比例低，且相对解耦，如各种设备驱动程序，系统架构支持，运行时系统（这样做可以积累自身工作，避免主系统升级后，前期一些自研工作由于无法兼容和继承，而被破弃用）。同质化是生态发展的一个大忌，简单说就是低水平重复，浪费了大量的时间和资源。我国已经拥有超过二百多款操作系统产品，同质化的产品导致操作系统生态碎片化加剧，“小碎散”的局面依然广泛存在，因此产品的同质化是生态碎片化的一个重要原因。通过本次调研发现，产品同质化在所有操作系统类别中广泛存在，近年来在桌面类和服务器类中有逐步改善的迹象，但在物联网类和汽车类和嵌入式类中，产品同质化和生态碎片化的迹象还在加剧。

应用场景细分促使操作系统定制化成为趋势。碎片化的另一个原因是新时代对操作系统产品给出了更加丰富的应用场景。这里有两个重要趋势，一个是软硬一体化趋势，这里包括物理硬件也包括虚拟硬件，当我们选择一个在线服务、一款智能手表或者一台智能滴灌系统时，其供应商定制优化的系统将直接开始服务。可以试想在iPhone手机刷一个鸿蒙系统？是的，这个想法已经过时了。另一个就是智能化趋势，在物联网类和汽车类中，通过集成多模态交互功能和自动驾驶AI算法使得操作系统在该场景下拥有高度智能特征，甚至一些自主决策能力。这两个趋势或在未来一段时间内持续引领操作系统的发展方向。

操作系统产品研发的社区化和国际化持续推进。开源无国界，操作系统产品本身就是国际化合作的产物，是开源社区的研发成果，主要创新力来源于社区。我国操作系统产品的发展有赖于国际开源社区的几十年持续的开放、共享、交流和协作。但我们在开源文化底蕴培养开源社区治理运营上的进展则落后于我们下载开源代码的速度。2006年Linux-2.6.12内核中中国开发者仅贡献了50个软件包，如今中国开发者对内核社区的累计贡献已经在所有国家中排名第一（自Linux-2.6.12至Linux-6.8历时18年的98个版本累计数据），在华为、联发科、阿里、瑞芯微、中兴通讯、龙芯中科、VIVO、腾讯、字节跳动、成都菁蓉、百度、中国移动、麒麟、酷派、OPPO、统信等一批企业的带领下，中国操作系统企业的社区化和国际化已经取得了一定的成绩。同期，这些企业创建的操作系统开源社区在国际上尚不具有影响力。希望未来中国企业能够建立可以比肩Kernel、Debian、Ubuntu、Fedora、CentOS这样具有国际影响力的操作系统社区，引领中国操作系统产业进入国际领先行列。目前，RT-Thread和Deepin是目前具有国际影响力较大的操作系统社区，openEuler和OpenHarmony以及OpenAnolis发展势头迅猛，希望未来可以获得全球开发者和国际市场的认可。

### 3.1.6发展建议

针对本次调研所呈现的操作系统行业发展现状，我们提出以下三点建议：

（1）我国操作系统产业的发展不仅需要政策引导、更需要获得市场引导和资本引导，才能进一步发挥我国的规模优势，调动企业研发的主动性和积极性，加强各操作系统团队间的深入合作，降低产品同质化、杜绝反复投资，将生态碎片化控制在可控范围内。

（2）加强操作系统生态共建，鼓励各操作系统团队积极加强与上游开源社区的技术交流，提升自身影响力；加强与供应链相关技术社区的深入合作，补链强链，避免技术生态割裂带来的供应链安全隐患。

（3）加强国内操作系统开源技术社区和用户群组的专业化运营和全球化建设，早日实现以开源社区驱动的操作系统产品创新机制，把我们的“根”社区建成全球操作系统的“根”社区。
 
