## 附录5 开源合规案例精选
### 中兴通讯开源合规案例

近十多年来，开源生态正变得越来越活跃和多样化，但是随着外部法规法条的日益完善以及市场准入门槛的提高，开源软件本身固有的合规、安全风险却长期困扰着绝大多数企业，特别是出海企业，成为企业开拓市场、合规经营头上的达摩克利斯之剑。

开源软件平均占到了整个软件产品成分的90%左右，开源软件所带来的风险也从一开始大家关注的开源许可证合规风险，逐步演进至EAR、产品安全、GDPR（个人信息保护）的合规和安全风险；近几年更是上升到了开源软件供应链安全、甚至是软件供应链安全的高度，开源软件的合规和安全也上升到各国的发展战略高度，成为企业之间、大国之间竞争的利器。在此背景下，构建适合企业发展战略的开源合规和安全治理体系就体现了企业开源治理新质生产力水平，在企业激烈的市场竞争中将起到举足轻重作用。

中兴通讯从2016年开始就尝试探索开源软件的合规治理，2018年出口管制事件后，公司全面重视合规，把合规上升到公司经营成功、成为百年老店目标的基石之一。在开源治理方面，由于开源软件的合规治理涉及法务、市场、研发、供应链、安全、研发流程和工具体系各个方面，究竟构建何种治理体系是经过了较长一段时间的碰撞、试点和反思。

中兴通讯以已有的高效产品开发（HPPD）研发体系为基础，将开源软件许可证、出口管制、产品安全、GDPR、软件供应链等合规、安全方面的外部法规、国际/国内标准、客户要求作为软件产品开发的约束条件，构建一体化的大合规、大安全的公司级治理体系，以确保能够满足外部不同法规、市场、客户的合规安全诉求。

![](https://i-blog.csdnimg.cn/direct/901e09e8377f437d8153e292009d2377.png#pic_center)

目前中兴通讯已经逐步构建起了公司级统一的开源合规和安全治理管控体系，通过信通院开源可信供应链和OpenChain双认证、对标欧盟弹性法案（CRA）和 BSI SBOM标准的NESAS 系列版本认证、GC 和 BSI BSZ认证、GSMA NESAS2.3（GSMA Network Equipment Security Assurance Scheme）移动通信设备产品开发和生命周期流程的独立安全审计、以及国内相关信创和国测方面的认证。

要想成功构建企业有效的开源治理新质生产力治理体系：

* 首先，公司领导对开源合规的重视是最关键的要素；
* 其次，全公司一盘棋，进行公司级的开源治理是成功的次要因素，也是提升开源治理新质生产力效能的最有效手段；
* 第三，企业须具备已固化的研发管控流程体系，开源合规和安全管控流程要求才能较容易的嵌入到已有的产品/项目研发管理过程中，从而确保管控的有效性；
* 第四，完整、全面、正确的识别产品/项目版本的软件成分（使用什么开源软件和如何使用开源软件？）是一切治理的基础！专业的SCA扫描工具是帮助项目了解开源现状和使用的必备工具；
* 第五，虽然是虚拟化的OSPO（开源软件管理办公室）运作，但是一个相对固定专业化的核心团队是确保治理方向正确、并引领企业逐年迭代演进的关键要素。
 
构建有效管控机制的过程并非一帆风顺，以下经验教训可供大家借鉴：

* 首先，组织层面对开源认知的不同，不了解开源的风险，随意用开源，害怕开源而不用开源是最可怕的。建议需要对组织各级进行洗脑、强有力的洗脑培训；
* 第二，组织高层领导的理解和支持是一切过程改进成功的必要条件，开源治理同样如此。外部合规安全事件驱动有时可起到事半功倍的效果。
* 第三、如何组织各领域专家、相关职能部门协同有序推进开源可信供应链建设？OSPO、开源COP建设、胡萝卜加大棒有时效果不错；
* 第四，如何说服组织内不同单位投入资源进行组织能力和工程能力建设，特别是组织一体化的开源治理管控体系？先试点成功，再全面推广，事实胜于雄辩；
* 第五，方向和目标非常重要，治理是一项长期的过程，需要说服领导和员工为什么要这样做？这样做有什么好处？组织的推进是帮助项目来进行合规和安全治理，否则这些工作只能项目自己来处理。解决了必须做的事情，剩下如何做就是你在帮助项目了；

开源软件和研发产品的全生命周期管理是开源治理管控的主线，自动化的研发、生产、运维系统是管控有效的必要保障，规范、流程、系统、度量展示与管控缺一不可。

![](https://i-blog.csdnimg.cn/direct/6d3084f02c5349c2a88127f010b256a5.png#pic_center)

开源可信供应链的要求没有尽头，企业需要持续优化、苦练内功、持续提升开源软件合规和安全管控新质生产力的研发效能，才能以不变应万变，在复杂的外部环境和激烈的市场竞争中立于不败之地。

 
### 麒麟软件开源合规案例

为保障使用软件包的来源合法，安全可信和开源合规，降低公司合规风险，麒麟软件公司特进行一系列开源合规相关工作，相关工作目前分为六大类，分别是引入合规，代码合规，安全可信，开源合规，健全制度与合规培训贯宣、理论支撑，后续也在持续优化中。

**引入合规工作**

主要关注开源软件的引入选型。软件包中心仓是公司开展一切业务的资源起点，选型是外埠软件包引入中心仓的唯一途径。麒麟软件制定开源软件引入选型流程，规范了外埠软件包引入流程，做到软件包生命周期管理端到端闭环；保障软件包的来源合法和安全可信；提供前期批量选型功能，提升研发效率。
 
引入原则基于技术、安全、合规、生命周期四个维度进行选型评估，确保最优引入，并根据选型相关信息，技术专家进行评审后才准许入库。

**代码合规**

麒麟软件搭建开源合规管理平台实现研发过程中对开源软件的引入、修改有基本的合规管理。开源合规管理平台的流程如下：

![](https://i-blog.csdnimg.cn/direct/145d5615772245e789c4c2a6f2a99c4d.png#pic_center)
开源合规管理平台检测流程

其中合规任务扫描支持软件包、URL地址、以及服务接入的方式创建合规扫描任务，合规平台先识别扫描任务的数据类型并进行相应的数据解析，再进行下一步的合规规则检测。合规规则检测的检测规则包括许可证兼容检测、版权规范检测、代码片段检测。合规审核为人工审核，当合规规则无法准确判断的合规问题的时候，会根据规则类型触发不同的审核流程，自动形成审核任务下发到软件包对应的责任人，审核后形成相应的记录存档在数据库。合规扫描完成后会形成一个完整的合规检测报告，覆盖合规检测问题以及标记具体位置，方便研发进行合规问题整改。

**安全可信**

漏洞管理机制非常重要，其中漏洞发现与收集是指收集麒麟相关产品的安全漏洞信息，确保所有的安全漏洞问题能够得到闭环；漏洞分析是通过对产品的影响域、危害程度分析制定漏洞修复策略；漏洞修复是根据漏洞信息制定相关修复策略确保安全漏洞已经被彻底修复；漏洞维护与补丁披露是根据漏洞修复信息编写漏洞公告、披露并告知用户进行安全更新。

**关于开源合规**

为确保计划开源的代码合规开源成立了开源评审小组，通过合规扫描和整改流程，防范和解决潜在的代码合规风险，如版权侵权风险等，并从技术和商业角度评审，确保公司开源代码的合规性和价值。以下是麒麟软件的开源合规评审机制：
 
![](https://i-blog.csdnimg.cn/direct/9119a92cbee040768f6c3acebaa44d6d.png#pic_center)
开源合规评审机制


**健全制度与合规培训贯宣**

这项工作是麒麟软件开展合规工作的基础。开源软件的合规使用本质上属于知识产权的权利行使与处分相关问题，因此首先应制订企业整体知识产权管理制度，其中对于涉及开源事项的决策机构、管理模式及事项决策流程进行整体性规定。此外开源软件合规治理涉及企业人员众多，技术、产品、法务等多部门人员均会涉及开源软件合规治理节点，因此，针对新老员工、不同岗位职责设计不同的培训内容，通过多次培训将基本开源软件合规治理理念和知识传递给参与日常开源事项的每一名员工。

合规培训是指其中麒麟软件成立合规工作小组，主要负责规范制定、合规法律解读、代码开源及维护策略决策等。为明确开源软件管理的生命周期，定义各环节的执行规范而建立开源软件管理规范。

**合规理论研究**

麒麟软件法务部门对于构建企业开源软件合规治理体系提供坚实的理论支撑。具体表现为法务部门组织力量深入研究解读世界主要开源许可证的各项条款，仔细分析识别各开源许可证所规定的开源软件发布、分发、修改、使用，衍生等各种行为的法律义务，提炼合规要点，撰写各主要开源许可证合规使用指南文档为合规治理工作提供理论指导。

![](https://i-blog.csdnimg.cn/direct/42377ae0046d406ba1948cc7ec7fa586.png#pic_center)
 


**指南文档**

实时跟踪新发布开源许可证，对存量和增量开源许可证进行分类管理，建立不同研发场景的开源许可证准入原则，对不同开源许可证建立黑白灰名单。

法务部门时刻保持对国内外开源软件合规纠纷案例的分析与追踪，紧跟开源软件合规理论发展趋势，捕捉相关政策和司法裁判思路变化，及时调整企业合规治理政策以适应外部变化，对企业技术部门日常落实开源软件合规治理中遇到的疑难问题进行排忧解难，全面护航企业开源软件合规治理工作的不断发展完善。建立完善的合规管理体系，是企业成功运营的重要前提和保障。
 
 

### 统信软件开源治理案例

随着全球开源操作系统蓬勃发展，统信软件认为，当前头部操作系统公司规模呈现出“千百十”的特征，即：

* 千人以上的操作系统开发团队
* 百人以上的内核研发团队
* 十人以上的开源合规律师团队

这意味着，操作系统厂商对于开源治理愈发重视。而在开源治理方面，统信软件先人一步，引入开源合规工具，梳理开源合规流程，在产品立项、研发、发布等各个环节落地开展合规工作，具体包括：

* 在产品立项及研发过程中：遵守规范的第三方代码及依赖引入流程，经过SCA工具及人工审核以保证引入的第三方代码的合规性及与主程序的兼容性；
* 在项目开源工作中：遵守必要的代码通知规范，经过CI门禁及人工审核以保证开源通知的合规性及易读性；根据公司开源策略、项目开源目的及第三方代码/依赖的开源许可证情况综合考虑项目所选用的开源许可证；
* 在产品分发和发布工作中：遵守开源许可证的通知义务，经过人工审核以保证产品的分发材料满足开源许可证要求；
* 建立相应管理制度规范：为规范开源软件迁移流程，统信软件制定了《开源软件迁移控制程序》，确保多个环节协调及顺序工作的完整性，使迁移工作能够提高工作效率；
* 探索开源治理的评估方法与模型：制定了《统信UOS开源合规治理白皮书》，系统总结了统信UOS各版本的开源特性，阐述了主要开源许可证和重点开源项目的开源合规性审查的要点和方法。
 
企业的开源治理，包含了开源安全、开源合规、开源供应链等等，所以企业的开源合规工作也不是孤立的，往往需要与其他工作结合起来。

对于开源合规，主要集中在开源知识产权风险的应对上，如何遵守许可证规定的通知义务和开源义务以避免触发著作权、专利、商标的侵权风险。此外，开源还涉及到域外管辖和出口管制的合规，例如美国出口管制条例EAR和我国的出口管制法规。当前开源许可证众多，每个许可证所规定的义务又各不相同，呈现出复杂多样、互不兼容的特点。这些都需要法务人员进行专业地分析和解读，而最后的合规处理又需要落实到代码和文件，需要由程序员来进行落地操作。

企业开源合规的成效，除了依赖于开源合规管理制度、开源合规工具，员工的开源素质是重点，包括员工对公司开源政策的理解，对重要许可证义务的理解，以及对标准合规处理的掌握。只有不断通过培训提高员工的开源素质，开源合规工作才能事半功倍。

开源合规工作的难点，应该是企业不断增长的合规需求与合规工具有限功能之间的矛盾。开源合规需求很多，包括：软件物料清单、组件识别、篡改识别、代码溯源、依赖检测、许可证兼容性分析等等，各种合规工具在不同需求点上表现不一；当前，由于开源供应链的合规需求上升，对软件物料清单的准确性和完整性又提出了更高的要求。

企业建立适合自身的开源政策最为重要。有的企业只是在企业内部使用开源软件，并不做分发，它要遵守的开源合规义务就很少，主要需要考虑的可能就是开源供应链上游带来的合规风险；有的企业在产品中使用开源软件也做分发，但对自研代码要求闭源，那就要高度关注开源代码和开源组件的选择和使用方式，避免违反copyleft许可证带来的开源义务；有的企业是既使用开源也向外开源，既要避免许可证冲突又要符合开源通知义务。企业必须根据自身战略和定位制订清晰的开源政策，并以其指导开源合规管理办法的制订，以及开源合规管理组织的职责和工作。

**关于开源合规方面的两点建议：**

跟所有其他的企业合规工作一样，开源合规也需要合规成本，可能是人力成本，也有可能是产品延迟发布的时间成本，所以开源合规的开展应以对项目最小影响为目标，科学地设置审核节点和审核内容非常重要。例如：在立项阶段就要求研发经理向合规审核小组提出开源使用请求，包括：项目是否开源、项目拟采用的开源许可证、项目拟采用的组件或第三方库及调用方式等，避免事后因重大合规缺陷导致的返工。还有可以在第一轮全量测试时进行项目代码审计，既能对项目代码进行完整扫描，发现问题又能即时返回研发进行代码修改。

行动起来最重要，不用等到所有资源全部到位，也不用等到各项功能都完全达标的合规工具，开源合规审核最重要的因素还是人。哪怕是简易审核流程，也能将最重要的不合规项发现出来。
 
 
 
 
