## 3.5 智能网联汽车行业研究报告
### 3.5.1智能网联汽车行业发展概况
 
2023年1-12月，我国新能源汽车新车渗透率达到30.8%，纯电动乘用车和插电混动乘用车能耗指标基本达到2025年指标；2023年PA级智能网联汽车销量快速增长，达到800万辆，渗透率达到46.2%，年平均两位数增长，接近2025年50%的目标，进入技术驱动的快速发展期。目前智能驾驶技术的发展正在按照舱泊融合1.0（2023年）、舱泊融合2.0（2024年）、舱驾融合（2024～2025年）、中央电脑（2025年）的技术路线向前发展。随着电子电气架构从分布式向集中化，再到形成真正的车载中央计算机发展，自动驾驶汽车最终会形成多域融合的统一操作系统。统一的智能汽车操作系统能够提供更强大的硬件普适性，大幅降低整车企业在测试、维护上的成本，也能更好地推进车路协同的落地。

 
从软件技术层面，智能网联汽车的整体产业生态还存在很多挑战：
 
* 首先，自动驾驶操作系统内核、基础库、功能软件等核心底层技术方面，当前国内还处于技术架构探索和快速更迭阶段，相对来说差距还比较明显，行业未能在统一架构上推进开发，协同合作不足，存在力量分散和重复造轮子的现象；
* 第二，研发测试工具链目前国内的成熟产品不多，应用方在生产环境还不能做到大规模使用，难以形成市场化良性循环，也导致了研发企业无法获得需求方的原始反馈，技术与应用场景的代沟明显；
* 第三，车规级高性能芯片目前还没有发展起来，从计算芯片指令集、ISP/DDR/DSP等芯片IP，到芯片的设计、工艺还存在一定的差距，需要行业内集合一定的资源，逐步的摸索和解决。
 
汽车的软硬件生态需要从产业角度，整体性的构建。操作系统的底层生态与计算芯片、域控制器的发展分不开，研发和测试工具链的发展与系统集成、测试验证、产品化分不开，高速迭代的应用、好的用户体验与开放的需求和良性的商业环境、政策法规的发展分不开，要解决上面的三个问题，真正意义的进入软件定义汽车的时代，是一个行业性的集体课题。
 
### 3.5.2 汽车软件行业开源现状与典型案例
 
**（1）汽车软件行业开源趋势**

软件定义汽车的时代，车用操作系统是智能网联汽车产业最基本、最重要的基石，直接决定了行业技术基础设施的能力水平。车用操作系统不仅管理着汽车的软硬件资源，芯片软硬件接口，同样管理大量数据资源，辐射带动相关传感器、软件算法、开发工具软件等领域发展；车用操作系统有效带动上游产业发展，是深化软件定义汽车、推动数字技术应用关键的基础设施，是汽车产业链和价值链的中枢。现在车用操作系统以商用闭源操作系统为主，采用黑盒交付方式存在开发局限，难以满足智能网联汽车应用软件的快速迭代需求。
 
预计未来三年将是智能汽车技术产业生态形成的关键期。然而车用操作系统作为一个复杂庞大的软件系统，从研发到应用是一个长期持续的过程，面临开发难度大、周期长、成本高等问题，需要持续投资，软硬件协同，挑战巨大。尤其是处于操作系统最底层的内核研发投入大、周期长，难以实现单独商业价值，单体企业难以承担。以开源共建方式推进车用操作系统的研发与生态构建已成业界共识。 
 
**（2）汽车软件行业开源现状**
 
随着汽车产业数字化转型深入发展，汽车软件扮演的角色愈发重要，加强基础研究，推动操作系统和基础软件国产化发展已成为行业共识。在软件定义汽车的趋势下，汽车行业发展的三个重要趋势之一就是从闭源到开源。开源软件正以指数级增长，为汽车制造商提供了更为灵活、高效的开发环境，同时也推动了汽车技术的创新和进步。
 
操作系统内核属于共性基础技术，共用、共建、共同扶持是基本思路，一种方式是开源进行行业共建，一种方式是共同扶持头部企业进行开发实现共用。开源对于国家和产业来说是一个建立共同基础的重要途径，对于企业来说可以给开发带来更多的灵活度和自由度。
 
内核是车用操作系统的核心，提供系统最基础的功能，保障系统的性能和稳定。从内核开始向上发展，通过对基础服务、系统服务等的持续建设，推动全面开放、社区开源，逐步发展出成熟的车用操作系统，更好的支撑行业生态建设。
 
当前，以百度Apollo自动驾驶开源项目、普华基础软件公司“小满”安全车控操作系统等为代表的开源项目正在快速发展壮大。与此同时，国内汽车软件生态正在不断快速发展中，如开源组织（中汽协、汽车工程学会、OpenSDV汽车开源联盟等）、汽车相关开源公司（如普华基础软件、国科础石、百度等）；典型开源项目（如Apollo、DDS、ROS等）、汽车软件开源组织形态（如极氪汽车、长安、小米等OSPO）等正逐渐形成更强大的开源生态。
 
作为一种汽车行业创新协作模式，开源不仅是开放源代码的软件技术开发，还包括更为广泛的开放技术领域及协同创新的理念与机制。目前汽车行业针对车控操作系统的开源生态建设已形成初步共识，后续有望分步实施、逐步演进：在操作系统产品发展期，开放是首先满足的条件，通过构建标准开放接口以支持更多行业伙伴产品的快速对接，实现更灵活的开发调试。在产品不断成熟期，可以有选择地开源部分代码以加速技术迭代，吸引更多生态伙伴参与开发和维护。产品完全成熟后，适时进行完全开源，形成稳定成熟的开源生态圈。
 
**开源共建至少有四方面优势：**

* 可有效降低车用软件开发成本，节省国外商业操作系统授权费用、工程服务费用；
* 降低车用软件开发入门门槛，保障软件开发可用资源，灵活使用行业可用软件资源、人力资源，提升软件开发效率及质量；
* 高效助力的技术发展与创新，使整车厂可聚焦技术创新及产品差异化竞争力打造。使用安心、可靠的基础软件平台，整车厂可以更加聚焦体现技术创新及产品差异化的上层应用软件，避免行业内卷和垄断；
* 有效提升汽车软件产业能力，形成良好的产业发展生态及人才培养环境。使得懂汽车的人更容易懂软件，培养“既懂汽车又懂软件”的复合型人才。 
 
目前行业已围绕开源进行积极探索，通过聚集行业力量，以更低的成本、更高效的模式共同打造车控操作系统、智能驾驶操作系统。中国汽车工程学会、中国计算机学会与国家智能网联汽车创新中心共建车用操作系统与泛在操作系统联合实验室，研发智能驾驶操作系统开源基线版本；OpenSDV汽车开源联盟已组织长安科技、国科础石、黑芝麻智能、Elektrobit、中科渝创等20余家单位，在该联盟操作系统工作组下发起及推进智能驾驶操作系统发行版项目，同时推进发展汽车实时操作系统、虚拟化、云原生等基础软件开源项目；；中国汽车工业协会、开放原子开源基金会与中电科、普华基础软件等成立汽车软件开源工委会，正在推进车控操作系统、中间件的共同研发。
 
开源共建不代表一哄而上，搞重复建设或者各自为战。开源项目的成败，取决于参与力量是否可以深度协同，打造完善的生态。主机厂更多会以提供工程化应用和验证的场景，基础软件开发领域的经验，科技企业结合工程应用需求，可参与内核核心代码、系统服务、基础服务、操作系统接口的开发工作，提升开源项目的实用性、适用性及通用性。未来，在共建开源操作系统的基础上，发动各方力量参与建立操作系统应用相关工具链、通用系统软件、功能软件、软件生态，社区的开发、建设工作。
 
考虑开源的不止中国企业。更早之前，博世和微软等企业也宣布成立“Eclipse软件定义汽车工作组”，为汽车行业提供开源的汽车软件，将复杂的汽车软件平台构建成一个巨大的生态。
 
2014年，Linux基金会发布了开源的AGL（Automotive Grade Linux，汽车级Linux）规范1.0版本，2018年丰田首次使用了基于AGL的车载信息娱乐系统，大众、戴姆勒、现代、马自达、本田、日产、上汽等主机厂也纷纷支持AGL。用于手机等移动终端的安卓（Android）操作系统是Linux最成功的发行版，由于其生态丰富、可实现用户习惯的无缝衔接，近两年广泛应用于国产自主品牌的信息娱乐系统，例如蔚来（NIOOS）、小鹏（XmartOS）等都是基于Android系统的定制化改造。
 
特斯拉Autopilot采用开源方案对Linux内核进行了实时性改造，分别实现了L2+级自动驾驶。此外，特斯拉CEO马斯克表示特斯拉可能会向其他电动汽车制造商开放部分汽车操作系统源代码，他认为这一做法能够对汽车行业提供帮助，等同于“安卓系统（Android）作为手机行业的通用标准”。产业界有不少开源社区和商业公司在做Linux增强和完善的发行版，以满足智能汽车产品中的部分功能要求（比如AGL的Linux已用于Cluster & IVI功能,RedHat的CentOS Automotive/RHIVOS将用于ADAS功能)。相较于QNX，基于Linux改造而来的操作系统具有两大优势：一是Linux具备开源优势，可灵活地在各种CPU架构上运行，方便内核的切换；二是有丰富的软件库，可支持智驾和座舱功能的操作系统。借此，特斯拉避免从零开始搭建，能通过OTA进行快速修正与升级，不断提升用户体验、构筑竞争壁垒。
 
**（3）汽车领域典型开源项目**
 
**Apollo开放平台**

Apollo开放平台是百度发布的向汽车行业及自动驾驶领域的合作伙伴提供的软件平台，于2017年正式对外开源。2023年12月19日，百度推出了全新升级版Apollo开放平台9.0。该版本在工程、算法和工具等方面实现了全面升级，通用层可赋能多种应用场景的规模化落地，整体操作更加灵活易上手，使用场景通用易拓展。极大提升开发效率的同时，可帮助更多开发者快速搭建属于自己的自动驾驶系统。其首次适配了ARM架构，并支持在orin下的编译和运行，在设备选型上为开发者提供了更为多样化的选择。
 
目前，百度Apollo自动驾驶开放平台已完成11个版本迭代，Apollo开放平台已汇聚了来自全球170多个国家和地区的16万余名开发者，拥有生态合作伙伴210余家，已成长为全球最活跃的自动驾驶开放平台。目前，社区累计发布内容超过1200篇，其中开发者贡献内容60余篇。此外，面向自动驾驶行业开发者的研发产品——Apollo自动驾驶开发套件（Apollo D-KIT），已为100多家高校、科研机构及行业伙伴提供研发支持。作为全球最大自动驾驶开放平台，Apollo拥有生态合作伙伴达210家，几乎囊括全球主流汽车制造商、一级零部件供应商、芯片公司、传感器公司、交通集成商、出行企业等，覆盖从硬件到软件的完整产业链。Apollo开放平台已在园区、矿区、港口、环卫、配送等低速自动驾驶领域得到广泛应用，其相关产品包括无人清扫车、无人快递车、无人售卖车、无人驾驶巴士、无人售货车、无人清扫车等。
 
Apollo开放平台于2023年12月27日正式升级了Apollo EDU高校计划，针对本科层次构建立体化校企合作人才培养解决方案，通过Apollo Studio开发者社区，百度构建了课程、实验、赛事一站式学习实践平台。截至2023年底，Apollo Studio开发者社区在线学习人次超过3.8万，累计覆盖全国开设自动驾驶相关专业类的理工院校超70%，985、211理工类院校覆盖率68%，成为国内自动驾驶在线培训规模最大和最有影响力的社区。
 
**中电科普华基础软件EasyAda“龘”，微内核开源项目**

中国汽车工业协会正式发布中国车用操作系统开源计划中首个微内核开源项目，中电科普华基础软件向行业开源了“龘”（EasyAda）微内核源代码，可实现面向各类芯片平台和应用场景提供安全内核，具有内核微型化、服务模块化、遵循POSIX规范、可靠性高、实时性强、安全性高、可扩展性强等特点。采用木兰公共许可证（第2版），已在开放原子开源基金会代码托管平台AtomGit发布包括初始化代码、核心功能源代码、芯片适配代码等共计122个文件、14883行源代码。
 
**地平线纯视觉自动驾驶Sparse4D算法**

地平线将业内领先的纯视觉自动驾驶算法——Sparse4D系列算法开源，推动行业更多开发者共同参与到端到端自动驾驶、稀疏感知等前沿技术方向的探索中。Sparse4D是迈向长时序稀疏化3D目标检测的系列算法，通过纯稀疏的融合感知框架，让感知算法效率更高、精度更高，让感知系统更简洁。相比稠密BEV算法，Sparse4D降低了计算复杂度，打破了算力对感知范围的限制，在感知效果和推理速度上，实现了对稠密BEV算法的超越。在nuScenes纯视觉3D检测和3D跟踪两个榜单上，Sparse4D均位列第一，成为SOTA，领先于包括SOLOFusion、BEVFormer v2和StreamPETR在内的一众最新方法。

![](https://i-blog.csdnimg.cn/direct/d27741b3c21d43f2abf6e7c9522721cc.jpeg#pic_center)

地平线积极参与智能驾驶开源软件生态建设，此外还开源了基于矢量化场景表征的端到端自动驾驶算法VAD、端到端矢量地图在线构建方法MapTR等领先技术，持续推动行业加速发展。
 
**国科础石础光操作系统 **

国科础石研发的应用于汽车智驾域、座舱域的础光Linux操作系统于2023年2月开源，在2024年初也获得了ASIL-B的相关功能安全认可，至今获得了诸多车企的良好反馈。础光Linux是国科础石在开源Linux基础上，针对汽车行业实时性优化改造的操作系统产品，该操作系统拥有更高的实时性及稳定性，有效增强功能安全性，并支持云原生。基于Linux的良好的软硬件生态，产品对NPU/GPU/Cuda等加速硬件可实现无缝衔接，减少厂商大量的适配和移植时间。 
 
**（4）开源社区及行业机构**

中国汽车工程学会、中国计算机学会与国家智能网联汽车创新中心共建车用操作系统与泛在操作系统联合实验室，研发智能驾驶操作系统开源基线版本，推进产品持续迭代、验证。普华基础软件联合一汽、理想、长安等20余家单位结成开源共建伙伴，探索实施开源计划。
 
OpenSDV汽车开源联盟是于2020年9月在中国科学院软件研究所的牵头发起下，由汽车行业及相关技术领域的企事业单位、社团组织、高等院校、科研院所等参与组成的以推广开源开放促进汽车产业发展的非营利组织。
 
### 3.5.3 汽车软件行业开源的问题、风险和挑战

汽车行业与传统IT行业还是有较大的差异化，汽车非常注重安全合规，并在全球供应链协同下设计、生产和制造，开源对汽车网联安全的影响非常重要。从多次行业的交流来看，业界对于共性需求的底层操作系统、中间件、算法等技术底座，都倾向于”联合开发”，组团、联合等方式存在很多弊端，而开源软件模式则在传统IT行业有了很多的成功案例，采用开源开放的模式，共同解决通用的技术底座问题，是众望所归。
 
在汽车软件行业尤其是对于功能安全要求极高的车控、智能驾驶等环节的底层软件上应用开源模式，与传统基于开源的研发模式是有极大差异的。协同研发的社区基础设施、结合功能安全要求的代码审核机制、验证和仿真的平台，都需要面向汽车行业进行定制。这样才可以促进开源开放模式在汽车行业获得共识，便于开展工作。

此外，在垂直整合过层中利用开源模式，可加快软硬件协同效率，但也面临车企与供应商之间商业利益平衡分配的问题。
 
### 3.5.4发展建议
 
长期来看，基于开源的智能网联汽车解决方案可能成为一种趋势，车企的自研路线将参考开源社区的技术。汽车行业软件基础设施层面会有大量开源方案出现（包括操作系统内核、中间件、框架、算法方案等），随着整车技术占比的提高，研发人员的多样化，车企研发团队也将与开发者社区建立深度连接，会出现开源、开放、协作式的汽车软件开发者社区，通过社区支持客户，沉淀知识，提升支持效率，也将成为一种产业生态建设模式。
 
从长远发展计，希望汽车行业有更有效的社会化组织、能够开源结合开放，同时增强适当的基础设施建设，从而降低开发者参与门槛，加速产业和行业规模化发展，共建的开源开放项目，逐渐会形成一定的事实标准，与众多的顶层标准一起，螺旋式地促进技术的进步与产业发展。