# 第五章 中国开源社区发展现状

当前我们所身处的数字化时代几乎都是由开源代码所构建的，伴随着开源运动在中国的落地与发展，中国的开源社区从最初单一且独立的社区不断演进，呈现出今天百花齐放的繁荣景象。本篇集中呈现当前国内各类社区发展的现状和特点。

## 5.1 中国开源社区的起源与发展历程

十几年前，很多人认为“开源=Linux”，因为当时的Linux操作系统、桌面办公软件（GNOME、OpenOffice）和浏览器（Mozilla）作为开源项目的主战场，掀起了第一波开源的浪潮。随着开源项目规模的不断壮大，开源社区也逐渐形成。

国内的开源社区起初以Linux爱好者为主导，最早出现于1998年。不过，早期国内社区多为个人爱好者兴办，社区的发展规模和影响力有很大的局限性，因此中国第一代社区的持续发展能力不足，大多销声匿迹。如，于1998年在清华大学成立的阿卡社区（AKA），2000年前后发展到顶峰，但此后受骨干成员出国、成家、创业等影响，逐渐进入低潮期，其中部分人员转型嵌入式培训，AKA转变为亚嵌公司。AKA早期的多数成员后来成为了中国最早的一批Linux精英。2001年创立的灰狐动力社区，最初只是一个关于中间件技术研究和应用纯个人网站，到2002年已经成为国内中间件行业极具权威性的站点。但在2010年5月19日，灰狐动力和开源力量宣布合并。创始于2006年12月的哲思社区，在当时是中国知名的自由软件社区，也已于多年前停更。而其中只有少数幸运的优秀社区因得到企业和产业的广泛认可而找到生存模式获得新生，如CSDN逐渐成长为中国最大开发者社区，ChinaUnix社区被IT168公司收购，PHPChina社区被康盛创想公司收购（后期被腾讯整体收购），开源中国社区被恒拓开源公司收购等。
    
后来，随着互联网的兴起，开源的项目和技术呈现百花齐放之盛况，从数据库到中间件、从前端到后端、从编程语言到编译器、从物联网到微服务、从大数据到人工智能，开源的技术和项目越来越丰富和多样化。在此趋势下，自2008年起，中国第二代开源社区纷纷登场。在吸取了一代的教训后，第二代社区的典型特征是更加聚焦、更加务实，通常是围绕一个公司的特定产品，且该公司作为社区的唯一或最大赞助商。这类社区包括深度操作系统社区、Ubuntu麒麟社区、龙芯俱乐部、OpenEuler社区等。这些社区的发起团队普遍具有全球开源视野，同时也认识到知名科技企业在开源生态发展中的核心作用，与企业合作共赢是开源社区发展的关键路径，第二代社区开始有意识地吸纳开源布道者、市场专业人士和法律专业人士成为社区的骨干人员。
    
近几年，随着移动互联网和云计算、AI在中国的蓬勃发展，中国开始涌现出大量开源项目的开发者，国内开源社区进入第三代。典型代表包括开放原子开源基金会、开源中国社区、木兰开源社区、GitCode、确实（Trustie）开源社区、OpenI启智开源社区等。第三代社区的典型特征是在社区运营和管理上更加中立和平衡，且社区内包含不同来源的众多开源项目。目前中国第三代开源社区仍处于起步阶段，在开源治理、社区运营等方面尚显稚嫩。能够坚持中立立场、平衡诸多赞助商之间以及与开发者之间的关系，吸引开源治理专家、培养社区运营骨干是第三代社区当前面对的主要挑战。
    
中国第一代技术社区至今仍坚持运营的屈指可数，最成功的典范就是CSDN开发者社区，作为目前世界第二大的开发者社区，20多年来CSDN为中国培养了几代开源开发者，同时也见证了中国开源快速发展的20年。2022年4月，CSDN成为开放原子开源基金会黄金捐赠人。也通过扩大对开发者服务内容（开源知识库、培训、猎头、代码托管平台、开源项目孵化和开源创投），身体力行地推进开源产业的发展，正在积极地向第三代开源社区转型。

由企业主导的第二代社区正在积极的与第三代社区（含国际开源社区和开源基金会）合作，通过开源捐赠或发起新项目等多种形式融入第三代社区，如华为将欧拉开源操作系统（openEuler, 简称“欧拉”）捐赠给开放原子开源基金会，携程捐赠Apollo项目到Apollo开源社区，百度捐赠HugeGraph图数据库给Apache软件基金会，华为将开源的云原生多云容器编排项目Karmada捐赠给CNCF等。

## 5.2 中国开源社区的现状特征

据中国开源软件联盟不完全统计，截止2023年6月，国内各类开源社区已经超过500个，按照项目型社区、本地化社区、开发者社区和代码托管社区四类进行汇总，项目型社区增速最为显著。

从开发者规模和开发者合作参与层次上，部分开源社区已经发展到非常大的规模，在社区生态上取得了显著的成绩。

### 5.2.1 项目型社区

欧拉，龙蜥，OpenCloudOS，OpenKylin，深度社区。

### 5.2.2 用户型社区

LinuxFans、Ceph中国社区、GoCN社区、Python中国社区、物联网自动化社区iot.cechina、Linux人社区、K8S中文社区

### 5.2.3 开发者社区

#### CSDN

官网：https://www.csdn.net/

简介：CSDN（中国开发者网络）创立于1999年，是全球知名中文开发者网站。秉承成就一亿技术人的使命，为IT技术人成长及科技企业发展，提供开发者生态的全方位服务。CSDN在社区基础上，通过知识云、人才云、开发云三大服务，赋能开发者、研发团队及科技企业在IT知识学习、人才招聘、研发效能与协同管理等方面的高速成长与发展。

#### 开源社

官网：https://kaiyuanshe.cn/

简介：开源社成立于 2014 年，是由志愿贡献于开源事业的个人成员，依 “贡献、共识、共治” 原则所组成，始终维持厂商中立、公益、非营利的特点，是最早以 “开源治理、国际接轨、社区发展、项目孵化” 为使命的开源社区联合体。开源社积极与支持开源的社区、企业以及政府相关单位紧密合作，以 “立足中国、贡献全球” 为愿景，旨在共创健康可持续发展的开源生态，推动中国开源社区成为全球开源体系的积极参与及贡献者。2017 年，开源社转型为完全由个人成员组成，参照 ASF 等国际顶级开源基金会的治理模式运作。近九年来，链接了数万名开源人，集聚了上千名社区成员及志愿者、海内外数百位讲师，合作了数百家赞助、媒体、社区伙伴。

#### 木兰开源社区

官网：https://portal.mulanos.cn/

简介：“木兰开源社区”建立于2019年8月，是国家重点研发计划重点专项“云计算和大数据开源社区生态系统”的核心成果。旨在促进产学研用各方开源领域的交流，推动国家科技创新成果开源，加强企业、科教研单位和行业用户之间的沟通，推动开源成果转化落地，同时为各类开源项目提供中立托管，保证开源项目的持续发展不受第三方影响，通过更加开放的方式来打造和完善开源社区生态。

#### 可信开源社区

官网：http://caicttrustedopensource.org.cn/

简介：可信开源社区共同体（TWOS）由众多开源项目和开源社区组成，目的是引导建立健康可信且可持续发展的开源项目和开源社区。可信开源社区共同体（TWOS）旨在搭建交流平台，提供全套的开源风险监测与生态监测服务。

#### SegmentFault 思否 

官网：https://segmentfault.com/

简介：SegmentFault 思否 (segmentfault.com) 是中国领先的新一代技术问答社区，也是中国最大的黑客马拉松（Hackathon）组织者。我们为中文开发者提供一个纯粹、高质量的技术交流平台以及前沿的技术行业动态。目前已经覆盖和服务了超过 1000 万开发者和 IT 信息从业者，帮助开发者解决了数百万个技术问题。

#### 开源中国

官网：https://www.oschina.net/

简介：OSCHINA（Open Source China，OSC）成立于 2008 年 8 月，目前已建立了相当完善的开源软件分类数据库，收录全球知名开源项目近 5 万款，涉及几百个不同的分类。围绕这些开源项目，OSCHINA 为中国开发者提供了最新开源资讯、软件更新资讯、技术分享和交流的技术平台。2013 年，OSCHINA 建立了代码托管与 DevOps 平台“码云 Gitee”，为广大开发者提供团队协作、源码托管、代码质量分析、代码评审、测试、CI/CD 与代码演示等功能。经过在开源领域超过十年的深耕，以及与中国本土开源环境的结合，推动了中国开源领域的快速发展。OSCHINA 目前已发展成为国内知名的开源技术社区，社区有 600 万开发者活跃，长期致力于推动国内开源软件的应用和发展，提升本土开源能力，以及为开源生态环境的优化提供支持。

#### 稀土掘金

官网：https://juejin.cn/

简介：稀土掘金是一款面向全球中文开发者的技术社区，是基于数据挖掘技术的个性化推荐引擎产品。它为每一位热爱技术的人提供有价值、成体系的技术内容，并搭建了一个聚焦开发者、温暖有爱、快速迭代、激励成长的垂类内容社区。掘金打通了技术内容、技术人才与技术服务企业的路径，未来将持续为开发者生态提供知识输出、技术交流、产业合作等全维度的支持。

#### infoQ

官网：https://www.infoq.cn/

简介： InfoQ 是一家全球性社区网站，基于实践者驱动的社区模式建立。软件正在改变世界。促进软件开发及相关领域知识与创新的传播是我们的使命。为此，我们致力于提供中立的、由技术实践者主导的会议以及文章、视频演讲和采访等资讯服务，面向 5 至 8 年工作经验的研发团队领导者、CTO、架构师、项目经理、工程总监和高级软件开发者等中高端技术人群，提供中立的、由技术实践主导的技术资讯及技术会议，搭建连接中国技术高端社区与国际主流技术社区的桥梁。

#### 开源雨林

官网：https://www.osrainforest.org/

简介：开源雨林是由华为技术有限公司和开放原子开源基金会、中国软件行业协会、中国科学院软件研究所、中国信息通信研究院、开源社等组织共同发起，围绕开源通识、开源治理和开源使用实践等方向构建一个用于收集、分享开源知识分享社区的经验。

#### 腾源会

官网：https://cloud.tencent.com/act/pro/weopen-home

简介：腾源会是腾讯云成立的汇聚开源项目、开源爱好者、开源领导者的开放社区，致力于帮助开源项目健康成长、开源爱好者能交流协助、开源领导者能发挥领袖价值，让全球开源生态变得更加繁荣。

### 5.2.4 服务型社区-耿航

GitCode，Gitee，Gitea，Gitlink，Coding

代码托管社区平台是指具备开源代码、项目孵化、开源治理、媒体等多种服务功能的社区，其他垂直小众社区也在该社区平台构建自己的影响力。具有代表性的服务型社区如下。

#### GitCode

官网：https://gitcode.net

简介：GitCode是专业开发者社区CSDN推出的开源项目协作管理平台，Gitcode提供了开源代码托管、开源教学、开发云、开源百科等服务，通过打造符合中文开发者使用习惯的开源项目协作产品，推动国内开发者学习开源、参与开源、贡献开源，助力中国开源产业生态的创新与繁荣。GitCode拥有CSDN 3500万的开发者用户基础，具有海量的开源文档资源库，是国内开源开发者用户量、互动量极高的社区。同时，Gitcode通过MyGitHub功能，支持社区内的开源软件、开源开发者与国际开源社区联动。GitCode定期组织开源技术沙龙、主题会议、中国开源发展蓝皮书等，普及开源技术，弘扬开源文化。

#### Gitee

官网：https://gitee.com

简介：Gitee是OSCHINA推出的代码托管协作开发平台，支持Git和SVN，提供免费的私有仓库托管。2021年Gitee新增用户数超过了180万，达到800万。新增活跃的仓库数超过了200万，自2019年开始保持着大幅增长的趋势。

#### 鹏城汇智

官网：https://www.ihub.org.cn

简介：鹏城汇智平台是由鹏城实验室建立并运营的完全公益性的开源代码托管平台，主要聚焦于人工智能及RISC-V领域，旨在服务广大开发者及科研工作者群体，建设一个具有专业的代码托管功能、稳定易用的开源平台，展示国内外优质的开源项目，促进我国开源及人工智能领域的发展。

#### GitLink

官网：https://www.gitlink.org.cn

简介：GitLink（确实开源）是CCF官方指定的开源创新服务平台，截至目前，已有5万开发者、1000+组织入驻，仓库数量累计140万。它为我国创新型软件产业发展提供了关键技术支撑和实践指南，支持了我国航空、航天、国防等多个关键领域的可信软件生产，为包括新一代人工智能启智社区、ARM绿色计算社区、云计算与大数据木兰社区、科技委可控开源创造行动红山社区等的建设提供关键技术支撑，为我国关键领域开源社区生态建设发挥了重要作用。

#### Coding

官网：https://coding.net

简介：Coding是深圳市腾云扣钉科技有限公司推出的产品，其重点面向团队和企业的代码协作开发服务。Coding的项目管理包含任务、讨论、文件等功能，支持多成员协作，并且深度集成了代码仓库的操作与状态。

#### 红山开源社区

官网：https://www.osredm.com/

简介：红山开源社区是由北京大数据先进技术研究院主导的非营利综合性在线科研协同创新平台。平台以国家重大战略科技需求为牵引，秉持“群智共享、开源开放、协同创新、择优孵化”的发展理念，重点依托开源攻关、创客行动、开放竞赛三种典型创新组织模式，通过广泛汇聚互联网群智资源，为战略科技领域技术创新突破、成果遴选转化提供全面支撑，旨在加快催生“开放、汇聚、协同、众创”的开源新生态。

红山开源社区重点聚焦战略科技领域的开源项目培育孵化，托管了一批优秀开源项目，重点方向包括关键基础软硬件、人工智能框架、科学计算及仿真软件等。其中在科学计算与仿真软件方面，主要托管培育了风雷软件、IDRLnet飞行器设计框架、openMatrix等明星开源项目。风雷软件是面向流体工程的开源混合CFD软件；IDRLnet开源飞行器设计框架是在传统CFD数值仿真基础上，内嵌物理知识神经网络的微分方程智能求解框架；OpenMatrix是由国防科大龚春叶团队研发的矩阵计算软件，旨在开发构建一款开源的适用于数值计算和科学工程计算的高级语言交互式环境，为计算流体力学、电磁学、气候气象等数值计算领域的设计建模与专业分析提供数值计算服务。

## 5.3 中国开源社区发展的挑战和趋势

### 5.3.1 开源社区发展的现状

开源社区是开源发展过程中非常重要的一环，其能够将开源项目和开发者连接起来，通过打造良好的开发者环境，让开发者参与到开源项目的发展中，诸如引导开发者使用开源项目，并反馈在使用过程中遇到的问题；指导开发者进行文档、代码级别的贡献。开发者的积极参与能够推动开源项目的快速发展，构建起强大的生态，因此开源社区也是很多开源项目、企业/组织投入精力进行建设的领域。

伴随着近些年开源在国内的火热，国内开源社区取得了一定的发展。从社区的类型、数量、运营方式等方面都有所反映。

#### 开源社区的类型

国内的开源社区目前大体分为以下几类：

**以开源项目为支撑，开源企业为背书的社区**

随着开源热潮在国内的蔓延，加上政策的支持，近些年国内涌现出了大量的开源项目。而且大部分开源项目都聚焦在基础软件领域，比如操作系统层面的鸿蒙和欧拉，中间件层面的 TiDB、Apache Pulsar，应用交付层面的极狐GitLab、KubeSphere 等。其中有些项目捐赠给了基金会，比如开放原子基金会、CNCF（根据 CNCF 统计，目前有大约 25% 的开源项目由中国企业主导并捐赠）、LFAI & DATA 等。这些项目背后都有对应的社区，也有对应的企业做支撑。

这类社区的共同点是，希望通过社区运营的一些手段，聚集更多的开发者，和开发者一起将项目打造成顶级开源项目。

**以热门技术为重点，众多爱好者为支撑的社区**

这类社区不以具体公司为背书，主要由来自各个领域的开发者组成，主要目的是推广某些最新的技术和理念。典型的如 DevOps 社区、云原生社区等。这类社区的共同点是核心组织成员往往是比较早接触这一类技术和理念的人员，具有很高的热情，而且在这一领域通过一定的积累，具备了一定的声望。前期依靠自身努力做推广工作，陆续聚集了一批志同道合的爱好者，最后逐渐演变为社区。

**以行业诉求为目的，众多企业参与的社区**

这类社区是想通过众多企业的参与，来打造一个中立的组织，大家协同达成行业的某些共识，比如 Open Island 社区。

#### 开源社区的运营现状

目前各类开源社区，都会通过一些运营手段来推广开源项目、建设开发者生态，而且以企业为背书的开源社区还有全职的运营人员。目前可见的运营手段有：

**举办活动**
这是最常见的一类运营手段。通过活动来搭建与开发者直接交流的平台，能够让开发者了解开源项目的最新发展、最佳实践，同时也能够吸引到一些对此开源项目感兴趣的开发者或企业，参与到开源项目的具体研发中，通过代码贡献来推动开源项目的发展。

活动分为纯线下、纯线上或者线下线上相互结合这几类。这类活动主要是围绕某一个特定主题进行话题分享，以讲师分享、观众聆听为主。比较常见的如 Meetup、Days 或者 Summit 等。时间可能是半天、一天或者数天，参与人员从几十到成百上千。

**内容共创**

通过文章征集的方式来吸引开发者撰写与对应开源项目有关的文章。文章大多聚焦在开源项目的具体使用或与其他产品的集成方面。开发者撰写的文章往往与实际场景使用有关，对于开源项目来讲能够扩大使用场景，帮助到更多的开发者。

比如极狐GitLab 101 活动，就是一个较长周期的与开发者内容共创的活动。

**工作坊**

工作坊强调的是动手实践。目的是希望参与者能够通过亲自动手实践来对于项目功能有一个更加深刻的认知。对于此类活动活动组织者往往会提前设定工作坊的主题、流程，参与者需要根据提前设定的流程，动手完成整个实践。相比于主题分享（讲师讲、观众听），工作坊的受众更加聚焦，基本是对于项目更感兴趣或者已经再用的开发者，当然这种活动对于参会者的要求比较高，参会者需要具备一定的技能。

**黑客松**

黑客松是一种难度非常大的活动。通常是围绕给定的主题范围，在规定的时间内（通常可能是 72h），参与者需要通过编码来打造一款可运行的产品。这类活动对于参会者的技能要求是顶级的，不仅需要参会者熟悉与设定主题相关的领域，此外还需要具备一定的编码技能，因此此类活动往往是团队作战，多人组成一个团队，通过分工、协作，在参赛时间内完成作品。

黑客松活动的产出有可能是一款真实可运行的产品，后续可以继续孵化打磨，成为优秀的产品。

#### 开源社区面临的挑战

目前，大多数开源社区都配备专职的运营人员，通过一些运营手段，来维护和开发者的关系。但是运营充满挑战。具体表现为：

**社区地位尴尬，并未得到重视**

按照 Community Over Code 的理念，社区在开源项目的发展中起着至关重要的作用。但是目前看，国内的开源社区在公司内部的位置略显尴尬。社区通常隶属于市场部，用市场部的惯常思维进行管理。仅仅将社区作为一个对外发声的通道，通过组织一些常规活动来向外展示项目相关的内容，属于“单向输出”，很难让开发者在社区找到归属感，并且参与建设。

**主要聚焦国内，并未走向国际**

目前国内的开源社区主要聚焦在国内发展，围绕国内开发者进行项目推进与生态建设，并没有发展成为连接全球开发者的桥梁。项目的文档是中文，没有英文版本，项目的 Issue、PR 也都以中文为主，和开发者沟通的渠道是微信群，不是 Slack 等。这些手段无法让国外开发者了解、熟悉开源项目，进一步阻碍了开源项目的全球化。

**将开发者社区作为商业获客手段**

以传统运营模式、运营思维进行社区的运营。将开发者当作潜在客户，将开发者活动当作商业获客的一种方式，以获客为导向来设置活动举办城市、活动主题、讲师邀请等，活动中容易演变为客户站台、自身产品的推介会。此外，还存在过分收集参会者的个人信息的现象，通过这些信息描述潜在客户信息，并且通过电话、邮件方式进行产品营销。

**运营手段雷同，难以破圈**

绝大多数运营手段都以活动举办、内容共创为主。而且活动基本围绕北上广深杭等一线、新一线城市展开。每个社区的运营方式都很类似，并没有特别亮眼的模式来进一步吸引开发者参与。

**存在不合理的 KPI 设置**

以 KPI 的方式衡量运营的成果，这就导致了极容易设置一些不合理的 KPI，比如在发起一些活动时，会要求参与者在 GitHub 上对既定项目进行 Star、Fork 等操作，甚至通过发送项目周边或者其他小礼物的方式来引诱参会者进行 Issue 的创建等，进而造成一种开源项目繁荣发展的假象。

**口号大，行动少**

社区运营的口号大多围绕“开源共建”，期望通过开发者的参与（代码贡献、文档贡献等）来共同打造开源项目，但是却缺少对应的流程，诸如完整的贡献指导文档，帮助开发者了解贡献的路径；详细的项目文档，帮助开发者更深入的了解项目。流程的缺失让开发者参与的门槛大大提高，共建变成了难以落地的口号。

**开源专业运营人才的缺失**

开源专业运营人员，除了需要具备运营能力（活动策划、组织），更重要的需要对于开源、开发者、项目本身、行业发展都有较为深刻的认识，既能够和开发者有共同语言，理解开发者的话术，又能够围绕项目本身的特点、发展方向策划合适的活动，来让开发者和项目在“双向奔赴”中达到双赢局面。目前看，这类型的人才是极度缺乏的。
