# 第五章 开源组织及开源生态发展现状

开源生态是指由开源组织和整个产业界互动形成的、广泛联系的合作平台。中国开源正从早期的使用者、跟随者、参与者，逐渐变成影响者、创作者和贡献者，开始涌现出越来越多的开源开发者、开源项目、开源组织和开源企业，开源生态逐渐完善。中国作为开源生态发展最具活力和潜力的国家之一，开源组织的数量和质量不断提升，开源软件的使用者和贡献者数量持续增长，国家支持开源发展的政策力度不断加大，中国的开源产业链也在不断完善。越来越多的企业意识到开源技术的重要性，积极参与到开源社区中，贡献代码、资源和经验，推动开源生态的发展。中国开源生态的蓬勃发展，不仅对于中国的技术创新和产业发展具有重要意义，对于全球的开源生态同样产生了积极的影响。

## 5.1 发展现状

开源组织是开源生态中的重要组成部分，包含开源基金会、综合型产业联盟、专业型开源组织、地区型开源组织、开源推广型社会组织等几大类型。

从全球范围来看，知名的开源组织都具备透明公开、自组织化、社区驱动、开放合作、社会价值等共性特点，同时具有各自的鲜明特征。例如发起了“自由软件运动”的自由软件基金会（FSF）、定义了何为“开源”的OSI组织、维护Linux内核生态的Linux基金会、孕育了Kubernetes等明星项目的云原生领域的CNCF基金会、孵化了Apache应用服务器的Apache软件基金会等。这些成功的基金会和开源组织，几乎毫无例外地都搭建起开放、中立的舞台，让社区领袖带领开发者，通过经年累月的努力与奋斗，掀起技术的浪潮与变革。

随着中国开源软件的快速发展，国内涌现出越来越多的开源组织，积极地为完善中国开源生态做出贡献。例如在国际上颇具影响力的中国开源软件推进联盟（COPU），倡导发展开源芯片的中国开放指令生态（RISC-V）联盟和中国RISC-V产业联盟，关注开源人工智能等的新一代人工智能产业技术创新战略联盟，聚焦工业4.0的开源工业互联网联盟，着力于云计算产业的中国开源云联盟、云计算开源产业联盟等，都彰显了中国开源生态蓬勃发展的生命力。当前在国内也涌现出一批开源推广型社区组织，如开源社、开源中国社区以及ALC（Apache Local Community）北京/深圳等，这些以开源爱好者和志愿者为主体的推广组织，对推动国内的开源知识普及、开源文化推广有巨大的积极意义。国内开源组织的发展，经历了借鉴、发展、创新的全历程，下面是我国的一些重点开源组织。

### 5.1.1 开源基金会

开源基金会是开源组织的重要部分。对于非营利性且处于中立位置的开源基金会来说，他们拥有开源项目的商标权，以及与代码相关知识产权的授权，与商业公司没有任何商业利益冲突，这为贡献者、开发者以及用户提供了良好的协作平台。基金会也会通过技术服务和项目孵化来帮助开发者和开源企业，如软件仓库（一般基于第三方平台）、问题跟踪技术指导、法律支持、项目投资、公共关系维护等，部分基金会还会提供一些公共的平台能力，以辅助项目日常的运营和治理，并满足项目在不同生命周期阶段对于开放治理的需求。目前国际上已有几十家专业的开源基金会在全球的开源生态中发挥着巨大作用，如1985年建立的自由软件基金会（FSF）、1999年创建的Apache软件基金会、2000年成立的Linux基金会以及2004年成立的Eclipse基金会等。

#### 开放原子基金会

2020年6月12日我国首家开源基金会——开放原子开源基金会经国务院批准，在民政部正式登记注册，业务主管单位是工业和信息化部。开放原子开源基金会第一批成员包括华为、阿里、腾讯、百度、360、浪潮、招商银行等十余家骨干企业，作为国内首家致力于开源产业公益事业的非营利性独立法人机构，开放原子开源基金会遵循开源发展理念，秉持“繁荣开源事业、共享开源价值”的愿景，遵循“以开发者为本的开源项目孵化平台、科技公益性服务机构”的定位，以打造科技创新共同体、孵化明星开源项目、构筑技术竞争优势、培育新兴产业生态、助力新一代信息技术和产业发展为目标，发挥开源项目的孵化器、连接器、倍增器的作用，达成提升我国对全球的开源贡献的使命。

开放原子开源基金会专注于开源软件的推广传播、法务协助、资金支持、技术支撑及开放治理等公益性事业；促进、保护、推广开源软件的发展与应用；以开放、共享、共建、共治为原则，坚持开源项目自治，致力于推进开源生态繁荣和可持续发展。自成立以来，开放原子开源基金会构建了开放共享、共建共治的开源服务机制，在募集资金、项目孵化、生态拓展、国际合作、开源法务与知识产权等方面取得积极进展。开放原子开源基金会的成立是一次创新实践，也是中国开源生态建设的重要里程碑。

开放原子开源基金会现有捐赠单位共47家（部分企业要求不露出），其中白金捐赠人16家，黄金捐赠人13家，白银捐赠人18家，与本基金会达成战略合作的开源贡献人6家。

![白金捐赠人](https://img-blog.csdnimg.cn/f6da3d5abd2645aebbe4fde80e9c44c7.png#pic_center)

![黄金捐赠人](https://img-blog.csdnimg.cn/730c318aaf574a82b76facec1b749509.png#pic_center)

![白银捐赠人](https://img-blog.csdnimg.cn/54fb5b8d93764acca7a2a1350e63fefb.png#pic_center)

![开源贡献人](https://img-blog.csdnimg.cn/c3a61bb2811a4ff289b4f7cc139da2a0.png#pic_center)

开放原子开源基金会通过明星项目牵引，大中小协同发展模式，推动开源项目运营治理。当前有30个开源项目通过技术监督委员会（TOC）的技术准入，其中有10个项目正式进入孵化流程，包括OpenHarmony、openEuler、XuperCore（待更名）、Pika（待更名）、TencentOS Tiny（待更名）、AliOS Things（待更名）、hapjs、OpenBlock（待更名）、铜锁/Tongsuo、开源大师兄（待更名），覆盖操作系统、云原生、数据库、区块链、物联网、密码学、低代码等重点领域。其中OpenHarmony、openEuler两个重点开源项目在业界形成较大影响力，累计数亿人次、数百万用户企业通过网络免费获取、使用项目的公开源代码并协同开发，节约了大量研发成本和社会交易成本。

OpenHarmony开源项目已发布OpenHarmony 3.2版本，支持手机、平板、大屏等复杂带屏设备应用开发。项目代码仓库超过400个，代码行数超过1亿行，下载量突破1.3亿，已有5100+位代码贡献者，活跃度指数在我国最大代码托管平台上位列第一，累计已有90个厂家的242款产品基于代码进行创新并通过兼容性测评。项目凭借其在开源领域所做出的突出贡献、技术特性、社区影响力，受到业内广泛关注和认可，获得2022东北亚优秀开源项目、InfoQ 2022年度十大开源新锐项目、CSDN年度开发者社区、51CTO 卓越影响力技术团队等奖项。

OopenEuler开源项目当前已发布2个长周期版本、5个创新版本，下载量已突破100万，代码仓库9571个，代码行数约10亿行，软件包3.1万个，社区贡献者已发展至1.3+万名，建立了近百个SIG工作组，新增360+名开发者加入社区参与贡献，社区用户超过109万，企业伙伴超过750家，基于该项目的软件产品的市场占有率位居前列。

开放原子开源基金会联合阿里、CSDN共同研发自主、先进、中立的代码托管平台——AtomGit，目前已经完成了基础研发工作，基本实现代码托管平台基础通用功能。

开放原子开源基金打造了开放原子全球开源峰会，开发者大会、技术沙龙等品牌活动，汇聚全球顶级开源专家，推动开源理念和开源文化的广泛传播。

开放原子开源基金会推动“校源行”公益项目落地生效，推出了开源导师培养计划和校源行“1+4+X”课程体系，招募224名开源大使，对十数所重要学校进行资助。启动开放原子开源大赛，打造开源领域国际知名赛事平台。积极开展“源译识”开源翻译项目、“源规律”开源公益课程项目、“心寄源”开源法律沙龙项目三个开源法律公益项目。为广大公众和从业者提供国际主流开源许可证协议的可信中文译本，录制开源公益课程、探讨开源法律专业内容，推广开源合规知识。

开放原子开源基金会一方面组建开源安全委员会，制订委员会章程、运营机制及发展规划，明确开源软件漏洞发现和修复、SBOM分析等重点工作计划，目前已经有26家单位加入；另一方面持续完善TOC管理制度，完成TOC换届工作，优化项目捐赠流程和毕业流程。铜锁、MiniBlink、开源大师兄等15个基金会项目通过TOC投票，进入孵化。指导OpenHarmony、openEuler申请成为项目群，逐步走向社区开放治理。

![开源安全委员会](https://img-blog.csdnimg.cn/e83118c0f8be4401b0aca7f5cf447a6e.png#pic_center)
 
<center>开源安全委员会</center>

开放原子开源基金会面临困难及应对措施：

**一是业务工作开展有待加强。** 受多方因素影响的影响，当前发展捐赠单位难度变大。需积极研究应对举措，推进业务工作展开。一方面，推动基金会出海计划，吸引海外项目和资金捐赠，吸引海外开发者为中国开源事业发展做贡献。另一方面，面向重点产业集聚区布局分支机构，引导开源项目和区域产业优势融合。实现国内国际双轮驱动，地方发展布局和海外拓展战略同步推进。最后，政府层面应组织召开以开源生态构建为主题的企业座谈会，加大企业对开源的重视，加深对基金会的了解，加强对捐赠意义的认识。支持基金会与各部委，行业协会，产业联盟进行对接。

**二是资金来源较为单一。** 目前，基金会资金主要来源于发起人和捐赠人的捐赠款项，仅依靠少数捐赠人的社会责任感或开源情怀并不能够维持基金会的长远发展。基金会将积极推进开源项目产业服务中心、开源项目协同孵化中心等业务侧建设，提升自我造血能力，增强自我发展中的自主性。

**三是宣传影响有待扩大。** 立足于开源领域国际交流平台，基金会宣传影响有待扩大。一方面，亟须完善品牌管理制度，加强对基金会内部、项目侧、合作伙伴侧的品牌管理沟通。另一方面，完善基金会传播矩阵和新媒体运营架构，提升品牌传播策划能力，加强基金会品牌宣传。持续扩大基金会影响力，让全球听见中国开源声音。

**四是符合我国国情的基金会发展模式有待探索。** 开放原子开源基金会是国内首家开源基金会，承载了不同于其他公益基金会的使命，其发展模式有待进一步加强调研、讨论和协同，齐心协力探索国内开源基金会可行的、专业化的解决方案。

**五是开源发展政策有待健全和落实。开源发展的体系化政策尚不完善，应推动制定、实施国有企业进行资金和项目捐赠的合法性、可行性、有益性的相关政策文件；制定、实施系列鼓励政策，推动开源软件在重点行业领域的广泛应用；提高地方政府对开源的认知，为开源项目在地方落地和生态建设创造有利条件。**

**六是专业开源人才落实难。** 开源基金会的发展离不开专业开源人才的支撑，互联网、开源等领域风头正热，高级研发人员以及高级项目运营人员均难招聘，导致新员工在开源项目运营和技术研发方面的经验稍显欠缺。开放原子开源基金会将大范围推广开放原子校源行，设立开源社团、开源课堂和开源人才资助计划。继续推进全球开源大赛，围绕核心技术等多方向，聚焦国内外重要开源项目设计赛题赛道，开展赛事运营相关工作。政府部门应在开源人才政策支持上给予倾斜，在人才引进与落户、居住证办理、公租房保障等方面提供大力支持。

#### 重庆天工开物开源基金会（田广礼）

### 5.1.2 综合新产业联盟

#### 中国开源软件推进联盟

2004年7月22日成立于北京的中国开源软件推进联盟（China OSS Promotion Union，COPU）由致力于开源软件文化、技术、产业、教学、应用支撑的企业、社区、客户、 大专院校、科研院所、行业协会、支撑机构等组织自愿组成的、民主议事的民间行业联合体，非独立社团法人组织。中国开源软件推进联盟的宗旨是为推动中国开源软件（Linux/OSS）的发展和应用而努力；为促进中国与全球关于开源运动（Linux/OSS）的沟通、交流与合作而努力；为促进全球开源运动（Linux/OSS）做出贡献而努力。截止目前，已经连续主办了17届“开源中国开源世界高峰论坛”和16届“中日韩三国IT局长OSS会议暨东北亚开源软件推进论坛”，成为最具国际影响力的中国开源组织之一。

#### CCF开源发展委员会

2021年12月17日，CCF开源发展委员会正式成立，旨在推动探索学术共同体主导的开源发展新途径，构建产学研项目成果共享孵化机制，加速产教研深度融合的开源生态建设。CCF开源发展委员会将重点聚焦共同打造开源、开放、中立的产学研协同开源创新服务平台，探索建立CCF开源项目孵化机制，培育原始开源创新项目，依托CCF联接科教资源、产业资源和社会资源等，形成产教研联动的开源创新模式，推动CCF开源品牌建设和开源社区运营，为CCF会员乃至全球开源创新实践者提供高水平的开源创新服务，助力我国开源生态建设的发展。CCF开源发展委员会在2022年承办了第一届CCF中国开源大会。

#### “科创中国”开源创新联合体

2021年1月18日“科创中国”联合体在北京成立，由中国科协科学技术传播中心、中国电子学会、腾讯、百度、麒麟软件、CSDN等36家单位共同发起。联合体以打造自主开源生态为宗旨，以建设产学研深度融合的开源创新体系为目标，以营造中国开源文化、提升开源创新能力为导向，广泛联系开源领域政、产、学、研、金、介、用、媒等各类创新主体，汇聚开源创新资源，发展自主开源基金，建设开源实验室、开源社区、开源创新示范基地等新型融合机构，拓展国际科技创新合作，建设“共商、共建、共享、共生、共赢”的科技共同体。截至2022年5月，“科创中国”开源创新联合体理事单位共有37家。

### 5.1.3 专业型开源组织

#### 新一代人工智能产业技术创新战略联盟

2017年7月23日，为配合新一代人工智能发展规划，支撑人工智能产业技术创新，营造健康有序、充满活力的人工智能应用生态，由北京大学、中关村视听产业技术创新联盟等联合倡议，在科技部试点联盟--数字音视频编解码（AVS）产业技术创新战略联盟的基础上，正式成立新一代人工智能产业技术创新战略联盟。发起成员单位包括百度、阿里巴巴、腾讯、华为、中兴、京东集团、传化集团、科大讯飞等知名企业，北京大学、清华大学、浙江大学、北京航空航天大学等著名高校科研院所及深行资本、将门投资等投资机构。

#### 绿色计算产业联盟

2016年4月，在工信部指导下，由华为、Arm、联想、戴尔（Dell）以及中科院计算所、北京大学、北航、电子标准院等17家国内外知名企事业单位，共同发起组建成立了绿色计算产业联盟。绿色计算产业联盟，英文名称为“Green Computing Consortium”，简称“GCC”。目前，GCC已有单位会员135家。愿景是顺应软件开源与硬件开放的信息技术发展趋势，汇聚全球产业链优势资源，以ARM计算芯片等开放技术为基础， 为最终企业用户提供更容易使用和管理的绿色节能产品。

#### 工业技术软件化开源社区

工业技术软件化开源社区是由国科开源工业互联网科创中心（湖北）有限公司建设的目前国内最大的工业技术软件化开源社区，是集企业和开发者开放交流服务、产学研创新服务、智能制造专家咨询服务、制造企业与软件企业对接服务、开源许可协议与知识产权保护服务于一体的开源技术平台。致力于提高国内工业互联网技术的自主创新能力，为国内工业互联网技术开源能力的提高和开源生态环境的优化提供长期推进的平台。

#### 云计算开源产业联盟

2016年3月9日，由工业和信息化部信息化和软件服务业司指导，中国信息通信研究院联合多家云计算开源技术公司发起，中国通信标准化协会代管的云计算开源产业联盟（OSCAR）在京成立。云计算开源产业联盟是业界首个专注于云计算市场的开源产业联盟，旨在推进OpenStack等开源技术在中国的产业化进程，加速中国云计算产业的创新发展。

#### 中国开源云联盟

中国开源云联盟（COSCL）成立于2012年8月，在工业和信息化部信息化和软件服务业司指导下，挂靠在中国电子技术标准化研究院，现有180余家开源生态圈产、学、研、用成员单位。中国开源云联盟（COSCL）作为国家重点研发计划《云计算和大数据开源社区生态系统》项目的指定开源组织，致力于联合国内开源产业界相关方，在中国共同推动开源生态系统搭建、技术社区建设、开源项目培育、开源团体标准研制、开源技术推广应用、以及开源人才培养等工作，是国内主流活跃的开源技术组织之一。

#### 中国人工智能开源软件发展联盟

2018年7月1日，中国人工智能开源软件发展联盟（AIOSS）是中国电子技术标准化研究院在工业和信息化部信息化和软件服务业司的支持下成立，以推动我国人工智能开源软件技术和产业发展为重要使命，搭建产学研用合作平台，促进联盟成员的研发、设计、生产、集成、服务等水平的提升，着重从政策、标准、技术、人才、公共服务、国际合作等方面加强我国人工智能开源软件生态圈的构建。

#### 中国开放指令生态(RISC-V)联盟

2018年11月，中国开放指令生态（RISC-V）联盟在世界互联网大会上成立，中国科学院计算所倪光南院士任理事长。该联盟旨在召集从事RISC-V指令集、架构、芯片、软件、整机应用等产业链各环节企事业单位及相关社会团体，自愿组成一个全国性、综合性、联合性、非营利性的社团组织。联盟将围绕RISC-V指令集，以促进开源开放生态发展为目标，以重点骨干企业、科研院所为主体，整合各方资源，通过产、学、研、用深度融合，力图推动协同创新攻关，促进RISC-V相关技术和产品应用推广，探索体制机制创新，推进RISC-V生态在国内的快速发展，从而使我国尽快摆脱核心芯片设计、知识产权、工艺技术等受制于人的不利局面。

#### 中国RISC-V产业联盟

2018年9月，中国RISC-V产业联盟成立，聚焦于RISC-V产业落地。它由国内外RISC-V领域重点企业、研究机构、和行业协会发起成立，目前已有50余家RISC-V领域相关企业以及10余家大学和研究机构加入。中国RISC-V产业联盟秉承开放、合作、平等、互利的原则，致力于解决中国RISC-V领域共同面对的关键问题，建立中国国产自主、可控、安全的RISC-V异构计算平台，促进形成贯穿IP核、芯片、软件、系统、应用等环节的RISC-V产业生态链。

#### 开源工业互联网联盟

开源工业互联网联盟（Openii Consortium）成立于2018年12月25日，由工业4.0研究院作为主要发起单位，以帮助中小制造企业实现创新发展为主要目标，采用开源软件和硬件的运行模式，加强利用数字孪生体系列技术来推动开源工业互联网的广泛应用。目前开源工业互联网联盟设有五大板块，分别为参考架构工作组、数字孪生体中心、开源项目中心、INNOBASE VENTURE和知识产权工作组等。工业4.0研究院负责数字孪生体中心的相关研究工作。

#### 开源GitOps产业联盟

2021年5月27日，在中国信息通信研究院云原生产业大会上，极狐与CNCF联合发起并成立“开源GitOps产业联盟” (Open GitOps Industry Alliance，OGA联盟）。OGA联盟为进一步推动中国开源、开放GitOps技术在各“产学研”领域的规范化实施和落地，以GitOps技术应用实践为核心，遵守“开源、开放、可信、自主、创新、共赢”的理念，致力于推动开源、开放GitOps技术的产业化发展，着力于构建具备国际技术竞争力、自主可控合作共赢的良好生态。

### 5.1.4 地区型开源组织（孙启统稿）

#### 北京智源人工智能研究院

北京智源人工智能研究院（简称“智源研究院”）是落实“北京智源行动计划”的重要举措，在科技部和北京市委市政府的指导和支持下，由北京市科委和海淀区政府于2018年11月推动成立。愿景是聚焦原始创新和核心技术，建立自由探索与目标导向相结合的科研体制。推动人工智能产业发展和深度应用，改变人类社会生活，促进人类、环境和智能的可持续发展。

#### 上海开源信息技术协会

上海开源信息技术协会是开源创新专业性非营利社会团体法人，成立于2022年3月。协会坚持第三方服务平台定位，立足上海，服务全国。基于自组织创新创业共同体模式，以专业、公开、公正、透明精神，积极发挥企业与政府之间的桥梁和纽带作用，服务国家及上海市数字经济发展战略，推动构建国家“自主、可控”数字经济创新创业公共基础设施。正在推动的主要工作有：开源理论及方法论构建、中国开源创新社会工程、上海开源产业园区、数字“一带一路”。

#### 深圳市开源技术服务中心

深圳市开源技术服务中心是立足深圳，面向全球的“民非组织”，为开源项目提供包括生态发展、运营、营销、法务、培训教育等基础服务是我们的服务重点。

#### 上海白玉兰开源开放研究院

2020年7月11日，上海白玉兰开源开放研究院正式揭牌，上海白玉兰开源开放研究院是由上海交通大学牵头，联合中国电子技术标准化研究院、北京大学、机器之心、复旦大学、华东师范大学、开源社、上海人工智能研究院有限公司等单位成立，对标国内外知名开源开放平台，建设世界一流开源开放平台。上海白玉兰开源开放研究院的目标是推动人工智能开源产品的国际规则互认，催生国际开源生态网络关键节点，建立系统验证与合规评测实验室形成国际标准。

#### 北京开源创新委员会

北京开源创新委员会成立于2021年10月，成员包含百度、腾讯、小米、京东、滴滴、地平线、CSDN、统信、PingCAP、中兴等近30家单位。它是在中国开源软件推进联盟、“科创中国”开源创新联合体、北京市科学技术委员会、北京市经济和信息化局、北京科学技术协会指导下，由开源企业、开源爱好者自发形成的民间公益团体。主要工作内容是发挥北京资源优势，促进开源产业合作、加强开源文化布道、跟进开源深度技术；协助企业开源转型、提升社区开源治理、规避潜在开源风险。

#### 北京开源芯片研究院

北京开源芯片研究院是成立于2021年12月的民办非企业，由一批行业龙头企业和国内顶尖科研单位共同牵头发起成立的创新联合体。研究院以开源开放凝聚产业发展共识，以协同创新激发应用牵引潜力，着力推进RISC-V创新链和产业链的加速融合，加速科技创新成果产业化落地，加快打造全球领先的RISC-V产业生态。研究院致力于研发 RISC-V 领域关键共性技术、建设关键支撑平台、优化生态治理、推动重点行业规模商用，加速 RISC-V 生态完善成熟，打造全球领先的 RISC-V 产业生态。研究院将围绕“香山”开源高性能 RISC-V 处理器核与“一生一芯”人才培养计划开展工作。

#### 厦门市开源芯片产业促进会

厦门市开源芯片产业促进会是成立于2022年7月6日的民办非企业，在厦门火炬高新区管委会和集美区政府联合指导和支持下，由中科（厦门）数据智能研究院牵头，厦门半导体工业技术研发有限公司（工研院）、厦门算能科技有限公司（比特大陆子公司）、厦门芯阳科技股份有限公司、厦门狄耐克智能科技股份有限公司联合发起设立，并作为中国开放指令生态（RISC-V）联盟的地方分中心，其主要宗旨是为厦门本地和外来引进的集成电路及相关的行业优质企业在开源芯片的产品开发、生产和应用及项目投资与合作等方面提供信息、人才、资金、技术、投资、政策等相关支持与服务，促进会目前有51家会员单位。

### 5.1.5 开源推广型社会组织（孙启统稿）

#### 开源社

2014年10月16日，由中国支持开源的企业、社区及个人所组成的开源联盟“开源社”正式成立，旨在携手国内社区、企业、高校及政府相关机构，共同促进中国开源社区成为全球开源软件的积极参与者和贡献者，并推动开源软件生态体系的健康可持续发展。同时，开源社将致力于促进中国开源软件和开源硬件的正确使用、授权许可、社区建设及管理，并为国内广大开发者提供教育培训、知识普及、工具及相关服务，全面满足中国新兴软件行业日益增长的现实需求。

#### ALC-Beijing和ALC-Shenzhen

ALC-Beijing和ALC-Shenzhen是遵照Apache软件基金会Local Community原则，并在Apache软件基金会申请通过的，面向北京和深圳的Apache本地开源社区组织。ALC-Beijing的发起人姜宁为了进一步推动Apache文化在国内的传播，并促进Apache本土项目和开发者的交流和合作，发起该组织，得到了Apache软件基金会的认可。目前该组织包含10多个Apache顶级项目，包括Kylin、Eagle、RocketMQ、ServiceComb、Griffin、SkyWalking、Dubbo、ECharts、APISIX、IoTDB、ShardingShpere、DolphinScheduler、Pulsar等。至今该组织海内外讲师180+，参与直播人数超过60万。2022年发起人姜宁当选为Apache软件基金会董事。

#### 腾源会

腾源会是腾讯云成立的汇聚开源项目、开源爱好者、开源领导者的开放社区，致力于帮助开源项目健康成长、开源爱好者能交流协助、开源领导者能发挥领袖价值，让全球开源生态变得更加繁荣。

#### 星策开源社区

星策开源社区是一个聚焦于企业智能化转型，由企事业单位、高等院校、科研单位、非营利性组织等按照自愿、平等、开源、协作的原则组成的非盈利性、中立的开源社区。联合发起单位包括中国开源软件推进联盟（COPU）、信通院、LF AI & DATA基金会、腾讯、微众银行、中兴通讯、蒙牛、工商银行、第四范式等。社区的使命是连接企业和AI，以开源的方式共享共建企业智能转型的方法论、案例、实践和技术，助力企业智能化转型成功。

#### 开放群岛

开放群岛（Open Islands）开源社区是由深圳数据交易有限公司联合国家智库、国家单位、高校、大型金融机构、大型互联网公司等近50家单位牵头成立的国内首个国际化自主可控隐私计算开源社区。以服务全国数据要素流通应用场景为目标，助力加快建设全国数据交易统一大市场，以开源开放的方式充分整合政府、企业、高校、科研机构等多方资源，推动数据要素流通，关键基础技术发展。

#### 西电开源社区

西电开源社区是一个以Linux为基础的，以技术交流和项目合作为主要活动的开源社区，是一群hacker和geek讨论、交流技术的地方，社区的精神是hacker精神，社区的点点滴滴都是靠hacker精神逐步迭代而来，社区的故事也无不体现了hacker精神社区倡导平等、开放、自由。努力为每一个酷爱技术的人提供良好的探索环境，使其兴趣得到充分发展。

### 5.1.6 企业开源办公室（边思康统稿）

## 5.2 问题与挑战

中国的开源组织在过去几年取得了长足的进步，得到了政府和社会的广泛关注和支持。然而，随着近来国际形势呈现出的深刻、复杂、动荡的变化，以及技术创新的迭代升级加速，中国的开源组织面临着一些问题和挑战。

1.	**产业影响力不够。** 开源组织的质量、数量及其产业影响力是软件产业发展现状的直接反应。当前我国的开源组织主要参与者是国内的企业，国内软件产业整体发展质量不高，体现在开源组织方面，整体上产业影响力不够。
2.	**国际化程度不足。** 尽管中国的开源组织数量在不断增加，但是国际化程度相对较低，很多开源组织需要进一步提高在全球开源社区中的影响力和话语权。
3.	**对于开源与标准协同发展的认识不清晰。** 国际领先的开源组织都对开源与标准的协同发展有清晰的认识和明确的战略，在利用开源推动技术广泛应用的基础上，结合标准与合格评定机制建立技术品牌，维护开源社区的稳定发展。我国的开源组织应当加强对于领先组织的洞察，充分利用多种工具组合，扩大开源社区的影响力。
4.	**可持续发展能力不高。** 虽然中国的开源组织取得了一些成就，但很多组织还存在着融资困难、人才短缺、技术创新难度大等问题，尤其是缺乏商业化运作模式，无法将开源项目转化为商业价值。
5.	**缺乏知识产权保护机制。** 中国的开源组织普遍缺乏对知识产权的保护意识和机制，导致了知识产权的滥用和侵权现象，对开源项目的长期发展产生了不良影响。

面对这些问题和挑战，中国的开源组织需要不断探索和创新，加大开源人才培养力度，提高开源项目的质量和技术水平，加强与国际开源社区的交流与合作，助力中国开源生态向更加健康、成熟和具有全球影响力的方向发展。

## 5.3 发展趋势

在国家政策进一步利好的背景下，越来越多的第三方开源组织涌现出来，通过在中国民政部的全国社会组织信用信息公示平台（xxgs.chinanpo.mca.gov.cn）上查询，发现共有16家从事开源相关工作的社会团体、基金会和民办非企业单还处于正常运营中，其中近一年内成立的就有5家。还有多个依托基金会、学会、联盟、大学等机构的开源组织也于近期纷纷成立。中国的开源组织呈现以下发展趋势：

1.	**数量和规模将继续扩大。** 随着人们对于开源的认知和接受程度不断提高，越来越多的企业和组织开始使用和贡献开源软件和技术，开源软件和技术在国内的应用场景也在不断扩展，开源组织的数量和规模也将继续扩大。
2.	**国际影响持续增强。** 随着中国开源社区的不断壮大和国际化程度的不断提高，中国开源组织也将会加强与国际开源社区的交流和合作，推动中国开源组织在国际舞台上的影响力和地位。
3.	**社区治理和战略工具应用能力逐渐完善。** 随着开源社区的不断壮大，社区治理也变得愈发重要。开源组织开始加强对社区成员的管理和沟通，制定更加民主和透明的决策机制，提高社区的运作效率和质量；一些领先的开源组织提高了包括开源与标准协同战略工具的应用能力，建设与开源社区结合的标准化流程，在代码开发的同时，将支撑互联互通功能的接口标准化，并同步建立合格评定机制，支持开源技术的稳定演进。
4.	**开源硬件成为关注重点。** 除了软件领域，开源硬件也将成为一个重要的发展方向，近期北京和厦门都成立了专注开源芯片的开源组织并在属地民政局正式注册。随着开源硬件平台的不断完善和普及，越来越多的企业和个人开始利用开源硬件平台开发各种应用和产品。

## 5.4 发展建议

在国际形势愈发复杂的背景下，开源组织更应该不忘初心、坚守本心。从实践来看，坚守并践行中立原则的开源基金会与开源组织将赢得开发者以及合作企业的持久信赖。有鉴于此，建议中国的开源组织：

**一是继续扩大国际化合作，融入全球开源生态。** 开源是全球化的，加强与国际开源组织和社区的交流合作，吸引全球的优秀项目与开发者，推动形成统一融合的开源生态，避免出现割裂化、碎片化、政治化的全球开源生态。

**二是增加开源项目的投入和质量，提高中国开源影响力。** 鼓励企业和政府机构参与开源项目的投入，加大对开源组织的支持和赞助，提高开源项目的质量和数量，为国内外用户提供更好的开源产品和服务，让更多的用户使用中国主导的开源项目。

**三是推动开源产业化，实现开源组织的可持续发展。** 积极探索开源项目的商业模式和产业化路径，加强和产业的对接和合作，提供更好的技术支持和应用场景，推动开源技术在产业领域的应用和发展。

**四是加强针对国际领先开源组织的洞察能力，识别开源组织的发展趋势，为我国开源组织的发展提供借鉴。** 作为后来者，我国开源组织的发展必须积极跟踪业界最新的动态和经验，提高组织的战略规划能力，快速提高开源组织的治理能力、管理水平和战略意识，特别是对于开源与标准协同发展的业界趋势要认真研究，争取与国际领先开源组织齐头并进，不至于在战略上落后。

**五是加大开源普及力度，增强开源文化的认识和推广。** 加强开源理念的普及和推广，培养开源文化的意识和习惯，让更多人参与到开源项目的建设和推广中来。
