# 第一章 开源的基本概念 

## 1.1 开源的定义和特征

### 1.1.1 开源的定义

开源（Open Source）一词于1998年2月3日由Chris Peterson提出，“Open Source”的概念出自当时著名的黑客（Hacker）社区Debian的社长Bruce Perens起草的“Debian Free Software Guidelines”（DFSG）。

1998年2月下旬，Eric Raymond和Bruce Perens共同创立"Open Source Initiative"（OSI）。OSI承担的首要任务之一是起草开源定义（OSD），并使用它来开始创建OSI批准的许可证列表。

对确立“Open Source”定义有决定意义的是在1998年4月7日在美国加州Palo Alto由18位“自由软件运动领袖”召开的Freeware高层会议，通过了传播开源的必要性。会议由Tim O'Reilly主持，Brain Behlendorf（Apache创始人）、Linus Torvalds（Linux创始人）、Guido Van Rossum（Python创始人）、Eric Raymond（著名记者、OSI首届主席）等参加。

随着时代的变迁，开源的定义内涵也在不断演进。目前的共识是：开源是促进信息技术创新的重要途径，是将源代码、设计文档或其他创作内容开放共享的一种技术开发和发行模式。技术领域的开源已包含源代码+软硬件设计文档源代码、源数据等技术和资源的开放共享，源代码仍然是开源的主要内容。 在开源模式下，通过许可证的方式，使用者在遵守许可限制的条件下，可自由获取源代码等，并可使用、复制、修改和再发布。

本质上，开源模式是一种依托互联网平台，大规模群体智慧通过共同参与和协作，不断累积智慧，实现持续创新的方法。该方法中，项目的核心开发人员与大规模的外围群体紧密合作，他们通过互联网来共享资源、开展协同开发、管理代码等，由此使得项目开发的效率、应对需求变化的能力大幅提升。

### 1.1.2 开源的特征

中国开源软件推进联盟于2016年归纳提出的（已被国际认可）开源特征包括：开放、创新、自由、共享、协同、绿色、民主（化）。开源的本质在于开放、共享、协同。

- 开放指开放标准、开放环境、开放源码；
- 创新是主轴；
- 自由指自由发布、自由传播、自由复制、自由修改、自由使用，其中，自由传播是开源运动的要义；
- 共享指共享资源；
- 协同指协同开发、协同作业、协作生产；
- 绿色指支持绿色可再生能源、绿色环境和零边际成本效应；
- 民主化指在新兴协同共享中，创新和创造力的民主化正在孵化一种新的激励机制，这种机制很少基于经济回报，而更多地基于推动人类的经济生活方式，缩小收入差距，实现全球民主化。为避免原创技术的流失，不能单纯限制孵化阶段开源代码的自由传播，可通过开源的商业模式、安全模块、运维举措、生态系统所构筑的屏蔽层来解决。

作为一种创新协作模式，开源已经不仅仅是开放源代码的软件技术开发，还包括更为广泛的开放技术领域及协同创新的理念与机制，总体包括开放科学、开源软件、开源硬件、开源技术、开源文化、开源经济等。“互联网＋基于知识社会的创新 2.0”是开源创新的基础理论（2005年由中国开源软件推进联盟提出，后来获得全球开源界领袖们的确认），与工业 4.0、工业互联网机制相通，与元宇宙（Metaverse）概念相似。利用开源渠道，将高阶社会（知识社会，虚拟化的实验空间）中的技术、管理、资源等要素，作用于低阶社会（现实的工业社会，物理空间）中的业态（生产的、技术的、经济的、社会的），促使其产生0→1的爆发性重构。

### 1.1.3 开源的范畴

时至今天，开源已成为开源软件、开源硬件、开源生态、开源技术、开源社区、开源经济、开源商业模式、开源理念、开源文化、开源教育、开源许可证、开源基金会、开源孵化器、开源数字化治理体系、开源标准等的总称。

## 1.2 世界开源发展简史

世界开源发展史，有三个里程碑时间节点：1970年、1985年、1991年，分别对应UNIX、GNU、Linux的发展。

### 1.2.1 UNIX简史

1969年之前，Bell实验室和MIT、GE合作启动开发一个多任务多用户的操作系统Multics，为UNICS操作系统诞生创造条件。

1969年，UNIX原型——UNICS（UNiplexed Information and Computing System）诞生。

1973年，Dennis Ritchie发明C语言，用C语言将UNICS重写并更名为UNIX，UNIX正式诞生。

1969-1977年，UNIX相继推出V1-V6版本，向社会开放源代码。

1977年开始进入“后UNIX”时代，UNIX演化为UNIX（闭源，即AT&T-UNIX）和BSD（开源，即BSD-UNIX）。主流的开源BSD操作系统有386BSD、FreeBSD、NetBSD、OpenBSD。

因此，世界开源的历史始自1970年开启的“前UNIX”，至今53年，开源在事实上已经历了半个世纪的发展历程。

### 1.2.2 GNU简史

GNU系统是一套向上兼容UNIX的完全自由的操作系统。GNU代表“GNU's Not UNIX”。

1983年9月27日，Richard Stallman提出了GNU工程的初始声明，意图找回在早期计算机社区中广泛存在的合作精神，通过除去专属软件所有者设置的障碍而使得合作再次成为可能。

1984年1月，Richard Stallman从MIT离职并开始编写GNU软件，同年9月开始GNU Emacs的工作。

1985年，Richard Stallman发表《GNU宣言》，吸收“前UNIX”和BSD的开源成果，开发推出Emacs等编译器等自由软件（Free Software）。同年10月，自由软件基金会（FSF）正式成立。

“Free Software”中的“Free”关乎自由，而不是价格，是指可以付费或不付费得到GNU软件。一旦得到了软件，便拥有了使用它的四项特定自由。可以自由按照自己的意愿运行该软件；可以自由复制软件并将其送给朋友和同事；可以自由通过对源代码的完全控制而改进程序；可以自由发布改进的版本从而帮助社区建设。

### 1.2.3 Linux简史

Linux的诞生、发展和成长过程始终依赖着五个重要支柱：UNIX操作系统、MINIX操作系统、GNU计划、POSIX标准和Internet网络。

1977年，UNIX的重要分支——BSD在UC Berkeley诞生。开发者是SUN公司创办者Bill Joy。

1984年，Andrew S. Tanenbaum为能续进行学术教育研究，重新开发了一个基于“前UNIX”和BSD4.3的开放源代码操作系统——Minix，这是Linux最开始的前身。

1985年，GNU开源计划和FSF基金会成立。在这个时间前后，涌现了很多重要的软件和协议，如GPL协议、GCC C编译器、Emacs编辑器、Glibc、bash shell等，为Linux后来的发展创造了肥沃的土壤。

1991年，芬兰本科生Linus Torvalds在Minix和GNU成果的基础上，开发并以GNU GPL许可方式发布了开放源代码操作系统Linux v0.01。

1992年5月21日，Peter MacDonald发布第一个独立的Linux安装包SLS。

1993年6月17日，Slackware Linux由Patrick Volkerding发布，这是第一个取得广泛成功的Linux发行版。8月16日，Ian Murdock（Debian中的“ian”）发布了第一个Debian Linux发行版。Debian是最有影响力的Linux发行版之一，是MEPIS、Mint、Ubuntu等的鼻祖。8月19日，Matt Welsh写的《Linux Installation and Getting Started》第1版出版，这是第一本关于Linux的书籍。

1994年3月14日，Linux内核V1.0发布，它支持基于i386单处理器的计算机系统。8月15日，William R. Della Croce, Jr.申请了“Linux”商标，9月进行了注册。11月3日，Red Hat共同创始人Marc Ewing宣布可以以49.95美元的零售价格获得Red Hat Software Linux的CD-ROM和30天的安装支持。

1996年5月9日，吉祥物Tux诞生。6月9日，Linux内核V2.0发布，这是第一个在单系统中支持多处理器的稳定内核版本。Linux从此成为很多公司的重要选择。10月14日，Mattias Ettrich发起KDE项目，此前UNIX和Linux都没有统一的桌面系统，编写桌面软件非常复杂。

1997年1月9日，第一个“Linux病毒”Bliss被发现。

1998年5月1日，基于Linux的Google搜索引擎面世。12月4日，IDC报告称1998年Linux出货量至少上升200%，以其他任何操作系统无法企及的速度增长着。

1999年3月3日，GNOME桌面系统进入Linux世界。

2000年2月4日，IDC报告表明Linux排在“最受欢迎的服务器操作系统的第2位”。10月30日，第一个Linux live发行版Knoppix发布。

2001年1月，Linux 2.4发布，进一步提升了SMP系统的扩展性，同时集成了很多用于支持桌面系统的特性：USB、PC卡（PCMCIA）的支持，内置的即插即用等功能。

2003年3月6日，SCO Group公司宣布正在发起对IBM高达10亿美元的诉讼，声称IBM把SCO的商业机密整合到了Linux中。12月，Linux 2.6版内核发布。

2007年8月8日，Linux基金会由开源发展实验室（OSDL）和自由标准组织（FSG）联合成立，得到了主要的Linux和开源公司，包括富士通、HP、IBM、Intel、NEC、Oracle、Qualcomm、三星以及开发者的支持。11月5日，Google发布Android，被称为“第一个真正开放的综合移动设备平台”。

2011年5月11日，Google I/O大会发布基于Linux内核的云操作系统Chrome OS的Chromebook。6月21日，Linus Torvalds发布Linux3.0版本。

Linux内核大版本的更新周期一般是2-3个月，当前最新版本为Linux 6.4-rc4，发布时间为2023年5月28日；稳定版本Linux 6.3.4，发布时间为2023年5月24日。其Maintainer为Greg Kroah-Hartman & Sasha Levin。

### 1.2.4 开源基金会崛起

开源基金会是开源生态中的重要部分。对于非营利性且处于中立位置的开源基金会来说，他们拥有开源项目的知识产权，而且没有任何商业利益，这为贡献者、开发者、用户提供了良好的协作平台；基金会也会通过技术服务和项目孵化来帮助开发者和开源企业，如软件仓库、问题跟踪、技术指导、法律支持、项目投资、公共关系维护等；基金会还会提供项目日常的运营和治理，以满足在项目生命周期不同阶段对于管理项目的需求。

自20世纪80年代自由软件基金会（FSF）开始，全球各类开源基金会快速发展，在构建全球开源生态中发挥着巨大的促进作用，据不完全统计，各类开源基金会已经超过100家，其中具有代表性的包括（以下数据截至2023年4月）：

- 自由软件基金会（1985年成立）
- Open Source Intiative（1998年成立）
- Apache软件基金会（1999年成立）
- GNOME基金会（2000年成立）
- Blender基金会（2002年成立）
- Mozilla基金会（2003年成立）
- Eclipse基金会（2004年成立）
- Open Invention Network（2005年成立）
- Linux基金会（2007年成立）
- 云原生计算基金会（2015年成立）
- RISC-V基金会（2015年成立）
- OpenJS基金会（2019年成立）
- TARS基金会（2020年成立）
- SODA基金会（2020年成立）
- 开放原子开源基金会（2020年成立）
- 开源基础设施基金会（2020年成立）
- OpenSSF基金会（2020年成立）
- Rust基金会（2021年成立）
- 天工开物开源基金会（2023年成立）

## 1.3 中国开源发展简史

1991年，中国与AT&T Bell Laboratories USL/USG合作，引进UNIX SVR 4.2版本源代码（全球唯一，但属于“后UNIX”闭源时期），并发布了中文版本，合作组建了中国UNIX公司；中方同时也引进“前UNIX”开放的源代码。

1999年，中科红旗、中软网络、冲浪平台在引进Red Hat公司Linux发行版的基础上，分别推出最早的Linux中文版本。

因此，中国开源的发展历史具有两个里程碑节点：1991年、1999年，至今32年、24年，可以分为启蒙、萌芽、发展、加速四个时代。

### 1.3.1 启蒙时代

1991年，陆首群、张克治和杨天行牵头代表中方代表团与美国AT&T USG合作，美方将最新开发的UNIX版本——UNIX SVR4.2源代码向中方开放。中方为此组织了UNIX新版本编辑委员会，由杨芙清、胡道元、仲萃豪、刘锦德、尤晋元、贾耀良、孙玉芳等国内资深软件专家组成，并邀集全国软件专家、程序员200多人，翻译、编辑、出版了UNIX SVR4.2中文版本共19册，首发式在人民大会堂举行，向全国各大图书馆、高等院校赠书，业界影响甚大。这一历史事件被Linux基金会收录，后被作为中国开源诞生的标志性事件。1991年成为中国开源元年。

1992年12月，中方与USG合资在华成立了中国UNIX公司。

1994年，已经在芬兰工作5年的宫敏博士第一次将Linux和大量自由/开源软件源码通过磁带带回中国。

1997年，宫敏第二次带回80GB的自由软件，并在国家信息中心的帮助下在中国经济信息网（https://www.cei.gov.cn/）上建成了“中国自由软件库”，为国内技术人员了解、学习和使用Linux及相关自由/开源软件提供了便利。

1998年，在开源概念提出的这一年，在湖南长沙读博士的章文嵩在Linux2.0内核上利用课余时间开发了Linux虚拟服务系统（LVS），并在第一时间开源，在全世界引起很大反响。同一年，在北京清华大学读研的魏永明，决定开发针对实时嵌入式系统的图形界面系统并将其开源，MiniGui应运而生。同一年，在安徽合肥读大二的自动化系学生吴峰光开始接触Linux，他发现Linux的文件预读算法磁盘I/O性能较差，便尝试对Linux内核进行改进。

1998年初，北京冲浪平台软件技术有限公司成立，专注于研发Linux中文发行版，同年9月Xteam Linux收获了第一个市场用户——北京市政府政策研究室。1999年3月正式对外发布Xteam Linux中文版1.0。2001年冲浪平台在香港创业板上市。

### 1.3.2 萌芽时代

在历时8年的启蒙阶段中，自由/开源软件的理念和文化开始在中国大地生根发芽，随着UNIX、Linux在中国用户的激增，以及互联网时代的到来，中国自发地涌现出一批开源社区和开源企业。在中国开源发展的萌芽阶段，Linux技术的快速普及起到了核心的推动作用。

1999年9月，蓝点软件技术（深圳）有限公司成立，次年3月在美国纳斯达克上市。一个中国初创公司从成立到在美上市仅用不足200天，且上市当天股价暴涨400余倍，这个神话旷古绝今。

1999年底，时任中国科学院软件所副所长的孙玉芳老师牵头筹建北京中科红旗软件有限公司和北京红旗中文贰仟有限公司，分别基于Linux和OpenOffice进行中文版红旗Linux和RedOffice的研制。孙玉芳老师英年早逝，一生发表操作系统相关论文180余篇，编著和译著操作系统原理相关著作140余册，他指导过的诸多硕士/博士生现已成为开源产业的中坚力量。

1999年，中国软件开发者社区CSDN在蒋涛的努力下成立了，并于2000年创办《程序员》杂志。

2000年2月，在科技部国家高技术研究发展计划（863计划）的支持下，由一批国内高校、研究院所、IT企业联合发起成立了共创软件联盟。共创软件联盟在开源许可证规则下对863计划的软件成果进行开源培育和孵化，并提出以开放源代码的协同创新模式作为中国基础软件发展的主要路径，对我国开源产业发展起到了重要的推动作用。

2002年，黄建忠以CJacker的ID在中国Linux公社发布了基于RedHat 8再发布的Magic Linux版本——这是国内第一个Linux社区发行版。

在这个阶段，部分中国开发者开始尝试向国际上游社区贡献代码。但同时，国内Linux企业对开源技术采用拿来主义，忽视开源社区、商业模式和开源知识产权等方面的投入和积累，导致在国际社区中出现了许多针对中国Linux发行商只是开源使用者的评价，直到2008年，这种印象才得以扭转。

2004年，中国开源软件推进联盟成立，陆首群教授被推举为联盟主席。在陆首群主席的大力推进下，COPU 为推动中国开源软件的发展而不懈努力，也为促进中、日、韩乃至全球关于开源运动的沟通、交流、共享、协同与合作而努力，为促进中国、东北亚和全球开源运动作出贡献而努力。联盟的国际智囊团聘请了几十位全球顶级开源专家以多种形式参与和推进中国开源建设，如此规模的智囊团在全球首屈一指，是开源界公认的顶级智库，是COPU创建的开源高地、科技高地、创新高地、人才高地。可以说，联盟的成立和陆主席的领导加速了中国开源软件发展的速度，为碎片化的国内开源产业建立了统一的根据地，为国际开源生态和中国开源生态建立了纽带。

2008年，以Kernel、Apache、GNOME、OpenOffice为代表的国际知名开源社区纷纷选择在北京召开全球技术峰会，作为他们进入亚洲的第一步（之前从未在亚洲国家召开顶级技术峰会）。这是对中国开发者在社区提交贡献的肯定。因此，我们认为2008年成了中国开源发展重要的分水岭。

### 1.3.3 发展时代

在2009年前，中国常被视为国际开源资源单纯的使用者，2009年之后，中国开发者提交的代码被Linux基金会接受，排名稳居世界前四（Kernel 2.6.27之后），中国开始成为国际开源资源的贡献者。

在2009年之后，伴随着云计算、物联网、大数据、移动互联网的快速发展，中国一批有实力有抱负的知名科技IT企业、互联网公司开始选择拥抱开源。Linux基金会执行董事Jim Zemlin曾表示：“这些中国科技公司无论从开源技术上，还是产业、经济发展上，已经走进世界领导者行列。”

在2009-2018年这十年中，中国开源呈现了百花齐放的繁荣局面，从开源开发者数量的激增，到开源社区的多样化（不再局限Linux等操作系统领域），再到知名科技企业自内而外的拥抱开源（内部实行开源治理，逐渐对外捐献开源项目，并向上游技术社区提交贡献）。2012年成立的中国开源云联盟（COSCL）和2016年成立的云计算开源产业联盟（OSCAR）就是典型的开源与云计算技术融合的产业联盟。这一阶段明显的特点在于不论是初创企业还是千百亿体量的科技巨头纷纷用开源技术来构建公司自身的技术堆栈，在技术上全面拥抱开源，并越来越重视对上游开源社区和开源基金会的投入与贡献。

### 1.3.4 加速时代

2019年至今，中国开源进入了一个新的时代——加速阶段。

根据Linux基金会有关Kernel.org社区贡献的统计，来自中国开发者的贡献已居全世界之首（Kernel 4.14至今）。中国开源发展进入深水区，开源生态的完整性、开源社区的成熟性、开源商业模式的多样性和复合性都在发生巨大变化。

由木兰开源社区牵头、多家单位联合参与起草的“中国第一个开源协议——木兰许可证”已经正式发布，前不久还被OSGJ翻译为日文版使用。由华为、百度、腾讯、360、浪潮等发起成立的开放原子开源基金会填补了中国没有开源基金会的空白，尽管它还不能与Linux基金会、Apache软件基金会相提并论，但在开源领域备受瞩目。

在现阶段，部分领先的中国企业不满足于拥抱开源，他们正在很多创新领域跃跃欲试，希望通过开模式来对创新技术进行引领，如商汤的OpenMMLab计算机视觉开放算法、矩阵元的Rosetta隐私AI开源框架、阿里的RocketMQ海量信息中间件、京东的JD Chain开源区块链、百度的PaddlePaddle深度学习平台和Apollo自动驾驶平台、海尔卡奥斯COSMOPlat工业互联网平台的工业APP开发框架开源项目等。同时，在现阶段出现了一些原生的开源明星项目，如Apache SkyWalking、Apache Echarts、Apache IoTDB、TiDB，其中一些优秀的开源项目如TiDB备受资本市场的推崇，创造了全球数据库融资历史新的里程碑。

## 1.4 开源软件与知识产权

至此，我们对开源的定义和发展史有了基本的认识，在继续深入了解之前，有必要关注开源软件与知识产权的知识。

### 1.4.1 软件知识产权的主要内涵

软件知识产权是计算机软件人员对自己的研发成果依法享有的权利。目前国际上对软件知识产权的保护法律还不是很健全，大多数国家都是通过著作权法来保护软件知识产权的，与硬件相关密切的软件设计原理还可以申请专利保护。

- 软件知识产权主要包括著作权、专利权与商标权。
- 著作权指软件的表达（如程序代码、文档等）方面的权利。
- 专利权包括软件的技术设计，如程序设计方案、处理问题的方法、各项有关技术信息等方面的权利。
- 商标权则是指软件的名称标识方面的权利。

软件需要有硬件平台的支撑才可以运行，而在硬件平台上运行的软件基本上是目标码（二进制格式），从而造成软件源码和二进制目标码的分离和割裂，而软件作为通用商品进行销售或分发时主要提供的只是二进制文件，这也成为主流的软件销售和分发方式，并主要通过随软件一起发布的最终用户许可协议（End User License Agreement，EULA）对软件的使用、修改和分享及其他相关事宜作出规定。

针对上述对软件源代码的处置方式，出现了一种开放、协同、共享的软件发展模式——通过开源软件许可证对软件源代码的复制、修改、再分发等权益，对商标、专利、著作权等内容进行进一步规范，这也是对软件知识产权发展的一个重要补充。

### 1.4.2 开源软件许可证

开源许可证就是开源软件使用的许可证。对开源软件许可证的法律界定先前存在一定的争议。在美国，一些法院认为软件许可证是合同（Contract），一些法院则认为是许可（License）。两者的区别在于，许可在传统上是由地产或物主作出的，目的在于允许他人使用自己的地块或物品。因此，它是单方向的，不构成完整的合同，而是作为合同的一个要素，用来和他人交换的条件。

合同和许可之分在美国法上具有重要意义。如果是合同，那么需要适用各州不同的合同法；如果是许可，那么需要适用统一的联邦版权法。此外，合同的违约救济和版权的侵权救济也有诸多不同，比如禁令（行为保全）的适用、判赔额的确定、律师费的分担等。

不过，包括中国在内的大陆法系国家，则普遍认为开源软件许可证构成合同；只不过这种许可合同并非协商得到，而是事先规定好的标准化格式合同。具体来讲，开源许可证是涉及版权、专利、商标等一系列权利义务的格式合同，且自动生效。

法律并没有限定许可证不能包含什么条款，这导致许可证的类型极其繁多、内容也非常自由。据不完全统计，广义上的开源许可证目前有超过200种，即便是OSI批准的许可证目前也多达96种，其中包括由中国主导编制的Mulan Permissive Software License v2(MulanPSL - 2.0)，全部许可证可参见https://opensource.org/licenses/alphabetical和https://opensource.org/licenses/category。

### 1.4.3 国外主流开源许可证解读

**（1）GNU通用公共许可证（GPL）**

GPL通用公共许可证是一个许可证家族的泛称，是一个被广泛使用的自由软件许可协议条款，为使用者提供了足够的复制、分发、修改的权利：

- 可自由复制；
- 可自由分发，提供他人下载；
- 可用来盈利，分发软件过程中收费（必须在收费前向客户提供该软件的GNU GPL许可协议）；
- 可自由地修改（使用了这段代码的项目也必须使用GPL协议）。

GPL当前主要有GPL v2和GPL v3两个版本。这组许可证的共同特征在于其“传染性”：任何基于GPL代码编写的软件都必须成为开源软件。换言之，使用了任何GPL代码的软件，无论GPL代码占比多少，都必须将完整的源代码公开，并允许他人修改、发布。

GPLv2许可证存在一些漏洞，例如它不能阻止一个软硬件结合的系统中，通过对硬件部分施加限制，间接阻止用户在该硬件上运行软件的修改版本；没有包括关于专利的约定，导致实践中出现Microsoft-Novell专利协议这类试图将专利申请用作于对付自由软件社群的武器的现象。

为解决这些问题，GPL v3于2007年发布。除填补上述漏洞，GPL v3兼容性更好。自由软件基金会明确表示GPL v3与Apache 2.0许可证兼容。

目前，使用GPL许可证的重要项目包括Linux内核和MySQL等，但新兴项目一般会选用更宽松的许可证。

**（2）LGPL（Lesser General Public License）**

LGPL叫做GNU宽通用公共协议，对产品所保留的权利比GPL少，适用于非开源产品的开源类库或框架，并可以不继承LGPL协议，使用其他的开源协议。

LGPL的特点在于，链接到该软件库的软件可以不适用LGPL或GPL，换言之，可以不公开源代码。LGPL的这一特性消除了在GPL下软件商用的最大障碍。尽管如此，基于该库修改而得到的软件仍然需要遵循GPL许可证。

**（3）Mozilla Public License（MPL）**

MPL允许在其授权下的源代码与其他授权的文件进行混合，包括私有许可证。在MPL授权下的代码文件必须保持MPL授权，并且保持开源，即允许在派生项目中存在私有模块，同时保证核心文件的开源。使用MPL授权的软件并不受专利的限制，其可以自由使用、修改，并可自由的重新发布。带有专利代码的版本仍然可以使用、转让，甚至出售。

**（4）BSD许可证系列**

BSD许可证是由UC Berkeley首倡和维护的，版本繁多，目前常用版本包括原始的BSD-4、BSD-3以及简化的BSD-2。BSD属于宽松许可证，与MIT许可证接近但更加宽松，甚至跟公有领域更为接近。在最简化的BSD-2许可证下，保留著作权声明、许可证内容以及免责声明即可；只要满足许可证设定的条件，就可以自由地修改并发布代码。

BSD-3许可证在BSD-2许可证的基础上增加了禁止背书条款（未经事先书面许可不得使用原作者之名来推广衍生作品）；BSD许可证进一步增加了广告条款（衍生作品的广告材料必须说明该软件包含由UC Berkeley及其贡献者开发的软件）。

**（5）MIT许可证**

MIT许可证之名源自首倡者MIT麻省理工学院，又称“X许可协议”（X License）或“X11许可协议”（X11 License）。

据统计，2015年GitHub上高达45%的项目使用MIT许可证。近几年MIT许可证的份额有所下滑，在2020年市场份额第一的位置被Apache 2.0取代，但仍是最受开发者欢迎的许可证之一。

MIT的特点在于条款非常简单，是开源协议中最宽松的一个：“被许可人有权利使用、复制、修改、合并、出版发行、散布、再许可和/或贩售软件及软件的副本，及授予被供应人同等权利”，加上要求被许可人保持同样的声明。

**（6）Apache许可证**

Apache许可证是一种“宽松”（Permissive）的许可证，目前常用版本是2.0，2020年成为使用最多的许可证。“宽松”是指不保证被使用软件的派生版会继续保持自由软件的形式，即：“怎么用都行，用在哪都行”。

具体而言，Apache 2.0许可要求保留版权和许可声明，但允许许可作品、修改和更大的作品在不同的条款和没有源代码的情况下分发，只是未修改的部分仍然需要保留Apache许可证。除了为用户提供版权许可之外，还有专利许可，对于那些涉及专利内容的开发者而言，该协议最适合。

由于上述利好条件，Apache 2.0成为了相当多流行的开源项目的许可证，最著名的例子之一就是Kubernetes。

不同开源许可证就许可、条件和限制的比较参见https://choosealicense.com/appendix/。 主要常见开源许可证的对比汇总见下表。

![](https://img-blog.csdnimg.cn/ebdf45303a964d55a24115b16f4e3b62.png)

常见开源许可证的对比汇总表

可以看出，除了允许商业性使用、分发和修改外等常见特征外，开源许可证还有两个共同点。一是开发者不承担保证责任（瑕疵担保责任）。开源代码通常都是免费提供的，因此开发者不应为他人使用该软件造成的损失而承担责任。二是要求保留著作权标记。开源软件并不意味着放弃著作权。相反，开源许可证的强制效力来源，恰恰来自于作者对开源软件的著作权。

因此，许可证一般都要求以适当的形式保留著作权标记（包括许可证正文以及作者署名）。

### 1.4.4 木兰开源许可证解读

木兰许可证族由中国电子标准化研究院牵头研制，已发布版本包含木兰宽松许可证（MulanPSL v1；MulanPSL v2）、木兰公共许可证（MulanPubL v1；MulanPubL v2）、木兰—白玉兰开放数据许可协议（MBODL v1）、木兰开放作品许可协议（MulanOWLs v1）。

#### 1.4.4.1 木兰宽松许可证（MulanPSL）

MulanPSL v2于2020年通过OSI认证，是全球首个由我国主导的国际通用中英文双语许可证，与Apache 2.0许可证有良好的兼容性，最大限度鼓励专利和版权开放，并于2021年发布日文版。截止2020年底，已有超过1万余项国内自主开源项目支持MulanPSL 2.0，得到Linux基金会、Apache基金会、华为、阿里、开源中国、CSDN等开源组织、公司和代码托管平台的支持应用，1万7千余代码仓应用（Gitee 11000+，GitHub 7000+）。其中典型应用有OpenEuler、OpenGauss、方舟编译器、XiOUS等。

#### 1.4.4.2 木兰公共许可证（MulanPubL）

木兰公共许可证在宽松版基础上增加了其传染性，对开源软件的分发增加了限制性要求。木兰公共许可证和木兰宽松许可证间存在较大差异，均以第 2 版为例，其差别集中在“分发限制”上。木兰公共许可证类似GPL具有传染性，要求接受者必须开放源代码。而木兰宽松许可证的“分发限制”中仅仅要求保留代码中的许可证声明，并未要求再次分发时的许可证设置，不具有“传染”特质。

木兰宽松许可证与木兰公共许可证的共同特点是：采用中英文表述，且具有同等法律效力；遵从表述简洁原则，容易理解；明确授予版权和专利权，不授予商标权。而区别在于前者能与现有的其他许可证友好兼容，后者对开源软件的分发条件有限制性要求，对云计算和SaaS等新兴技术的分发也有条件限制。

![](https://img-blog.csdnimg.cn/7e796257670f450bb850e53b0aeab9d5.png)

木兰宽松许可证与国外主流许可证的异同

![](https://img-blog.csdnimg.cn/d7a62ef11e2442199ca9ff15908d23c8.png)

木兰公共许可证与国外主流许可证对分发的限制

#### 1.4.4.3 木兰—白玉兰开放数据许可协议

木兰—白玉兰开放数据许可协议于2021年7月在世界人工智能大会发布第一版，旨在基于中国国情和法律，针对人工智能场景下的数据使用与非商业约束做了分层详实约定，从而最大限度鼓励和助力关键数据资源的开放流通。

数据要素的流通是一个复杂问题，其牵涉到技术、商业模式、法律环境等多个维度的问题，而“木兰—白玉兰协议”的目的是希望从法律层面提供一套可以约定数据发布方和使用方的标准权责的文本，从而形成一种“社区行为规范”去加速数据的开放共享。

考虑到数据要素流通的合规复杂性，MBODL v1基于以下原则和适用性拟定：

- 针对人工智能训练数据集的发布拟定适用的协议。
- 所发布数据应满足基本的公开发布、免费发布的前提。
- 所发布数据符合国家数据安全的要求，不涉及国家秘密、国家安全、社会公共利益、商业秘密等。
- 所发布数据当前不涉及个人信息。

基于当前人工智能训练数据集从权属角度可分为两类情况：第一类，数据由数据发布者合法合规所有或具备用益权；第二类，数据由数据发布者通过合法合规的方式自第三方处获取汇编组合而得。因此，MBODL对上述两类情况产出了两组不同起草策略的协议：

（1）MBODL自主拥有数据或拥有处置权。在协议架构上，设置了类似CC协议的一个套组协议：

- MBODL-SA：相同方式授权，使MBODL具备传染性。
- MBODL-NC：非商业，可匹配不同非商业限定。
- MBODL-CU：仅计算使用，限定模型和分析类使用。

以上协议均以MBODL基础，在“许可限制”小节中予以增加不同的限制而形成，同时也类似CC协议，可以再进行许可限制的叠加交叉，形成新的协议。

（2）汇编第三方内容形成数据集。类似Open Database License（ODbL），采用“数据集结构和数据集内容分离”策略。对数据库或者数据集的结构（即数据选取、组织的方式，database scheme）和数据内容予以了拆分授权的方式。目前，MBODL（结构内容分离版）协议作为一个单独的实验性协议供各界讨论适用性和条款的实践落地可能。

MBODL协议突破了以往数据协议中对“使用”一词的模糊定义，将传统的“使用”一词，依照数据分析和机器学习的术语，做技术性分解和定义，便于行业内技术人员理解协议的制约。同时破局“非商业”的模糊性，对数据本身商业化、模型商业化、基于分析和模型的结论商业化做明确的独立切割。并且明确限制的类型和范畴。

#### 1.4.4.4 木兰开放作品许可协议

木兰开放作品许可协议于2022年木兰峰会正式发布。本协议适用于著作权法下的作品。旨在适应开放作品的新特点，满足开放作品创作者的新需要，推动开放作品的发展。

（1）当前开放作品新特点：
- 群体化创作作品变得越来越流行，这类作品通常由多个作者共同参与完成，作品更新较快，版本较多；
- 开放作品创作者对作品的授权也呈现更加开放的新需求，如授予作品相关的专利许可。

（2）木兰开放作品许可协议解决问题：
- 授予专利许可的许可协议类别。满足了作品权利人授予作品涉及的技术方案、外观设计等专利权的需要；
- 对多版本作品如群智作品提供了署名规范。方便了相关作品在实践过程中的使用和检索；
- 以中英文双语表述，中英文版本具有同等法律效力，在中英文版本存在不一致的情况下以中文版为准，对中文用户理解和使用协议具有一定优势；
- 在明确合同双方行为约束的前提下尽可能地精简条款、优化表述，降低产生法律纠纷的风险。

## 1.5 开源与标准

### 1.5.1 开源与标准的关系

开源与标准之间既是研究对象关系、规范与实现的关系又是协同发展关系。开源与标准化协同发展是信息技术领域发展的最佳模式，共同构建开放的产业生态。

#### 1.5.1.1 开源与标准的关系

开源与标准关系分三种：一是研究对象关系，开源作为标准化对象开展标准化工作；二是规范与实现关系，标准是技术的抽象规范，开源是标准的具体实现；三是协同发展关系，开源与标准以协同发展、相互促进的方式，共同支撑产业创新、助力产业发展。

![](https://img-blog.csdnimg.cn/7d6022fbd4684146996c5c713721ad59.png)

图 开源与标准关系图

**研究对象的关系**

开源作为标准化对象。标准化对象是指需要标准化的主题。通常，标准化对象包括两方面的内容：一是标准化学的研究对象，二是标准化工作的对象。前者也称为总体对象，它是各工作对象的总和构成的总体，主要是研究各种具体对象的共同属性、本质和普遍规律；后者也称为具体对象，它是需要制定标准的对象或各专业标准化工作的对象。

**规范与实现的关系**

标准是技术的抽象规范，开源则是以“开源方式”对于标准所定义规范的具体实现。

**协同发展的关系**

标准是基于开放流程的、以实现兼容性和互操作为目标的技术规范的开发过程。开源是基于开放合作和代码共享为特征的技术实现过程。开源与标准是构建开放的信息技术生态的两种重要工具，两者相互补充，相互促进，协同发展，缺一不可。

![](https://img-blog.csdnimg.cn/1094c892da584c6d81dbbf0210706cb8.png)

图 开源与标准协同，共筑开放的技术和产业生态

#### 1.5.1.2 开源与标准协同发展

标准化是开源治理的重要手段，以开源为对象的治理，是专注于开源活动体系及其效能和风险管理的一系列治理规则，由治理主客体、组织结构和过程组成，以确保参与开源活动能够支撑组织的目标。Linux、OpenInfra、Apache等全球代表性开源基金会均将标准化作为开源社区建设和发展的重点任务之一，主要围绕开源社区治理、技术开发以及推动实现互操作等方面。国内已着手布局构建自主开源规则体系，但当前开源生态仍面临基础共性理论统一、技术互联互通困难、社区治理能力尚待完善等问题，需要标准化手段推进开源运营治理规则体系建设。

开源和标准协同发展，是推动开源和标准规则研究、技术及应用发展的重要基础性工作，可以共同构筑开放有序的产业生态，预防独家垄断与技术锁定；为客户提供更多选择；促进产业包容式发展；持续推动开放式创新。

#### 1.5.1.3 开源标准化价值

![](https://img-blog.csdnimg.cn/b24819060a814768be39e3cc2ce328bd.png)

图 开源标准化价值

**开源规则和社区治理标准化的价值**

在规则层面，标准化对开源的价值体现于统一产业界认识，如开源术语、元数据、许可证等。针对开源技术和应用的相关概念，是认识、理解开源技术的基础，为开源领域其他标准研制提供支撑，旨在形成行业基础共识。由我国官方推出的首个开源协议木兰宽松许可证”（MulanPSL）在此方面迈出了坚实的一步，但还需要后续更多的系列行动；

在社区层面，标准化对开源的价值体现于保障社区的健康与稳定。社区文化、领导及治理能力是维护社区可持续发展的基础。社区治理遵循开放、透明、平等、共识、协作的原则，以法律法规、社区机制、治理流程、运营流程、基础设施、社区评估六大域建立开源社区治理、运营和技术框架，支撑社区可持续发展。通过建立开源社区治理机构，协调内外资源，对开源软件的许可模式和开源的知识产权保护提供法律和法理的保障；通过制定开源项目的治理流程和合规规范来保障项目健康发展。

**开源项目和技术标准化的价值**

在项目和技术层面，标准化对开源的价值体现在以下几个方面：

（1）开源通过实施标准并在标准的支持下实现与现有技术生态的互操作，促进开源的快速、广泛应用。

（2）标准化可以支持开源技术形成稳定演进的技术框架和外部接口，与外部系统的互联互通，防止社区分裂，推动生态发展。

（3）标准可以支撑开源所定义的技术成为稳定的规范，同时支持闭源实现，共同构建产业生态，保证开源项目的可持续发展。

（4）标准化可以开源项目构建稳定的技术品牌的建设。例如Open Infrastructure Foundation通过DefCore标准的制定，并结合基于标准的合格评定，定义OpenStack技术品牌。

通过为开源建立标准，可以解决四个方面的问题：

（1）统一概念和认识

当前OSD的本质是定义了开源软件的授权协议的主要特征，并非定义开源本身。同时关于开源软件、开源硬件、开源社区、开源产品、开源基金会等概念，也一直没有明确、无歧义、相互之间协调一致的定义。

而概念与概念之间的关系，也需要清晰的定义，如：开源基金会、开源社区与开源产品、开源项目与软件版本、开源代码仓库与开源制品等，都应建立某种符合逻辑、能够涵盖各种情况的关联关系。我国亟需一套完整的定义，将各种相关的概念统一在一个框架之下。开源作为标准化对象，对于其基础共性理论及方法论，可以从国家标准层面进行统一。

（2）构建互联互通的技术生态体系

开源必须通过实现标准才能完成与外部系统兼容和互联互通，实现多平台的可移植性和进入技术生态系统的目标。开源与标准化协同发展过程中，将做到以团体标准为抓手，构建协调一致的技术生态体系并连接尚未联通的断点，减少行业内上下游的重复工作，同时用标准化的方式持续推进制定互联互通的标准。

（3）构建技术品牌，防止社区分裂

针对开源项目核心技术接口，通过标准化机制制定和发布团体标准，并基于标准建设合格评定机制，构建技术品牌。稳定的技术品牌发展路径和版本更新机制，可以增强技术社区的向心力，有助于维护开源项目统一演进，防止技术社区分裂

（4）建立评估体系

在开源标准制定过程中，将关注如何计算、评估以及测量各种指标，如一个GitHub仓库中可以看到的stars数量、其数量背后的价值、开源项目的热门程度、技术难度、质量高低、社区健康度等指标。同时基于开源标准构建评估体系，更好服务开源生态建设。

当前开源发展过程中，以标准体系化方式汇集最佳实践，并不断修订以帮助开源社区健康成长，是开源标准化工作重点关注的方向之一。

#### 1.5.1.4 标准开源化价值

标准是“通过标准化活动，按照规定的程序经协商一致制定，为各种活动或其结果提供规则、指南或特性，供共同使用和重复使用的文件”。标准对于开源的价值在于提供可移植性和互操作性，从而提高开源软件的开发和部署效率，节省成本；同时标准制定、优化和推广也与开源项目的研发、升级和应用密切相关。

![](https://img-blog.csdnimg.cn/5756545d500941368980cafd865972ae.png)

图 标准开源化价值

（1）开源是标准制定需求的来源

标准制定的需求来源于多个途径，开源作为广泛应用的软件是重要的需求来源之一。开源可以把在研发和推广过程中的客户需求和技术需求反馈到标准化流程中，通过开放的讨论形成共识，形成标准化文本，并通过标准化体系广泛推广，支持更多形式的标准实现，包括其他的开源项目、闭源软件，共同构造产业生态。

（2）开源是标准优化的基础

标准通过版本演进实现不断优化。开源在广泛应用过程中积累发现的问题不仅通过代码实现即时改进，对于影响兼容性和互操作的技术模块也应当及时反馈到标准化，实现标准的持续优化，提高标准的质量，并通过标准化体系为开源生态的扩展提供更大的支撑。

（3）开源帮助验证标准的可行性

标准作为抽象的技术要求需要得到验证，开源可以提供代码实现验证标准的可实现性，并将实现过程中遇到的问题回馈标准化流程，有利于提高标准的质量。

目前很多标准化组织，例如W3C等，开发流程要求标准发布之前必须有两个以上的实现，验证标准的可实现性，否则标准无法发布。目前很多W3C标准的是实现都是通过开源方式完成的。JCP标准开发流程同样要求标准必须有开源实现来验证标准的可实现性，这些开源代码构成了OpenJDK开源社区的基础。

（4）开源帮助推广标准

标准通过开源代码的实现加速了标准的快速应用。一般的标准都立足于技术的高层定义，以满足多种实现方式的需求，而无法直接通过代码方式使用。开源作为代码的直接实现，可以快速实现标准，大幅度提高了标准的易用性，可以推动标准的广泛使用。在一些领域的标准化工作中，采用包括XML在内的建模语言形成标准文本，支持通过自动化的方式完成代码转换，从而大幅度提高了代码实现的效率，也为标准与开源协调发展提供了技术工具支撑。

当然标准不仅支持开源实现，也支持闭源实现。例如，TCP/IP协议栈的实现，有开源的版本，也有闭源的版本，特点不同，面对不同用户的需求，满足在使用标准过程中对于多样性的需求。

### 1.5.2 开源与标准协同发展现状

开源与标准之间既是研究对象关系、规范与实现的关系又是协同发展关系。开源与标准化协同发展是信息技术领域发展的最佳模式，共同构建开放的产业生态。以国家标准结合团体标准的方式来共同促进开源生态可持续健康发展。

#### 1.5.2.1 开源的标准化需求

（1）开源规则和社区治理的标准化。

开源要素包括术语、概念和规则等需要通过标准化达成共识，否则会埋下混淆的隐患。目前开源的一些重要要素由“开放源代码促进会”（Open Source Initiative，OSI）定义，符合其发布的“开源定义”（Open Source Definition，OSD）已经成为业界广泛应用的、用于确定“开源许可证”的标准；在OSD的基础上OSI发布的“开源许可证”在业界应用广泛；同时，OSI还建立了许可证审查流程，“确保标记为开源的许可证和软件符合现有的社区规范和期望”。OSI标准在开源领域内达成了共识，防止开源的滥用。

（2）开源项目和技术的标准化。

大量开源社区建设标准化流程，围绕开源项目和技术制定团体标准，并基于团体标准推动国际标准的制定。
例如，Linux Foundation建立了标准化组织Joint Development Foundation（JDF），2020年经ISO/IEC JTC1批准，成为公开可用规范（PAS）提交者；Eclipse Foundation设立Eclipse Foundation Specification Process，“为制定开源社区驱动的、开源友好的规范提供开放和透明的框架”；OpenInfra Foundation为OpenStack技术品牌的定义成立了DefCore标准项目，用于“确定如何授予OpenStack的商业实施使用商标的指导原则”。

#### 1.5.2.2 标准的开源化需求

标准化组织建设开源项目，围绕标准的验证、实施和推广开发开源代码。

例如，万维网联盟（World Wide Web Consortium，W3C）建立开源项目W3C Open Source Software，认为“W3C标准的自然补充是可运行的代码，实现和测试是标准开发的重要组成部分，发布代码促进了开发人员社区的思想交流”；结构化信息标准促进组织（Organization for the Advancement of Structured Information Standards，OASIS）建立开源项目Open Projects，支持社区“在开源许可证下开发所需技术——代码、API、标准、参考实现”；致力于Java语言标准开发的Java Community Process标准组织建设OpenJDK开源社区，“为JavaSE JSRs标准提供开源参考实现”。
