# 全球数据库产品库（持续更新）

本项目旨在收集全球数据库产品（包括开源、闭源）的情况，会不断更新维护，如果您有推荐的信息或建议，欢迎提交 Issues 或 PR，一起参与贡献。同时，您在提交时，也可将您的信息一起更新至致谢名单，感谢您一起共建全球数据库产品库。

## 开源

| 序号 | 数据库产品名称 | 发行组织 | 数据库类型1<br>（关系、键值、时序、文档、列、图、向量） | 数据库类型 2<br>（集中式、分布式、OLTP、OLAP、HTAP、云原生） | 正式开源时间 | 开源许可协议 | 技术特点/产品特征 | 代码托管地址 | 负责人/主要贡献者 |
| :-- |  :-- |  :-- |  :-- |  :-- |  :-- |  :-- |  :-- |  :-- |  :-- | 
| 1 | AliSQL | 阿里 | 关系 | 集中式 | 2016 | GPL-2.0license | AliSQL是基于MySQL官方版本的一个分支，由阿里云数据库团队维护，目前也应用于阿里巴巴集团业务以及阿里云数据库服务。该版本在社区版的基础上做了大量的性能与功能的优化改进。尤其适合电商、云计算以及金融等行业环境。该版本性能优于社区版MySQL70%左右，可帮助中小企业和开发者提升数据运营能力。 | https://github.com/alibaba/AliSQL |  |
| 2 | ApacheDoris |  | 关系 | OLAP,分布式 | 2017 | ApacheLicense2.0 | ApacheDoris是一个现代化的MPP分析型数据库产品。仅需亚秒级响应时间即可获得查询结果，有效地支持实时数据分析。ApacheDoris的分布式架构非常简洁，易于运维，并且可以支持10PB以上的超大数据集。 | https://github.com/apache/incubator-doris |  |
| 3 | ApacheKylin™ | 麒麟 | 关系 | 分布式、OLAP | 2014 | Securitypolicy | ApacheKylin™是一个开源的分布式大数据分析数据仓库；它旨在提供大数据时代的OLAP（在线分析处理）能力。通过在Hadoop和Spark上革新多维立方体和预计算技术，Kylin能够在数据量不断增长的情况下实现接近恒定的查询速度，将查询延迟从几分钟减少到亚秒级。 | https://github.com/apache/kylin |  |
| 4 | Claims | 华东师范 | 关系 | 集中式，OLTP |  |  | CLAIMS（CLuster-AwareIn-MemorySql查询引擎）是一个并行的内存数据库原型，它在商品服务器集群上运行，并提供对关系数据集的实时数据分析。得益于智能和大规模并行性以及内存数据处理优化，CLAIMS在对TPCH数据集和上海的查询中比开源社区中的两个最先进的系统Shark和Impala快5倍证券交易所数据集。 | https://github.com/dase/CLAIMS |  |
| 5 | GreatSQL | Percona | 关系 | 集中式，OLTP |  |  | GreatSQL是源于PerconaServer的分支版本，除了PerconaServer已有的稳定可靠、高效、管理更方便等优势外，特别是进一步提升了MGR（MySQLGroupReplication）的性能及可靠性，以及众多bug修复。此外，GreatSQL还合并了由华为鲲鹏计算团队贡献的两个Patch，分别针对OLTP和OLAP两种业务场景，尤其是InnoDB并行查询特性，TPC-H测试中平均提升聚合分析型SQL性能15倍，最高提升40多倍，特别适用于周期性数据汇总报表之类的SAP、财务统计等业务。 | https://gitee.com/GreatSQL/GreatSQL-Doc/issues |  |
| 6 | HugeGraph | 百度 | 图 | 集中式 | 2018 | ApacheLicense2.0 | HugeGraph是一款易用、高效、通用的开源图数据库系统（GraphDatabase），实现了ApacheTinkerPop3框架及完全兼容Gremlin查询语言，具备完善的工具链组件，助力用户轻松构建基于图数据库之上的应用和产品。HugeGraph支持百亿以上的顶点和边快速导入，并提供毫秒级的关联关系查询能力（OLTP），并可与Hadoop、Spark等大数据平台集成以进行离线分析（OLAP）。 | https://github.com/apache/incubator-hugegraph |  |
| 7 | Milvus | 上海赜睿信息科技有限公司 | 向量 | 集中式 | 2019 | ApacheLicense2.0 | Milvus作为专门设计用于处理输入向量查询的数据库，它能够以万亿规模索引向量。与现有的主要按照预定义模式处理结构化数据的关系数据库不同，Milvus是自下而上设计的，用于处理从非结构化数据转换而来的嵌入向量。<br>为非结构化数据构建<br>Milvus帮助用户关注非结构化数据的语义含义，而不是分片、数据持久化和负载均衡等复杂性。Milvus支持向量和标量数据的高性能、混合搜索，为非结构化数据处理开辟了新的可能性。<br>按需性能<br>Milvus是云原生的，可以轻松进行水平扩展。该平台能够处理任何规模的存储和计算，并具有支持按需和自动扩展的微服务设计。<br>成本效益<br>Milvus改进了Faiss和hnswlib等高性能存储和索引库，保证了时间和资源高效的查询速度。Milvus采用多种加速方式（如CPU、SIMD、GPU和FPGA），可在毫秒级内检索万亿级数据集上的矢量数据。<br>方便使用的<br>Milvus支持多种数据类型，并提供完善的多语言SDK。Milvus通过Python-ORMAPI提供跨笔记本电脑、本地集群和云的集成用户体验。丰富的部署和可视化工具可帮助用户更快地启动和运行Milvus。<br>社区支持<br>Milvus毕业于LFAI&DataFoundation的孵化器计划，已被全球1,000多个组织采用。该平台充满活力的开源社区欢迎所有人的贡献。 | https://github.com/milvus-io/milvus |  |
| 8 | NebulaGraph | 悦数科技 | 图 | 分布式,云原生 | 2018 | Apache | 可靠的分布式、线性扩容、性能高效的图数据库.擅长处理千亿节点万亿条边的超大数据集，同时保持毫秒级查询延时的图数据库解决方案 | https://github.com/vesoft-inc | zhong.tian@vesoft.com |
| 9 | OceanBase | 阿里 | 关系 | 分布式，HTAP | 2021 |  MulanPubL-2.0 | OceanBase数据库是阿里巴巴和蚂蚁集团不基于任何开源产品，完全自研的原生分布式关系数据库软件，在普通硬件上实现金融级高可用，首创“三地五中心”城市级故障自动无损容灾新标准，具备卓越的水平扩展能力，全球首家通过TPC-C标准测试的分布式数据库，单集群规模超过1500节点。产品具有云原生、强一致性、高度兼容Oracle/MySQL等特性，承担支付宝100%核心链路，在国内几十家银行、保险公司等金融客户的核心系统中稳定运行。 | https://gitee.com/oceanbase/oceanbase?_from=gitee_search |  |
| 10 | openGauss | 华为 | 关系 | OLTP，集中式 | 2020 |  MulanPubL-2.0 | openGauss是一款全面友好开放，携手伙伴共同打造的企业级开源关系型数据库。openGauss采用木兰宽松许可证v2发行，提供面向多核架构的极致性能、全链路的业务、数据安全、基于AI的调优和高效运维的能力。openGauss深度融合华为在数据库领域多年的研发经验，结合企业级场景需求，持续构建竞争力特性。同时，openGauss也是一个开源、免费的数据库平台，鼓励社区贡献、合作。 | https://gitee.com/opengauss |  |
| 11 | Palo | 百度 | 关系 | OLTP，分布式 |  |  | 数据仓库Palo是基于ApacheDoris（百度自研的分析型数据库）构建的企业级MPP云数据仓库，Palo全面兼容MySQL协议，提供快捷查询UI，易于使用；支持高并发低延时查询，支持PB级以上的超大数据集，可有效地支持在线实时数据分析。Palo的分布式架构非常简洁，易于运维，可帮助企业快速且低成本的构建云上数据仓库。 | https://github.com/baidu/palo |  |
| 12 | Pika | 360 | 键值 | 集中式 | 2015 | BSD-3-Clauselicense | 容量大，支持百G数据量的存储<br>兼容redis，不用修改代码即可平滑从redis迁移到pika<br>支持主从(slaveof)<br>完善的运维命令 | https://github.com/Qihoo360/pika |  |
| 13 | PolarDB | 阿里 | 关系 | 分布式，云原生，HTAP | 2021 |  Apache-2.0 | 兼容并包，助力企业数字化转型<br>100%兼容开源MySQL、RDSMySQL和PostgreSQL，无需修改代码即可使用，提供从RDSMySQL高可用版到PolarDB的一键迁移功能，连接地址保留不变。高度兼容Oracle语法，ADAM工具全周期协助您进行Oracle迁移，将Oracle的迁移成本和周期缩减到原来的1/10甚至更低。<br>海量存储，享受云原生技术的普惠<br>PolarDB支持最大容量100TB，最多可横向扩展16个节点，每个节点最高88vCPU，Serverless分布式存储空间根据数据量自动伸缩，仅须为实际使用的容量付费。<br>澎湃性能，快速弹性应对突增负载<br>采用计算&存储分离架构，大幅提升了资源利用率与性能。高并发场景下相比传统MySQL性能最高提升6倍，单节点最高100万QPS，增加计算节点只需5分钟，快速弹性应对突发业务负载的场景。<br>稳如磐石，数据安全永远是第一位<br>PolarDB采用“一主多从”架构，同一实例的所有读写和只读节点都访问存储上同一个数据副本。集群版单机故障，可实现主备切换0数据丢失，彻底解决异步复制带来的主备节点数据非强一致问题，几分钟内即可扩展只读副本，备份和恢复数据。 | https://gitee.com/ai-iotdb/polardb-x |  |
| 14 | RadonDB |  | 关系 | 云原生，分布式，OLTP | 2018 |  GPL-3.0license | RadonDB是新一代企业级云原生数据库品牌，提供包括：关系型数据库、分布式数据库、时序&分析型数据库、数据库管理平台等企业级云数据库产品和服务。<br>RadonDB具备多平台部署、安全可靠、金融级强一致性等特点，提供多场景解决方案及专业的集群管理和自动化运维能力，满足客户各领域的数据库需求，大幅度提升业务开发与价值创新的效率，为客户的业务运行保驾护航。<br>RadonDB开源社区一个面向云原生、容器化的数据库开源社区。为数据库技术爱好者提供围绕主流开源数据库（MySQL、PostgreSQL、Redis、MongoDB、ClickHouse等）的技术分享。提供企业级RadonDB开源产品及服务。 | https://github.com/radondb |  |
| 15 | QTSDB | 360 | 时序 | 分布式 |  |  | QTSDB是360团队基于influxdb研发的一款分布式时序数据库，用于处理海量数据写入与查询。实现上，是基于开源单机时序数据库influxdb1.7开发的分布式版本，除了具有influxdb本身的特性之外，还有容量扩展、副本容错等集群功能。 |  |  |
| 16 | SelectDB | 飞轮科技 | 关系 | OLAP,云原生,分布式 | 2022 | Apache-2.0license | 云原生实时分析型数据库 | https://github.com/search?q=SelectDB | zhoujialiang@selectdb.com |
| 17 | SequoiaDB | 巨杉数据库 | 关系 | OLTP，分布式 |  |  | SequoiaDB巨杉数据库是一款金融级分布式关系型数据库，其自研的原生分布式存储引擎支持完整ACID，具备弹性扩展、高并发和高可用特性，支持MySQL、PostgreSQL和SparkSQL等多种SQL访问形式，同时支持MongoDB引擎。适用于核心交易、数据中台、内容管理等应用场景。产品线分为SequoiaDB-DP、SequoiaDB-TP、SequoiaDB-CM、SequoiaDB-DOC。 | https://gitee.com/wangzhonnew/SequoiaDB/tree/master/ |  |
| 18 | StarRocks | Linux Foundation | 关系 | 分布式，OLAP | 2021 | Apache-2.0 license | StarRocks是一款经过业界检验、现代化，面向多种数据分析场景的、兼容MySQL协议的、高性能分布式关系型分析数据库。<br>StarRocks充分吸收关系型OLAP数据库和分布式存储系统在大数据时代的优秀研究成果，并在业界实践的基础上，进一步改进优化，架构升级和添加新功能，形成了全新的企业级产品。<br>StarRocks致力于满足企业用户的多种数据分析场景，支持多种数据模型(明细表，聚合表)，多种导入方式（批量），可整合和接入多种现有系统(Spark，Flink，Hive，ElasticSearch)。<br>StarRocks兼容MySQL协议，可使用MySQL客户端和常用BI工具对接StarRocks来进行数据分析。<br>StarRocks采用分布式架构，对table进行水平划分并以多副本存储.集群规模可以灵活伸缩，能够支持10PB级别的数据分析;支持MPP，并行加速计算;支持多副本，具有弹性容错能力。<br>StarRocks采用关系模型，使用严格的数据类型，使用列式存储引擎，通过编码和压缩技术，降低读写放大.使用向量化执行方式，充分挖掘多核CPU的并行计算能力，从而显著提升查询性能。 | https://github.com/StarRocks/starrocks |  |
| 19 | StoneDB | 石原子科技 | 关系 | 集中式，HTAP | 2022 |  GPL-2.0 | StoneDB是由石原子科技公司自主设计、研发的国内首款基于MySQL内核打造的开源HTAP（HybridTransactionalandAnalyticalProcessing）融合型数据库，可实现与MySQL的无缝切换。StoneDB具备超高性能、实时分析等特点，为用户提供一站式HTAP解决方案。<br>StoneDB100%兼容MySQL5.6、5.7协议和MySQL生态等重要特性，支持MySQL常用的功能及语法，支持MySQL生态中的系统工具和客户端，如Navicat、Workbench、mysqldump、mydumper。由于100%兼容MySQL，因此StoneDB的所有工作负载都可以继续使用MySQL数据库体系运行。<br>StoneDB专门针对OLAP应用程序进行了设计和优化，支持百亿数据场景下进行高性能、多维度字段组合的复杂查询，相对比社区版的MySQL，其查询速度提升了十倍以上。<br>StoneDB采用基于知识网格技术和列式存储引擎，该存储引擎为海量数据背景下OLAP应用而设计，通过列式存储数据、知识网格过滤、高效数据压缩等技术，为应用系统提供低成本和高性能的数据查询支持。 | https://github.com/stoneatom/stonedb |  |
| 20 | TDengine | 北京涛思数据科技 | 时序 | 集中式，分布式 | 2019 | AGPL-3.0 | 高性能：通过创新的存储引擎设计，无论是数据写入还是查询，TDengine的性能比通用数据库快10倍以上，也远超其他时序数据库，而且存储空间也大为节省。<br>分布式：通过原生分布式的设计，TDengine提供了水平扩展的能力，只需要增加节点就能获得更强的数据处理能力，同时通过多副本机制保证了系统的高可用。<br>支持SQL：TDengine采用SQL作为数据查询语言，减少学习和迁移成本，同时提供SQL扩展来处理时序数据特有的分析，而且支持方便灵活的schemaless数据写入。<br>AllinOne：将数据库、消息队列、缓存、流式计算等功能融合一起，应用无需再集成Kafka/Redis/HBase/Spark等软件，大幅降低应用开发和维护成本。<br>零管理：安装、集群几秒搞定，无任何依赖，不用分库分表，系统运行状态监测能与Grafana或其他运维工具无缝集成。<br>零学习成本：采用SQL查询语言，支持Python,Java,C/C++,Go,Rust,Node.js等多种编程语言,与MySQL相似，零学习成本。<br>无缝集成：不用一行代码，即可与Telegraf,Grafana,EMQX,Prometheus,StatsD,collectd,Matlab,R等第三方工具无缝集成。<br>互动Console:通过命令行console，不用编程，执行SQL语句就能做即席查询、各种数据库的操作、管理以及集群的维护. | https://gitee.com/taosdata/TDengine?_from=gitee_search |  |
| 21 | TDSQL | 腾讯云 | 关系 | 分布式、云原生、HTAP | 2019 |  BSD-3-Clause | TDSQL是腾讯云企业级分布式数据库，旗下涵盖金融级分布式、云原生、分析型等多引擎融合的完整数据库产品体系，提供业界领先的金融级高可用、计算存储分离、数据仓库、企业级安全等能力，同时具备智能运维平台、Serverless版本等完善的产品服务体系。<br>截至2021年，目前腾讯云的数据库已经拥有超过50万客户，服务1000多家政府客户和2000多家金融客户，每天支撑数十亿笔的交易量。同时广泛覆盖游戏、电商、移动互联网、云开发等泛互联网业务场景，助力新零售、教育、SaaS、广告等超过4000家行业客户进行数字化升级。 | https://github.com/search?q=TDSQL |  |
| 22 | TenDBCluster | 腾讯游戏 |  | 分布式 | 2020 |  GPL-2.0 | TenDBCluster是腾讯游戏CROSDBA团队提供的MySQL分布式关系型数据库解决方案，主要包括兼容MySQL协议、透明分库分表、负载均衡、高可用、在线扩展等特点。业务开发可以仅专注于业务逻辑的开发和运营，无需编写数据分片逻辑，在海量用户并发情况下也无须关心DB存储层的负载压力。 | https://github.com/Tencent/TenDBCluster-TSpider |  |
| 23 | TiDB | PingCAP | 关系 | 云原生，HTAP，分布式 | 2015 | Apache-2.0 | 与传统的单机数据库相比，TiDB具有以下优势：<br>纯分布式架构，拥有良好的扩展性，支持弹性的扩缩容；<br>支持SQL，对外暴露MySQL的网络协议，并兼容大多数MySQL的语法，在大多数场景下可以直接替换MySQL；<br>默认支持高可用，在少数副本失效的情况下，数据库本身能够自动进行数据修复和故障转移，对业务透明；<br>支持ACID事务，对于一些有强一致需求的场景友好，例如：银行转账；<br>具有丰富的工具链生态，覆盖数据迁移、同步、备份等多种场景。 | https://github.com/pingcap |  |
| 24 | PostgreSQL | 加州大学伯克利分校 | 关系 | 集中式 | 1989 | BSD | PostgreSQL是一种特性非常齐全的自由软件的对象-关系型数据库管理系统（ORDBMS），是以加州大学计算机系开发的POSTGRES，4.2版本为基础的对象关系型数据库管理系统。POSTGRES的许多领先概念只是在比较迟的时候才出现在商业网站数据库中。PostgreSQL支持大部分的SQL标准并且提供了很多其他现代特性，如复杂查询、外键、触发器、视图、事务完整性、多版本并发控制等。同样，PostgreSQL也可以用许多方法扩展，例如通过增加新的数据类型、函数、操作符、聚集函数、索引方法、过程语言等。另外，因为许可证的灵活，任何人都可以以任何目的免费使用、修改和分发PostgreSQL。[1]  | https://github.com/search?q=postgresql |  |
| 25 | MongoDB | MongoDB开发组 | 文档 | 分布式 | 2009 | MongoDB | MongoDB是一个基于分布式文件存储[1] 的数据库。由C++语言编写。旨在为WEB应用提供可扩展的高性能数据存储解决方案。<br>MongoDB是一个介于关系数据库和非关系数据库之间的产品，是非关系数据库当中功能最丰富，最像关系数据库的。它支持的数据结构非常松散，是类似json的bson格式，因此可以存储比较复杂的数据类型。Mongo最大的特点是它支持的查询语言非常强大，其语法有点类似于面向对象的查询语言，几乎可以实现类似关系数据库单表查询的绝大部分功能，而且还支持对数据建立索引。 | https://github.com/mongodb/mongo |  |
| 26 | Redis |  | 键值 | 分布式 | 2009 |  MIT | redis是一个key-value存储系统。和Memcached类似，它支持存储的value类型相对更多，包括string(字符串)、list(链表)、set(集合)、zset(sortedset--有序集合)和hash（哈希类型）。这些数据类型都支持push/pop、add/remove及取交集并集和差集及更丰富的操作，而且这些操作都是原子性的。在此基础上，redis支持各种不同方式的排序。与memcached一样，为了保证效率，数据都是缓存在内存中。区别的是redis会周期性的把更新的数据写入磁盘或者把修改操作写入追加的记录文件，并且在此基础上实现了master-slave(主从)同步。 | https://github.com/redis/redis |  |
| 27 | Elasticsearch | Elastic | 搜索引擎 | 集中式 | 2010 | ApacheLicense2.0 | Elasticsearch是一款开源搜索引擎,凭借着先发优势和早期的积累,被用于多种检索类业务场景,并占据了一定的市场。2021年初,Elastic公司决定将这款开源软件的ApacheLicense2.0变更为双授权许可,即ServerSidePublicLicense(SSPL)和ElasticLicense。其核心条款是“如果将程序的功能或修改后的版本作为服务提供给第三方,那么必须免费公开提供服务源代码”。这意味着不法分子可以获得其源代码并研究其漏洞,给企业用户带来巨大的安全风险。 | https://github.com/elastic/elasticsearch |  |
| 28 | SQLite | DwayneRichardHipp | 关系 | 集中式 | 2000 | SQLite | SQLite是一个开源的嵌入式关系数据库，实现自包容、零配置、支持事务的SQL数据库引擎。其特点是高度便携、使用方便、结构紧凑、高效、可靠。与其他数据库管理系统不同，SQLite的安装和运行非常简单，在大多数情况下-只要确保SQLite的二进制文件存在即可开始创建、连接和使用数据库。如果您正在寻找一个嵌入式数据库项目或解决方案，SQLite是绝对值得考虑。 | https://github.com/sqlite/sqlite |  |
| 29 | Cassandra | ApacheSoftwareFoundation | 列 | 分布式 | 2008 |  Securitypolicy | Cassandra是一套开源分布式NoSQL数据库系统。它最初由Facebook开发，用于储存收件箱等简单格式数据，集GoogleBigTable的数据模型与AmazonDynamo的完全分布式的架构于一身Facebook于2008将Cassandra开源，此后，由于Cassandra良好的可扩展性，被Digg、Twitter等知名Web2.0网站所采纳，成为了一种流行的分布式结构化数据存储方案。 | https://github.com/apache/cassandra |  |
| 30 | MariaDB | Mysql创始人 | 关系 | 集中式 | 2009 | GPL | MariaDB数据库管理系统是MySQL的一个分支，主要由开源社区在维护，采用GPL授权许可MariaDB的目的是完全兼容MySQL，包括API和命令行，使之能轻松成为MySQL的代替品。在存储引擎方面，使用XtraDB来代替MySQL的InnoDB。MariaDB基于事务的Maria存储引擎，替换了MySQL的MyISAM存储引擎，它使用了Percona的XtraDB，InnoDB的变体，分支的开发者希望提供访问即将到来的MySQL5.4InnoDB性能。这个版本还包括了PrimeBaseXT(PBXT)和FederatedX存储引擎。 | https://github.com/atcurtis/mariadb |  |
| 31 | Splunk | Splunk公司 | 搜索引擎 | 集中式 | 2012 |  Apache-2.0license | Splunk是一款日志分析软件，如果用户经常用grep、awk、sed、sort、uniq、tail、head来分析日志，那么就需要Splunk。它能处理常规的日志格式，如apache、squid、系统日志、mail.log等。它所采取的方法是对所有日志先进行index，然后可以交叉查询，并支持复杂的查询语句，然后通过直观的方式表现出来。该工具支持多种日志收集方法。用户的日志可以通过文件方式传到Splunk服务器，也可以通过网络实时传输过去，或者是分布式的日志收集。目前，这款软件分为免费版本和专业版本两种方式向用户提供服务。 | https://github.com/splunk |  |
| 32 | AmazonDynamoDB | 亚马逊 | 文档 | 集中式 | 2007 | AmazonDynamoDB | 亚马逊dynamodb是一个开源软件，主要用于快速、精确地创建具有实时三维图像、视频和动画等媒体的多格式文档。它可以与MSI、AECTEA-GWT、EGG、GRID等传统的Adobe公司产品兼容，并且能够直接与Photoshop、Flash、SWF等软件整合。 | https://github.com/pynamodb/PynamoDB |  |
| 33 | Hive | Facebook | 关系 | 集中式 | 2012 |  Apache-2.0license | Hive是由Facebook开源，用于解决海量结构化日志的数据统计工具。<br>Hive是基于Hadoop的一个数据仓库工具，可以将结构化的数据文件映射为一张表，并提供类SQL查询功能。其本质是：将SQL转化成MapReduce程序<br>1）Hive处理的数据存储在HDFS<br>2）Hive分析数据底层的实现是MapReduce<br>3）执行程序运行在Yarn上 | https://github.com/apache/hive |  |
| 34 | Teradata | Teradata天睿公司 | 关系 | 分布式 |  |  MITlicense | Terdata是一个专门为大型仓库应用程序设计的关系数据库管理系统，它基于大规模并行处理(MassivelyParallyProcessing，MPP)架构。它以AMP为基本单元，通过并行优化查询性能。AMPS(AccessModuleProcessor)是用于管理数据库的虚拟处理器。它们从解析器接收执行计划，并能够接收、操作和存储数据。在TeradataSystem中共享预先定义的AMP数量，以执行任务，包括查询、数据存储、备份、索引生成等。 | https://github.com/Teradata |  |
| 35 | Neo4j | Neo4j股份有限公司 | 图 | 集中 | 2003 | Viewlicense | Neo4j是一个开源的NoSQL图形数据库，2003年开始开发，使用scala和java语言，2007年开始发布。<br>是世界上最先进的图数据库之一，提供原生的图数据存储，检索和处理；采用属性图模型（Propertygraphmodel），极大的完善和丰富图数据模型；专属查询语言Cypher，直观，高效； | https://github.com/neo4j |  |
| 36 | HBase | Apache基金会 | 列 | 分布式 | 2008 |  Apache-2.0license | Hadoop(HBase)是一个开源的、基于列存储模型的分布式数据库，它是ApacheHadoop项目的一部分，开发语言为Java。HBase不同于一般的关系数据库，它是一个适合于非结构化数据存储的数据库。另一个不同的是HBase基于列的而不是基于行的模式。且具有高可靠性、高性能、可伸缩、并建立在关系模型基础上的分布式数据库。HBase是GoogleBigtable的开源实现，类似GoogleBigtable利用GFS作为其文件存储系统，用以存储大规模结构化数据。HBase利用HadoopHDFS作为其文件存储系统；Google运行MapReduce来处理Bigtable中的海量数据，HBase同样利用HadoopMapReduce来处理HBase中的海量数据；GoogleBigtable利用Chubby作为协同服务，HBase利用Zookeeper作为对应。 | https://github.com/apache/hbase |  |
| 37 | InfluxDB |  | 时序 | 集中式 | 2013 |  MITlicense | InfluxData是开源时间序列数据库InfluxDB的创建者。 它专为处理物联网设备和传感器、应用程序、容器、虚拟机和网络产生的大量时间戳数据而设计。借助InfluxDB，开发人员可以快速、大规模地为IoT、分析和云原生服务构建实时应用程序。<br>InfluxData专注于开发人员的幸福感，并随时随地与开发人员会面-使用他们选择的语言，使用他们喜欢的工具以及他们构建应用程序的任何地方：在云中、本地或本地。InfluxData还致力于帮助开发人员更快地启动和运行，以便他们可以专注于其他事情。 | https://github.com/influxdata/influxdb |  |
| 38 | ClickHouse | Yandex | 列 | 分布式 | 2016 | Apache-2.0license | ClickHouse是一个开源的，面向列的MPP架构数据分析数据库（大规模并行处理），由俄罗斯Yandex为OLAP和大数据用例创建。<br>查询速度非常快，每台服务器每秒处理上亿或上百亿行的数据。<br>可以充分利用硬件多线程实现单个查询的分支处理性能超过每秒2tb<br>数据存储经过压缩，能够减少io<br>存储引擎强大 | https://github.com/ClickHouse |  |
| 39 | 云树Shard(DBLE) | 上海爱可生信息技术股份有限公司 | 关系 | 分布式、OLTP |  | GPL-2.0 | 云树®Shard(DBLE)是一个高性能、高可靠性，可弹性扩展的分布式数据库中间件，负责SQL解析、优化、路由、分发、合并等操作，可灵活构建不同规模的数据库集群，通过将业务数据分片到不同的数据库存储节点中，充分利用各节点的计算资源，极大地提高了数据库的性能。云树®Shard(DBLE)支持MySQL协议和语法，提供可视化安装部署配置管理、高可用、自动水平拆分备份恢复、监控、不停机扩容等全套解决方案，适用于高并发及TB级海量数据场景。 |  |  |
| 40 | loTDB | 清华 | 时序 | 集中式，分布式 | 2016 |  MITlicense | IoTDB是清华大学主导的Apache孵化项目，是一款聚焦工业物联网、高性能轻量级的时序数据管理系统，提供数据采集、存储、分析的功能。IoTDB提供端云一体化的解决方案，在云端，提供高性能的数据读写以及丰富的查询能力，针对物联网场景定制高效的目录组织结构，并与ApacheHadoop、Spark、Flink等大数据系统无缝打通；在边缘端，提供轻量化的TsFile管理能力，端上的数据写到本地TsFile，并提供一定的基础查询能力，同时支持将TsFile数据同步到云端。<br><br>IoTDB具备低存储成本、高速数据写入（百万数据点秒级写入）、快速查询（TB级数据毫秒级查询）、功能完备（数据的增删改查、丰富的聚合函数、相似性匹配）、查询分析一体化（一份数据，满足实时查询与分析挖掘）、简单易用（采用标准的JDBC接口、类SQL查询语言）等特点。<br><br>基准测试表明IoTDB读写性能均优于现有的时序数据库InfluxDB、OpenTSDB、Cassandra以及GE的工业大数据平台Predix。根据中国软件评测中心和中国人民大学的性能对标测试，IoTDB的各项性能指标均明显优于当今国际最优的时序数据库系统。 | https://github.com/Felamande/lotdb |  |
| 41 | OushuDB | 偶数科技 | 关系 | 分布式，云原生，OLAP |  |  | OushuDatabase（简称OushuDB）是一款高性能云原生数据仓库，由国人自主研发、符合信创标准；OushuDB通过计算存储分离架构解决了传统数据仓库高成本、高门槛、难维护、难拓展的问题。同时支持各大公有云和私有云。<br>云原生：采用计算存储分离架构，利用云服务器、分布式存储，对数据基础设施的可扩展性进行深度优化，充分满足云端应用高度弹性、无限扩容的要求。支持腾讯云、阿里云、华为云、金山云、微软Azure、AWS等主流云平台。<br>高性能：面向PB级大数据的复杂查询，相比传统MPP和SQL-on-Hadoop快一个数量级。全新设计的执行器让性能提升5~10倍，显著降低批处理和即席查<br>强兼容：具备完善的SQL标准和ACID特性，支持HDFS和多种对象存储的增删改查、以及偶数自研的Magma存储。兼容基于Oracle，PostgreSQL，Greenplum开发的应用，用户可以轻松实现不同数据基础设施的平稳迁移。<br>纯国产：OushuDB由国内顶尖工程师自主开发，符合国家信创标准。偶数研发团队曾主导国际顶级的数据库开源项目。 | https://github.com/oushu-io |  |
| 42 | gstore | 北京大学-王选计算机研究所 | 图 | 集中式 | 2017 |  BSD-3-Clauselicense | gStore是由北京大学-王选计算机研究所-数据管理实验室邹磊教授团队研发面向RDF知识图谱的开源图数据库系统。<br>不同于传统基于关系数据库的知识图谱数据管理方法，gStore原生基于图数据模型(NativeGraphModel)，维持了原始RDF知识图谱的图结构；其数据模型是有标签、有向的多边图，每个顶点对应着一个主体或客体。gStore将面向RDF的SPARQL查询，转换为面向RDF图的子图匹配查询，利用我们所提出的基于图结构的索引(VS-tree)来加速查询的性能。 | https://github.com/search?q=gstore |  |
| 43 | MatrixOne | 矩阵起源 | 关系 | 分布式，云原生，HTAP | 2021 | Apache-2.0license | MatrixOne是面向未来的超融合云和边缘原生DBMS，它通过简化的分布式数据库引擎支持跨多个数据中心、云、边缘和其他异构基础架构的事务、分析和流工作负载。<br>超融合引擎<br>单体引擎<br>单体数据库引擎旨在支持混合工作负载：事务性、分析性、流式处理、时间序列、机器学习等。<br>内置流媒体引擎<br>借助内置的流引擎，MatrixOne通过开创性的增量物化视图维护支持数据库内流处理。<br>云和边缘原生<br>与实际基础设施无关<br>MatrixOne支持不同位置和基础架构之间的无缝工作负载迁移和突发。<br>多站点主动/主动<br>MatrixOne通过优化的一致性协议提供行业领先的延迟控制。<br>极致性能<br>高性能<br>获得专利的矢量化执行支持的加速查询以及通过因式分解技术实现的最优计算下推策略。<br>强一致性<br>MatrixOne引入了一种跨存储引擎的全局、高性能分布式事务协议。<br>高可扩展性<br>通过分解的存储和计算实现无缝且无中断的扩展。 | https://github.com/matrixorigin/matrixone |  |
| 44 | KaiwuDB | 浪潮 | 时序 | 分布式，HTAP |  |  | KaiwuDB是浪潮集团控股的数据库企业，公司汇聚了全球顶尖的数据库人才，以多模数据库为核心产品，面向工业物联网、数字能源、交通车联网、智慧产业等各大行业领域，提供领先创新的数据服务软件。<br>KaiwuDB具有分布式计算、多模数据库架构、实时就地运算等核心技术；产品体系囊括自主研发多模数据库及数据服务平台等；KaiwuDB是一款包含时序引擎、通用事务引擎、超速分析引擎、内存实时引擎等多模引擎的数据库产品；具备就地计算、云原生、高速入库、极速查询、多中心、云边端同步、跨模计算、原生预测分析等特性，可一站式满足AIoT场景下数据管理需求及关键行业核心系统的自主可控及安全需求。 | https://github.com/search?q=KaiwuDB |  |
| 45 | CnosDB | 北京诺司时空科技 | 时序 | 集中式 | 2021 |  AGPL-3.0license | CnosDB是一个由社区驱动的开源时间序列数据库。CnosDB适用于各种时序场景，如服务器指标、应用程序指标、性能指标、函数接口调用指标、网络流量数据、探测器数据、日志、市场交易记录等。 | https://github.com/cnosdb/cnosdb |  |
| 46 | OpenMLDB | 第四范式 | 关系 | 集中式，OLTP | 2021 |  Apache-2.0license | OpenMLDB是一个面向机器学习应用提供正确、高效数据供给的开源数据库。除了超过10倍的机器学习数据开发效率的提升，OpenMLDB也提供了统一的计算与存储引擎减少开发运维的复杂性与总体成本。 | https://github.com/4paradigm/OpenMLDB |  |
| 47 | Yukon | 超图禹贡 | 空间 | 集中式 | 2020 |  MITlicense | 禹贡开源空间数据库Yukon支持二三维一体化的空间数据存储能力<br>禹贡开源空间数据库Yukon还支持与PostgreSQL的适配。<br>禹贡开源空间数据库Yukon提供对空间网格编码的支持，通过网格编码实现二三维空间数据的统一管理。<br>禹贡开源空间数据库的代码开源，数据格式开放，与openGauss社区携手，共建开源空间数据库根技术，共同推进空间数据库的国产化进程。<br>禹贡开源空间数据库Yukon已集成至SuperMapGIS11i(2022)产品，可通过SuperMapiManager实现一键部署，组件、桌面、服务器产品也提供了对禹贡的支持。 | https://github.com/wizguin/yukon |  |
| 48 | Tendis | 腾讯云 | 键值 | 分布式 | 2020 | Viewlicense | 云数据库Tendis是腾讯云自研、100%兼容Redis协议的数据库产品，作为一个高可用、高性能的分布式KV存储数据库，从访问时延、持久化需求、整体成本等不同维度的考量，完美的平衡了性能和成本之间的冲突，降低业务运营成本，提升研发效率。云数据库Tendis支持主从热备，提供自动容灾切换、数据备份、故障迁移、实例监控、在线扩容、数据回档等全套的数据库服务。 | https://github.com/Tencent/Tendis |  |
| 49 | TerarkDB | 字节 | 关系 | 集中式，OLTP | 2020 | Apache-2.0,Unknownlicensesfound | TerarkDB是RocksDB的替代品，具有优化的尾部延迟、吞吐量和压缩等。在大多数情况下，您可以将现有的RocksDB实例迁移到TerarkDB，没有任何缺点。 | https://github.com/bytedance/terarkdb |  |
| 50 | NebulaGraph |  | 图 | 分布式，云原生 | 2019 |  Apache-2.0license | NebulaGraph是一款开源的、分布式的、易扩展的原生图数据库，能够承载包含数千亿个点和数万亿条边的超大规模数据集，并且提供毫秒级查询。<br>主要特征：<br>对称分布<br>存储计算分离<br>水平可扩展性<br>RAFT协议强数据一致性<br>与OpenCypher兼容的查询语言<br>基于角色的访问控制以实现更高级别的安全性<br>不同类型的图形分析算法 | https://github.com/vesoft-inc/nebula |  |
| 51 | Kvrocks | 美图 | 键值 | 集中式 | 2019 |  Apache-2.0license | Kvrocks是基于RocksDB之上兼容Redis协议的NoSQL键值数据库，设计目标是提供一个低成本以及大容量的Redis服务，作为Redis在大数据量场景的互补服务，简单易用且业务迁移成本低。目前线上使用的公司包含:美图、携程、百度以及白山云等，在线上经过两年多大规模实例的验证。<br>Kvrocks主要功能<br>Redis协议，用户可以使用redis客户端访问kvrocks<br>命名空间，类似于redisdb，但每个命名空间使用令牌<br>复制，异步复制使用像MySQL这样的binlog<br>高可用，支持redissentinel在master或slave故障时进行failover<br>Kvrocks支持RedisString、List、Hash、Set、ZSet五种基本数据类型，以及Bitmap、Geo和自定义的SortedInt类型。当前支持大多数命令，也支持Pub/Sub、事务以及备份等功能。 | https://github.com/KvrocksLabs/kvrocks |  |
| 52 | BaikalDB | 百度 | 关系 | 分布式，OLAP | 2018 |  Apache-2.0license | BaikalDB是百度推出的一个分布式增强型结构化数据库系统。它支持PB级结构数据的顺序和随机实时读/写。BaikalDB兼容MySQL协议，支持MySQL风格的SQL方言，用户可以通过它无缝地将数据存储从MySQL迁移到BaikalDB。<br>BaikalDB提供MySQL接口，支持常用的SELECT，UPDATE，INSERT，DELETE语法。提供各种WHERE过滤、GROUPBY聚合，HAVING过滤，ORDERBY排序等功能，用户可以组合实现各种在线OLAP需求，具备秒级别的亿级数据扫描聚合能力。另外，为了满足各种业务的检索需求，该系统内置全文检索需求，满足大部分快速检索的业务场景。<br>此外BaikalDB还支持一些比较特色的功能，比如FullText索引，HyperLogLog，Bitmap功能，但由于百度内部分词库不开源，开源几乎没有现成好使的分词库，目前open出来只是最简单的单字切词。 | https://github.com/baidu/BaikalDB |  |
| 53 | CovenantSQL | 契约实验室 | 关系 | 集中式，OLTP | 2018 |  Apache-2.0license | CovenantSQL是个去中心化，不可篡改，结合共享经济的数据库。CovenantSQL不仅仅为ĐApp提供支持，并且同时支持传统App。在兼容传统SQL的同时，实现了高性能的可拓展性、安全性及保密性。用户可以完全控制及分享数据，而不需要担心数据安全及隐私问题。简单的迁移步骤及兼容全类型SQL保证了用户迁移成本降到最低。 | https://github.com/CovenantSQL/CovenantSQL |  |
| 54 | DingoDB | 九章云极 | 关系 | 集中式，OLAP | 2022 |  Apache-2.0license | DingoDB是新一代集分析与服务于一体的实时分析数据库HSAP(HybridServing&AnalyticalProcessing)，支持高频修改和查询、实时交互式分析、实时多维分析。<br>DingoDB借鉴了TP系统和AP系统各自的优点，在存储海量数据的同时，能够进行高并发的数据查询，实时的数据分析。数据从各种类型的渠道导入DingoDB，借助DingoDB的高并发查询，实时数据分析和多维分析的能力，来支撑政府和企业若干业务应用。 | https://github.com/dingodb/dingo-deploy |  |
| 55 | TensorBase | 北京致大尽微科技有限公司 | 关系 | 集中式，OLAP | 2020 | ApacheLicense2.0 | 开箱即用<br>在Rust中点亮快速的架构性能（真实世界的基准测试）<br>现代重新设计的柱状存储<br>高性能网络传输服务器<br>ClickHouse兼容语法<br>使用DBA-Freeops进行绿色安装<br>可靠性和高可用性(WIP)<br>集群(WIP)<br>云原生适配(WIP)<br>ArrowdataLake(…) | https://github.com/tensorbase/tensorbase |  |
| 56 | FlashDB | 阿明克 | 键值 | 集中式，OLTP | 2020 | ApacheLicense2.0 | 占用空间极小，ram使用量几乎为0；<br>支持多分区、多实例。当数据量较大时，可以细化分区，减少检索时间；<br>支持磨损平衡，延长Flash寿命；<br>支持断电保护功能，可靠性高；<br>支持string和blob两种KV类型，方便用户操作；<br>支持KV增量升级，产品固件升级后，KVDB内容也支持自动升级；<br>支持修改每条TSDB记录的状态，方便用户管理； | https://github.com/armink/FlashDB |  |
| 57 | TenDBCluster | 腾讯游戏 | 关系 | 分布式，OLTP | 2020 |  GPL-2.0and2otherlicensesfound | TenDBCluster是腾讯游戏CROSDBA团队提供的MySQL分布式关系型数据库解决方案，主要包括兼容MySQL协议、透明分库分表、负载均衡、高可用、在线扩展等特点。业务开发可以仅专注于业务逻辑的开发和运营，无需编写数据分片逻辑，在海量用户并发情况下也无须关心DB存储层的负载压力。 | https://github.com/Tencent/TenDBCluster-TenDB |  |
| 58 | openGemini | 华为 | 时序 | 集中式，分布式 | 2022 |  Apache-2.0license | 灵活的部署<br>openGemini提供单节点和分布式集群版本，可以部署在物理机器、虚拟机或云上。<br>高扩展<br>openGemini的ts_sql和ts_store模块可以根据需要单独扩展。可以自动检测新节点并将其添加到相应的集群中。<br>易于学习<br>openGemini支持SQL，并与InfluxDB数据协议和接口兼容。<br>高性能<br>openGemini可以管理大量的时间序列，并在运维和监控期间支持复杂的数据查询和分析，帮助您存储大量数据并处理工业物联网行业的高读/写吞吐量。 | https://github.com/openGemini/openGemini |  |
| 59 | IvorySQL | 瀚高 | 关系型 | 集中式 | 2021 | Apache-2.0license | 开源<br>没有厂商的限制。<br>基于PostgreSQL<br>基于PostgreSQL，具有完整的SQL、坚如磐石的可靠性和庞大的生态系统.<br>瀚高支持<br>由领先的PostgreSQL数据库提供商瀚高软件提供支持。<br>兼容Oracle<br>将Oracle数据库迁移到IvorySQL。<br>可定制化<br>只需下载代码，并按照你的想法自定义。 | https://github.com/IvorySQL/IvorySQL |  |
| 60 | PinusDB | 长沙巨松 | 时序 | 集中式 | 2019 | GPL-3.0license | 高压缩比<br>针对时序数据的特点，采用独特的压缩算法，大大降低历史数据存储空间，一般能将数据存储空间压缩到原来的10%甚至更低。<br>高性能<br>具备高效的读写能力，普通PC机写入性能超过20万条/秒；支持交互式查询。<br>大容量<br>单表存储千亿级数据量。<br>强大的历史数据管理<br>数据库将数据以天为单位存储为一个个单独的文件。并且，可以以天为单位对历史数据进行删除、附加、分离等操作。<br>简单易用<br>基于类似关系库表的数据模型，理解、使用更简单。用户使用类似标准SQL进行数据操作，数据筛选、统计更方便。 | https://github.com/pinusdb/pinusdb |  |
| 61 | TiKV | PingCAP | 键值 | 分布式 | 2015 | Apache-2.0license | 低且稳定的延迟<br>RawKV的平均响应时间小于1毫秒（P99=10毫秒）。<br>高扩展性<br>借助PlacementDriver和精心设计的Raft组，TiKV具有出色的水平扩展能力，可以轻松扩展到100+TB的数据。横向扩展您的TiKV集群以适应数据大小的增长，而不会对应用程序产生任何影响。<br>便于使用<br>运行一个命令来部署一个包含生产环境所需的一切的TiKV集群。使用TiUP或TiKV运算符轻松扩展或扩展集群。<br>易于维护<br>TiKV基于GoogleSpanner和HBase的设计，但更易于管理，不依赖任何分布式文件系统。<br>一致的分布式事务<br>与谷歌的Spanner类似，TiKV（TxnKV模式）支持外部一致的分布式事务。<br>可调节的一致性<br>在RawKV和TxnKV模式下，您可以自定义一致性和性能之间的平衡。 | https://github.com/tikv/tikv |  |
| 62 | He3DB | 移动云 | 关系型 | 云原生，OLTP |  |  MulanPSL-2.0 | 云上一般小型业务比较看重低成本，更偏向于使用RDS数据库服务。而中大型业务对性能或者可用性要求更高，而不得不选择云原生数据库。当前各大云厂商的云原生数据库从产品力的角度看已经大幅领先RDS，但是市场占有率RDS依然占据大头，最重要的原因就是RDS成本优势。我们团队认为RDS成本和云原生数据库产品力之间存在一个权衡，而正是这种权衡，让我们决定研发He3DB,我们对He3DB的定位既能向下占据部分RDS市场，又能向上承接部分云原生数据库业务。<br>He3DB不会一味的追求更大，更快，更强，而是会设置一个产品力上限，而这个上限能够满足移动云绝大多数用户使用场景，在这个前提下，我们会把降低成本作为He3DB持续追求的目标。 | https://gitee.com/he3db/he3pg?_from=gitee_search |  |
| 63 | LinDB | 饿了么 | 时序 | 分布式 | 2019 | Apache-2.0license | 高性能<br>LinDB参考了其他时序数据库里的最佳实践，并且在此基础上做了些优化。和InfluxDB中的Continuous-Query不一样，在创建数据库之后，LinDB支持根据指定的时间间隔自动对数据进行rollup。不仅如此，LinDB在并行查询和计算分布式时序数据方面速度相当快。<br>原生的多活支持<br>LinDB在设计阶段就是为了在饿了么的多活系统架构下工作的。LinDB的计算层（brokers）支持高效的跨机房聚合查询。<br>高可用<br>LinDB使用ETCD集群以保证元数据的高可用和存储安全（也支持单机模式启动）。当出现故障时，多通道复制的WAL协议可以避免数据的不一致情况：<br>1).任一复制通道只有一名成员负责数据的权威性，因此避免了数据冲突;<br>2).数据可靠性保障：只要先前的leader数据并未丢失，当其重新上线时，这些数据便将被复制到其他的副本中；<br>水平拓展性<br>LinDB使用了基于Series(Tags)的sharding策略，可以真正解决热点问题（另外也考验了系统设计的能力），简单的增加新的broker和storage节点即可实现水平拓展。<br>Metric的治理能力<br>为了保证系统的健壮性，LinDB并不假设所有用户都已了解metric使用的最佳实践。因此，LinDB提供了metric和tag粒度的限制能力，避免整体集群在部分用户错误的使用姿势下崩溃。 | https://github.com/lindb/lindb |  |
| 64 | 红象数据库 | redelephant | 关系 | 集中式，OLTP |  |  | 红象数据库是由RedElephant2020团队在开源PostgreSQL的基础上研发的一款以去O为目标的数据库产品。<br>红象数据库的设计初衷是将应用程序使用的各类Oracle数据库对象及数据平滑地迁移至红象数据库，并利用PostgreSQL生态中经过大规模部署、使用和验证的接口、工具、扩展、方案等，在进行二次开发基础上为用户提供专业化的数据库服务，从而达到替换Oracle的目的 |  |  |
| 65 | Perst | 俄罗斯 | 关系 | 集中式 | 2023 | Viewlicense | Perst是McObject的开源、双重许可、面向对象的嵌入式数据库系统(ODBMS)。它有一个版本作为全Java嵌入式数据库开发，另一个版本以C#实现（用于Microsoft.NETFramework应用程序）。Perst使开发人员能够在其应用程序中以最快的速度以及低内存和存储开销存储、排序和检索对象，同时利用Java和C#的面向对象范例。 | https://github.com/search?q=Perst |  |
| 66 | DataScript | 俄罗斯 |  | 集中式 | 2014 | EPL-1.0license | DataScript的目的是成为客户端应用程序的基本构建块，需要在其生命周期内跟踪大量状态。有很多好处：集中、统一的方法来管理所有应用程序状态。处理状态的客户端变得解耦和独立：渲染、服务器同步、撤消/重做不会相互干扰。即使在单线程浏览器环境中，不变性也可以简化事情。跟踪应用程序状态演变，回退到任何时间点，始终呈现一致的状态，在后台同步而不锁定任何人。Datalog查询引擎可回答有关当前应用程序状态的重要问题。用于跟踪进出数据库的数据的结构化格式。也可以针对它运行数据日志查询。 | https://github.com/tonsky/datascript |  |
| 67 | AlaSQL | 俄罗斯 | 关系 | 集中式 | 2014 | MITlicense | 用JavaScript编写，不使用浏览器WebSQL数据库<br>是功能齐全的紧凑型sql服务器，具有JOIN、GROUP、UNION、ANY、ALL、IN、子查询和非常有限的事务支持<br>支持ROLLUP()、CUBE()和GROUPINGSETS()函数<br>适用于所有现代版本的浏览器（Chrome、Firefox、IE、Safari）、Node.js以及移动iOS和Android<br>用了一些优化方法，运行快速 | https://github.com/AlaSQL/alasql |  |
| 68 | RedDatabase | RedSoft | 关系 | 集中式 |  |  | 支持所有主要平台和操作系统（包括：Windows2000/XP/2003/Vista、Linux家族、BSDUnix、IBMAIX、HP-UX、SunSolaris等）；<br>支持64位系统<br>支持多处理器和多核硬件平台<br>高性能——RedDatabase直接与MicrosoftSQLServer2005、Oracle10g、PostgreSQL8等数据库竞争，而RedDatabase在价格类别上更加灵活；<br>能够将数据库存储在单个文件中<br>“热”数据库备份和增量备份（仅复制从先前副本更改的部分数据库，而不是整个数据库），包括使用硬件备份解决方案；<br>几乎所有使用的开发环境（ODBC、JDBC、C/C++、C#、Java、Delphi、PHP、Python、Perl、VB等）的接口模块的可用性，这些模块的测试结果和保证稳定运行；<br>能够以DLL的形式在“嵌入式​​”软件（嵌入式）本地模式下工作，而无需单独安装和配置DBMS，包括对嵌入Java虚拟机的支持；<br>与以前版本的Firebird数据库向后兼容；<br>多版本架构；<br>满足大多数ISO/ANSISQL要求<br>模块化架构；<br>小型数据库的硬件要求低<br>通过模块扩展DBMS本身功能的大量机会；<br>内核最初基于多版本架构(MGA)（在其他DBMS中仅在以后的版本中出现，例如MSSQLServer2005、PostgreSQL6.5）；<br>完全符合原子性、一致性、绝缘性、耐久性（ACID）的原则。 | https://github.com/vsocrates/reddatabase |  |
| 69 | Akumuli | Apache | 列 | 集中式 | 2014 | Apache-2.0license | Akumuli是现代硬件的时间序列数据库。它可用于实时捕获、存储和处理时间序列数据。“akumuli”这个词可以从世界语翻译为“积累”。<br>主要特征：<br>面向列的存储。<br>基于具有多版本并发控制的新型LSM和B+tree混合数据结构（无并发错误，并行写入，针对SSD和NVMe进行了优化）。<br>支持指标和事件。<br>快速高效的压缩算法，优于“大猩猩”时间序列压缩。<br>碰撞安全和恢复。<br>快速聚合，无需预先配置的汇总或物化视图。<br>许多查询可以在不解压缩数据的情况下执行。<br>最近数据的压缩内存存储。<br>可用作服务器应用程序或嵌入式库。<br>基于JSON和HTTP的简单API。<br>快速范围扫描和连接，读取速度不依赖于数据库基数。<br>快速数据摄取：<br>在具有8核32GBRAM（仅使用6核）的DigitalOceanDroplet上每秒540万次写入<br>在具有8核32GBRAM（6核启用WAL）的DigitalOceanDroplet上每秒460万次写入<br>在32核IntelXeonE5-2680v2（c3.8xlargeEC2实例）上每秒1610万次写入。<br>查询是延迟执行的。只要客户端读取它们，就会产生查询结果。<br>压缩算法和输入解析器在每次代码更改时都经过模糊测试。<br>Grafana数据源插件。<br>用于时间序列查找的快速紧凑的倒排索引。 | https://github.com/akumuli/Akumuli |  |
| 70 | TingoDB | 俄罗斯 | 键值 | 集中式 |  |  | TingoDB是用于Node.js和node-webkit的嵌入式JavaScriptNoSql数据库。它的API和功能旨在向上兼容MongoDB及其Node.js驱动程序。认真考虑这一点。它不仅仅是一种MongoDBAPI，因为它使用相同的查询语法。它是精确的副本，允许构建可以透明地支持MongoDB和轻量级嵌入式数据引擎的应用程序。甚至可以采用一些依赖于MongoDB的衍生库。很好的例子是Mongoose.jsODM库，可以使用Tungus驱动程序与TingoDB连接。<br><br>当前支持的功能集包括搜索、索引、原子更新、分组、map-reduce。以上所有内容都在纯JavaScript中，没有二进制依赖项，其性能可与原生MongoDB相媲美，当然前提是在合理大小的数据集上使用它。<br><br>应用领域<br>我们确实认为，TingoDB的目标必须介于普通键值存储和成熟的NoSQL解决方案之间。当您在NodeJS项目的轻量级数据库中需要中小型应用程序需求时，请考虑使用它。但请记住，您总是可以在需要时成长。<br><br>MongoDB兼容API<br>对于TingoDB实现的功能，它通过100%与MongoDB兼容的API公开它们。作为此声明的证明，所有测试都旨在使用其本机驱动程序和TingoDB在MongoDB上运行。更多其他重要的测试部分来自NodeJS驱动程序项目。<br><br>索引<br>TingoDB支持存储在内存中的B树索引。索引用于搜索查询优化并模仿MongoDB索引（备用、唯一等）。尚不支持复合索引。<br><br>搜索、排序、分组和MapReduce<br>支持全套MongoDB搜索运算符。嵌入式数组同时支持搜索和索引。完全支持排序，并尽可能使用索引。分组和MapReduce的工作方式与设计一样。<br><br>原子更新和并发访问<br>NodeJS不是多线程应用程序，但仍然使用异步方法，您可以并行处理许多事情。TingoDB对于这种使用是安全的，并且支持原子更新，就像它的老大哥一样。<br><br>安全持久<br>TingoDB使用仅附加文件来存储集合文档。这可确保您永远不会丢失所有数据，并且可以在发生任何损坏时回滚到良好的副本。<br><br>合理的大数据集<br>TingoDB仅将内存用于索引和可选缓存。它使用文件访问操作加载集合文档。我们估计内存消耗与数据集大小的比率为1:100。这当然取决于数据库使用的索引数量。<br><br>合理的速度<br>TingoDB不是超级快，但在合理大小的数据集上非常接近您对MongoDB的期望。平均而言，我们估计它比MongoDB慢1到2倍，这对于纯JavaScript解决方案来说还不错。 | https://github.com/sergeyksv/tingodb |  |
| 71 | Elliptics | 支持Yandex的EvgeniyPolakov | 键值 | 分布式 | 2012 | LGPL-3.0license | Elliptics是一种具有开源代码的分布式键值数据存储。默认情况下，它是一个经典的分布式哈希表(DHT)，多个副本放在不同的组中（分布式哈希）。Elliptics的创建是为了在存储大量中型和大型文件（1KB到千兆字节，数千到数十亿个对象）时满足多数据中心和物理分布式存储位置的要求。<br>主要特点：<br>分布式哈希表，无元数据服务器，真正的水平扩展<br>数据复制——副本可以存储在不同的物理位置<br>范围和批量请求<br>不同的I/O存储后端，API来创建自己的低级存储后端<br>在删除或添加节点的情况下自动重新分区数据<br>最终持续恢复<br>一致的哈希寻址模型<br>集群统计<br>前端：HTTP；绑定：C/C++、Go、Python<br>服务端脚本执行支持（写触发模拟）<br>带TTL的分布式SLRU缓存<br>P2P流支持（仅限eblob和文件后端-NginxWeb服务器等外部应用程序可以将数据从eblob对象文件直接流式传输到客户端，无需代理） | https://github.com/reverbrain/elliptics |  |
| 72 | YDB | Yandex | 关系 | 分布式 |  | Viewlicense | YDB（YandexDatabase）是一个基于Postgres的分布式NewSQL关系型DBMS。<br>真正的弹性可扩展性<br>添加或删除节点以根据需要轻松扩展和缩减。事实证明，YDB可以在实际生产中使用每秒数百万个事务和PB级数据，用于任务关键型实时应用程序。<br>容错<br>YDB设计为在三个可用区工作，即使节点或可用区离线也能确保可用性。<br>便于使用<br>YDB将强一致性、ACID事务、高性能查询、快速数据摄取与熟悉的SQL方言和JSONAPI支持相结合。适用于任何现代工作负载：键值、关系、JSON。<br>自动容灾<br>在磁盘、服务器甚至数据中心发生故障后自动恢复，将应用程序的延迟中断降至最低。<br>可在任何云中使用<br>YDB可用于自我部署，包括Kubernetes、本地和云环境。<br>开源<br>在Apache2.0下获得许可。<br>没有云或供应商锁定的风险。 | https://github.com/search?q=YDB |  |
| 73 | EJDB | Softmotions | 文档 | 集中式 |  | MITlicense | ClickHouse®是一个开源的面向列的数据库管理系统，可以实时生成分析数据报告。 | https://github.com/search?q=EJDB |  |
| 74 | libmdbx | PositiveTechlologies |  |  |  | Viewlicense | libmdbx是从LMDB派生的嵌入式事务键值DBMS。libmdbx于2015年作为LMDB的一个分支开始。源代码存储库于2019年从Github转移到ABF，以抗议对俄罗斯实施的国际制裁。 | https://github.com/search?q=libmdbx |  |
| 75 | Synergy-DB | RFNC-VNIIEF全俄实验物理研究所（联邦核中心） |  | 集中式 |  |  | DBMS“Synergy-DB”提供对具有不同保密级别的数据的多用户访问。它能够与两个国产操作系统——Synergy-OSv.1.0和AstraLinux特别版——进行交互，通过安全提供商获取有关用户凭据的信息。<br>开发人员将系统的技术特征称为权限自由区分和强制访问控制、识别和身份验证、独立于系统日志记录的安全事件注册模块、使用后清理RAM和磁盘内存以及其他工具修改以满足保护信息免受未经授权的访问。<br><br>该解决方案的优点之一是开发人员调用安全提供程序的模块化结构，因此可以在不修改源代码的情况下灵活扩展支持的操作系统列表。 | https://github.com/search?q=Synergy-DB |  |
| 76 | Xodus | 俄罗斯 |  | 集中式 |  | Apache-2.0license | Xodus是事务性的并且完全符合ACID。<br>Xodus是高度并发的。由于MVCC和真正的快照隔离，读取是完全非阻塞的。<br>Xodus是无模式且敏捷的。它不需要架构迁移或重构。<br>Xodus是嵌入式的。它不需要安装或管理。<br>Xodus是用纯Java和Kotlin编写的。<br>Xodus是免费的，并在Apache2.0下获得许可。 | https://github.com/search?q=Xodus |  |
| 77 | Sophia | 俄罗斯 |  | 集中式 | 2013 | Viewlicense | 完全只追加的MVCC的存储引擎，旨在快速地进行写操作，并优化了读操作；<br>支持ACID事务，基于快照隔离而实现的真正轻量级事务控制；<br>支持异步，能够选择阻塞或非阻塞的方式执行事务处理过程；<br>支持压缩，最少两到十倍压缩比率，压缩算法包括LZ4、ZSTD；<br>基于BSD开源协议开源 | https://github.com/pmwkaa/sophia |  |
| 78 | Consus | KonstantinKnizhnik |  | 集中式 | 2016 | BSD-3-Clauselicense | 纯Java<br>JDBC<br>SQL89/92<br>单个文件<br>交易<br>便于使用<br>非常快 | https://github.com/rescrv/Consus |  |
| 79 | Lira-R | 俄罗斯 |  | 集中式 |  |  | 企业范围的系统中存储和处理数据；<br>支持SQL语言标准ANSISQL-92、SQL-99、SQL:2003、SQL:2011；<br>高效处理各种类型的数据，包括复合数据和几何数据；<br>支持非关系数据类型XML、JSON和JSONB；<br>SQL查询的并行执行；<br>声明性表分区；<br>使用SCRAM-SHA-256算法进行密码验证；<br>支持全文搜索，包括俄语；<br>根据发布-订阅模型的内置逻辑复制方式。 | https://github.com/search?q=Lira-R |  |
| 80 | EaseDB | AlexanderShakhmatov |  | 集中式 | 2013 | MITlicense | EaseDB会自动优化缓存性能以及任何内存层次结构上查询处理的整体性能。我们开发了一个可视化界面来显示EaseDB与其缓存意识对应物相比的详细性能，缓存意识算法和硬件平台中的参数都不同。 | https://github.com/X2rdas/easedb |  |
| 81 | vyhodb | IgorVykhodtsev |  | 集中式 | 2012 | MITlicense | vyhodb是用Java编写的支持可序列化事务的网络模型DBMS。<br><br>主要特点：<br>采用无模式方法的网络模型<br>具有SERIALIZABLE隔离级别的ACID事务<br>三种运行模式（单机、嵌入式、本地）<br>存储过程（用Java编写）<br>用于快速搜索子记录的索引<br>用于遍历数据模型的函数API<br>用于将Java对象映射到vyhodb数据模型的ONMAPI<br>vyhodb也很容易使用：<br><br>简单配置（一个属性文件）<br>自动扩展存储<br>“热”备份<br>主/从复制<br>负载均衡器和非容错集群<br>占用空间小(1.4mb) | https://github.com/igor-bul/vyhodb |  |
| 82 | ClickHouse | Yandex | 列 | 分布式 | 2016 | Apache-2.0license | 真正的列式数据库。没有任何内容与值一起存储。例如，支持常量长度值，以避免将它们的长度“number”存储在值的旁边。<br>线性可扩展性。可以通过添加服务器来扩展集群。<br>容错性。系统是一个分片集群，其中每个分片都是一组副本。ClickHouse使用异步多主复制。数据写入任何可用的副本，然后分发给所有剩余的副本。Zookeeper用于协调进程，但不涉及查询处理和执行。<br>能够存储和处理数PB的数据。<br>SQL支持。Clickhouse支持类似SQL的扩展语言，包括数组和嵌套数据结构、近似函数和URI函数，以及连接外部键值存储的可用性。<br>高性能。<br>使用向量计算。数据不仅由列存储，而且由向量处理（一部分列）。这种方法可以实现高CPU性能。<br>支持采样和近似计算。<br>可以进行并行和分布式查询处理（包括JOIN）。<br>数据压缩。<br>HDD优化。该系统可以处理不适合内存的数据。<br>用于数据库（DB）连接的客户端。数据库连接方式包括控制台客户端、HTTPAPI，或者各种编程语言的wrapper（可以用的有Python、PHP、NodeJS、Perl、Ruby与R[18]语言）。ClickHouse也可以使用JDBC驱动。 | https://github.com/ClickHouse/ClickHouse |  |
| 83 | Solr | Apache基金会 | 搜索引擎 | 集中式 | 2006 | Apache-2.0license | Solr是基于ApacheLucene构建的流行、快速的开源搜索平台，可满足您所有的企业、电子商务和分析需求。<br>有关Solr项目、团队组成、源代码存储库和其他详细信息的完整描述，请访问Solr网站：https://solr.apache.org/<br><br>Solr的功能优势：<br>灵活的查询语法；<br>支持各种格式文件（Word，PDF）导入索引库；<br>支持数据库数据导入索引库；<br>分页查询和排序<br>Facet维度查询<br>自动完成功能<br>拼写检查<br>搜索关键字高亮显示<br>Geo地理位置查询<br>Group分组查询<br>SolrCloud | https://github.com/apache/solr |  |
| 84 | PostGIS |  | 空间 | 集中式 | 2005 | GPL-2.0 | PostGIS通过添加支持存储、索引和查询地理数据来扩展PostgreSQL关系数据库的功能。<br>PostGIS功能包括：<br>空间数据存储：在2D和3D数据中存储不同类型的空间数据，例如点、线、多边形和多几何图形。<br>空间索引：根据位置快速搜索和检索空间数据。<br>空间函数：范围广泛的空间函数，允许您过滤和分析空间数据、测量距离和面积、相交几何、缓冲等。<br>几何处理：用于处理和操作几何数据的工具，例如简化、转换和泛化。<br>栅格数据支持：栅格数据的存储和处理，例如高程数据和天气数据。<br>地理编码和反向地理编码：地理编码和反向地理编码的功能。<br>集成：使用QGIS、GeoServer、ArcGIS、Tableau和MapServer等第三方工具访问和使用PostGIS。 | https://github.com/postgis/postgis |  |
| 85 | Firebird | Firebird基金会 | 关系 | 集中式 | 2000 |  | Firebird是一个关系数据库，提供许多运行在Linux、Windows、MacOS和各种Unix平台上的ANSISQL标准功能。Firebird为存储过程和触发器提供出色的并发性、高性能和强大的语言支持。自1981年以来，它以各种名称用于生产系统。<br><br>Firebird项目是一个由C/C++程序员、技术顾问和支持者组成的商业独立项目，基于InpriseCorporation于2000年7月25日发布的源代码开发和增强多平台关系数据库管理系统。 | https://github.com/FirebirdSQL/firebird |  |
| 86 | Couchbase | Couchbase股份有限公司 | 文档 | 分布式 | 2011 |  | Couchbase是一个开源的分布式NoSQL文档数据库。它支持Memcached客户端协议，并提供了额外的功能，如磁盘持久性、数据复制。<br>灵活的<br>JSON意味着您的数据可以适应敏捷的工作流程和不断变化的需求。多模型意味着您可以将多种数据技术整合到一个Couchbase数据库中。<br>人类可读的JSON标准数据<br>内置键值、SQL++、索引、全文搜索、分析和事件<br>灵活的建模和访问支持迭代、敏捷的开发周期<br>快速地<br>Couchbase有一个内置的托管缓存来启用内存优先架构。读写操作以RAM的速度运行。<br>微秒级延迟和快如闪电的性能<br>轻松横向扩展以适应不断增长的工作负载<br>自动分片、自动故障转移和自动复制<br>熟悉的<br>Couchbase汇集了最好的NoSQL文档数据库和关系数据库。<br>SQL++引擎支持对JSON数据进行SQL查询<br>SDK和SQL++中的ACID事务以增强数据一致性<br>范围和集合提供类似于关系模式和表的数据组织级别<br>超过11种语言的SDK以及各种扩展和集成 | https://github.com/couchbase |  |
| 87 | Memcached | DangaInteractive | 键值 | 分布式 | 2003 | BSD-3-Clause | 简单来说CouchBase是一款开源的，分布式的nosql数据库，主要用于分布式缓存和数据存储领域。能够通过managecache提供快速的亚毫米级别的k-v存储操作，并且提供快速的查询和其功能强大的能够指定SQL-like查询的查询引擎。<br><br>CouchBase是在memcached和redis之类缓存组件的基础上发展而来的，被称作为可能是好的缓存系统。所其必然能满足之前的前辈所满足不了的地方。<br>传统的缓存组件包括memcached和redis有着这种或者那种的缺点：<br><br>Cluster支持完善度不够或者直接没有Cluster<br>没有良好的高可用性机制，持久化支持的亦不是很完善<br>扩容和故障恢复能操作维护复杂<br><br>其他<br>而CouchBase则对上面的一些缺点都有着良好的支持。或者说<br>CouchBase所提供的任何单一功能，在市面上基本上都能找到一款数据库能够满足。但是这些数据库实际使用的话总是会有各种各样的妥协，性能很好的话，扩展性可能很差之类的。而CouchBase的目标就是建立一个大一统，各种功能都包含可用，所谓接近完美的数据库。 | https://github.com/memcached/memcached |  |
| 88 | SparkSQL | Apache基金会 | 关系 | 集中式 | 2014 | Apache-2.0 | SparkSQL是ApacheSpark用于处理结构化数据的模块。<br>融合<br>将SQL查询与Spark程序无缝混合。<br>SparkSQL允许您使用SQL或熟悉的DataFrameAPI在Spark程序中查询结构化数据。可用于Java、Scala、Python和R。<br><br>统一数据访问<br>以相同的方式连接到任何数据源。<br>DataFrames和SQL提供了一种访问各种数据源的通用方法，包括Hive、Avro、Parquet、ORC、JSON和JDBC。您甚至可以连接这些来源的数据。<br><br>蜂巢集成<br>在现有仓库上运行SQL或HiveQL查询。<br>SparkSQL支持HiveQL语法以及HiveSerDes和UDF，允许您访问现有的Hive仓库。 | https://github.com/apache/spark |  |
| 89 | Impala | Cloudera | 关系 | 分布式 | 2013 | Apache-2.0 | 对存储在ApacheHadoop集群中的PB级数据进行闪电般快速的分布式SQL查询。<br>Impala是一种现代、大规模分布式、大规模并行的C++查询引擎，可让您分析、转换和组合来自各种数据源的数据：<br>同类最佳的性能和可扩展性。<br>支持存储在HDFS、ApacheHBase、ApacheKudu、AmazonS3、AzureDataLakeStorage、ApacheHadoopOzone等中的数据！<br>广泛的分析SQL支持，包括窗口函数和子查询。<br>即时代码生成使用LLVM生成专门针对每个单独查询量身定制的闪电般快速的代码。<br>支持最常用的Hadoop文件格式，包括ApacheParquet和ApacheORC。<br>支持行业标准安全协议，包括Kerberos、LDAP和TLS。<br>Apache许可，100%开源。 | https://github.com/apache/impala |  |
| 90 | CouchDB | Apache基金会 | 文档 | 集中式 | 2005 | Apache-2.0 | ApacheCouchDB是开源NoSQL文档数据库，用于收集和存储JSON文档格式的数据。与关系数据库不同，CouchDB使用无模式数据模型，简化了各种计算设备、手机和Web浏览器中的记录管理。<br>CouchDB于2005年推出，并于2008年成为Apache软件基金会（链接位于ibm.com外部）的一个项目。作为开源项目，CouchDB由一个活跃的开发人员社区提供支持，他们专注于易用性和web应用，持续改进该软件。 | https://github.com/apache/couchdb |  |
| 91 | Presto | Facebook | 关系 | 分布式 | 2013 | Apache-2.0 | 基于内存的并行计算，Facebook推出的分布式SQL交互式查询引擎多个节点管道式执行<br>支持任意数据源数据规模GB~PB是一种Massivelyparallelprocessing（mpp）(大规模并行处理)模型<br>数据规模PB不是把PB数据放到内存，只是在计算中拿出一部分放在内存、计算、抛出、再取。<br>主要特点：多数据源、支持SQL、扩展性（可以自己扩展新的connector）、混合计算（同一种数据源的不同库or表；将多个数据源的数据进行合并）、高性能、流水线（pipeline） | https://github.com/prestodb/presto |  |
| 92 | ApacheFlink | Apache基金会 | 关系 | 集中式 | 2014 | Apache-2.0 | ApacheFlink是一个开源的流处理框架，具有强大的流处理和批处理能力。<br>在https://flink.apache.org/了解更多关于Flink的信息。<br>主要特征：<br>支持批处理和数据流程序的流优先运行时；<br>优雅流畅的Java和ScalaAPI；<br>同时支持极高吞吐量和低事件延迟的运行时；<br>基于数据流模型，支持DataStreamAPI中的事件时间和乱序处理；<br>跨不同时间语义（事件时间、处理时间）的灵活窗口（时间、计数、会话、自定义触发器）；<br>具有恰好一次处理保证的容错；<br>流媒体程序中的自然背压<br>用于图形处理（批处理）、机器学习（批处理）和复杂事件处理（流处理）的库；<br>DataSet（批处理）API中对迭代程序(BSP)的内置支持；<br>自定义内存管理，用于在内存和核外数据处理算法之间进行高效、稳健的切换；<br>ApacheHadoopMapReduce的兼容层；<br>与YARN、HDFS、HBase和ApacheHadoop生态系统的其他组件集成； | https://github.com/apache/flink |  |
| 93 | OpenSearch | 亚马逊 | 搜索引擎 | 集中式 | 2021 | Apache-2.0 | OpenSearch是Elasticsearch和Kibana在2021年初许可证变更后由社区驱动的开源分支。我们希望维持（并发展！）一个搜索和分析套件，供依赖所授予权利的众多企业使用按原版，Apachev2.0License。<br>OpenSearch在ApacheLicense版本2.0(ALv2)下作为完全开放源代码分发，无需许可费用。用户可以自由部署、增强和扩展他们认为合适的软件。<br>OpenSearch项目社区在公共存储库中维护OpenSearch代码库并邀请公众贡献，没有贡献者许可协议或其他构建和协作障碍。<br>OpenSearch得到用户和供应商社区的支持。OpenSearch用户可以为自己的利益添加或改进工具集，或者将他们的改进贡献回社区。<br>OpenSearch支持分布式处理，允许用户水平扩展资源以增加容量和性能。高度可配置的部署拓扑允许OpenSearch用户微调其集群的成本性能。用户可以从单一界面添加和管理节点和集群，使资源与需求保持一致。由OpenSearch合作伙伴<br>组成的多元化生态系统提供了丰富的OpenSearch支持解决方案以及咨询服务，以帮助社区从OpenSearch工具中提取附加值。 | https://github.com/opensearch-project/OpenSearch |  |
| 94 | Greenplum | Pivotal | 关系 | 分布式 | 2005 |  Apache-2.0 | Greenplum数据库(GPDB)是一个基于PostgreSQL的高级、功能齐全的开源数据仓库。它提供对PB级数据量的强大而快速的分析。Greenplum数据库专门面向大数据分析，由世界上最先进的基于成本的查询优化器提供支持，可在大数据量上提供高分析查询性能。<br>Greenplum项目是在Apache2许可下发布的。我们要感谢我们过去和现在的所有社区贡献者，并且对所有新的潜在贡献都非常感兴趣。对于Greenplum数据库社区，没有贡献太小，我们鼓励所有类型的贡献。 | https://github.com/greenplum-db/gpdb |  |
| 95 | etcd |  | 键值 | 分布式 | 2013 |  Apache-2.0 | etcd是分布式系统最关键数据的分布式可靠键值存储，主要特点是：<br>简单：定义明确、面向用户的API(gRPC)<br>安全：具有可选客户端证书身份验证的自动TLS<br>快速：基准测试10,000次写入/秒<br>可靠：使用Raft正确分布<br>etcd是用Go编写的，使用Raft共识算法来管理一个高可用的复制日志。<br>许多公司在生产中使用etcd，在关键部署场景中开发团队支持它，其中etcd经常与Kubernetes、locksmith、vulcand、Doorman等应用程序合作。可靠性通过严格的鲁棒性测试得到进一步保证。 | https://github.com/etcd-io/etcd |  |
| 96 | Hazelcast | Hazelcast公司 | 键值 | 分布式 | 2008 |  Apache-2.0 | Hazelcast是一个分布式计算和存储平台，用于针对事件流和传统数据源进行一致的低延迟查询、聚合和有状态计算。它允许您快速构建资源高效的实时应用程序。您可以以任何规模部署它，从小型边缘设备到大型云实例集群。<br>一组Hazelcast节点共享数据存储和计算负载，可以动态扩展和缩减。当您向集群添加新节点时，数据会在集群中自动重新平衡，并且当前正在运行的计算任务（称为作业）会快照其状态并通过处理保证进行扩展。 | https://github.com/hazelcast/hazelcast |  |
| 97 | Prometheus |  | 时序 | 集中式 | 2015 |  Apache-2.0 | Prometheus是CloudNativeComputingFoundation项目，是一个系统和服务监控系统。它按给定的时间间隔从配置的目标收集指标，评估规则表达式，显示结果，并可以在观察到指定条件时触发警报。<br>Prometheus与其他指标和监控系统的区别在于：<br>多维数据模型（由指标名称和键/值维度集定义的时间序列）<br>PromQL，一种强大而灵活的查询语言来利用这个维度<br>不依赖分布式存储；单个服务器节点是自治的<br>用于时间序列收集的HTTP拉取模型<br>通过批处理作业的中间网关支持推送时间序列<br>通过服务发现或静态配置发现目标<br>多种图形和仪表板支持模式<br>支持分层和横向联合 | https://github.com/prometheus/prometheus |  |
| 98 | Derby | Apache基金会 | 关系 | 集中 | 1997 | Apache-2.0 | ApacheDerby是一个完全用java编写的数据库，Derby是一个Opensource的产品，基于ApacheLicense2.0分发。<br>ApacheDerby非常小巧，核心部分derby.jar只有2M，所以既可以做为单独的数据库服务器使用，也可以内嵌在应用程序中使用。Cognos8BI的ContentStore默认就是使用的Derby数据库，可以在Cognos8的安装目录下看到一个叫derby10.1.2.1的目录，就是内嵌的10.1.2.1版本的derby。<br>Derby是特别地为Java环境进行优化，Derby本身不仅是一个纯Java程序，而且Derby在执行用户的SQL程序时，能够把SQL编译成Javabytecode并以系统的Java虚拟机执行。由于SQL程序转成的Javabytecode能被JIT动态翻译，因此Derby可能比传统的数据库管理系统更佳的性能。<br><br>其他特性包括：<br>支持主从架构或嵌入环境<br>多线程<br>ACID<br>Java数据库连接（JDBC）<br>低系统需求：约占2MB的硬盘空间，压缩后更只是600KB | https://github.com/apache/derby |  |
| 99 | RocksDB | Facebook, | 键值 | 集中式 | 2013 | GPL-2.0 | RocksDB由Facebook数据库工程团队开发和维护。它建立在SanjayGhemawat(sanjay@google.com)和JeffDean(jeff@google.com)早期关于LevelDB的工作之上<br><br>此代码是一个库，它构成了快速键值服务器的核心构建块，特别适用于在闪存驱动器上存储数据。它采用日志结构合并数据库(LSM)设计，可在写入放大因子(WAF)、读取放大因子(RAF)和空间放大因子(SAF)之间进行灵活权衡。它具有多线程压缩，使其特别适合在单个数据库中存储数TB的数据。 | https://github.com/facebook/rocksdb |  |
| 100 | ravendb | HibernatingRhinos | 文档 | 集中式 | 2010 | GPL-2.0 | 一个易于安装、易于使用的NoSQLOLTP文档数据库，具有高性能、集群功能、管理工作室UI和顶级安全性。通过跨多个节点的集群进行实时复制，确保您的数据安全且始终可用。使用商用硬件达到每秒100万次读取和100,000次写入。在Windows、Linux、MacOS、Docker以及.NETC#、Java、Python、Ruby、Go、Node.js平台上使用RavenDB。<br>主要功能：<br>ACID数据库事务<br>每个文档、多个文档和整个集群的ACID合规性。<br><br>高性能<br>每秒150,000次写入，在商用硬件上读取超过100万次。<br>高级查询引擎 | https://github.com/ravendb/ravendb |  |
| 101 | PipelineDB |  | 关系 | 集中式 | 2013 | BSD\GPLv3 | PipelineDB是用于高性能时间序列聚合的PostgreSQL扩展，旨在为实时报告和分析应用程序提供支持。<br>PipelineDB允许您定义连续的SQL查询，这些查询永久聚合时间序列数据，并仅将聚合输出存储在常规的可查询表中。您可以将此概念视为极高吞吐量、增量更新的物化视图，永远不需要手动刷新。<br>原始时间序列数据永远不会写入磁盘，这使得PipelineDB对于聚合工作负载非常高效。<br>连续查询产生自己的输出流，因此可以链接在一起形成连续SQL的任意网络。 | https://github.com/pipelinedb/pipelinedb |  |


## 闭源

## 致谢名单

感谢以下各位贡献者的大力支持与参与！

| 姓名 | 职务信息 |
| :-- | :-- |
| 白国华 | 中国 PostgreSQL 分会秘书长 |
| 唐小引 | CSDN&《新程序员》执行总编 |
| 王启隆 | 首都师范大学学生 |

## 欢迎与我联系

扫码添加时，请备注您的姓名+公司职位。

<img src="https://img-blog.csdnimg.cn/3b20251d39b543cb8571c0c55bfa9dbd.png" width = "394" height = "460" alt="联系信息" align=center />
