# 附录5 开放科学和开放获取


##  5.1 开放科学的发展历程

开放科学的思想最早萌芽于中世纪的欧洲宫廷资助系统，资助者采用同行评议、开放交流的方式鉴别受资助成果的质量。开放科学的发展大致经历了三个阶段。欧洲一直走在开放科学的前沿，2009年欧盟第七框架计划（FP7）资助了欧洲科研开放获取基础设施项目OpenAire，致力于建设开放和可持续的学术交流基础设施。2014年，在欧洲“地平线2020计划”下提出了欧洲开放科学培训项目（FOSTER）。2018年，欧盟支持发起开放获取S计划，旨在使得受公共和私人支持的，经过同行评议的出版物能够完全和立即开放获取 。美国开放科学中心（COS）于2013年发布了开放科学框架（OSF），旨在协助科研团队管理项目和公开成果 。《中华人民共和国科学技术进步法》（2021年修订）第九十五条规定“推动开放科学的发展，促进科学技术交流和传播”。

##  5.2 开放科学概念和框架

![](https://img-blog.csdnimg.cn/a235a17ce1b4424a8cef3f0eb9e6bdd7.png)

根据联合国教科文组织（UNESCO）在2021年11月发布的《开放科学建议书》，开放科学被定义为一种包容性的结构，它结合了各种运动和实践，旨在使多语言科学知识对所有人开放、可访问和可重复使用，以增加科学合作和信息共享，以造福于科学与社会，并向传统科学界之外的社会行为者开放科学知识创造、评估和交流的过程。开放科学包括所有科学学科和学术实践的各个方面，包括基础科学和应用科学、自然科学和社会科学以及人文科学，它建立在开放科学知识、开放科学基础设施、科学传播、社会行为者的开放参与并与其他知识系统进行公开对话的框架之上。

## 5.5 开放科学的核心价值观、指导原则、行动领域和监测

《开放科学建议书》概述了开放科学的四大核心价值观、六项指导原则、七个行动领域。

### 5.5.1 开放科学的核心价值

（1）质量和完整性：开放科学应该尊重学术自由和人权，支持高质量的研究，方法是汇集多种知识来源，广泛提供研究方法和成果，供严格审查和透明的评估过程使用。

（2）集体利益：科学知识应该是公开且普遍共享的。科学实践应该是包容的、可持续的和公平的，也应该是科学教育和能力发展的机会。

（3）公平公正：开放科学应发挥重要作用，确保发达国家和发展中国家科学家之间的公平，实现科学投入和产出的公平互惠共享，使知识的生产者和消费者都能平等获得科学知识。

（4）多样化与包容性：开放科学应该包含知识、实践、工作流程、语言、研究成果和研究主题的多样性，以支持科学界作为一个整体的需求和知识多元化，支持多样化的研究团体和学者，支持传统科学界之外的更广泛的公众和知识持有者，包括土著人民和当地社区，以及不同国家和地区的社会行动者。

### 5.5.2 开放科学的指导原则

（1）透明度、审查、批评和可重复性：应该在科学努力的所有阶段促进增加开放，以加强科学成果的强度和严谨性，增强科学的社会影响，并提高整个社会解决复杂的相互关联的问题的能力。

（2）机会均等：所有科学家和其他开放科学行为者和利益攸关方都有平等的机会接触开放科学，为开放科学作出贡献并从开放科学中受益。

（3）责任、尊重和问责：与公共问责、对利益冲突的敏感、对研究活动可能产生的社会和生态后果的警惕、知识产权和对与研究有关的伦理原则和影响的尊重一起，应该构成开放科学良好治理的基础。

（4）合作、参与和包容：超越地理、语言、世代和资源界限的各级科学进程的合作应成为规范，学科之间的合作应得到促进，社会行为体的充分和有效参与，并吸收边缘社区的知识，以解决具有社会重要性的问题。

（5）灵活性：鼓励向开放科学过渡和实践的不同途径，同时坚持上述核心价值，并最大限度地遵守在此提出的其他原则。

（6）持续性：开放科学应该建立在长期实践、服务、基础设施和资助模式的基础上，以确保来自弱势机构和国家的科学生产者的平等参与。

### 5.5.3 开放科学的行动领域

为实现开放科学建议书的目标，建议成员国根据国际法并考虑到各自的政治、行政和法律框架，在以下七个领域同时采取行动。

（1）促进对开放科学、相关利益和挑战以及开放科学的多种途径的共同理解；

（2）为开放科学营造有利的政策环境；

（3）投资开放科学基础设施和服务；

（4）投资于开放科学的人力资源、培训、教育、数字素养和能力建设；

（5）培育开放科学文化，调整开放科学激励机制；

（6）在科学进程的不同阶段促进开放科学的创新方法；

（7）在开放科学的背景下促进国际和多方利益攸关方合作，以减少数字、技术和知识差距。

### 5.5.4 开放科学的监测

（1）部署监测和评估机制，以衡量开放科学政策和激励措施对既定目标的有效性和效率。采用多方利益攸关方的方法，收集和传播开放科学及其影响方面的进展、良好做法、创新和研究报告。

（2）制定监测指标和框架，考虑在国家战略计划范围内制定一个具有质量和数量指标并在国际一级共享的监测框架，为执行本建议制定短期、中期和长期的目标和行动。

（3）制定战略以监测开放科学的有效性和长期效率，其中包括多方利益攸关方的参与方法。

## 5.6 开放获取

### 5.6.1 开放获取的发展历程

2002年，《布达佩斯开放获取倡议》（BOAI）正式提出开放获取概念 。2003年，德国马普学会等机构发起开放获取柏林会议，并发表《柏林宣言》，呼吁免费公开更多的科学资源，鼓励科学家以OA方式出版论文 。2004年，Springer出版集团开始在其1000多种订阅期刊上向作者提供开放获取选项，带动期刊向符合开放获取期刊转换。2006年，高能物理开放获取联盟SCOAP3建立，推动学科内大多数期刊向开放获取出版转换 。2007年，南非开普敦开放教育会议发布了《开普敦开放教育宣言》 。2009年，开放获取知识库联盟COAR成立，旨在联合遍布五大洲的机构知识库并建立一个全球协作网络，提高存储成果的可见度和利用度。2013年，全球研究理事会发布《出版物开放获取行动计划》。

### 5.6.2开放获取的主要方式

《布达佩斯开放获取倡议》提出了实现开放获取的两条路径，即开放获取期刊（Open-access Journals）和开放存储（Self-archiving），这两种方式分别被称为金色OA和绿色OA。除这两种主要方式外，在实际出版过程中还有其他的开放获取模式。

金色OA（Gold OA）：指论文的最终版本在网络上立即开放获取，读者不需要付费。金色OA的论文一般发表在完全开放获取或向开放获取转换的期刊上，遵循CC BY或CC BY-NC-ND的版权许可协议，由作者、研究机构或基金资助机构缴纳论文处理费（article processing charge，APC） 。

绿色OA（Green OA）：指作者在订购期刊上发表论文后, 将论文一定版本存到开放获取知识库中并在一定时间后（Embargo period, 开放时滞期）开放获取 。

青铜OA（Bronze OA）：指科研论文的许可并不明确，出版商可能限时授予文献免费访问权限的获取方式 。

钻石OA（Diamond OA）：指在不收取作者费用的情况下，发布开放获取的期刊，即作者和读者双向免费。2022年3月2日，Science Europe、S联盟（cOAlition S）、人文学科开放学术交流研究基础设施服务联盟项目（OPERAS）和法国国家研究机构（ANR）共同提出了“钻石OA行动计划” 。

黑色OA（Black OA）：是较新的说法，指的是从学术社交网（如Mendeley、Research Gate、Academia.edu等）或非法提供学术论文全文的网站（如Sci-Hub）上可以免费下载大量本应交费浏览的学术文章 。

### 5.6.3开放获取的载体

CORE（https://core.ac.uk/）是全球最大的开放获取研究论文库，其使命是索引全球所有开放获取研究，并为所有人提供不受限制的访问。CORE目前包含2.61亿篇从全球11,000数据提供商收集的开放获取文章。

Dimensions是最全面的研究资助数据库，它将资助与数百万种由此产生的出版物、临床试验和专利联系起来。截至2023年5月Dimensions有135,517,255出版物、6,595,673基金、12,245,864数据集、938,422政策文本、770,634临床试验、153,152,401项专利 。其中，开放获取论文共有42,747,022，约占31.5%。该平台收录的中国出版物总量为4,203,610、数据集为405,693、基金项目619,635、临床试验10,249，其中开放获取论文共1,265,665，占比30.11%。

Web of Science（https://www.webofscience.com/wos）是全球最受信赖且独立于出版方的全球引文数据库。平台全面收录了超过 17 亿条被引文献和 1.59 亿条记录，可以跟踪跨学科和时间的科研想法。截至2023年5月，Web of Science核心合集中收录的中国论文共有7,776,949篇，其中开放获取论文2,195,823篇，占28.23%。

- 开放获取期刊

开放获取期刊指用户可以在法律允许的范围内最大限度地接近学术资源，打破传统学术期刊的限制和门槛，排除经济、地域等因素，按照个体需求进行阅读和分享学术期刊 。开放获取期刊强调自由、免费、开放、共享的理念，减少了获取学术信息的阻碍和交流的时滞性，为快速传播科研成果提供了有利条件。美国科研出版社（Scientific Research Publishing，简称SCIRP）是全球最大的开放获取期刊出版商之一。目前已出版超过200多种开放获取、在线、同行评审的期刊，涵盖了广泛的学术学科。此外，国际上开放出版期刊平台还有PLOS、Cogent OA 、Dove Medical Press 、Copernicus Publications 、ELCVIA 、Frontiers 等。DOAJ是全球开放获取期刊索引，只接受开放获取期刊，期刊应遵守学术出版的透明度和最佳实践原则，期刊必须有自己的专用URL和主页，必须至少有一个ISSN，期刊必须有编辑和编委会，所有文章在发表前必须通过同行评审 。截至2023年4月，DOAJ共收录来自131个国家的19,233种期刊，其中中国期刊有256种，占1.33% 。GoOA是开放获取论文一站式发现平台，是由中国科学院资助、中科院文献情报中心建设推出的开放资源。它收录了经严格遴选的来自144家知名出版社的2500余种OA期刊及其全文，学科领域涉及自然科学领域及部分社会科学领域。

- 机构知识库

机构知识库（Institutional Repository，简称IR）又称机构典藏库、机构仓储、机构库等，通常情况下指的是，某个机构实体为保存和管理本机构智力成果资源（包括本机构成员创作的学术成果、科研数据、课件教程、软件工具等），自主或借助第三方机构建立的集提交、组织、检索、分析、利用等为一体的学术存储与服务系统 。OpenDOAR是开放获取存储库全球目录，截至2023年4月，OpenDOAR平台注册的机构知识库总数达6025个，其中美国（925个）、日本（657个）、英国（324个）排名前三位，中国65个，占比1.08% 。2019年4月4日在美国宾夕法尼亚州费城举行的RDA第十三届全体会议上提出了维护数字存储库可信性的TRUST原则，即Transparency（透明度）、Responsibility（承担责任）、User Focus（用户导向）、Sustainability（可持续性）、Technology（技术能力）。国际上机构知识库联盟主要包括：开放获取知识库联盟（COAR）、法国FAL、荷兰DAREnet、澳大利亚ARROW、日本JAIRO、德国OA-Network、英国JISC RepositoryNet、欧盟DRIVER 。我国的机构知识库联盟主要有中国科学院机构知识库网络（CAS IR GRID）、中国高校机构知识库联盟（Confederation of China Academic Institutional Repository，简称 CHAIR）和农业机构知识库联盟。其中，CAS IR GRID共有期刊论文908,684篇，会议论文139,822篇，专利数据114,490条，其他数据132,784条 。CHAIR共有会员机构51家，元数据总量2,868,428，访问量248,935 。农业机构知识库联盟共有下属机构36个，专家学者7514位，科研成果197,697篇 。

- 预印本平台

预印本（preprint）是作者在提交期刊出版前未经严格同行评议的手稿（投稿版、录用稿），经过初步的评议审核后，即借助于预印本平台在最短的时间内以开放获取的形式发布，为作者获得最新研究成果的网络首发权，为学术交流系统提供最新、最快速的研究成果传播与利用渠道。

1961—1967年，在美国国立卫生研究院（NIH）的支持下，由相同领域或共同研究兴趣的科学家组成了“信息交换小组”（Information Exchange Groups，IEGs），该小组吸引了3600名研究人员并产生了2500篇预印本。第一个电子化预印本平台arXiv由物理学家保罗·金斯帕（Paul Ginsparg）于1991年在美国洛斯阿拉莫斯（Los Alamos）国家实验室建立，arXiv 起初主要收录高能物理领域的预印本，如今，学科领域扩展到数学、计算机、计量生物、计量金融、统计学等。2013年，美国开放科学中心 （Center for Open Science）推出了免费、开源的预印 本集成平台OSF（Open Science Framwork），目前平台数量达到30个，预印本及其由作者保存在预印本平台上的文献达220万篇。2017年Science将预印本评为当年十大科技进展之一，生物学bioRxiv和化学Chemrxiv在更大范围内受到关注。

学术论文出版的预印本平台有：arXiv、BioRxiv、medRxiv、ChemRxiv、F1000、figshare、Peerage of Science、engrXiv、PeerJ Preprints等 。其中，arXiv于1991年发起，涉及物理学、数学、计算机科学、定量生物学、定量金融学、统计学、电气工程和系统科学以及经济学领域的超过200万篇学术论文。BioXiv、MedXiv和ChemXiv分别是生命科学、医学和化学领域的预印本平台。ChinaXiv是中国科学院文献情报中心于2016年开始运营的预印本交流平台，支持中英文科技论文预印本的发布、传播、下载和评论。ChinaXiv还有面向具体学科领域的12个共建子平台，如中国心理学、生物工程、岩土力学、语音乐律、数学、天文学、光学、核物理、信息资源管理、护理学、法学和数字出版预印本平台。ChinaXiv-Global是由ChinaXiv提供的全球预印本服务，索引由全球重要的预印本平台发布的论文，帮助科研人员更好更快第发现最新的研究产出。
