# 附录1：开源大事记

###  1991年

* 中国开源诞生元年，中美合作引进 UNIX SVR4.2。陆首群、杨天行和张克治牵头，代表中方代表团与美国 AT&T 公司合作，美方将当时最新开发的 UNIX 版本—— UNIX SVR4.2 源代码向中方开放	(除美国外，中国是全球获得源代码的第二家)。此后，中方组织全国软件专家、程序员等 200 多人共同翻译、编辑、出版了“UNIX SVR4.2中文版本”。中美合作引进 UNIX SVR4.2”这一历史事件被 Linux 基金会收录，后被作为中国开源诞生的标志性事件，1991 年也就此成为中国开源的诞生元年。

###  1992年

* 成立合资 UNIX 公司，产生深远影响。国内计算机软硬件厂商与 USG 合资成立 UNIX(中国)系统技术有限公司，对后续 UNIX/Linux 在中国的发展和普及，以及开源文化的传播有深远影响。

###  1994年

* Linux 与自由软件被引进中国。Linux 操作系统和大量自由软件被宫敏引进中国，国内技术人员开始接触到 Linux。同时，自由软件的火种开始在国内传播。

###  1997年

* 建立“中国自由软件库”。通过国家信息中心的帮助，宫敏在中国经济信息网上建成“中国自由软件库”。为国内技术人员了解、学习和使用 Linux 及相关自由/开源软件提供了便利。

###  1998年

* LVS( Linux Virtual Server，Linux 虚拟服务器)诞生。用于实现负载平衡，其代码进入了Linux 2.4和 2.6 版本的官方内核中。章文嵩是这一开源软件创始人。
* 开源 Linux 图形用户界面支持系统“MiniGUI”进入开发。由魏永明发起，历经十余年的迭代更新，MiniGUI 可支持 Linux/uClinux、eCos、μC/OS-II、VxWorks、ThreadX、Nucleus、pSOS、OSE 等操作系统和数十种 SoC 芯片。
* 冲浪平台成功实现中文Linux操作系统第一次商业应用。该司研发的 Xteam Linux 中文操作系统成功在北京市政府研究室办公 OA 系统中实现应用。
* 中国第一批开源社区——阿卡社区(AKA)在清华大学成立。后该社区转变成为亚嵌公司，AKA早期的多数成员成为中国最早的一批Linux人才。
* 国内 Linux 内核工程师开始参与国际开源项目。正在自动化系读大二的学生吴峰光开始接触 Linux，发现Linux的文件预读算法磁盘 I/O 性能较差，开始尝试对 Linux 内核进行改进。吴峰光后来成长为国内对 Linux 内核贡献最多的工程师。

###  1999年

* 中文版红旗 Linux 和 RedOffice 进入研发。由中国科学院软件所的孙玉芳牵头，基于 Linux 和 OpenOfﬁce 进行了中文版红旗 Linux 和 RedOfﬁce 的研制。
* 国内专业开发者社区 CSDN 成立。蒋涛创立中国软件开发者社区 CSDN，目前已成为中国最大的开发者社区。22 年来，CSDN 为中国培养了几代开源开发者，同时也见证了中国开源快速发展的 20 年，目前正积极向第三代开源社区转型。
* 蓝点最早发布中文 Linux 版本—— BluePoint Linux。蓝点团队发布汉化的 BluePoint Linux，这是全球最早的中文 Linux 版本。同年，蓝点软件技术(深圳)有限公司创立。

###  2000年

* 共创软件联盟成立。在“ 863 计划”支持下，国内高校、研究院所、IT 企业联合发起成立“共创软件联盟”。联盟在开源许可证规则下对 863 计划的软件成果进行开源培育和孵化，提出以“开放源代码的协同创新模式”作为中国基础软件发展的主要路径，对我国开源产业发展起到了重要推动作用。
* 北京市科委筹建软件产业基地公共技术支撑体系。为提升北京软件产业工程化水平，北京市科委筹划建设北京软件产业基地公共技术支撑体系。

###  2001年

* Sun 中国工程研究院成立。研究院内部设立 Mozilla、Office、Java 等小组，是外资公司首次在中国设立全职参与开源社区研发的研发中心，为中国培养了大批开源人才。
* Intel 中国开源技术中心(OTC)成立。该中心于 2003 年正式更名为 Intel 开源技术中心。经过近 20 年发展，中心为中国开源产业界培养了大批顶尖专家。

###  2002年

* 国内第一个 Linux 社区发行版发布。黄建中以“CJacker”的 ID 在中国 Linux 公社发布了基于 Redhat8 再发布的 Magic Linux 版本，Magic Linux 是国内第一个 Linux 社区发行版。
* 北京软件产品质量检测检验中心成立。负责运营管理公共技术支撑体系。

###  2003年

* IBM 中国 Linux 解决方案合作中心在北京中关村软件园正式启动。该中心由 IBM 公司和北京市政府合作，联合众多国内软件开发公司，目的是为国内提供 Linux 实验平台，培养 Linux 软件开发人才。
* 中国科技论文在线网正式开通。作为中国最早的开放存取仓储之一，中国科技论文在线网为科研人员提供了方便、高效的交流平台，让最新科研成果得以及时推广，科研思想得到有效保护。  

###  2004年

* 中、日、韩三国政府在北京签署“开放源代码软件合作备忘录”。这是三国首次将软件开源提升到国家级的战略合作层面。备忘录内容包括：三国政府将为开放源代码软件，尤其是Linux的开发和应用创造政策环境、加强 Linux 对三国语言的支持、推动 Linux 软件的研发和商品化以及在三国中的应用、大力推广 Linux 在电子政务/企业信息化和远程教育等领域中的应用等。7 月，由三国政府倡导的 Linux 平台 Asianux1.0 发布。
* 中国科学院和国家自然科学基金委员会签署了《柏林宣言》。这一举动表明了中国科学界和科研资助机构支持开放获取的原则和立场。
* 中国开源软件推进联盟(COPU)成立。该联盟是一个非政府组织，由致力于开源文化、技术、产业、教学、应用的企业、社区、院校、科研院所等单位自愿组成。联盟的宗旨是推动中国开源软件的发展和应用；促进中日韩以及中国与全球开源运动的沟通、交流与合作；促进中国为全球开源运动做出贡献。

###  2005年

* 国家自然科学基金委员会正式发布“国家自然科学基金基础研究知识库”。该知识库收集国家自然科学基金资助项目成果的研究论文全文，向社会公众免费开放。
* Mozilla 中国中心成立。Mozilla 中国中心是由中国科学院软件研究所和 Sun 中国工程研究院共同发起，经 Mozilla Foundation正式授权的非赢利性机构，该中心依托在中国科学院软件研究所。

###  2006年

* 中国开源软件推进联盟(COPU)主办“2006 年第一届开源中国开源世界高峰论坛”。主题为“开放标准，开源架构，开源生态系统与应用解决方案”，大会讲师 24 位，包括担任 COPU智囊团高级顾问的全球开源领袖及跨国企业专家，与会中外代表约 250 人。
* 首届中国Linux内核开发者大会(CLK)成功举办。Intel、清华大学、AKA社区共同发起第一届中国Linux内核开发者大会(CLK)。该大会延续至今，成为中国开源领域的顶级技术峰会，发掘出吴峰光、马涛等一批内核领域的专家。

###  2008年

* Linux(Kernel)、Apache、OpenOffice 等国际知名开源社区在北京召开全球技术峰会。这是国际开源组织首次在亚洲国家举办技术峰会，是对中国开发者为社区所做贡献的肯定，也成为中国开源发展史上重要的里程碑。
* 阿里巴巴开始研发孵化 Dubbo (开源分布式服务框架)。这是一款高性能、轻量级的开源Java RPC框架。2019 年 5 月 16 日，Apache 软件基金会董事会决议通过了 Apache Dubbo 的毕业申请，成为顶级项目。
* 开源爱好者红薯创建开源中国(OSCHINA)社区。该社区十多年来推动了中国开源领域的发展。
* 76 位华人为 Linux Kernel 贡献 822 个补丁，2008 北京 Linux 开发者研讨会在京召开。在 COPU 与国际 Linux 基金会合作举办的“ 2008 北京 Linux 开发者研讨会”上，中国新锐与国际开源社区资深大师同台研讨，在 Linux Kernel 2.6.29 版本 11232 个补丁中，由 76 位华人(占获得成功的志愿者总数 6.85%)向社区贡献 822 个补丁(占全部补丁 7.20%)。

###  2010年

* Linux 基金会在中国设立分支机构。Linux 基金会任命 Cliff Miller 出任基金会中国首席代表，这也是 Linux 基金会首次在中国设立分支机构，希望通过此举进一步推进 Linux 平台在中国的普及化。

###  2011年

* 阿里开源 fastjson 和 Druid。fastjson 是 JSON 解析库，可以解析 JSON 格式的字符串，支持将 Java Bean 序列化为 JSON字 符串，也可以从 JSON 字符串反序列化到 Java Bean。Druid 是 Java 语言中的数据库连接池，能够提供强大的监控和扩展功能，包括监控数据库访问性能、提供 WallFilter 等。

###  2012年

* 中国开源云联盟成立。英特尔亚太研发有限公司、新浪网技术(中国)有限公司、中标软件有限公司以及上海交通大学正式签署协议，联合成立“中国开源云联盟”，该联盟是国内首个联合产学研各方组建的开源组织。旨在按照国际上 OpenStack 开源社区的工作方针，整合中国 OpenStack 开发者和中国公司的研发资源。
* 腾讯发布首个对外开源项目 Tinker。Tinker 作为腾讯的第一个开源项目，是 Android 热解决方案库，支持在不重新安装 apk 的情况下对 dex、library和resources进行更新，推动了 Android 产品和社区的发展。

###  2013年

* 三方合作开发 Ubuntu Kylin。由中国工业和信息化部下属中国软件与集成芯片推广中心(CSIP)、Canonical、国防科技大学三方组成的“ CCN 开源联合促进实验室”成立，合作开发面 向中国用户的 Ubuntu 版本—— Ubuntu Kylin(优麒麟)。
* OSCHINA 上线了Gitee(码云)。截至 2022 年开发者超过 800 万，托管项目超过 2000 万，覆盖几乎所有本土原创开源项目。
* CSDN 推出代码托管协作平台“CODE”，后升级为 GitCode 平台，提供全新代码协作管理功能。平台结合 CSDN 3500 万开发者用户基础及海量知识文档库，通过与 GitHub 的项目联动，为中文社区开源开发者使用开源、发起开源、推广开源提供专业易用的工具平台及运营服务。
* W3C(万维网联盟)将北京航空航天大学的中国办事处升级为全球总部。2003 年，W3C 首次在中国举办“中国国际万维网发展论坛”。2011 年，百度加入 W3C，成为国内首个加入 W3C 的互联网 企业。随后，腾讯、360 等互联网企业纷纷加入。

###  2015年

* 国务院提出要大力发展开源社区。国务院在《关于积极推进“互联网+”行动的指导意见》中提出大力发展开源社区，鼓励企业自主研发和国家科技计划(专项、基金等)支持形成的软件成果通过互联网向社会开源。引导教育机构、社会团体、企业或个人发起开源项目，积极参加国际开源项目，支持组建开源社区和开源基金会。鼓励企业依托互联网开源模式构建新型生态，促进互联网开源社区与标准规范、知识产权等机构的对接与合作。

###  2016年

* 国务院支持开源社区创新发展。国务院在《“十三五”国家信息化规划》中提到，引导和支持产学研用深度融合，推动龙头企业和科研机构成立开源技术研发团队，支持科技型中小企业发展，构建产学研用协同创新集群。支持开源社区创新发展，鼓励我国企业积极加入国际重大核心技术的开源组织，从参与者发展为重要贡献者，在优势技术领域争当发起者，积极维护我国相关标准专利在国际开源组织中的权益。
* 云计算开源产业联盟(OSCAR)成立。由工业和信息化部信息化和软件服务业司指导，中国信息通信研究院联合多家云计算开源技术公司发起，中国通信标准化协会代管的云计算开源产业联盟(OSCAR)成立，该联盟是业界首个专注于云计算市场的开源产业联盟。
* 中国首个自主研发的产业级深度学习平台飞桨(PaddlePaddle)正式开源。飞桨以百度多年的深度学习技术研究和业务应用为基础，是中国首个自主研发、功能完备、开源开放的产业级深度学习平台。

###  2017年

* 《新一代人工智能发展规划》提出开源开放推进人工智能。7 月 20 号，国务院发布的《新一代人工智能发展规划》提出中国推进人工智能的四条原则：科技引领、系统布局、市场主导、开源开放。其中在开源开放的原则下，共同建设一个体系化的AI技术体系。
* 新一代人工智能产业技术创新战略联盟(AITISA)成立。由北京大学、中关村视听产业技术创新联盟等联合倡议，在科技部试点联盟——数字音视频编解码(AVS)产业技术创新战略联盟的基础上，新一代人工智能产业技术创新战略联盟成立。
* 阿里巴巴捐赠给 Apache 社区的开源项目 RocketMQ 正式毕业，成为 Apache 顶级项目(TLP)。自此，RocketMQ 成为国内首个互联网中间件的 Apache 顶级项目。
* 百度正式对外开源 Apollo 自动驾驶。Apollo 开放平台可以帮助汽车行业及自动驾驶领域的合作伙伴结合车辆和硬件系统，快速搭建一套属于自己的自动驾驶系统。截至 2021 年底，该平台已完成 11 个版本迭代，全球拥有 135 个国家超 80000 名开发者，合作伙伴超 210 个，开源代码量总计 70 万行。
* BCOS开源。BCOS由微众银行、万向区块链、矩阵元三方研发，是聚焦于企业级应用服务的区块链技术平台，于2017年7月31日完全开源。
* Linux 基金会授予陆首群“推进开源终身成就奖”。Linux 基金会首次在中国召开 LC3(LinuxCon&ContainerCon&CloudCon)会议。会上，Linux 基金会授予中国开源软件推进联盟名誉主席陆首群“推进开源终身成就奖”。

###  2018年

* 国务院支持建设一批能够融入国际化发展的开源社区。国务院在《关于深化“互联网+先进制造业”发展工业互联网的指导意见》中提出，面向关键技术和平台需求，支持建设一批能够融入国际化发展的开源社区，提供良好开发环境，共享开源技术、代码和开发工具。
* 国家部委首次以国家科技专项支持开源生态建设。科技部下发国家重点研发计划专项——《云计算与大数据开源社区生态系统》项目，这是国家部委首次以国家科技专项方式支持系统化地推进开源社区生态系统建设。
* 中国人工智能开源软件发展联盟成立。由工业和信息化部、北京市人民政府共同主办，中国电子技术标准化研究院、中国人工智能开源软件发展联盟(筹)具体承办下，中国人工智能开源软件发展联盟成立大会召开，宗旨是推动我国人工智能开源软件技术和产业发展。
* 中国 RISC-V 产业联盟成立。由国内外 RISC-V 领域重点企业、研究机构和行业协会发起的中国 RISC-V 产业联盟正式成立，旨在解决中国 RISC-V 领域共同面对的关键问题。包括：建立中国国产自主、可控、安全的 RISC-V 异构计算平台，促进形成贯穿 IP 核、芯片、软件、系统、应用等环节的 RISC-V 产业生态链。
* 中国开放指令生态(RISC-V)联盟成立。由中科院计算所、北京大学、清华大学等近20家国内研究机构和企业联合发起的中国开放指令生态(RISC-V)联盟成立，中国工程院院士倪光南担任理事长。
* 3 个原创于中国的项目进入了 CNCF 。三个项目分别是：Harbor，开源镜像仓库项目，用于容器镜像管理；TiKV，开源分布式事务键值数据库；Dragonly，由阿里巴巴开源的云原生镜像分发系统。
* 专为物联网设计的轻量级开源虚拟化管理软件 ACRN 推出。该项目完全由 Intel 中国开源技术中心实现，从架构设计到团队管理，所有参与项目的工程师都在上海和北京。ACRN 为 IOT 和汽车量身订作虚拟化软件，是该业界第一个开源的软件项目。
* 云原生计算基金会 CNCF 授予陆首群“开源领袖奖”。CNCF 执行董事 Dan Kohn 代表 CNCF 在上海召开的首届 CNCF&KubeCon 国际开源会议上向中国开源软件推进联盟名誉主席陆首群颁发 “开源领袖奖”，以表彰他对中国开源事业乃至全球开源事业的突出贡献。

###  2019年

* OpenCV 中国团队成立。引导中国开发力量为 OpenCV 作贡献，同时改进 OpenCV，使之适应未来应用，特别是机器人相关应用，促进科研成果快速应用。
* 木兰开源社区建立。由中国电子技术标准化研究院牵头建立的木兰开源社区，是国家重点研发计划重点专项“云计算和大数据开源社区生态系统”的成果之一，旨在促进产学研用各方开源领域的交流，推动国家科技创新成果开源等。
* OpenI 启智平台成立。OpenI 启智是新一代人工智能产业技术创新战略联盟组织产学研用各界，通力协作、共建共享的开源软件、开源硬件、开放数据社区。
* 头歌社区建立。该社区主要为高校和企业提供开放的科教项目和课程资源在线开发与服务环境，支持五大类课程/金课建设、实验教学环境建设、科研创新环境建设、工程教育专业认证体系建设等工作。
* 数字孪生体联盟成立。由工业 4.0 研究院牵头发起成立数字孪生体联盟，通过运行数字孪生体创新中心，重点建设开源社区和发掘应用场景。
* SODA Foundation中国区启动。Linux基金会数据与存储领域的首个子基金会 SODA Foundation 中国区正式启动，旨在通过智能开放的数据自治标准化建设，帮助用户应对数据基础设施云化转型过程中的挑战。
* Angel 成国内首个从 LF AI 基金会毕业项目。腾讯自主研发的 Angel 从 Linux 基金会 LF AI 毕业，成为国内首个从LF AI基金会毕业的项目。
* 华为提出软件开源战略。华为自研操作系统鸿蒙和方舟编译器开源，宣布未来会将服务器操作系统 EulerOS、AI 计算框架 MindSpore 和单机版数据库 GaussDB OLTP 全部开源。
* 全球 Star 数最高的 React 组件库项目。阿里开源的企业级 UI 设计语言 Ant Design 在 GitHub 的Star 数突破 5 万。2019 年 7 月，Ant Design 的 GitHub star 数超过 Material UI，成为全球 Star 数最高的 React 组件库项目。
* 阿里开源芯片——无剑 100 Open。平头哥公司推出开源物联MCU芯片平台——无剑 100  Open，包含了玄铁处理器、基础接口、开发环境和OS的开源芯片平台。希望能把整个芯片研发周期缩短 50%，开发成本降低 50%，被阿里定位为面向下一代的 AIoT 产品平台。
* 全球首个开放云原生应用模型 OAM 正式开源。首个开放云原生应用模型 OAM(Open Application Model) 由阿里巴巴和微软联合开源，这是业界第一个云原生应用标准定义与架构模型。
* 全球首个通用安全计算平台 Teaclave 进入 Apache 孵化。由百度主导研发的 Teaclave 进入 Apache 孵化，该平台基于硬件安全能力(Intel SGX)，确保敏感数据在可信域外和离岸场景下安全可控的流通和处理。2020 年 10 月，Teaclave社区正式通过并发布了 0.1.0 版。

###  2020年

* OSI 批准 MulanPSL-2.0。2019 年，中国首个开源许可证正式发布，名为木兰宽松许可证(Mulan Permissive Software License, Mulan PSL)。2020 年，木兰宽松许可证(第2版)正式成为国际化开源许可证。
* Linux 基金会宣布成立 OpenSSF。OpenSSF 可以实现跨行业协作，通过构建具有目标计划和最佳实践的更广泛社区，将领导者聚集在一起，以提高开放源码软件的安全性。
* 开放原子开源基金会成立。由阿里巴巴、百度、华为等十家龙头科技企业联合发起的开放原子开源基金会成立，填补了中国没有开源基金会的空白。
* 上海白玉兰开源开放研究院揭牌。上海白玉兰开源开放研究院是由上海交通大学牵头建设，目标是推动人工智能开源产品的国际规则互认，催生国际开源生态网络关键节点等。
* 清华大学发布自主研制开源时间序列数据管理系统 Apache IoTDB。为解决工业互联网领域的时间序列大数据管理需求，清华大学软件学院王建民带领团队自主研制了面向工业领域的开源时间序列数据管理系统 Apache IoTDB，成为中国高校首次在 Apache 国际开源社区发布的软件项目。
* 华为关系型数据库 openGauss 开源。该数据库在 ARM 架构芯片上深度优化，并兼容 X86架构，采用木兰宽松许可证(MulanPSL-2.0)开源。
* 阿里云开源 Kubernetes 上第一个云原生平台构建引擎，以及完整实现的 OAM 模型——KubeVela。KubeVela 的开源和规模化落地证明了以 OAM 为基础的开放应用架构是一条能够充分释放云原生潜力的有效路径，推动 OAM 成为中国信通院主导发布的《云计算开放应用模型》标准框架。
* 阿里巴巴开源 Easy 系列算法框架 EasyTransfer。阿里云机器学习 PAI 开源了业界首个面向 NLP 场景的深度迁移学习框架 EasyTransfer。
* 腾讯云企业级分布式KV数据库 Tendis 开源。Tendis 兼容 Redis 核心数据结构与接口，可提供大容量、低成本、强持久化的数据库能力，适用于兼容 Redis 协议，需要大容量且较高访问性能的温冷数据存储场景。
* ALC-Beijing 向 Apache 软件基金会申请并成立。ALC-Beijing 是面向北京的 Apache 本地开源社区组织。目前该组织包含 10 多个Apache顶级项目，包括 Kylin、Eagle、RocketMQ、ServiceComb、Grifﬁn 等项目。

###  2021年

* 开源进入国家“十四五规划”。在《中华人民共和国国民经济和社会发展第十四个五年规划和 2035 年远景目标纲要》中，“开源”被首次提及，标志着发展开源成为我国十四五期间的重要工作之一。随后，中共中央、国务院印发的《知识产权强国建设纲要(2021－2035年)》《国家标准化发展纲要》等国家级发展纲要以及《“十四五”国家知识产权保护和运用规划》《“十四五”数字经济发展规划》《“十四五”国家信息化规划》等“十四五”规划，以及工信部、中央网信办、科技部等部委发布印发的《关于加快推动区块链技术应用和产业发展的指导意见》《物联网新型基础设施建设三年行动计划(2021-2023年)》《关于规范金融业开源技术应用与发展的意见》等一系列政策文件，都将开源作为技术创新的主流模式，在多个方面明确提出支持开源发展。
* 工信部将开源纳入重点工作。工信部发布《“十四五”软件和信息技术服务业发展规划》，将“开源重塑软件发展新生态”作为“十四五”期间我国软件产业的四大发展形势之一进行重点阐述。明确提出“建设 2-3 个有国际影响力的开源社区，培育超过 10 个优质开源项目”的发展目标，并把“繁荣国内开源生态”作为工作任务，设置“开源生态培育”为专项行动，把“培育重点开源项目、建设优秀开源社区、提升开源治理能力”作为专项行动主要工作，把“加强软件源代码检测和安全漏洞管理能力、提升开源代码、第三方代码使用的安全风险防控能力”作为强化安全服务保障的重要内容，这是国家级产业规划首次把开源单独作为一个重点工作来部署。
* 五部委发布《关于规范金融业开源技术应用与发展的意见》。中国人民银行办公厅、中央网络安全和信息化委员会办公室秘书局、工业和信息化部办公厅、中国银行保险监督管理委员会办公厅、中国证券监督管理委员会办公厅发布《关于规范金融业开源技术应用与发展的意见》。
* 第一届中国开源教育研讨会(SOSEC)召开。中国第一届开源教育研讨会在四川民族学院举行。来自华东师范大学、四川大学、上海交通大学、东北大学、西北工业大学、中山大学、暨南大学、桂林电子科技大学、四川民族学院、中国科学研究院等高校和研究院(所)的 40 余名专家、学者汇聚一堂，共同探讨开源教育。
* “科创中国”开源创新联合体成立。该联合体是由中国科协科学技术传播中心、中国电子学会、腾讯、百度、麒麟软件、CSDN 等36家单位共同发起成立的开放性、非营利、非法人组织。联合体以打造自主开源生态为宗旨，以建设产学研深度融合的开源创新体系为目标。
* 中国计算机学会 CCF 开源发展委员会正式成立。该委员会旨在推动探索学术共同体主导的开源发展新途径，聚焦共同打造开源、开放、中立的产学研协同开源创新服务平台，探索建立CCF 开源项目孵化机制，培育原始开源创新项目。
* 华为正式发布面向数字基础设施的开源操作系统欧拉(openEuler)。该操作系统可广泛部署于服务器、云计算、边缘计算、嵌入式等各种形态设备，应用场景覆盖 IT、CT 和 OT，实现统一操作系统支持多设备，应用一次开发覆盖全场景。
* 浪潮研发的 NewSQL 分布式数据库 ZNBase 开源。ZNBase 参考谷歌 Spanner/F1 的设计思想，SQL 层使用 Go 语言开发，基于开源 CockroachDB 修改，重写其商业代码和开源部分代码，代码修改率 76%。存储层使用 C++ 开发，采用多模引擎，涵盖结构化、KV、文件存储、时序存储、图存储等。
* 奥星贝斯开源了 OceanBase 数据库。基于分布式架构和通用服务器，OceanBase 实现了金融级可靠性及数据一致性。2020 年 5 月，OceanBase 以 7.07 亿 tpmC 的在线事务处理性能创造了 TPC-C 新的世界纪录。
* 百度开源的 ECharts 正式从 Apache 毕业，成为顶级项目。ECharts 基于 JavaScript 的数据可视化图标库，可以生产直观、可交互、定制化的数据可视化图表。
* 第四范式的机器学习数据库 OpenMLDB 开源。OpenMLDB 在半年内实现全球代码托管平台GitHubtopics 排名。其中，机器学习数据库、AI数据库方向 best-match 取得Top1；内存数据库、特征存储方向位列 Top3。
* 小米推出新一代 Kaldi。由小米集团首席语音科学家，原约翰·霍普金斯大学语言和语音处理中心的 DanielPovey 主导，正式推出了新一代 Kaldi，该项目起源于 2009 年约翰·霍普金斯大学的夏季研讨会。
* 国内首个违反 GPL 的案件判决生效。广东省深圳市中级人民法院审理罗盒公司诉风灵公司案的一审判决体现了中国法院对开源软件侵权审理思路的转变。在一审中，法院明确指出GPLv3 协议是一种民事法律行为，具有合同性质，可以认定为授权人和用户间订立的著作权协议，属于《合同法》调整的范围。此判例称得上是国内首个明确GPLv3协议法律效力的案例，对国内开源软件侵权行为提供了“有法可依”的背书。
* 全球开源技术峰会 GOTC2021 召开。该峰会由开放原子开源基金会举办，由上海站与深圳站组成，覆盖云原生、大数据、人工智能、物联网、区块链、DevOps、开源治理等多个技术领域，为开发者带来全球最新的开源技术。
* 木兰开源社区参加“国家‘十三五’科技创新成就展”。木兰开源社区被国家科技部推荐作为新兴技术板块参加“国家‘十三五’科技创新成就展”，这是我国开源领域首次被国家认可，与蛟龙号、高铁等大国重器一起进入国家顶级科技成就展览。
* 浙江省发布全国首个《开源社区知识产权管理规则指引 ( 试行 )》，共十二条，包括管理原则、管理平台、社区组成、约束机制、协同研发、软件管理、专利管理、商标管理、风险管理等方面，提出了合法正当、创新引领、应用先导、发展优先以及数据安全的管理原则。
* Elastic License 2.0 (ELv2) 虽 然 满 足 源 码 可 见， 但 并 不 符 合 OSI 的 开 源 定 义， 采 用 ELv2 的 StarRocks 因自称开源，而引起业界非议。
* 国外一开发者在网上抱怨深圳手机公司 UMIDIGI 未公开其采用了 GPL-2.0 协议的手机操作系统内核源代码，位于深圳的知名博主机械妖姬（Naomi Wu）帮助开发者前往手机公司登门索要源代码，并将整个过程的自拍视频发布在了网上，造成热议。事后，该公司在官网的论坛和 GitHub 上相继提供了源代码，国外开发者表达了谢意，纠纷顺利解决。
* 中国信通院建立可信开源标准体系，推动 8 个行标立项。
* 中国电子技术标准化研究院推动国家开源标准体系顶层设计，推动相关开源标准立项，分别涵盖术语、元数据、许可证框架、开源项目、开源贡献者、开源治理等方面，首个开源领域国家标准《信息技术开源 开源许可证框架》获批立项。
* 2021 年 6 月 22 日，中科院计算所牵头开发的香山开源高性能 RISC-V 处理器在首届 RISC-V 中国峰会发布 ；7 月，香山处理器完成第一版（代号雁栖湖）的 28nm 流片 ；10 月 30 日，香山处理器团队负责人包云岗研究员在第六届中国开源年会发表演讲《开源芯片的挑战与机遇》；12 月 6 日，香山通过 RISC-V Summit 第一次在国际 RISC-V 社区正式亮相。
* 2021 年 10 月 19 日，阿里平头哥于 2021 云栖大会宣布开源四款玄铁 RISC-V 系列处理器，成为系列处理器与基础软件的全球首次全栈开源。
* 木兰开源社区吸纳 OpenDigger 项目进入孵化，推动和完善开源项目、社区衡量指标建设。
* 木兰开源社区的木兰宽松许可证已有多达 10 万个国内项目采用。
* 2021 年11 月 4 日，龙蜥操作系统宣布将捐赠到开放原子开源基金会进行孵化。目前，龙蜥操作系统已在阿里云全面上线，总装机量达百万量级。龙蜥社区（OpenAnolis）已拥有 50 多家生态企业。其中统信软件、中国移动云等已基于龙蜥操作系统发布商业版本。龙蜥也是国内首个从操作系统层面提供全软件栈国密算法的 OS 解决方案，并且对内核 SM4 算法做了深度优化，性能提升近 800%，让中国国密算法从合规走向生产应用。
* 2021 年 11 月，华为 openEuler 正式捐赠给开放原子开源基金会。
* 2021 年 10 月 28 日，开放原子开源基金会技术监督委员会投票通过开源项目OpenCloudOS 进入开放原子开源基金会孵化。 
* 2021 年 12 月 9 日，由赛昉科技支持的 RISC-V 开源社区平台 RVspace 正式上线。
* 2021 年 12 月 22 日，国产开源操作系统 OpenCloudOS 的开源社区正式成立。腾讯、宝德、北京初心、北京红旗、飞腾、浪潮、龙芯中科、OPPO、先进开源、中电科申泰、中科方德、兆芯等 20余家操作系统生态厂商及用户成为首批创始单位。

###  2022年

* 2022 年 2 月，TODOGroup 与 Linux 基金会研究合作，发布了《开源项目办公室的演变》白皮书。
* 2022 年 3 月，开源社 ONESGroup 官宣成立，专注企业开源战略研究。
* 2022 年 3 月，姜宁当选 Apache 基金会董事、堵俊平再次当选 LFAI & DATABoard 主席。
* 2022 年 4 月，TiDB 宣布正式开源分析引擎 TiFlash。TiFlash ，基于 ClickHouse 开发，是 TiDB HTAP 形态的关键组件，它是 TiKV 的列存扩展，通过 RaftLearner 协议异步复制，但提供与TiKV一样的快照隔离支持。这个架构解决了 HTAP 场景的隔离性以及列存同步的问题。自 5.0 引入 MPP 后，也进一步增强了 TiDB 在实时分析场景下的计算加速能力。
* 2022 年 4 月，家又进一步提出了《知识产权强国建设纲要和"十四五"规划实施年度推进计划》、《中国银保监会办公厅关于银行业保险业数字化转型的指导意见》，到了 12 月，三部门联合发布的《互联网信息服务深度合成管理规定》，也将对 AIGC 以及开源领域产生深远影响。
* 2022 年 5 月，字节跳动公布一封内部邮件，官宣开源委员会正式建立。
* 2022 年 5 月，中国信通院牵头成立“可信开源合规计划”并发布《开源合规指南（企业篇）》。《开源合规指南（企业篇）》由中国信通院牵头，联合“可信开源合规计划”的成员单位的专家共同编写完成，分析总结了开源合规发展特点，重点围绕开源软件与数据合规风险、开源许可协议规定、企业开源合规风险防控三大环节展开研究，对于企业做好开源合规具有很强的指导意义，为推动我国开源合规建设提供了参考。
* 2022 年 5 月，阿里巴巴宣布开源的 FederatedScope 框架，使用事件驱动的编程范式来构建联邦学习，支持大规模、高效率的联邦学习异步训练，能兼容不同设备运行环境，且提供丰富功能模块，降低了隐私保护计算技术开发与部署难度，目前该框架现已面向全球开源。
* 2022 年 6 月，中国首个桌面操作系统开源社区开放麒麟正式发布。开放麒麟（openKylin）由麒麟软件、国家工业信息安全发展研究中心等单位联合成立，目标通过开放操作系统源代码的方式，让更多的开发者共同参与国产开源操作系统的开发，从而打造具有自主创新技术的开源桌面操作系统。
* 2022 年 6 月，石原子宣布开源一体化实时 HTAP 数据库 StoneDB。StoneDB 是一款全面兼容 MySQL 的实时 HTAP 数据库，自研 Tianmu 引擎对标 MySQLHeatWave 架构，具备行列混存、自适应压缩、知识网格和智能索引等核心技术特性，能够高效解决 MySQL 在分析场景中面临的性能瓶颈，同时支持数据强一致性的事务特性，具备完整的事务并发处理能力，相比 MySQL 原生分析能力最高可提升 100 倍。
* 2022 年 6 月，华为开源业界首个分布式云原生开源套件 Kurator。分布式云开源套件 Kurator 助力企业业务跨云跨边、分布式化升级，目标是标准化、统一分布式云管理，整合 Karmada、KubeEdge、Volcano、Kubernetes、Istio、Prometheus 等业界主流开源技术栈，为用戶提供多云、多集群统一编排，统一调度，统一流量治理，边云协同，统一监控运维等核心能力，助力企业业务跨云跨边、分布式化升级。
* 2022 年 6 月，腾讯开源一站式为服务解决方案 SpringCloudTencent。SpringCloudTencent 实现了 SpringCloud 标准微服务 SPI，开发者可以基于SpringCloudTencent 快速开发 Spring Cloud 云原生分布式应用，实现诸如服务注册与发现、配置中心、服务路由、限流熔断以及元数据链路透传能力等分布式微服务场景。
* 2022 年 7 月，蚂蚁集团宣布开源云原生时序数据库 CeresDB。CeresDB 是一款高性能、分布式、Schema-less 的云原生时序数据库，能够同时处理时序型（time-series）以及分析型（analytics）负载。不同于传统时序数据库，CeresDB 的目标不仅仅是能够处理具备常规时序特征（Timeseries）的数据，同时也要能够应对复杂的分析型场景。
* 2022 年 7 月，《 2022中国开源发展蓝皮书》正式发布。
* 2022 年 8 月，InfoQ《中国开源发展研究分析 2022 》发布。
* 2022 年 8 月，TDengine 开源三周年，发布 TDengine3.0。TDengine 3.0 正式发布，升级成为一款云原生时序数据库（Time Series Database），解决了困扰时序数据库发展的高基数难题，支持 10 亿个设备采集数据、100 个节点，支持存储与计算分离。
* 2022 年 8 月，TinaTsou 当选 LFEdgeBoard 主席。其中尤为引人瞩目的是：Tina 是第一位担任企业互联网工程任务组（IETF）工作组主席的中国女性，也是国际电联电信标准化部门（ITU-T）历史上来自亚洲最年轻的报告人。她还曾担任 Akraino 技术指导委员会主席。
* 2022 年 9 月，在中国信通院发起的 OSCAR 开源产业大会上，国内首份《 2022 年 OSPO 案例汇编（第一期）》正式发布，收录了多家企业的 OSPO 实践案例。
* 2022 年 10 月，由 LinuxFoundationAPAC 布道者团队 OSPOSIG 发起的 OSPOSummit 官宣启动。
* 2022 年 10 月，字节跳动开源自研数据集成引擎 BitSail。BitSail 支持 20 多种异构数据源间的数据同步，并提供离线、实时、全量、增量场景下的全域数据集成解决方案。目前，BitSail 服务于字节跳动内部几乎所有业务线，包括抖音、今日头条等大家耳熟能详的应用，同时也支撑了火山引擎多个客戶的数据集成需求。
* 2022 年 10 月，京未来诉江苏云蜻蜓，GPL 抗辩获法院支持国内首案。原告南京未来高新技术有限公司起诉被告江苏云蜻蜓信息科技有限公司、刘某某侵害计算机软件著作权，诉讼请求二被告连带赔偿原告经济损失 2000 万元。被告律师发现，原告的代码中含有使用“GPL + 例外”许可证的软件，经过代码分析，认为原告软件不符合许可证中例外要求，且没有公开源代码，构成 GPL 违约。
* 2022 年 10 月，CSDN《 2022中国开源贡献度报告》发布。
* 2022 年 11 月，开放原子开源基金会、X-lab 开放实验室和阿里巴巴联合出品的《 2022年开源大数据热力报告》发布。
* 2022 年 11 月，格睿云宣布开源云原生时序数据库 Greptime。GreptimeDB 是分布式、高性能、存储计算分离的开源云原生时序数据库。Greptime 使用 Rust 构建时序数据库。架构方面，Greptime 实现了存算分离，以 Datanode 作为核心组件，具备时序存储引擎、查询引擎和 Python Coprocessor 等功能，并且功能可以单独划分为特定的计算池，读、写、分析和 Python 计算的负载相互隔离，互不影响。
* 2022 年 12 月，国电子技术标准化研究院牵头完成木兰开放作品许可协议和开源治理系列标准。《开源与标准协同发展研究报告》由国内相关专家共同研究和编制完成，从国内外开源项目、社区以及标准研究的实践及成效出发，以更科学的视⻆系统分析并阐明开源与标准的关系，明确新发展趋势下开源的内涵与外延，为我国后续系统开展开源标准化工作进一步打开思路、给出方向及建议。
