# 第九章 中国开源发展的机遇和挑战

20世纪70年代以来，以软件产品和服务为代表的开源创新活动成果逐渐成为人类在信息和通信技术领域开展的大规模协作的实践范例，其中产生的巨大知识增量不仅孕育了新的软件开发方法和产品、改善了人类生产生活方式、催生了信息技术产业和新商业模式，也孕育了开源文化、社群自治机制、群智协作网络、开放式创新范式和创新公地理论等，其产生的影响远超出软件领域，延伸到数字经济与科技治理等多方面。自21世纪初的互联网革命以来，开源逐渐成为全球国家主体、各类市场主体以及个人在复杂性高、不确定性强的科技创新前沿领域持续构建创新能力的新路径。

中国开源正处于加速发展阶段，各技术领域如操作系统、数据库、人工智能、云计算等正与开源深度融合，传统行业如金融、电信、医疗、制造业等也正在被开源快速渗透。更重要的是，中国正在成为全球开源市场的增长点，极大的市场容量、完善的产业链、快速的迭代能力正吸引全球的开源项目进入中国。不过，中国开源的高速发展也面临成长的烦恼，如与日俱增的技术风险、法律风险、供应链风险，以及人才危机。

## 9.1 中国开源发展的机遇

《荀子·富国》言：“其，其源”。在中文的语境中，“开源”是指开始出现河流的源头，开拓源头，便亦可节制支流。随着社会的发展和语言的变迁，“开源”一词被应用到科技、经济等各行各业，同时也被赋予了新的时代含义。开源的核心要义是平等、自由、协作、开放、共建、共治、共享、创新。开源并不限定于某一特定领域，它更像是一种精神、信仰和理念，也是人类共同追求的一类文明和文化。

开放科学和开源技术为促进人类进步和知识社会的深度交流融合提供了机会。开源代表的是一种开放包容的理念，有助于推动人类命运共同体的建设。中国科学院院士王怀民在2023年5月开放科学论坛（北京）的致辞中提到，“开源软件的成功实践为开放科学发展提供了全新范例，成为当今开放科学最活跃的实践领域。开源创新不仅能够有效提升创新者的效率，而且能够有效保护创新者的利益。过去二十多年，中国开源软件事业蓬勃发展，是全球开源软件增长贡献率最高的国家。”开源软件作为开放科学的一部分，可向每个人开放各个层面的科学过程和产品，包括开放获取、开放研究数据、开放设计、开放方法论、开放评估等。在人类先验知识与技术的基础上不断迭代优化，促进国际交流与深化合作，提高交互效率，推动更快的知识转移，增进理解和经验。

### 9.1.1 开源正成为全球数字市场的增长点

开源软件以前所未有的力量推动全球创新和经济增长。世界各国纷纷将数字经济作为重要的发展战略，而支撑数字经济发展的底层数字技术已离不开开源软件的协同。开源软件在科技创新与经济发展中的重要性已日益突显。《2022年Linux基金会年报》指出，2022年有超过850个活跃的开源项目，在项目社区每周新增5200万行代码，比上年增长了13%，Linux基金会开源社区2022年贡献了320万个项目，通过众筹的方式募集了330万美元的资金。135000个开发者参与了培训课程，有26000取得了资格认证，年增长15%。据《2022年中国开源软件产业研究报告》的数据显示，开源可为企业项目节省38%的直接开发成本，避免重复造轮子的成本投入。据《2022 GitHub Octoverse年度报告》，截止2022年，GitHub上已有9400多万开发者，2022年新增2050万个用户，其中印度新增的开发者数量最多，全球开发者共创建了8500万个新项目。全球90%以上的公司使用开源，据统计，2022年《财富》排行榜前100名企业中超过90%都在使用GitHub，2022年开发者们共进行了4.13亿次开源贡献。科技巨头企业纷纷建立了大型开源社区，组织成立开源项目办公室（OSPO）协调开源战略，并鼓励更多员工为开放源码做贡献。

移动互联网与云计算在中国的快速发展，吸引了全球范围内的开源项目进入中国市场，极大的市场容量促使以云原生为代表的新型订阅收费模式快速变现，吸引众多全球开发者的另一个因素是国内大型企业将其产品陆续开源，以及大量以开源为基础的初创公司开始涌现。

中国具备全球最完善的电子工业产业链，许多开源技术在中国市场找到载体落地并销往全球。开源技术本地化，并在本地提供服务和二次开发的过程，是一个明显的趋势，并且该过程会降低开源在中国产业生态内的应用和产业化门槛并加速产业化进度，RISC-V、TWS（True Wireless Stereo）等技术在中国的快速产业化就是最佳案例。特别是软件、硬件结合的产品及软硬一体化的应用解决方案，依托中国完备、高效的产业生态，有利于在全球市场占据领先地位。尤其在IoT和AIoT领域，中国的产业链优势显而易见，这也是中国开源发展的一个历史机遇。

而随着IoT和AIoT的发展，数据将从万物互联中产生。中国制造业的市场规模与快速迭代的优势，将带来更多的技术创新。加快中国开源市场增长的步伐，TDengine、Apache IoTDB等中国开源力量的崛起，就是因为中国IoT和AIoT快速发展的核心动力作为支撑。

此外，开源订阅服务的商业模式和可定制化的开放技术架构为中国企业降低了市场门槛与学习成本，提升了性价比。高价值的商业需求反馈到开源社区，引领技术向服务商业、服务客户的方向发展，可以形成收益闭环，进而反哺开源项目和开发者。这是开源项目发展壮大的必要过程，要接地气，要服务用户，要形成产业，要变现，最终实现开源商业共赢的可持续发展模式，中国在其中最大的作用是产业的快速发展帮助开源项目快速迭代，引领企业走上商业友好的可持续发展路线，也就是帮助开源项目升级迭代，有效集成开源技术并售卖到全球，实现盈利分成。

### 9.1.2 开源正与各技术领域深度融合

开源软件的发展从操作系统开始，发展到数据库、中间件，并向应用领域逐渐延展，进而在近年来开始主导深度信息技术领域的创新，开源正在与各技术领域深度融合。其中，数据库、云原生与开源项目的结合最为紧密，操作系统领域也出现大量成熟的Linux发行版，很多企业开始自研开源的实时操作系统。在新技术领域，人工智能、物联网、元宇宙等技术也逐渐拥抱开源并落地开源产品。中国高度重视各个技术领域在开源方向的前瞻性布局，无论是项目活跃度，还是项目影响力，都在快速提升。

在数据库领域，开源展现出两大趋势。一是国产商业数据库逐渐走向开源，其中华为的openGauss、阿里云的PolarDB、奥星贝斯的OceanBase等，开始致力于为国内数据库行业构建基础根技术和根生态；二是中国在分布式、实时数仓等方向的开源产品已经成为了全球范围内的优秀项目，如PingCAP发起的TiDB、百度发起的Doris和由国人开发的在Apache基金会孵化毕业的HAWQ项目等。

在人工智能领域，深度学习已经是技术创新与开源落地的主要方向。自2017年发布的《新一代人工智能发展规划》提出开源开放的原则后，共同建设AI技术体系成为了众多人工智能企业的共同目标，自动驾驶、医疗影像、普惠金融、智能供应链等新一代人工智能开放创新平台诞生。人工智能等重大科技项目开源开放，以开源的形式提升创新质量，有力地推动了产业进程。如今人工智能与开源融合已成行业共识：人工智能开源有助于支撑人工智能领域形成高端产业集群优势，逐步引领世界前沿技术的发展；人工智能开源有助于吸引更多人才进入人工智能产业，建设多层次人才培养体系；人工智能开源有助于推动人工智能广泛应用，加快推动人工智能与各行业的融合创新和赋能。2022年11月底，美国OpenAI公司发布对话式大规模自然语言预训练模型ChatGPT及体验服务，在自然语言处理领域展现出了惊人的通用智能水平，这项技术变革打开了通向通用人工智能的一扇门，通用人工智能正向我们走来，将会对社会各个方面带来深度挑战与变革。随着大模型的快速发展，中美在大模型领域将掀起新一轮人工智能竞争热潮，开源无疑将成为推动大模型底层基础设施建设、打破OpenAI闭源垄断的重要方式。

在物联网领域，开源在智能网联汽车中表现出的应用机遇尤为显著。汽车软件会变成一个由开源和专有组件组成的生态系统，共同提供软件组件的可选择性和灵活性，采用敏捷的软件开发、发布、更新模式也是必要的。充分利用已验证过的开源软件构建智能驾驶软件生态已经成为重要趋势，如在车载信息娱乐系统（In-Vehicle Infotainment，IVI）应用方面普遍采用Android、Linux等开源操作系统，以及开源通信中间件（DDS）框架、开源机器学习框架等。汽车的安全与实时性至关重要，在使用开源软件的过程中，以安全性和附加服务为核心属性，不断强化产品。对于主流汽车厂商，使用开源软件的前景将具有巨大的吸引力，因为它保留了对全栈软件的控制权，包括他们的数据。

在元宇宙领域，开源是元宇宙成为公共可信生存空间的必然前提。元宇宙作为与现实社会孪生的公共虚拟空间，其资源禀赋、运行机制必须是可视、可解释的，才能形成共同的信任基础，因此，开源必然是元宇宙的核心特征和要求之一。元宇宙是技术公司、科技人员、普通参与者共同创造的“宇宙”，除了个体掌控的私有数据外，一切都是开源的。代码是开源的，在开源社区可以随意查看开源代码；技术是开源的，所有元宇宙的技术底层逻辑都是公开的；公共数据是开源的，所有人皆可查看和使用，以此规避中心化平台的垄断；内容是开源的，任何人都能创造元宇宙的内容；智能合约是开源的，任何人都可以调用智能合约。

如今，开源与各技术领域携手同行的势头迅猛，开源有助于各技术领域扩大人才规模及上下游生态影响力，通过运营开源社区快速获得反馈并加快产品开发、提升产品质量，同时反哺社区开发者及独立软件开发商等生态伙伴，达到多方共赢目的。

我国开源创新生态已进入历史新征程。开源释放更多创造力，通过开源协作可让更多参与者感受到文化多样性与包容性的力量。开源激发融合思考与广度发展，以推动数字技术服务更可靠、更高效并实现跨部门跨领域深度合作。

### 9.1.3 开源逐步渗透传统行业

开源在各行业的渗透率正在逐渐加深。据Linux基金会2022年5月发布的《企业开源指南：制定与实施开源软件战略》报告中指出，开源给各行各业带来了机会，在各行业的垂直软件栈中，开源的渗透率占整个软件使用量的20%~85%。开源软件已经成为新的商业产品和服务的基础，并且对许多组织的软件开发工作流程至关重要。

红帽大中华区总裁曹衡康在《开源圆桌派》中表示，从行业使用来看，金融、电信、汽车制造这三个行业渗透率极高。而根据红帽、SUSE、华为、阿里巴巴、PingCAP、Kyligence等数十家主流开源服务供应商向CSDN提供的来自19个不同行业共计156个行业应用案例统计可以看到，金融、运营商以及政务、医疗行业占比最高。其中，金融行业占比17.3%，电信行业运营商占比10.9%，医疗行业占比为9.6%。以开源操作系统OpenEuler、企业级Kubernetes平台OpenShift等为例，其主要应用场景分布在金融、运营商、政府、物流、制造等场景。

开源正在渗透传统行业，同时行业也在反哺开源，其中尤以金融和电信行业为甚，近年来涌现了诸多非常优秀的开源项目。金融行业以微众银行为代表，已发起二十余个开源项目，其中两个已于2021年进入Apache孵化器。电信行业中，以中国移动为代表的中国运营商与海外企业合作，参与推动了包括ONAP、EDGE、G-SRv6等基于平台、关键部件、系统与集成领域的开源项目。

在开源社区建设方面，金融、电信、制造业已经形成行业特色。行业开源社区主要承担行业内的开源代码服务、供需对接、开源治理推动、开源规范制定、开原生态建设及企业交流等工作，极大地推动了各行业开源协作和开源实践。例如，金融行业于2018年10月由浦发银行和华为联合上海银行、上海农商银行、中国人寿、上海清算所、中国信通院、富麦科技等成立了金融行业开源技术应用社区，社区成员包括四十余家金融机构和八家互联网公司。在制造业，2018年成立工业技术软件化开源社区（OSIICN），现入驻工业互联网领域企业超过1000家，汇集合计年产值过万亿元的企业集群，其中包括华为、航天云网、树根互联等44家工业互联网企业、400余家软件企业、43个创新中心，以及百余名行业专家和大量工业软件个人开发者。开源技术作为实现关键核心技术自主安全可控方面具有重要的意义，已成为破局金融科技“卡脖子”难题的重要手段。2020年，金融业成立开源专业委员会，立足金融业开源工作，不断凝聚产业各方科技力量，探索开源模式对金融科技创新发展的促进作用，围绕开源治理、知识产权保护、生态体系建设等方面积极开展工作，共同促进金融业开源技术健康可持续发展。2021年，在中国人民银行科技司指导下、全国金融标准化技术委员会秘书处支持下，坚持贯彻落实“我为人民群众办实事”，加快解决“数字鸿沟”普惠难题，践行科技应用金融服务大众的理念，“金融业生僻字处理”开源项目成功孵化，并开展全国生僻字开源试点、建立金融业生僻字信息平台等。开源技术在国内金融业应用缺乏相关标准的引领和指导，从急需急用原则出发，针对开源软件管理方法、治理能力、安全可控、流程管理等方面进行规范，2022年2月，全国金融标准化技术委员会秘书处下达《金融业开源软件应用管理指南》《金融信息系统开源软件应用评估规范》两项金融行业标准立项通知，不断完善金融业开源技术标准体系框架。由此可见，传统行业的开源社区建设初见成果，有可供其它行业借鉴的实践经验。

面向未来，在数字经济的推动下，以智能汽车为代表的数字化大发展的行业将成为开源进一步渗透的方向。以宝马为例，在多年前就成立了自动驾驶项目，并将开源作为重点推进，核心在于使用开源能够推进开发更加敏捷高效，同时对系统的稳定性及安全大有裨益。

可以预见，行业正在逐渐形成拥抱开源、使用开源的共识。未来，开源将在传统企业展现更多的力量，而传统行业积极拥抱开源、引入开源软件的背后，是其业务发展导致的企业对持续变化的业务需求响应能力、软件性能及成本与效率方面的考虑。出于传统行业的增长需求、市场环境的变化、客户需求的多样性等原因，传统企业自身的研发能力不足以支撑企业敏捷响应、快速迭代、开发，制约了企业的快速发展，尤其是金融行业的应用场景规模大、高并发，对企业应用的软件性能有严苛要求。但企业根据需求自研系统或引入外部商业软件都会带来高昂的采购成本、维护成本和人力投入。

在此背景下，开源由于其开放式协作的特点，使得开发流程更为敏捷，业务需求和变化能快速得到响应，而且开源社区为企业与外部精英提供合作平台，可以解决短期内传统行业研发实力不足的问题。引入开源软件意味着企业可以基于原有开源代码自行开发或只需采购增量服务，节约时间、人力、经济成本。传统行业引入开源软件提升了企业业务竞争力，驱动了企业数字化转型，帮助企业系统实现了安全性和可靠性提升。从全局角度而言，传统行业拥抱开源为其带来了新的增长机遇。

## 9.2 中国开源发展的挑战

近年来，开源在各行业各领域得到广泛应用，国内的开源生态整体呈现蓬勃发展的态势。据统计，全球97%的软件开发者和99%的企业使用开源软件，基础软件、工业软件、新兴平台软件大多基于开源，我国的软件开发企业几乎都会使用到开源技术。然而，开源软件生态系统庞大，涉及技术、法律、供应链、人才等多个环节，其中任何一环出现问题，开源软件发展都将面临着挑战。

### 9.2.1 开源面临技术安全风险

**（1）开源软件漏洞数量保持高位**

根据Synopsys公司发布的《2023开源安全和风险分析（OSSRA）报告》，Black Duck审计服务团队在2022年审计的涵盖17个行业的1703个代码库中，有96%的代码库包含开源代码，76%为开源代码库；84%的代码库包含至少一个已知开源漏洞，比2022年版的OSSRA报告增加了近4%；检查的代码库中有48%包含高风险漏洞，仅比去年减少了2%。

中国信息通信研究院发布的《全球开源生态研究报告（2022）》中指出，根据Snyk和Linux基金会2022年发布的开源安全调查报告，一个应用程序开发项目平均有49个漏洞和80个直接依赖项。此外，修复开源项目漏洞所需的时间也在稳步增加。2018年修复安全漏洞平均需要4天，而2021年修复一个补丁大约需要110天。

奇安信代码安全实验室《2022中国软件供应链安全分析报告》则显示，截至2021年底，CVE/NVD、CNNVD、CNVD等公开漏洞库中共收录开源软件相关漏洞52716个，其中6346个为2021年度新增漏洞。而在奇安信代码安全实验室审计的3354个国内企业软件项目中，存在已知开源软件漏洞的项目有2897个，占比高达86.4%；存在已知高危开源软件漏洞的项目有2680个，占比为79.9%；存在已知超危开源软件漏洞的项目有2400个，占比为71.6%。这些项目中，共检出231368个已知开源软件漏洞（涉及到7269个CVE漏洞编号），平均每个软件项目存在69个已知开源软件漏洞，略高于去年报告中的66个，最多的软件项目存在1555个已知开源软件漏洞。而从漏洞的影响角度来看，最多的Spring Framework远程代码执行漏洞CVE-2022-22965影响了37.1%的软件项目，多个漏洞影响了超过30%的项目。

在2021年检测的2406个国内企业自主研发的软件项目中，输入验证、路径遍历、跨站脚本、注入、NULL引用、资源管理、密码管理、API误用、配置管理、日志伪造等十类安全缺陷是程序员在编写软件代码时经常会出现的典型安全缺陷，十类典型安全缺陷的总体检出率为59.9%，低于去年报告的78.8%，每类典型缺陷的检出率及排名如表18所示。

|排名|缺陷类型|检出率|
|:---:|:---:|:---:|
|1|	输入验证	|41.8%|
|2|	跨站脚本|	35.1%|
|3	|API误用|31.5%|
|4|	NULL引用|	30.2%|
|5|	资源管理|	29.9%|
|6	|路径遍历|	28.4%|
|7	|注入|	26.3%|
|8|	密码管理|	22.8%|
|9	|配置管理	|18.2%|
|10	|日志伪造|	12.5%|

*表18 主要漏洞类型*

**（2）开源软件漏洞影响范围巨大**

根据Synopsys公司《2023开源安全和风险分析报告》，2022年仍存在大量早已在2021年就披露的漏洞，例如该年影响最大的Apache Log4j2漏洞。2021年12月，Apache Log4j2被发现其某些功能存在递归解析功能，存在攻击者可直接构造恶意请求，触发远程代码执行的漏洞。根据工信部发布的《关于阿帕奇Log4j2组件重大安全漏洞的网络安全风险提示》，该漏洞可能导致设备远程受控，进而引发敏感信息窃取、设备服务中断等严重危害，属于高危漏洞。

据Check Point Research统计漏洞爆发4天（自12月10日至12月13日）情况报告，在Apache Log4j2漏洞发现早期的12月10日，黑客尝试利用该漏洞进行攻击的次数仅有几千次，但这一数据在隔天却增至4万次。而漏洞爆发72小时后，捕捉到利用该漏洞尝试攻击的行为就已超过83万次，如图30所示。

![在这里插入图片描述](https://img-blog.csdnimg.cn/b73b9f11001a47a1b365180369eb78bd.png)<br/>图30 基于Log4j2漏洞的攻击数量迅速上升

不仅攻击次数在持续攀升，基于该漏洞的新变种也在短时间内迅速衍生。Log4j2作为一个基于Java的日志框架影响范围之广远超开发团队的预想，全球近一半企业因为该漏洞受到了黑客的试图攻击。并且由于Apache Log4j2应用范围大、漏洞修复较为复杂，而利用漏洞却十分简便，因此Apache Log4j2漏洞很可能在未来几年内也将一直存在。

**（3）上游开源组件的漏洞传播与修复挑战**

当一个常用开源组件因存在漏洞被修复时，我们希望把新版本快速同步到其他所有调用了该组件的开源项目中去，而不是同一个漏洞被一次次在不同软件中反复发现，反复修复，浪费人力物力，甚至被攻击者反复利用。上游组件的修复能否快速、大规模、全覆盖地推送到下游依赖环节，是开源软件供应链安全可靠性面临的重要挑战。

仍以2021年底爆发的Log4j2为例，Apache Log4j2零日漏洞（Log4Shell、CVE-2021-44228）是因“Lookup”机制存在解析问题，导致了JNDI注入漏洞。该漏洞的触发条件简单，但危害却极大。攻击者可向程序输入特定的攻击字符串，当程序进行日志记录时，该漏洞即可被触发，用来执行恶意代码。Log4j2是Java代码项目中广泛使用的开源日志组件，因此这个漏洞很快演变为一场Java生态中开源软件供应链的安全危机。据不完全统计，GitHub超过8600多个开源软件直接依赖Log4j2组件，但通过这些开源软件继续追溯，最终超过20万个开源软件受到了影响；同时，在官方第一次发布修复版本的一周时间后，仍然有超过80%的间接关联开源软件没有被修复。

从数据上可以看出，上游开源组件中一旦发现有严重漏洞，就会直接或间接地影响到依赖它的下游开源软件，同时通过开源软件之间错综复杂的层级依赖关系的传播后，该漏洞隐匿在深层依赖的应用中不易被发现，为全球软件供应链带来无法估量且不可控的影响。

**（4）对开源软件组成成分分析时，受制条件较多**

目前，如果被检测的软件无法提供源代码，那么二进制文件是唯一可以进行分析检测的对象，但大多数二进制文件都经过了混淆、加壳等处理，给组件成分分析带来了巨大的困难和挑战。同时，从二进制文件推导除组件以及版本的精确度问题也需要解决。此外，在进行开源软件克隆检测时，需要有一个巨大的开源软件源代码数据库作为支撑，而如何高效地在海量代码片段中检索到被检测软件的克隆特征，进而进行同源分析，并减少人工确认的工作量、减少误报是工业界面临的一个问题。

为了解决以上挑战，建议开源软件供应方、开源软件使用方分别采取相应措施进行应对。

对于开源软件供应方：

1. 在运营成本可控的前提下，制定开源软件安全开发管理规范，设立安全专业的安全运维管理团队，定期发布安全漏洞自查检测结果，积极响应社区、用户、社会的安全漏洞发现，及时修补相应的安全漏洞。
2. 建立并管理维护一套统一标准可传递的软件组成成分清单和完善的准入审核机制及方法。对每一个提交进行开源相似度、版权审查的同时，进行严格的组成成分、安全及许可证审查，坚决禁止人为后门的存在，严格控制高危漏洞数量，保证开源项目的健康成长。
3. 开源供应方充分利用社区、托管平台、开源安全产品供应商等生态资源，为开源贡献者提供一套完整易用的开源安全工具链，完成代码安全开发、许可证合规审计、版权审计、安全审计、开源组件对比选型等任务。

对于开源软件使用方：

1. 建立安全规范可信的开源下载源：目前开源下载源鱼龙混杂，一方面增加了依赖管理的难度，同时也为IDE投毒、提交缺陷代码、代码版本不一致、攻陷代码平台、篡改代码、不安全组件引入等各种安全风险提供了生长空间。
2. 建立软件物料清单管理规范：软件物料清单（SBOM）能帮助企业确定是否容易受到软件组件中已被发现的安全漏洞的影响，无论这些组件是内部开发的、商业采购的还是开源的软件库。
3. 推行开源治理：行业组织、企业定期盘点开源资产，构建完整的依赖关系图谱，以应对在紧急状况下的安全响应。同时针对开源软件建立完善的引入审批、技术评估、合规使用、漏洞检测、更新维护、应急处置、停用退出制度。

### 9.2.2 开源面临法律风险

**（1）开源许可证法律效力有待进一步明确**

根据Synopsys公司《2023开源安全和风险分析报告》显示，尽管存在许可证冲突的代码呈逐年减少的趋势，但在2022年的被审代码库中仍有高达54%的代码存在冲突。其中，Creative Commons ShareAlike 3.0 (CC BY-SA 3.0)许可证冲突以约20%的占比，称为该年度许可冲突的最主要的原因。CC BY-SA 3.0许可证冲突数据揭示出，许多商业和开发人员常将来自Stack Overflow等论坛的代码片段、函数、方法和操作代码片段，不假思索地引入到软件中，从而引发冲突。此外，标准开源许可证的变体或定制版本许可证可能会对被许可方提出不必要的要求，并且要求对可能的知识产权问题和其他问题进行法律评估。例如，JSON许可证实质上是宽松型MIT许可证，只不过添加了“该款软件严禁用于恶意用途，仅限用于善意用途”的注释。许多热门项目的责任方都因为许可证定义含糊不清而删除了使用JSON许可证的代码，因为“善意用途”与“恶意用途”定义争议性极强，很难界定。

国内司法实践中逐步开始重视开源许可证的法律效应。2021年4月，广东省深圳市中级人民法院审理罗盒公司诉风灵公司案的一审判决，该案明确指出GPLv3协议是一种民事法律行为，具有合同性质，可以认定为授权人和用户间订立的著作权协议，属于《合同法》调整的范围。此案例是国内首个明确GPLv3协议法律效力的案例，对开源许可证的法律界定，对开源软件侵权行为的判罚作出了有益的探索。

**（2）著作权风险**

开源代码有时会渗透到其他代码中，或者其他代码渗透到开源代码中。根据不同的开源许可，则有可能不得不向整个社区公开原本不想公开的代码。例如，某些代码根据GPL等许可证合并到某些软件的源代码中，可能会“感染”该软件，从而导致该软件根据许可证的条款自动获得许可，也因此必须遵守该许可。例如，微软便遇到过该渗透问题，在微软将具有GPL许可的部分代码合并到其Hyper-V驱动程序中后，才发现部分代码被感染，而微软不得不向Linux贡献了该Hyper-V驱动程序的代码以避免违反GPL。

**（3）专利权风险**

专利相对于著作权来说更加复杂，在获取专利权和维持专利权上要投入更多。专利在申请阶段就需要提交和申请很多文件，而一旦出现潜在的侵权问题，专利的诉讼成本也高于一般的著作权诉讼的成本。因此发起专利侵权诉讼本身就是专利权人需要极为慎重考虑的事情。

另外，完全存在适用于许可软件但许可人和被许可人都不知道的专利。由于专利数量较多，开发者不可能了解世界上所有的软件。由于许可人只能许可属于他们的作品，因此特定软件许可的存在并不能保护被许可人免受第三方专利权人提出的侵权索赔。对专利风险的分析往往需要聘请律师来进行，成本也较高。

**（4）商业秘密问题**

在开源领域，商业秘密的判断比较困难，因为开源软件本身就开放了很多信息，哪部分能够构成商业秘密是未来需要探讨的方向。

**（5）认定受开源许可证影响的软件边界**

高传染性。在过往的案件中，曾出现北京高级人民法院认为软件中的插件并不受到GPL约束，而广州知产法院认同了GPL协议的“高传染性”，即在GPL3.0协议下开源软件的衍生作品或修改作品也需要遵循GPL许可协议开放其源代码。

独立程序。在2019年，最高院审理的一件计算机软件作品著作权纠纷案中认为前端和后端代码是独立的不同代码，前端代码用于页面设计等，而后端代码用于实现软件本身的底层逻辑，因此认为前端代码与后端代码在实际达到的效果和最终结果存在明显不同，且法院认为不能仅仅因为代码的交互配合就认定二者为同一代码。最高院认为GPL的高传染性包括基于开源软件的衍生程序或修订版本，但不包括存在交互或联系的其他独立程序。正如计算机系统中的多数软件或代码需要互相配合以达到目的，但这些软件或代码并非同一软件或代码。2022年3月，陕西省西安市中级人民法院判决的另一起计算机软件作品著作权纠纷案中提及，根据GPL协议规定，只要修改文本在整体上或某个部分来源于遵循GPL的程序，该修改文本的整体就必须按照GPL流通，不仅该修改文本的源码必须向社会公开，且对于修改文本的流通不准许附加修改者自己作出的限制。

开源的界限。开源软件经常涉及技术的跨国界传播，因此也需要面对各国国家的技术管制相关法律。开源社区是在不同国家的法律下建立起来的，其必须遵守所在地的法律法规，因此，开源平台和开源企业实际上难以保持中立。开源软件的开发与维护往往涉及到不同的主体，也就涉及到不同的权利归属、许可、授权等法律问题。

### 9.2.3 开源面临供应链风险

软件供应链已经成为网络空间攻防对抗的焦点，直接影响关键基础设施和重要信息系统安全。软件的供应链安全问题由来已久，只是随着开源软件规模化应用，软件供应链愈发复杂多元，使开源软件供应链风险尤其突出。

对应传统供应链的概念，广义的开源软件供应链可以这样定义：开源软件供应链是一个实际业务系统，在开发和运行过程中，涉及的所有开源软件上游社区（Upstream）、源码包（Source Package）、二进制包（Binary）、包管理器（Package Manager）、存储仓库（Repository），以及开发者（Developer）和维护者（Maintainer）、社区（Community）、基金会（Foundation）等，按照依赖、组合、托管、指导等关系形成的供应链网络。

以操作系统这一典型大型复杂系统软件作为例子。操作系统从组织结构上看是管理计算机硬件资源和软件资源的系统程序集合，包括内核及其他系统工具。由Linux内核衍生出的操作系统发行版，如Ubuntu、CentOS、Android等，统称为Linux发行版，它们将众多实现不同功能的开源软件，以软件包的形式与Linux内核有机地整合在一起，以满足终端用户不同的使用需求。DistroWatch和Repository statistics的数据显示，较为常用的Linux发行版，仅一个版本就需要维护数以万计的软件包以支撑自身功能和生态，比如Ubuntu 18.04涉及29207个软件包、Debian Unstable涉及32453个软件包。即便是通过剪裁构建而成的较为精简的系统，也包含近百个软件包。从以上数据不难看出，在开源协作模式下，软件之间的供应链关系已经非常普遍和繁杂，构建和维护开源软件供应链已成为全球开源领域的共同挑战。

开源软件存在不同于传统闭源商用软件的供应链安全问题。开源软件在开放的社区生态中发育成长，其使用许可证均允许用户自主复制、修改和使用其软件源代码。因此，开源软件版本之间演化出了跨社区、跨主体的复杂依赖关系，由此带来软件漏洞传播失控、许可证授权冲突，以及责任主体缺失等特殊的供应链安全风险。据美国新思科技公司《2022年开源安全和风险分析报告》统计，被调研的2409个活跃开源库中，97%版本包含开源代码，81%存在已知漏洞，49%包含至少1个已知高风险漏洞。美国围绕开源软件供应链安全管理出台了软件物料清单（SBOM）、安全漏洞管理等相关政策与行政令，旨在加强供应链安全保障，以加强网络安全。近期，美国还通过改变开源创新基础设施和开源项目访问权限及使用许可证、漏洞披露管制等手段，制约他国开源创新活动。

当前，我国开源软件供应链安全管理缺乏标准规范、安全政策、管理平台和责任主体，开源软件及其安全漏洞情报主要依赖美国的开源平台和漏洞数据库发布，存在断供风险。开源软件是我国数字经济发展的重要基石，其供应链安全关乎国家安全与经济社会稳定发展，不容小觑。

例如，开源漏洞给企业的安全甚至国家的安全都带来了严峻的挑战：应用软件80%~90%的代码来自开源组件，平均每个应用使用的开源软件数量达100多个，平均每个软件应用存在 50多个开源软件漏洞。越来越多的黑客正在优先利用开源漏洞攻破安全防线。开源漏洞的危害巨大，甚至单个安全漏洞（例如Log4j远程代码执行漏洞）就可能将整个软件或互联网产业搅动起来，被迫进行大面积的库升级或替换。为了很好的应对开源软件引入的安全问题，需要建立一套完整的自动化解决方案，及时给出漏洞预警，帮助软件开发者及时治理开源漏洞所带来的安全风险，提高效处理率。为了应对开源软件引入的安全问题，国际上专门成立了OpenSSF组织，试图建立一套完整的自动化解决方案，及时给出漏洞预警，帮助软件开发者及时治理开源漏洞所带来的安全风险。目前国内很多企业与组织在关注开源供应链安全问题，在开放原子开源基金会专门设立了开源供应链小组，在CCF开源委员会设有开源供应链安全工作组，但目前这些力量相对分散，尚未形成合力，因此，可以汇聚众多的相关力量，参考OpenSSF建立类似甚至更佳的解决方案，为开源生态可持续发展贡献力量，并产生广泛的影响力。

总体来说，当前中国开源软件供应链主要面临三方面的挑战。

**（1）关键开源组件的可持续维护挑战**

开源软件的长期义务维护可能会导致一系列不公平的现象，例如商业公司通过开源软件赚取了丰厚利润，但并没有给维护者任何回馈，甚至会刻意回避谈及对开源软件的使用，由此引起开源维护者的反感甚至一些过激行为。2022年3月发生的faker.js与colors.js开源库遭作者Marak恶意破坏的事件就是典型的例子。faker.js与colors.js使用范围较广，faker.js在npm上的每周下载量接近250万、colors.js 达到约2240万，属于较为关键的开源软件供应链上游节点。faker.js使用的是十分宽松的MIT开源许可协议，因此许多商业公司并没有为使用此项目支付任何费用。作为fake数据领域最优秀的开源项目之一，faker.js和colors.js庞大的工作量却主要由其作者Marak一人完成，并且没有从商业公司得到相应的支持和回报。长期累积的恶性循环终于爆发，作者通过向两个包提交恶意代码进行供应链投毒，并发布到GitHub和npm包管理器中，之后又将项目仓库所有代码清空，完全停止维护，从而使依赖于这两个库的数千个项目无法运行。

其实早在2014年HeartBleed漏洞爆发时，人们已经发现出现问题的OpenSSL库只有两位兼职人员在义务维护。同样，前面提到的Log4j2也仅有几位兼职社区开源爱好者在维护。可想而知，这些软件包在出现漏洞后，修复的及时程度和全面程度必然会受到影响。

**（2）国际局势动荡的挑战**

最近几年，开源软件供应链出现了意识形态、地缘政治、战争冲突等导致的开源社区分裂。一些关键的开源托管平台和开源基础软件对特定国家、特定实体雇员采取了账号禁止访问、代码删除等“断供”行为，这也是未来开源软件发展面临的又一巨大挑战。

开源无国界，但开源组织（如基金会）、开源代码托管平台（属于商业公司所有）乃至开发者（开发者有国籍）都会受到属地出口管制政策的制约。例如，全球最大的代码托管平台GitHub、全球最大的容器托管平台Docker Hub、国际著名开源基金会Apache基金会就明确声明受美国《出口管理条例》的约束。早在2019年，GitHub就曾禁止伊朗程序员访问托管其上的仓库。Docker Hub也曾声明对列入美国制裁实体清单上的企业停止容器镜像托管和下载服务。

随着俄乌局势升级，出于美国制裁的原因，GitHub开始封禁俄罗斯开发者的账号，严格限制俄罗斯获得维持军事能力所需的技术。一些著名的开源社区和开源项目也出现了宣扬政治立场的行为。轻则在开源项目中植入支持某方的标语口号、捐款按钮等，重则把对方排除出开源社区。例如，OpenBLAS作为一个基于BSD许可发行的优化BLAS计算库，删除了对俄国产处理器Elbrus的支持，这意味着Elbrus可能将无法使用新版功能的优化线性代数内核，未来Elbrus处理器也无法在被依赖OpenBLAS库的应用直接使用。更为严重的是，有人在广泛使用的开源基础库中植入恶意代码，当判断使用者IP地址属于某个特定国家时，会对整个系统根目录发起强制删除操作，后果不堪设想。这些行为虽然已经背离了开源精神，违反了开源社区的基本共识，但在高强度的对抗情况下几乎必然会发生，不得不引起高度重视。

**（3）大企业垄断开源生态阻碍创新**

开源一直秉承鼓励创新的发展理念，已成为推动全球数字科技创新的重要因素。数据表明，开源技术支撑了90%以上的互联网产品，推动了一大批小而精的创新型企业发展壮大。开源倡导开放、共享的模式，兴起之时就遭到众多科技巨头的坚决抵制，但随着开源势不可挡的发展，全球科技巨头转而持续加码开源领域，纷纷通过收购开源平台强化其垄断地位，试图通过掌控开源平台不断强化对科技生态的领导力，并使得社区从早期的高度分散的技术架构转变为由几个强大的网络巨头所控制的架构。这种“大公司拥抱开源”的现象，一方面因大公司拥有在更高级别上开发和维护开源项目所需的资金，推动产生了更多的开源重点项目，并有助于提高质量和安全性；另一方面，受商业利益等因素驱使，通过对开源社区项目的开发和商业化推广，对开发人员施加种种限制，易造成技术垄断，并最终阻碍技术创新。

在过去十余年中，从Linux、MySQL到Kubernetes、Spark、Presto和MongoDB，开源一直是云创新的支柱，但部分大型云服务商正在改变开源的形态，可能会破坏开源创新的激励因素。大型云服务商很容易获取到优质的开源项目，并将其作为托管服务提供给客户。这些大企业并没有动力去回馈开源社区，很自然地从这些别人的工作中获得不公平的利润，从而破坏了开源创新所需要的发展动力。如果这种现象持续存在，将会极大地对开源从业者创办企业和获得投资方面产生抑制作用。

另外一些国际巨头不断通过垄断开源生态，在产业链中掌握极大话语权，并以此获益。例如Google旗下的操作系统Android、浏览器Chrome、深度学习框架TensorFlow、容器编排引擎Kubernetes等，分别在各自的领域占据优势地位，这些开源产品自身具有一定通用性和适用性，便于后续开发者“不重复制造轮子”而在其产品的基础上进行进一步开发，但又通过人为制造诸如广告服务、有意破坏其他竞品连接Google服务的用户体验等方式排除竞争者获得垄断地位，最后从高达30%的Google应用商店抽成、内置Android系统的Google ADs、GMS服务授权费用等途径获得高额的垄断利润。尽管这些产品本身都是开源的，但中小企业和个体开发者在面对Google限定的服务接口、苛刻的商业条款等问题时，很少有能力再进行创新并反馈开源社区，开放共享的初心被完全破坏殆尽。2020年底，红帽公司宣布2021年底停止维护CentOS 8，2024年6月30日停止维护CentOS 7，这意味着在全球使用广泛的开源CentOS服务器操作系统将停服，后续将无法获得官方升级和补丁，为广大基于开源CentOS服务器操作系统的业务应用带来网络安全风险。

为了积极应对和防范开源软件供应链风险，建立软件物料清单SBOM(Software Bill of Materials)是一个极为必要的工作。SBOM旨在跨组织共享，有助于提供软件供应链成分清单与透明度。根据NTIA(美国国家电信和信息化管理局)的定义，SBOM(Software Bill of Materials，软件物料清单)是一种正式标准化的、机器可读的元数据，它唯一地标识软件组件和依赖，以及它们之间的层级关系；也可能包括版权和许可证等成分数据。NTIA在2021年6月份发布软件物料清单 (SBOM) 最小的“必需元素”，包含以下三类：

- 数据字段（Data Fields）：应当予以追踪的每个组件的文档基准信息，包括供应商、组件名称、组件版本、其它唯一标识符、依赖关系、SBOM数据作者以及时间戳。

- 自动化支持（Automation Support）：支持自动化，包括通过自动生成和机器可读性扩展至软件生态系统。生成并使用SBOM的几种主要数据格式，包括Linux Foundation: SPDX(ISO/IEC 9562)、 SWID (ISO/IEC 19770-2)和 CycloneDX (OWASP)

- 实践和流程（Practices and Processes）：定义 SBOM 请求操作、生成和使用，包括频率、深度、已知的未知、分布式和交付、访问控制和错误缓解。

Synopsys公司将“为消费者提供SBOM”是关键的供应链安全实践和方法，认为可以降低供应链安全风险。2022年美国政府NIST发布《通过安全的软件开发实践增强软件供应链的安全性》及OpenSSF发布《开源软件安全动员计划白皮书》等，都要求“软件开发者需提供详尽的SBOM”，从源代码溯源做起保障软件供应链的安全性。根据Linux基金会的调研报告，SBOM对于提升软件供应链安全有三大收益：

- 51%的人表示，开发人员更容易理解应用程序中组件之间的依赖关系

- 49%的用户表示更容易监控组件的漏洞

- 44%的人指出，管理许可证合规变得更容易

2022年下半年美国和欧盟都发布了新的供应链安全相关要求法案或草案，要求厂商评估供应链数字化产品的安全性，此举旨在保护供应链安全，防止SolarWinds等安全事件的再次发生。2022年9月美国《通过安全的软件开发实践增强软件供应链的安全性》备忘录主要针对联邦政府的供应商，要求供应商对产品进行安全自证，如果为联邦政府重点关注的产品，则需要第三方评估。其中有一点要求：如果为联邦政府重点关注的产品，软件开发者需提供详尽的SBOM。同样，欧盟则在2022年9月15日发布了题为《网络弹性法案》（Cyber Resilience Act）的草案，预计在2024年生效，旨在为联网设备制定通用网络安全标准。法案要求所有出口欧洲的数字化产品都必须提供安全保障、软件物料清单SBOM、漏洞报告机制，以及提供安全补丁和更新等。违反规定的公司将面临最高1500万欧元或全球营收2.5%的罚款。其中针对出口到欧盟的数字化产品，带有软件的产品制造商有一点要求:提供至少需包括产品的顶层依赖关系的软件物料清单SBOM。

为了更加准确的建立SBOM，以及根据SBOM判断一个复杂的开源软件的供应链安全状况，还需要建设开源软件供应链基础设施平台，形成开源软件采集存储、开发测试、集成发布、运维升级等一体化设施，打造服务中国乃至全球的开源代码知识图谱和开源软件供应链体系。以中国科学院软件研究所为例，从2019年起在中科院先导专项的支持下开始建设开源软件供应链管理平台，目前已完成设施原型开发以及可视化展示。平台累计完成超过662万款开源软件的采集及对应知识图谱构建，是当前已知最大规模源代码知识图谱：代码量超过100亿行，软件图谱实体数量超过1300万个，节点属性超过781种，关系数量超过1.8亿条，涵盖操作系统、数据库、人工智能等主要供应链。基于知识图谱技术，设施对数百万开源软件属性特征和结构特征进行了分析，结合重要性算法、流行度算法、安全性算法、风险预警算法及软件健康度评判机制，实现了对于开源软件供应链关键节点的识别与验证。此外，实时监控开源软件漏洞事件舆情，做到早发现、早评估、早修复，保证关键节点的安全可靠。在开源人才培养方面，中科院软件所于2020年发起了“开源软件供应链点亮计划”，包含“开源之夏”、开源维护人员招募计划等系列活动，旨在搭建高校开发者与开源社区的沟通桥梁，吸引高校开发者参与开源社区贡献。	
	

### 9.2.4 开源面临平台垄断和生态风险

开源是建立在开发者不应受制于特定平台的理念之上的。与其他类型的开发者相比，开源开发者似乎更应该不受平台效应的影响。在GitHub之前有整整两代自由和开源的开发者，他们使用的工具在没有GitHub的情况下也能正常工作，而且有技术娴熟的用户，他们对便符解决案有很高的容忍能力。开源代码托管平台作为开源开发协作中降低创新成本的基础设施，是开源生态发展中的路和桥

然而，GitHub在全球范围内都继续占据主导地位，就连1999年成立的保护伞型组织Apache软件基金会(Apache Software Foundation)，也在2019年将它们基于Git的项目迁移到GitHub。人们一度认为，Apache软件基金会不愿采用现代开源工具，使得中国面临开源平台非对称依赖性生态风险。

早在2020年，来自伊朗、克里米亚等地工程师表示，其GitHub账户突然无法正常使用，继而引发全球知名开源项目托管平台GitHub开始限制受美国贸易制裁国家的开发者使用该平台的猜测。2019年7月28日，GitHub首席执行官奈特•弗里德曼对GitHub限制伊朗等地账户给出的回应，并承认“GitHub受美国贸易法的约束，就像任何在美国开展业务的公司一样”。GitHub表示，未来将全面检查政府的授权，以确保用户和客户不受法律要求的影响。

为了遵守美国的贸易管制法律，GitHub最近三年来对服务方式做了一些必要的修改。GitHub官方对托管平台与美国贸易管制相关的细则发布了正式的详细说明，说明中指出，“GitHub.com，GitHub Enterprise Server以及用户上传到Github任一产品的信息可能受到贸易管制法规的约束，包括美国出口管理条例（EAR）；美国的贸易管制法律限制了某些国家和地区的用户使用 GitHub.com服务，根据美国财政部外国资产控制办公室（OFAC）颁发的授权，GitHub可允许受到美国制裁的国家和地区的用户使用某些免费GitHub.com服务，禁止的范围包括通过使用位于这些受限国家与地址的IP代理、VPN以及其他伪装方式”。

由此可见，根据美国和其他适用法律，特别指定国民（SDN）和其他被拒绝或被封锁的人士将被禁止访问或使用GitHub.com，其他用户不不能代表受制裁国家/地区的政府使用GitHub.com。GitHub官方称，随着美国贸易管制法律的发展，GitHub将继续与美国监管机构合作讨论，以便了解能够在多大程度上为受制裁市场的开发商提供免费代码协作服务。

开源生态建设对信息技术发展意义重大，开源平台已经成为数字时代的重要基础设施，发达国家科技巨头借助开源力量能够对其自身产品进行完善，提升与下游公司及开发者的合作黏性，构建更为完整的产业生态，强化自身话语权。2018年GitHub被微软以75亿美元收购，曾引发开源社区恐慌，并造成一部分开发者流失。此次GitHub对美国政府贸易管制条例的妥协，更引发了全球开发者对开源社区是否无国界的担忧。虽然GitHub尚未对中国开发者采取限制行动，但我国构建开源生态的步伐亟需加速。

目前，我国科技公司和开发者均大多使用国外开源平台，一旦国外公司对开源平台进行管控，我国将面临由于平台迁移带来的巨额成本，并存在产业供应链安全的巨大隐患。虽然我国企业近几年逐步重视开源布局，涌现了一批开源平台、开源库等，但因对于核心技术、开源规则掌握不足，响应者较少，发展较为缓慢。未来，我国需要加速推进开源许可证、软件专利等知识产权服务工作，鼓励建立指导委员会、项目领队、代码守护人、代码审核员、代码贡献者、超级用户、开源社区等开源组织，推动完善Star点赞、Fork复制分枝、下载量，关键问题修复等开源代码的质量体系升级，探索具有全球影响力的开源商业模式，加快营造国内开源氛围，提升我国企业在全球主流开源生态中的贡献度及话语权，实现由参与者向贡献者再到构建者的升级。

综上所述，我国构建开源平台生态仍面临四方面严峻挑战。第一，我国开源生态建设起步相对较晚，在开源生态构建方面仍面临严峻的内外部形势，对开源核心技术的掌控能力不足，包括原创性开源技术不足、开源规则的运用不熟练等。第二，开源生态领域企业、政府和社会三者之间的协同模式尚未成形，国内企业尚未找到合适的开源商业模式。第三，崇尚开源创新开放包容的社会环境尚未形成，全社会缺乏对开源社区治理活动的持续性资金投入和人才输入。第四，融入国际开源社区较为困难，在国际主流开源社区和开源项目上缺少主导权和话语权。

为应对风险挑战，需要在三方面推进我国开源生态建设。

（1）多种方式推动开源应用推广

发展开源具有重要社会效益和经济效益，我国应运用多种方式推动开源方案应用推广。一是加快研究开源知识产权认定法律法规，解决著作权归属、流入代码知识产权等共性法律问题，为未来应对国际开源知识产权纠纷做好准备。二是通过政府采购推动开源方案应用实践。三是强对开源技术、开源理念和开源文化的教育和宣传，为开源方案或混合方案的使用提供指导和实践指南。四是鼓励将开放性、公益性研发项目开源，逐步形成制度性要求，以提高全社会的开源意识。

（2）完善相关开源社团自治组织和基金会的资金组织制度

我国已经出现支持开源创新的基础平台，但持续发展缺少有效机制和制度保证。一是应通过开源基金会模式，鼓励社会力量与政府共建公益性开源创新生态环境。二是积极学习借鉴Linux基金会、Apache基金会等国外成功开源社区的基金会运行模式。三是建立更完善非盈利性的基金会组织机制和法律制度，有效汇聚社会力量，提供持续的开源创新服务。

（3）构建开源生态基础设施和配套环境

一是大力支持开源模式探索，加强开源生态机理、方法和技术的研究。二是构建开源软件生态核心资产库，推动政府、大型科技企业、中小创业企业、高校科研机构等多主体参与开源建设。三是建设公共开源支撑平台，推动构建适合中国软件开发者群体特点、协作习惯的开源工具和社区机制。四是支持建立若干中文开源社区，为开源生态建设提供持续技术支持。五是加强开源软件人才培养，调动广大科研人员参与开源热情，打破企业和科研机构的界限，建立产学研协作的开源实践平台。

### 9.2.5 开源面临人才风险

**（1）人才供需对接的效率低**

据GitHub《2021年度Octoverse报告》统计，中国开发者人数占比排名第二，有755万+。按照中国数字经济转型发展的要求，2022年中国有1200万的人才需求缺口。

**（2）高技能人才匮乏，结构性供给不足尤为突出，顶尖开源人才更难寻**

自然语言处理、视觉识别、语音识别等人工智能领域的人才缺乏尤其严重。企业找到恰当的、需要的人才成本依然很高，普通大学毕业生去企业之后要1~2年才能适应开源等工作的岗位要求，总体来看，人才培养周期长，加剧了企业的开源人才挑战。

**（3）企业对开源人才的培养成本投入少，开源人才留存困难**

由于工作时间长、压力大、企业凝聚力弱等问题，给开源人才的留存造成了一定困难。加之多数企业存在人力成本居高不下，对开源人才的支持与培养投入少，导致在开源人才管理方面也面临一些挑战。

**（4）国内就业文化和试错容错机制差，开源人才压力大，不能长期持续走冷板凳研发源码和产品**

相比ChatGPT几年磨一剑的过程来看，国内就业大环境压力和同行竞争等原因，使人员团队很难静下来研发和打磨，大部分以短平快的研发为主。而由于年龄歧视的原因，一些有经验的专家级开发人员又很难有用武之地，被迫中断原来积累的经验和技术。

基于以上的挑战，建议从四个方面缓解开源人才危机：

1. 加强以高校开源培养教育体系为主的系统化国家人才培养体系。在高校推进开源教育，建立产学研一体化开源创新人才培养体系，是我国开源创新人才培养的重要路径。首先，可基于优秀开源成果进行课程体系设计、师资队伍建设和培养计划制定，策划和参加各类国内外开源竞赛，培养开源创新人才，支撑形成可持续发展生态。其次，加强开源文化和开源技能教育，建立鼓励软件成果开源的评价机制和价值导向，推动高校产出更多原创性开源成果。最终，以开源教育为抓手，打造新型产教融合平台，建立从高校开源学习、产业开源实践到开源创新创业的闭环，服务中国软件产业发展。

2. 加强开源社区建设及社区间合作。据调查，50%以上企业管理者认为 “从开源项目团队或开源活动中直接引入”是开源人才引进的有效渠道。而不同开源社区间多合作，更能促进整体的开源生态繁荣。麦肯锡《2022年人工智能状况——五年回顾》的报告中指出，虽然企业组织除了从顶级技术大学和科技公司招聘人才之外，也更有可能从其他大学、培训学院和以多元化为重点的项目或专业组织寻找人才。

3. 建立企业开源人才成长体系的培养机制，国家设立职业技能认定条件和政策。多数企业有针对开源人才成体系的培养机制，增加对现有员工的培训，不仅可以缩小技能差距，为开源人才提供培训机会，也正在成为吸引他们留下来的重要方式。国家可以通过考试等方式设立开源工程师、数据科学家和人工智能工程师等相关岗位，使人才成长体系和成长通道有章可循。

4. 优化开源人才薪酬福利待遇，增加多元化职业吸引力。薪资福利一向是吸引人才的有效手段。据调查，39%的公司愿意给予开源人才的加薪幅度高于其他业务人员。近半数受访开源企业，为开源人才提供的薪酬总额（税前），包括工资、奖金和津贴，考虑的上调比例是10%~20%。优化开源人才薪酬福利待遇有助于增加开源相关岗位的吸引力，一定程度上可缓解开源人才危机。在薪酬相同或者不占优的环境下，还需要从职业荣誉感、社会责任和国家使命等多方面提供激励和条件，留住人才。
