# 附录1：中国开源大事记

### 1991年

* 中国开源诞生元年，中美合作引进Unix SVR4.2。陆首群和杨天行牵头，代表中方代表团与美国AT&T公司合作，美方将当时最新开发的Unix版本——Unix SVR4.2源代码向中方开放（除美国外，中国是全球获得源代码的第二家）。此后，中方组织全国软件专家、程序员等200多人共同翻译、编辑、出版了“Unix SVR4.2中文版本”。中美合作引进Unix SVR4.2”这一历史事件被Linux基金会收录，后被作为中国开源诞生的标志性事件，1991年也就此成为中国开源的诞生元年。

### 1992年

* 成立合资UNIX公司，产生深远影响。国内计算机软硬件厂商与USG合资成立UNIX(中国)系统技术有限公司，对后续Unix/Linux在中国的发展和普及，以及开源文化的传播有深远影响。

### 1994年

* Linux与自由软件被引进中国。Linux操作系统和大量自由软件被宫敏引进中国，国内技术人员开始接触到Linux 。同时，自由软件的火种开始在国内传播。

### 1997年

* 建立“中国自由软件库”。通过国家信息中心的帮助，宫敏在中国经济信息网上建成“中国自由软件库”。为国内技术人员了解、学习和使用Linux及相关自由/开源软件提供了便利。

### 1998年

* LVS（Linux Virtual Server，Linux虚拟服务器）诞生。用于实现负载平衡，其代码进入了Linux 2.4和2.6版本的官方内核中。章文嵩是这一开源软件创始人。
* 开源Linux图形用户界面支持系统“MiniGUI”进入开发。由魏永明发起，历经十余年的迭代更新，MiniGUI可支持Linux/uClinux、eCos、μC/OS-II、VxWorks、ThreadX、Nucleus、pSOS、OSE等操作系统和数十种SoC芯片。 
* 冲浪平台成功实现中文Linux操作系统第一次商业应用。该司研发的Xteam Linux中文操作系统成功在北京市政府研究室办公OA系统中实现应用。
* 中国第一批开源社区——阿卡社区（AKA）在清华大学成立。后该社区转变成为亚嵌公司，AKA早期的多数成员成为中国最早的一批Linux人才。
* 国内Linux内核工程师开始参与国际开源项目。正在自动化系读大二的学生吴峰光开始接触Linux，发现Linux的文件预读算法磁盘I/O性能较差，开始尝试对Linux内核进行改进。吴峰光后来成长为国内对Linux内核贡献最多的工程师。

### 1999年

* 中文版红旗Linux和RedOffice进入研发。由中国科学院软件所的孙玉芳牵头，基于Linux和OpenOffice进行了中文版红旗Linux和RedOffice的研制。
* 国内专业开发者社区CSDN成立。蒋涛创立中国软件开发者社区CSDN，目前已成为中国最大的开发者社区。22年来，CSDN为中国培养了几代开源开发者，同时也见证了中国开源快速发展的20年，目前正积极向第三代开源社区转型。
* 蓝点最早发布中文Linux版本——BluePoint Linux。蓝点团队发布汉化的BluePoint Linux，这是全球最早的中文Linux版本。同年，蓝点软件技术（深圳）有限公司创立。

### 2000年

* 共创软件联盟成立。在“863计划”支持下，国内高校、研究院所、IT企业联合发起成立“共创软件联盟”。联盟在开源许可证规则下对863计划的软件成果进行开源培育和孵化，提出以“开放源代码的协同创新模式”作为中国基础软件发展的主要路径，对我国开源产业发展起到了重要推动作用。
* 北京市科委筹建软件产业基地公共技术支撑体系。为提升北京软件产业工程化水平，北京市科委筹划建设北京软件产业基地公共技术支撑体系。

### 2001年

* Sun中国工程研究院成立。研究院内部设立Mozilla、Office、Java等小组，是外资公司首次在中国设立全职参与开源社区研发的研发中心，为中国培养了大批开源人才。
* Intel中国开源技术中心（OTC）成立。该中心于2003年正式更名为Intel开源技术中心。经过近20年发展，中心为中国开源产业界培养了大批顶尖专家。

### 2002年

* 国内第一个Linux社区发行版发布。黄建中以“CJacker”的ID在中国Linux公社发布了基于Redhat8再发布的Magic Linux版本，Magic Linux是国内第一个Linux社区发行版。
* 北京软件产品质量检测检验中心成立。负责运营管理公共技术支撑体系。

### 2003年

* IBM中国Linux解决方案合作中心在北京中关村软件园正式启动。该中心由IBM公司和北京市政府合作，联合众多国内软件开发公司，目的是为国内提供Linux实验平台，培养Linux软件开发人才。
* 中国科技论文在线网正式开通。作为中国最早的开放存取仓储之一，中国科技论文在线网为科研人员提供了方便、高效的交流平台，让最新科研成果得以及时推广，科研思想得到有效保护。
     
### 2004年

* 中、日、韩三国政府在北京签署“开放源代码软件合作备忘录”。这是三国首次将软件开源提升到国家级的战略合作层面。备忘录内容包括：三国政府将为开放源代码软件，尤其是Linux的开发和应用创造政策环境、加强Linux对三国语言的支持、推动Linux软件的研发和商品化以及在三国中的应用、大力推广Linxu在电子政务/企业信息化和远程教育等领域中的应用等。7月，由三国政府倡导的Linux平台Asianux1.0发布。
* 中国科学院和国家自然科学基金委员会签署了《柏林宣言》。这一举动表明了中国科学界和科研资助机构支持开放获取的原则和立场。
* 中国开源软件推进联盟（COPU）成立。该联盟由永中、金山、中文 2000、中科红旗、IBM、HP、Intel、Novell等公司参与发起，是中日韩三国签署开源软件合作备忘录后的具体行动举措之一。

### 2005年

* 国家自然科学基金委员会正式发布“国家自然科学基金基础研究知识库”。该知识库收集国家自然科学基金资助项目成果的研究论文全文，向社会公众免费开放。
* Mozilla中国中心成立。Mozilla中国中心是由中国科学院软件研究所和Sun中国工程研究院共同发起，经Mozilla Foundation正式授权的非赢利性机构，该中心依托在中国科学院软件研究所。

### 2006年

* 中国开源软件推进联盟（COPU）主办“2006年第一届开源中国开源世界高峰论坛”。主题为“开放标准，开源架构，开源生态系统与应用解决方案”，大会讲师24位，包括担任COPU智囊团高级顾问的全球开源领袖及跨国企业专家，与会中外代表约250人。
* 首届中国Linux内核开发者大会（CLK）成功举办。Intel、清华大学、AKA社区共同发起第一届中国Linux内核开发者大会（CLK）。该大会延续至今，成为中国开源领域的顶级技术峰会，发掘出吴峰光、马涛等一批内核领域的顶尖专家。

### 2008年

* Kernel、Apache、OpenOffice等国际知名开源社区在北京召开全球技术峰会。这是国际开源组织首次在亚洲国家举办技术峰会，是对中国开发者为社区所做贡献的肯定，也成为中国开源发展史上重要的里程碑。
* 阿里巴巴开始研发孵化Dubbo（开源分布式服务框架）。这是一款高性能、轻量级的开源Java RPC框架。2019年5月16日，Apache 软件基金会董事会决议通过了 Apache Dubbo的毕业申请。
* 开源爱好者红薯创建开源中国（OSCHINA）社区。该社区十多年来推动了中国开源领域的发展。
* 76位华人为Linux Kernel贡献822个补丁，2008北京Linux开发者研讨会在京召开。在COPU与国际Linux基金会合作举办的“2008 北京Linux开发者研讨会”上，中国新锐与国际开源社区资深大师同台研讨，针对Linux Kernel2.6.29，在该版本 11232个补丁中，由76位华人（占获得成功的志愿者总数6.85%）向社区贡献822个补丁（占全部补丁7.20%）。

### 2010年

* Linux基金会在中国设立分支机构。任命Cliff Miller出任基金会中国首席代表，这也是Linux基金会首次在中国设立分支机构，希望通过此举进一步推进Linux平台在中国的普及化。

### 2011年

* 阿里开源fastjson和Druid。fastjson是JSON解析库，可以解析JSON格式的字符串，支持将Java Bean序列化为JSON字符串，也可以从JSON字符串反序列化到Java Bean。Druid是Java语言中的数据库连接池，能够提供强大的监控和扩展功能，包括监控数据库访问性能、提供WallFilter等。

### 2012年

* 中国开源云联盟成立。英特尔亚太研发有限公司、新浪网技术（中国）有限公司、中标软件有限公司以及上海交通大学正式签署协议，联合成立“中国开源云联盟”，该联盟是国内首个联合产学研各方组建的开源组织。旨在按照国际上OpenStack开源社区的工作方针，整合中国OpenStack开发者和中国公司的研发资源。
* 腾讯发布首个对外开源项目Tinker。Tinker作为腾讯的第一个开源项目，是Android热解决方案库，支持在不重新安装apk的情况下对dex、library和resources进行更新，推动了Android产品和社区的发展。

### 2013年

* 三方合作开发Ubuntu Kylin。由中国工业和信息化部下属中国软件与集成芯片推广中心（CSIP）、Canonical、国防科技大学三方组成的“CCN开源联合促进实验室”成立，合作开发面向中国用户的Ubuntu版本——Ubuntu Kylin（优麒麟） 。
* OSCHINA上线了Gitee（码云）。开发者超过800万，托管项目超过2000万，覆盖几乎所有本土原创开源项目。
* CSDN宣布推出代码托管协作平台“CODE”。该系统搭建于阿里云IaaS平台上，向个人开发者、IT团队及企业提供代码托管、在线协作、社交编程、项目管理等服务，这也是国内推出的第一家代码托管平台。
* W3C（万维网联盟）将北京航空航天大学的中国办事处升级为全球总部。2003年，W3C首次在中国举办“中国国际万维网发展论坛”。2011年，百度加入W3C，成为国内首个加入W3C的互联网企业。随后，腾讯、360等互联网企业纷纷加入。 

### 2015年

* 国务院提出要大力发展开源社区。国务院在《关于积极推进“互联网+”行动的指导意见》中提出大力发展开源社区。鼓励企业自主研发和国家科技计划（专项、基金等）支持形成的软件成果通过互联网向社会开源。引导教育机构、社会团体、企业或个人发起开源项目，积极参加国际开源项目，支持组建开源社区和开源基金会。鼓励企业依托互联网开源模式构建新型生态，促进互联网开源社区与标准规范、知识产权等机构的对接与合作。

### 2016年

* 国务院支持开源社区创新发展。国务院在《“十三五”国家信息化规划》中提到，引导和支持产学研用深度融合，推动龙头企业和科研机构成立开源技术研发团队，支持科技型中小企业发展，构建产学研用协同创新集群。支持开源社区创新发展，鼓励我国企业积极加入国际重大核心技术的开源组织，从参与者发展为重要贡献者，在优势技术领域争当发起者，积极维护我国相关标准专利在国际开源组织中的权益。
* 云计算开源产业联盟（OSCAR）成立。由工业和信息化部信息化和软件服务业司指导，中国信息通信研究院联合多家云计算开源技术公司发起，中国通信标准化协会代管的云计算开源产业联盟（OSCAR）成立，该联盟是业界首个专注于云计算市场的开源产业联盟。
* 国内首个非Hadoop生态体系的顶级项目RocketMQ从Apache毕业。由阿里巴巴捐赠给Apache社区的开源项目RocketMQ正式毕业，成为Apache顶级项目（TLP）。
* 中国首个自主研发的产业级深度学习平台飞桨（PaddlePaddle）正式开源。飞桨以百度多年的深度学习技术研究和业务应用为基础，是中国首个自主研发、功能完备、开源开放的产业级深度学习平台。

### 2017年

* 《新一代人工智能发展规划》提出开源开放推进人工智能。7月20号，国务院发布的《新一代人工智能发展规划》提出中国推进人工智能的四条原则：科技引领、系统布局、市场主导、开源开放。其中在开源开放的原则下，共同建设一个体系化的AI技术体系。
* 新一代人工智能产业技术创新战略联盟（AITISA）成立。由北京大学、中关村视听产业技术创新联盟等联合倡议，在科技部试点联盟——数字音视频编解码（AVS）产业技术创新战略联盟的基础上，新一代人工智能产业技术创新战略联盟成立。
* 阿里巴巴捐赠给Apache社区的开源项目RocketMQ正式毕业，成为Apache顶级项目（TLP）。自此，RocketMQ成为国内首个互联网中间件的Apache顶级项目。
* 百度正式对外开源Apollo自动驾驶。Apollo开放平台可以帮助汽车行业及自动驾驶领域的合作伙伴结合车辆和硬件系统,快速搭建一套属于自己的自动驾驶系统。目前该平台已完成11个版本迭代，全球拥有135个国家超80000名开发者，合作伙伴超210个，开源代码量总体70万行。
* BCOS开源。BCOS由微众银行、万向区块链、矩阵元三方研发，是聚焦于企业级应用服务的区块链技术平台，于2017年7月31日完全开源。
*  Linux基金会授予陆首群“推进开源终身成就奖”。Linux基金会首次在中国召开LC3(LinuxCon & ContainerCon & CloudCon)会议。会上，Linux基金会授予中国开源软件推进联盟名誉主席陆首群“推进开源终身成就奖”。

### 2018年

* 国务院支持建设一批能够融入国际化发展的开源社区。国务院在《关于深化“互联网+先进制造业”发展工业互联网的指导意见》中提出，面向关键技术和平台需求，支持建设一批能够融入国际化发展的开源社区，提供良好开发环境，共享开源技术、代码和开发工具。
* 国家部委首次以国家科技专项支持开源生态建设。科技部下发国家重点研发计划专项——《云计算与大数据开源社区生态系统》项目，这是国家部委首次以国家科技专项方式支持系统化地推进开源社区生态系统建设。
* 中国人工智能开源软件发展联盟成立。由工业和信息化部、北京市人民政府共同主办， 中国电子技术标准化研究院、中国人工智能开源软件发展联盟(筹)具体承办下，中国人工智能开源软件发展联盟成立大会召开，宗旨是推动我国人工智能开源软件技术和产业发展。
* 中国RISC-V产业联盟成立。由国内外RISC-V领域重点企业、研究机构和行业协会发起的中国RISC-V产业联盟正式成立，旨在解决中国RISC-V领域共同面对的关键问题。包括：建立中国国产自主、可控、安全的RISC-V异构计算平台，促进形成贯穿IP核、芯片、软件、系统、应用等环节的RISC-V产业生态链。
* 中国开放指令生态（RISC-V）联盟成立。由中科院计算所、北京大学、清华大学等近20家国内研究机构和企业联合发起的中国开放指令生态（RISC-V）联盟成立，中国工程院院士倪光南担任理事长。
* 3个原创于中国的项目进入了CNCF。三个项目分别是：Harbor，开源镜像仓库项目，用于容器镜像管理；TiKV，开源分布式事务键值数据库；Dragonfly，由阿里巴巴开源的云原生镜像分发系统。
* 专为物联网设计的轻量级开源虚拟化管理软件ACRN推出。该项目完全由Intel中国开源技术中心实现，从架构设计到团队管理，所有参与项目的工程师都在上海和北京。ACRN为IOT和汽车量身订作虚拟化软件，是该业界第一个开源的软件项目。
* 云原生计算基金会CNCF授予陆首群“开源领袖奖”。CNCF执行董事Dan Kohn代表CNCF在上海召开的首届CNCF&KubeCon国际开源会议上向中国开源软件推进联盟名誉主席陆首群颁发“开源领袖奖”，以表彰对中国开源事业乃至全球开源事业的突出贡献。

### 2019年

* OpenCV中国团队成立。引导中国开发力量为OpenCV作贡献，同时改进OpenCV，使之适应未来应用，特别是机器人相关应用，促进科研成果快速应用。
* 木兰开源社区建立。由中国电子技术标准化研究院牵头建立的木兰开源社区，是国家重点研发计划重点专项“云计算和大数据开源社区生态系统”的成果之一，旨在促进产学研用各方开源领域的交流，推动国家科技创新成果开源等。
* OpenI启智平台成立。OpenI启智是新一代人工智能产业技术创新战略联盟组织产学研用各界，通力协作、共建共享的开源软件、开源硬件、开放数据社区。
* 头歌社区建立。该社区主要为高校和企业提供开放的科教项目和课程资源在线开发与服务环境，支持五大类课程/金课建设、实验教学环境建设、科研创新环境建设、工程教育专业认证体系建设等工作。
* 数字孪生体联盟成立。由工业4.0研究院牵头发起成立数字孪生体联盟，通过运行数字孪生体创新中心，重点建设开源社区和发掘应用场景。
* SODA Foundation中国区启动。Linux基金会数据与存储领域的首个子基金会SODA Foundation中国区正式启动，旨在通过智能开放的数据自治标准化建设，帮助用户应对数据基础设施云化转型过程中的挑战。
Angel成国内首个从LF AI基金会毕业项目。腾讯自主研发的Angel从Linux基金会LF AI毕业，成为国内首个从LF AI基金会毕业的项目。
* 华为提出软件开源战略。华为自研操作系统鸿蒙和方舟编译器开源，宣布未来会将服务器操作系统EulerOS、AI计算框架MindSpore和单机版数据库GaussDB OLTP全部开源。
* 全球Star数最高的React组件库项目。阿里开源的企业级UI设计语言Ant Design在GitHub的Star数突破5万。2019 年 7 月，Ant Design的GitHub star数超过Material UI，成为全球Star数最高的React组件库项目。
* 阿里开源芯片——无剑100 Open。平头哥公司推出开源物联MCU芯片平台——无剑100 Open，包含了玄铁处理器、基础接口、开发环境和OS的开源芯片平台。希望能把整个芯片研发周期缩短50%，开发成本降低50%，被阿里定位为面向下一代的AIoT产品平台。
* 全球首个开放云原生应用模型OAM正式开源。首个开放云原生应用模型OAM（Open Application Model）由阿里巴巴和微软联合开源，这是业界第一个云原生应用标准定义与架构模型。
* 全球首个通用安全计算平台Teaclave进入Apache孵化。由百度主导研发的Teaclave进入Apache孵化，该平台基于硬件安全能力（Intel SGX），确保敏感数据在可信域外和离岸场景下安全可控的流通和处理。2020年10月，Teaclave社区正式通过并发布了0.1.0版。

### 2020年

* OSI批准MulanPSL-2.0。2019年，中国首个开源许可证正式发布，名为木兰宽松许可证（Mulan Permissive Software License, Mulan PSL）。2020年，木兰宽松许可证（第2版）正式成为国际化开源许可证。
* Linux基金会宣布成立OpenSSF。OpenSSF可以实现跨行业协作，通过构建具有目标计划和最佳实践的更广泛社区，将领导者聚集在一起，以提高开放源码软件的安全性。
* 开放原子开源基金会成立。由阿里巴巴、百度、华为等十家龙头科技企业联合发起的开放原子开源基金会成立，填补了中国没有开源基金会的空白。
* 上海白玉兰开源开放研究院揭牌。上海白玉兰开源开放研究院是由上海交通大学牵头建设，目标是推动人工智能开源产品的国际规则互认，催生国际开源生态网络关键节点等。
* CSDN推出全新升级的开源代码托管平台GitCode。GitCode具有面向国际化市场，使用最新GitLab最新高可靠部署方案，独立第三方平台等特点。
* 工信部等部门联合Gitee建设中国独立的开源托管平台。由开源中国牵头，联合10家单位组成的联合体中标“2020年开源托管平台项目”招标，联合体依托Gitee（码云）建设中国独立的开源托管平台。
* 清华大学发布自主研制开源时间序列数据管理系统Apache IoTDB。为解决工业互联网领域的时间序列大数据管理需求，清华大学软件学院王建民带领团队自主研制了面向工业领域的开源时间序列数据管理系统Apache IoTDB，成为中国高校首次在Apache国际开源社区发布的软件项目。
* 华为关系型数据库openGauss开源。该数据库在ARM架构芯片上深度优化，并兼容X86架构，采用木兰宽松许可证（MulanPSL-2.0）开源。
* 阿里云开源Kubernetes上第一个云原生平台构建引擎，以及完整实现的OAM模型——KubeVela。KubeVela的开源和规模化落地证明了以OAM为基础的开放应用架构是一条能够充分释放云原生潜力的有效路径，推动OAM成为中国信通院主导发布的《云计算开放应用模型》标准框架。
* 阿里巴巴开源Easy系列算法框架EasyTransfer。阿里云机器学习PAI开源了业界首个面向NLP场景的深度迁移学习框架EasyTransfer。
* 腾讯云企业级分布式KV数据库Tendis开源。Tendis兼容Redis核心数据结构与接口，可提供大容量、低成本、强持久化的数据库能力，适用于兼容 Redis协议，需要大容量且较高访问性能的温冷数据存储场景。
ALC-Beijing向Apache软件基金会申请并成立。ALC-Beijing是面向北京的Apache本地开源社区组织。目前该组织包含10多个Apache顶级项目，包括Kylin、Eagle、RocketMQ、 ServiceComb、Griffin等项目。

### 2021年

* 开源进入国家“十四五规划”。在《中华人民共和国国民经济和社会发展第十四个五年规划和2035年远景目标纲要》中，“开源”被首次提及，标志着发展开源成为我国十四五期间的重要工作之一。随后，中共中央、国务院印发的《知识产权强国建设纲要（2021－2035年）》《国家标准化发展纲要》等国家级发展纲要以及《“十四五”国家知识产权保护和运用规划》《“十四五”数字经济发展规划》《“十四五”国家信息化规划》等“十四五”规划，以及工信部、中央网信办、科技部等部委发布印发的《关于加快推动区块链技术应用和产业发展的指导意见》《物联网新型基础设施建设三年行动计划（2021-2023年）》《关于规范金融业开源技术应用与发展的意见》等一系列政策文件，都将开源作为技术创新的主流模式，在多个方面明确提出支持开源发展。 
* 工信部将开源纳入重点工作。工信部发布《“十四五”软件和信息技术服务业发展规划》，将“开源重塑软件发展新生态”作为“十四五”期间我国软件产业的四大发展形势之一进行重点阐述。明确提出“建设2-3个有国际影响力的开源社区，培育超过10个优质开源项目”的发展目标，并把“繁荣国内开源生态”作为工作任务，设置“开源生态培育”为专项行动，把“培育重点开源项目、建设优秀开源社区、提升开源治理能力”作为专项行动主要工作，把“加强软件源代码检测和安全漏洞管理能力、提升开源代码、第三方代码使用的安全风险防控能力”作为强化安全服务保障的重要内容，这是国家级产业规划首次把开源单独作为一个重点工作来部署。 
* 五部委发布《关于规范金融业开源技术应用与发展的意见》。中国人民银行办公厅、中央网络安全和信息化委员会办公室秘书局、工业和信息化部办公厅、中国银行保险监督管理委员会办公厅、中国证券监督管理委员会办公厅发布《关于规范金融业开源技术应用与发展的意见》。
* 第一届中国开源教育研讨会（SOSEC）召开。中国第一届开源教育研讨会在四川民族学院举行。来自华东师范大学、四川大学、上海交通大学、东北大学、西北工业大学、中山大学、暨南大学、桂林电子科技大学、四川民族学院、中国科学研究院等高校和研究院（所）的40余名专家、学者汇聚一堂，共同探讨开源教育。
* 科创中国”开源创新联合体成立。该联合体是由中国科协科学技术传播中心、中国电子学会、腾讯、百度、麒麟软件、CSDN等36家单位共同发起成立的开放性、非营利、非法人组织。联合体以打造自主开源生态为宗旨，以建设产学研深度融合的开源创新体系为目标。自成立以来，推进成立了中关村传播中心；共建18万平方米开源教育实训基地；组织“科创中国”开源创新榜单评审等。
* 中国计算机学会CCF开源发展委员会正式成立。该委员会旨在推动探索学术共同体主导的开源发展新途径，聚焦共同打造开源、开放、中立的产学研协同开源创新服务平台，探索建立CCF开源项目孵化机制，培育原始开源创新项目。
* 华为正式发布面向数字基础设施的开源操作系统欧拉（openEuler）。该操作系统可广泛部署于服务器、云计算、边缘计算、嵌入式等各种形态设备，应用场景覆盖IT、CT和OT，实现统一操作系统支持多设备，应用一次开发覆盖全场景。
* 浪潮研发的NewSQL分布式数据库ZNBase开源。ZNBase参考谷歌Spanner/F1的设计思想，SQL层使用Go语言开发，基于开源CockroachDB修改，重写其商业代码和开源部分代码，代码修改率76%。存储层使用C++开发，采用多模引擎，涵盖结构化、KV、文件存储、时序存储、图存储等。
* 奥星贝斯开源了OceanBase数据库。基于分布式架构和通用服务器，OceanBase实现了金融级可靠性及数据一致性。2020年5月，OceanBase以7.07亿tpmC的在线事务处理性能创造了TPC-C新的世界纪录。
百度开源的ECharts正式从Apache毕业，成为顶级项目。ECharts基于JavaScript的数据可视化图标库，可以生产直观、可交互、定制化的数据可视化图表。
* 第四范式的机器学习数据库OpenMLDB开源。OpenMLDB在半年内实现全球代码托管平台GitHub topics排名。其中，机器学习数据库、AI数据库方向best-match取得Top1；内存数据库、特征存储方向位列Top3。
* 小米推出新一代Kaldi。由小米集团首席语音科学家，原约翰·霍普金斯大学语言和语音处理中心的Daniel Povey主导，正式推出了新一代Kaldi，该项目起源于2009年约翰·霍普金斯大学的夏季研讨会。
* 国内首个违反GPL的案件判决生效。广东省深圳市中级人民法院审理罗盒公司诉风灵公司案的一审判决体现了中国法院对开源软件侵权审理思路的转变。在一审中，法院明确指出 GPLv3 协议是一种民事法律行为，具有合同性质，可以认定为授权人和用户间订立的著作权协议，属于《合同法》调整的范围。此判例称得上是国内首个明确GPLv3协议法律效力的案例，对国内开源软件侵权行为提供了“有法可依”的背书。
全球开源技术峰会GOTC 2021召开。该峰会由开放原子开源基金会举办，由上海站与深圳站组成，覆盖云原生、大数据、人工智能、物联网、区块链、DevOps、开源治理等多个技术领域，为开发者带来全球最新的开源技术。
* 木兰开源社区参加“国家‘十三五’科技创新成就展”。木兰开源社区被国家科技部推荐作为新兴技术板块参加“国家‘十三五’科技创新成就展”，这是我国开源领域首次被国家认可，与蛟龙号、高铁等大国重器一起进入国家顶级科技成就展览。
