# 附录2：开源专有名词

### 开源

开源是促进信息技术创新的重要途径，是将源代码、设计文档或其他创作内容开放共享的一种技术开发和发行模式。技术领域的开源包含源代码+软硬件设计文档源代码、源数据等技术和资源的开放共享，源代码仍然是开源的主要内容。 在开源模式下，通过许可证的方式，使用者在遵守许可限制的条件下，可自由获取源代码等，并可使用、复制、修改和再发布。

### 自由软件

自由软件（Free Software），是指可以付费或不付费得到GNU软件，“Free”关乎自由，而不是价格。一旦得到了软件，便拥有了使用它的四项特定自由。可以自由按照自己的意愿运行该软件；可以自由复制软件并将其送给朋友和同事；可以自由通过对源代码的完全控制而改进程序；可以自由发布改进的版本从而帮助社区建设。

### 商业软件

商业软件（Business Software）是指通过贸易方式向社会公众发行的各种商品化软件。对于商业软件。供应商不仅应该向用户提供程序和使用说明，而且应该向用户提供包括版本更新在内的技术服务，商业软件在知识产权方面的最重要体现是版权（著作权），即商业软件的权利人享有软件及其复制品的发行权。目前国际上通行的商业软件发行方式是向用户提供使用许可。按照这种方式，用户在支付一定费用后，得到的仍不是这份软件复制品的全部权利，而是一种附条件、有限制的权利：即在遵守使用许可协议的条件下，行使由该软件的使用许可协议所规定的若干项权利，如使用、临时复制等。

### 开源供应链

开源软件供应链是一个实际业务系统，在开发和运行过程中，涉及所有开源软件上游社区（Upstream）、源码包（Source Package）、二进制包（Binary）、包管理器（Package Manager）、存储仓库（Repository），以及开发者（Developer）和维护者（Maintainer）、社区（Community）、基金会（Foundation）等，按照依赖、组合、托管、指导等关系形成的供应链网络。

### 开源基金会

开源基金会是开源生态中的重要部分。对于非营利性且处于中立位置的开源基金会来说，他们拥有开源项目的知识产权，而且没有任何商业利益，这为贡献者、开发者以及用户提供了良好的协作平台；基金会也会通过技术服务和项目孵化来帮助开发者和开源企业，如软件仓库、问题跟踪、技术指导、法律支持、项目投资、公共关系维护等；基金会还会提供项目日常的运营和治理，以满足在项目生命周期不同阶段对于管理项目的需求。

### Apache 基金会

Apache软件基金会（Apache Software Foundation，ASF），是专门支持开源软件项目的非盈利性组织。在它所支持的Apache项目与子项目中，所发行的软件产品都遵循Apache许可证（Apache License）。Apache基金会倡导的是合作和贡献，信奉“贡献者→提交者→成员→导师”路径。想成为贡献者，需积极为Apache 社区贡献代码、补丁或文档。想成为提交者，需要成员的指定，而成为了提交者，就会拥有一些“特权”，提交者中的积极分子和优秀生可“毕业”成为成员。

### Linux 基金会

Linux基金会通过提供财务和智力资源，基础设施，服务，活动以及培训来支持创建可持续开源生态系统。Linux是大多数开源软件的基础，该组织的核心目标是推动Linux系统的发展。近年来，随着开源的兴起，Linux基金会适应时代发展的需要，在Linux的基础上扩大涉足领域，并监管大型协作项目。业界Xen、KVM、CNCF、Hyperledger等知名项目，都来自Linux基金会。

### 开放原子开源基金会

开放原子开源基金会是我国首个开源基金会，主要提供基础服务、法律服务、IT基础设施服务、社区运营管理等四大类别服务。该基金会是由民政部登记、工业和信息化部主管的基金会。开放原子开源基金会设理事会、技术监督委员会与秘书处。理事会负责审议和修改基金会章程等；技术监督委员会是其中立的技术决策机构，负责基金会技术相关的决策及项目的孵化评审等；秘书处是基金会的执行机构，负责基金会日常事务等工作。

### 云原生计算基金会（CNCF）

云原生计算基金会（Cloud Native Computing Foundation，CNCF）是Linux基金会旗下的基金会，成立于2015年12月11日，其口号是坚持和整合开源技术来让编排容器作为微服务架构的一部分，是致力于云原生应用推广和普及的一支重要力量。CNCF作为一个厂商中立的基金会，致力于GitHub上的快速成长的开源技术如Kubernetes、Prometheus、Envoy等的推广，帮助开发人员更快、更好地构建出色的产品。，

### 开源基础设施基金会（OIF）

2020年10月，OpenStack基金会（OSF）正式演进为开源基础设施基金会（Open Infrastructureoundation，OIF）。OIF是非盈利组织，在2012年成立。旨在推动OpenStack云操作系统在全球的发展、传播和使用。OIF的目标是在全球范围内服务开发者、用户及生态系统，提供共享资源，以扩大OpenStack公有云与私有云的成长，从而帮助技术厂商选择平台，助力开发者开发出行业最佳的云软件。OIF分为个人会员和企业会员两类，个人会籍是免费无门槛的，他们可凭借技术贡献或社区建设加入OpenStack社区。企业会员则根据赞助会费的情况，分为白金会员、黄金会员、企业赞助会员及支持组织者，其中白金会员的话语权最大。

### OIN(Open Invention Network)专利保护社区

OIN是目前为止最大的专利保护社区，旨在维护关键开源软件（OSS）项目参与者的专利自由，支持源软件（OSS）关键元素Linux的自由开发环境。核心技术专利互不侵犯符合开源软件内在的文化常态，通过加入OIN社区，足以了解社区里的行为诚信与否，帮助社区成员降低专利风险。OIN成立开时获得了谷歌、IBM、NEC、飞利浦、索尼、SUSE和丰田等企业的大力支持，拥有3,400多位社区成员和2.6＋million 多项专利与申请。

### 开源社区

开源社区是众多创作者和使用者交流和学习的“基地”。开源社区是项目开发的组织形式，是由所有参与开发和改进源代码项目的用户组成的社群，通常也是遵循某项开源许可证协议发布源代码的网络平台。在开源社区，众多开发者进行合作与开发，并分享成果。

### 木兰开源社区

木兰开源社区是国家重点研发计划的重点专项“云计算和大数据开源社区生态系统”的成果之一，旨在促进产学研用各方开源领域的交流，推动国家科技创新成果开源，加强企业、科教研单位和行业用户之间的沟通，推动开源成果转化落地。该社区为各类开源项目提供中立托管，保证开源项目的持续发展不受第三方影响，通过更加开放的方式来打造和完善开源社区生态。2019年8月，木兰系列开源许可证的《木兰宽松许可证，第1版》正式上线，MulanPSL v2于2020年通过OSI认证，成为首个我国主导的中英双语开源许可证。

### CSDN社区

中国开发者社区CSDN（Chinese Software Developer Network），创立于1999年。截至2021年3月，CSDN拥有超过3200万注册会员，Alexa全球网站综合排名第26位，社区技术文章累计超过3600万篇，新媒体公众号粉丝总量超2400万，合作企业上干家。旗下拥有全球最大的中文开发者社区CSDN.NET、专业技术博客CSDN BLOG、在线学习平台程序员学院、中国特色的代码托管平台Gitcode、高校合作平台CSDN教育、IT技术人才猎头服务科锐福克斯等等，全力为中国IT技术人提供知识传播、在线学习、职业发展、工具赋能等全生命周期服务，是技术创新、行业创新、中国自主IT生态重塑的开发者黄金时代最优云服务平台。

### 开源许可证

开源许可证是对开源技术进行规范的授权合同，也可称为授权协议书，具有合同和著作权的双重法律性质。开源许可证采用契约和授权方式，指导和规范许可人和被许可人在处理开源作品时的权利、义务和责任，是解决开源面临的法律和商业问题的核心机制。许可证通过分配使用者公开自己修改等代码等知识传播责任，从而促进资源共享和开源发展，避免开源技术过度消费。

### GPL许可证

相对于其他开源软件许可证，特别是GPL许可证，BSD（Berkly Software Distribution）许可证对被许可人来说可能是最“宽容”的。虽然BSD许可证具备开源软件许可证普遍的要求，但BSD许可证只要求被许可者附上该许可证的原文以及所有开发者的版权资料。也就是说，只要标明了源代码的出处，被许可人可以将其用在自己的软件中，并按自己的要求（包括以商业软件的方式）再发布或再许可等。因此，BSD许可证在学校或公共科研机构研发的开源软件转化为产品方面发挥了重要作用。

### LGPL许可证

LGPL许可证（Lesser General Public License或Library General Public License）中文可译为＂较宽松公共许可证”或“函数库公共许可证”，也是自由软件联盟GNU开源软件许可证的一种。在具体执行LGPL许可证时，与GPL许可证最大的不同之处在于其适用于特殊设计的函数库，并允许非自由的程序可以与这些函数库连接。

### MPL许可证

MPL（Mozilla Public License）最初是1998年Netscape的Mozilla小组为其开放源代码软件项目设计的软件许可证。与GPL许可证和BSD许可证相比，MPL的许多权利与义务与它们相同，但也存在不同之处，比如，许可证允许被许可人将经过许可证获得的源代码同自己其他类型的代码混合得到自己的软件程序。

### 最终用户许可协议

最终用户许可协议（End User License Agreement，EULA）指的是一家公司的软件与软件的使用者所达成的协议，是软件应用程序作者或者发布者与应用程序使用者之间的合法合同。最终用户许可协议对软件的使用、修改和分享及其他相关事宜作出规定。

### 开源代码托管平台

开源代码托管平台，简单来说就是存储、管理、维护源代码，促进项目协同开发的网络平台。现在代码托管技术以Git为主，大多数企业使用Git进行协同开发，很多代码托管平台也是通过Git来实现的，如GitHub、GitLab、Gitee、COOD CHINA。

### 技术

世界知识产权组织在1977年版的《供发展中国家使用的许可证贸易手册》中将技术定义为：“技术是制造一种产品的系统知识，所采用的一种工艺或提供的一项服务，不论这种知识是否反映在一项发明、一项外形设计、一项实用新型或者一种植物新品种，或者反映在技术情报或技能中，或者反映在专家为设计、安装、开办或维修一个工厂或为管理一个工商业企业或其活动而提供的服务或协助等方面。”该定义是至今为止国际范围内对“技术”一词最全面、完整的解释。知识产权组织把世界上所有能带来经济效益的科学知识都定义为技术。
