# 附录2：开源专有名词

### 开源

开源即开放源代码，兴起于软件行业，是源代码可开放共享的开发模式，具有自由开放、共建共享的特性。开源是促进信息技术创新的重要途径。目前，技术领域的开源已包含源代码、源数据等技术和资源的开放共享，源代码仍然是开源的主要内容。
在开源模式下，通过许可证的方式，使用者在遵守许可限制的条件下，可自由获取源代码等，并可使用、复制、修改和再发布。开源模式是大规模群体依托互联网平台，通过共同参与协作，不断累积群体智慧，实现持续创新的方法。该方法中，项目的核心开发人员与大规模的外围群体紧密合作，通过互联网进行共享资源、协同开发、代码管理等，实现项目开发应对需求变化的能力大幅提升。

### 开源软件

开源软件,又可译为“开放源代码软件”，是指源代码开放、允许用户按照许可证条款对源代码进行修改并可自由重复发行的一类软件。虽然开源软件必须公开源代码, 但需符合相应许可证的相关要求,只有在遵守许可证的条件下才能得到开源软件的源代码, 并可自由地对其修改或再发布。因此, 开源软件是通过许可证对其进行知识产权保护的, 也是受著作权保护的作品, 未经权利人许可不能随意使用。

### 商业软件

商业软件（Business Software）是指通过贸易方式向社会公众发行的各种商品化软件。对于商业软件，供应商不仅应该向用户提供程序和使用说明，而且应该向用户提供包括版本更新在内的技术服务。商业软件在知识产权方面的最重要体现是版权（著作权），即商业软件的权利人享有软件及其复制品的发行权。目前国际上通行的商业软件发行方式是向用户提供使用许可。按照这种方式，用户在支付一定费用后，得到的仍不是这份软件复制品的全部权利，而是一种附条件、有限制的权利：即在遵守使用许可协议的条件下，行使由该软件的使用许可协议所规定的若干顶权利，如使用、临时复制等。

### 公有软件

公有软件（Public Domain Software,又可译为"公有领域软件”）是指著作权中的经济权利（包括复制权、修改改编权、发行权等专有权利）有效期已经届满的软件，以及权利人由于不准备使之商品化而已经明确声明放弃著作权的软件。在知识产权方面，公有软件不同于开源软件，开源软件的著作权仍由权利人享有，并受著作权保护，但公有软件除人身权外，再无其他著作权。

### Apache 基金会

Apache软件基金会（也就是Apache Software Foundation，简称为ASF），是专门支持开源软件项目的非盈利性组织。在它所支持的Apache项目与子项目中，所发行的软件产品都遵循Apache许可证（Apache License）。Apache基金会倡导的是合作和贡献，信奉“贡献者→提交者→成员→导师” 路径。想成为贡献者，需积极为 Apache 社区贡献代码、补丁或文档。想成为提交者，需要成员的指定，而成为了提交者，就会拥有一些“特权”。提交者中的积极分子和优秀生可 “毕业”成为成员了。

Apache运营成功很重要的一点是“Apache之道”——它的开源治理方式、原则和文化。其运营的精髓主要有以下六点。第一点，“精英治理”（Meritocracy），也就是贡献越多，发言权越大，同时责任也会越大。第二点，Apache认为社区重于代码。只要愿意投入精力让项目越来越好，代码一般也可以参与，这样极大地调动了开发者的积极性。第三点，在 Apache 社区中所有人都是平等的，人人享有平等的发言权。第四点，公开透明。所有事项都必须在邮件列表中体现或者实现，事项内容仅以邮件为准。第五点，共识机制。任何人都可以提出自己的意见，只要有反对意见提出正当理由或替代方案，大家就会停下讨论。第六点，社区自治。Apache下的300多个项目社区都由社区自治，每个月交一个报告就可以。Apache提供品牌保护等横向的支持。

### Linux 基金会

Linux基金会通过提供财务和智力资源，基础设施，服务，活动以及培训来支持创建可持续开源生态系统。Linux是大多数开源软件的基础，该组织的核心目标是推动Linux系统的发展。近年来，随着开源的兴起，Linux基金会适应时代发展的需要，在Linux的基础上扩大涉足领域，并监管大型协作项目。业界Xen、KVM、CNCF、Hyperledger等知名项目，都来自于Linux基金会。

### 开放原子开源基金会

开放原子开源基金会是我国首个开源基金会，主要提供基础服务、法律服务、IT基础设施服务、社区运营管理等四大类别服务。该基金会是由民政部登记、工业和信息化部主管的基金会。开放原子开源基金会设理事会、技术监督委员会与秘书处。理事会负责审议和修改基金会章程等；技术监督委员会是其中立的技术决策机构，负责基金会技术相关的决策，以及项目的孵化评审等；秘书处是基金会的执行机构，负责基金会日常事务等工作。

### 云原生计算基金会（CNCF）

CNCF基金会，英文全称为Cloud Native Computing Foundation，中文译为“云原生计算基金会”。CNCF是Linux基金会旗下的基金会，成立于2015年12月11日，其口号是坚持和整合开源技术来让编排容器作为微服务架构的一部分，是致力于云原生应用推广和普及的一支重要力量。CNCF作为一个厂商中立的基金会，致力于Github上的快速成长的开源技术的推广，如Kubernetes、Prometheus、Envoy等，帮助开发人员更快更好的构建出色的产品。

### 开源基础设施基金会（OIF）

2020年10月，OpenStack基金会（OSF）正式演进为开源基础设施基金会（Open Infrastructure Foundation, OIF）。OpenStack基金会是一家非盈利组织，在2012年成立。OpenStack基金会旨在推动OpenStack云操作系统在全球的发展、传播和使用。OpenStack基金会的目标是在全球范围内服务开发者、用户及整个生态系统，为其提供共享资源，以扩大OpenStack公有云与私有云的成长，从而帮助技术厂商选择平台，助力开发者开发出行业最佳的云软件。

OpenStack基金会分为个人会员和企业会员两大类。OpenStack基金会个人会籍是免费无门槛的，他们可凭借技术贡献或社区建设工作等参与到OpenStack社区中。而公司参与的会根据各司赞助会费的情况，分成白金会员、黄金会员、企业赞助会员以及支持组织者，其中白金和黄金会员的话语权最大。

### OIN(Open Invention Network)专利保护社区

OIN 是目前为止最大的专利保护社区，旨在维护关键开源软件 (OSS) 项目参与者的专利自由，支持开源软件 (OSS) 关键元素 Linux 的自由开发环境。核心技术专利互不侵犯符合开源软件内在的文化常态，通过加入 OIN 社区，足以了解社区里的行为诚信与否，帮助社区成员降低专利风险。OIN 成立时获得了谷歌、IBM、NEC、飞利浦、索尼、SUSE 和丰田等企业的大力支持，拥有 3,400 多位社区成员和 2.6+ million 多项专利与申请。

### 开源代码托管平台

开源代码托管平台，简单来说就是存储、管理、维护源代码，促进项目协同开发的网络平台。现在代码托管技术以Git为主，基本上大多数的公司都在使用Git进行协同开发，很多代码托管平台也是通过Git来实现的，如GitHub、GitLab、Gitee、CODE CHINA。

### 开源社区

开源社区是众多创作者和使用者交流和学习的“基地”。开源社区是项目开发的组织形式，是由所有参与开发和改进源代码项目的用户组成的社群，通常也是遵循某项开源许可证协议发布源代码的网络平台。在开源社区，众多开发者进行合作与开发，并分享成果。

### CSDN社区

中国开发者社区CSDN (Chinese Software Developer Network) ，创立于1999年。截至2021年3月，CSDN拥有超过3200万注册会员，Alexa全球网站综合排名第26位，社区技术文章累计超过3600万篇，新媒体公众号粉丝总量超2400万，合作上千家科技公司。旗下拥有全球最大的中文开发者社区CSDN.NET、专业技术博客CSDN BLOG、在线学习平台程序员学院、中国特色的代码托管平台CODE CHINA、高校合作平台CSDN教育、IT技术人才猎头服务科锐福克斯等等，全力为中国IT技术人提供知识传播、在线学习、职业发展、工具赋能等全生命周期服务，是技术创新、行业创新、中国自主IT生态重塑的开发者黄金时代最优云服务平台。

### CODE CHINA平台

CODE CHINA是中国开发者专业社区CSDN旗下的综合型开源社区平台，专注开源项目托管、开源教育、开源知识分享三大功能。作为开源项目托管平台，开发者和企业可以用CODE CHINA托管、运营、推广自己的开源项目，也可以托管自己的私有代码仓库。平台包括Issue，Wiki，Pages，MR，Star，Fork等开源社区需要的工具。代码托管平台还支持基于开源开发模式的教学引擎，结合在线编辑器，为开源项目提供交互式的学习平台。CODE CHINA会在项目代码镜像的基础上，实现与Github 的双向同步。在开源项目托管的基础上，通过开源小社区赋能开源项目更多能力，助力开源项目的社区运营，聚合新闻、博客、问答、直播等产品，在社区中产生更多丰富多彩的开源内容，打造更活跃的社区，让开源项目可以更高效地构建和运营开发者生态社区。

### 确实（Trustie）社区

”确实“（英文名Trustie）是由科技部资助、国内多所知名高校和机构联合发起的开源平台和社区，重点聚焦科教领域原始创新成果的开源孵化和国内高校开源人才培养，提供包括开源项目托管、群体化协同开发、开源资源检索排行、开源代码众包标注等服务。确实平台为国内多个开源社区建设提供底层平台和关键技术支持，助力国家开源生态发展。

### 启智社区

启智社区（Open i）是向全球开放的、技术透明的基础技术开源开放平台，包括开放硬件、开源软件、开源算法、开源模型和开源应用。启智社区发布了国内首个AI开源许可证启智OIL1.0，制定了支撑软件开源、硬件开源乃至数据和模型开源的许可证服务规划，在社区章程基础上初步建成与国际接轨的开源治理体系并设立了立项管道（project acceptance pipeline）制度，建立项目孵化管道及成熟度评价体系。

### 头歌（EduCoder）社区

“头歌”（英文名EduCoder）是一个新型的大规模开放在线计算机实践教学云平台与开发社区，借鉴开源模式和机制形成了以软件定义的“实训项目”为核心、课堂学习与项目实践有机结合的创新实践人才培养模式，致力于为高校人才培养、企业技术创新提供智能化云端在线实践教学、实验实训、课程建设、案例共享与共建等服务，目前已经发展为由广大院校、企业、联盟以及其他组织机构共建共享的信息技术类专业教育社区。

### 开源中国

开源中国提供技术资讯服务、代码管理服务和软件众包服务等。开源中国社区拥有完整的知识库， 主要用户为一线程序员。Gitee.com(码云) 是开源中国推出的代码托管平台，码云Gitee开发云平台推出代码托管、代码质量管理、软件演示平台和项目协作管理等云服务。开源中国众包平台以电商交易方式开展众包业务，其共享经济模式打破软件外包行业的信息不对称的现状，实现软件开发行业的模式创新和产业升级。
木兰开源社区

木兰开源社区是国家重点研发计划重点专项“云计算和大数据开源社区生态系统”的成果之一，旨在促进产学研用各方开源领域的交流，推动国家科技创新成果开源，加强企业、科教研单位和行业用户之间的沟通，推动开源成果转化落地。该社区为各类开源项目提供中立托管，保证开源项目的持续发展不受第三方影响，通过更加开放的方式来打造和完善开源社区生态。 2019年8月，木兰系列开源许可证的《木兰宽松许可证，第1版》正式上线，MulanPSL v2于2020年通过OSI认证，成为首个我国主导的中英双语开源许可证。

### 开源许可证

开源许可证是对开源技术进行规范的授权合同,也可称为授权协议书，具有合同和著作权的双重法律性质。开源许可证采用契约和授权方式，指导和规范许可人和被许可人在处理开源作品时的权利、义务和责任，是解决开源面临的法律和商业问题的核心机制。许可证通过分配使用者公开自己修改的源代码等知识传播责任，从而促进资源共享和开源发展，避免开源技术过度消费。

### GPL 许可证

GPL许可证（GNU General Public License）是自由软件开源联盟GNU开源许可证的一种。同时, GPL 也是开源软件领域对被许可人权利限制最严的许可证。GPL许可证最大的特点在于它要求根据GPL 许可证发布的软件(如Linux操作系统)修改、翻译的演绎作品，甚至只要其中任何一部分代码是以GPL发布的，那么全部程序也必须受GPL许可证的约束，即继续遵守GPL许可证的规定。
### BSD 许可证

相对于其他开源软件许可证，特别是GPL许可证，BSD(Berkly Software Distribution)许可证对被许可人来说可能是最“宽容”的。虽然BSD许可证具备开源软件许可证普遍的要求，但BSD许可证只要求被许可者附上该许可证的原文以及所有开发者的版权资料。也就是说，只要标明了源代码的出处，被许可人可以将其用在自己的软件中，并按自己的要求(包括以商业软件的方式)再发布或再许可等。因此，BSD许可证在学校或公共科研机构研发的开源软件转化为产品方面发挥了重要作用。

### LGPL 许可证

LGPL许可证(Lesser General Public License或Library General Public License)中文可译为"较宽松公共许可证”或“函数库公共许可证”，也是自由软件联盟GNU开源软件许可证的一种。在具体执行LGPL许可证时，与GPL许可证最大的不同之处在于其适用于特殊设计的函数库，并允许非自由的程序可以与这些函数库连接。

### MPL 许可证

MPL(Mozilla Public License)最初是1998年初Netscape的Mozilla小组为其开放源代码软件项目设计的软件许可证。同GPL许可证和BSD许可证相比，MPL的许多权利与义务与它们相同，但也存在着不同之处，比如许可证允许被许可人将经过许可证获得的源代码同自己其他类型的代码混合得到自己的软件程序等。

### RISC-V 开源芯片

RISC-V（发音为“risk-ﬁve”）是一个基于精简指令集（RISC）原则的开源指令集架构（ISA）。2019 年8月，中科院与鹏城实验室发布RISC-V开源芯片设计系统级验证及原型平台SERVE。2019年前后，我国发布了首个RISC-V支持政策并成立了中国RISC-V产业联盟，清华和伯克利共同发起成立了RISC-V国际开源实验室，包括华为、阿里巴巴、中科院计算所等在内的中国企业、机构正全力加速推进RISC-V中国化生态建设。

### 技术

世界知识产权组织在1977年版的《供发展中国家使用的许可证贸易手册》中，给技术下的定义：“技术是制造一种产品的系统知识，所采用的一种工艺或提供的一项服务，不论这种知识是否反映在一项发明、一项外形设计、一项实用新型或者一种植物新品种，或者反映在技术情报或技能中，或者反映在专家为设计、安装、开办或维修一个工厂或为管理一个工商业企业或其活动而提供的服务或协助等方面。”这是至今为止国际上对技术最为全面和完整的定义。知识产权组织把世界上所有能带来经济效益的科学知识都定义为技术。
