import { createI18n } from 'vue-i18n'
import en_US from './config/en_US.json'
import zh_CN from './config/zh_CN.json'
import zh_HK from './config/zh_HK.json'

const I18n = createI18n({
    locale: 'zh_CN',
    globalInjection: true,
    legacy: false,
    messages: {
        zh_CN,
        zh_HK,
        en_US
    }
})

const setLang = (lang) => {
    if (!lang) return;
    console.log('setLang', lang);
    I18n.global.locale.value = lang
}
// 
window.$t = I18n.global
window.setLang = setLang

export default I18n
