/* Copyright (c) 2016 PaddlePaddle Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. */
#include <fcntl.h>

#ifdef _POSIX_C_SOURCE
#undef _POSIX_C_SOURCE
#endif

#ifdef _XOPEN_SOURCE
#undef _XOPEN_SOURCE
#endif

#include <string>
#include <vector>

#include "google/protobuf/io/zero_copy_stream_impl.h"
#include "google/protobuf/text_format.h"
#include "paddle/fluid/framework/async_executor.h"
#include "paddle/fluid/framework/data_feed.h"
#include "paddle/fluid/framework/data_feed.pb.h"
#include "paddle/fluid/framework/scope.h"
#include "paddle/fluid/inference/io.h"
#include "paddle/fluid/platform/place.h"
#include "paddle/fluid/platform/variant.h"
#include "paddle/fluid/pybind/fleet_wrapper_py.h"

namespace py = pybind11;

namespace paddle {
namespace pybind {
void BindFleetWrapper(py::module* m) {
  py::class_<framework::FleetWrapper>(*m, "Fleet")
      .def(py::init())
      .def("push_dense", &framework::FleetWrapper::PushDenseVarsSync)
      .def("init_server", &framework::FleetWrapper::InitServer)
      .def("run_server", &framework::FleetWrapper::RunServer)
      .def("init_worker", &framework::FleetWrapper::InitWorker)
      .def("init_model", &framework::FleetWrapper::PushDenseParamSync)
      .def("save_model", &framework::FleetWrapper::SaveModel)
      .def("load_model", &framework::FleetWrapper::LoadModel)
      .def("stop_server", &framework::FleetWrapper::StopServer)
      .def("gather_servers", &framework::FleetWrapper::GatherServers)
      .def("gather_clients", &framework::FleetWrapper::GatherClients)
      .def("get_clients_info", &framework::FleetWrapper::GetClientsInfo)
      .def("create_client2client_connection",
           &framework::FleetWrapper::CreateClient2ClientConnection)
      .def("shrink_sparse_table", &framework::FleetWrapper::ShrinkSparseTable)
      .def("shrink_dense_table", &framework::FleetWrapper::ShrinkDenseTable)
      .def("client_flush", &framework::FleetWrapper::ClientFlush);
}  // end FleetWrapper
}  // end namespace pybind
}  // end namespace paddle
