#  Copyright (c) 2021 PaddlePaddle Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from __future__ import print_function

import numpy as np
import unittest
import sys
sys.path.append("..")
from op_test import OpTest
import paddle
import paddle.fluid as fluid
import paddle.fluid.core as core

paddle.enable_static()
SEED = 2021


class TestCast1(OpTest):
    def setUp(self):
        self.set_npu()
        self.op_type = "cast"
        self.place = paddle.NPUPlace(0)

        ipt = np.random.random(size=[10, 10]) + 1
        self.inputs = {'X': ipt.astype('float32')}
        self.outputs = {'Out': ipt.astype('float16')}

        self.attrs = {
            'in_dtype': int(core.VarDesc.VarType.FP32),
            'out_dtype': int(core.VarDesc.VarType.FP16)
        }

    def set_npu(self):
        self.__class__.use_npu = True

    def test_check_output(self):
        self.check_output_with_place(self.place)


class TestCast2(OpTest):
    def setUp(self):
        self.set_npu()
        self.op_type = "cast"
        self.place = paddle.NPUPlace(0)

        ipt = np.random.random(size=[10, 10]) + 1
        self.inputs = {'X': ipt.astype('float16')}
        self.outputs = {'Out': ipt.astype('float32')}

        self.attrs = {
            'in_dtype': int(core.VarDesc.VarType.FP16),
            'out_dtype': int(core.VarDesc.VarType.FP32)
        }

    def set_npu(self):
        self.__class__.use_npu = True

    def test_check_output(self):
        self.check_output_with_place(self.place, atol=1e-3)


class TestCast3(OpTest):
    def setUp(self):
        self.set_npu()
        self.op_type = "cast"
        self.place = paddle.NPUPlace(0)

        ipt = np.random.random(size=[10, 10]) + 1
        self.inputs = {'X': ipt.astype('int32')}
        self.outputs = {'Out': ipt.astype('int32')}

        self.attrs = {
            'in_dtype': int(core.VarDesc.VarType.INT32),
            'out_dtype': int(core.VarDesc.VarType.INT32)
        }

    def set_npu(self):
        self.__class__.use_npu = True

    def test_check_output(self):
        self.check_output_with_place(self.place, atol=1e-3)


if __name__ == '__main__':
    unittest.main()
